/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.directwrite;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.directwrite.DWFactory;
import com.sun.javafx.font.directwrite.DWFontFile;
import com.sun.javafx.font.directwrite.DWRITE_SCRIPT_ANALYSIS;
import com.sun.javafx.font.directwrite.IDWriteFactory;
import com.sun.javafx.font.directwrite.IDWriteFont;
import com.sun.javafx.font.directwrite.IDWriteFontCollection;
import com.sun.javafx.font.directwrite.IDWriteFontFace;
import com.sun.javafx.font.directwrite.IDWriteFontFamily;
import com.sun.javafx.font.directwrite.IDWriteLocalizedStrings;
import com.sun.javafx.font.directwrite.IDWriteTextAnalyzer;
import com.sun.javafx.font.directwrite.IDWriteTextFormat;
import com.sun.javafx.font.directwrite.IDWriteTextLayout;
import com.sun.javafx.font.directwrite.JFXTextAnalysisSink;
import com.sun.javafx.font.directwrite.JFXTextRenderer;
import com.sun.javafx.font.directwrite.OS;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.TextRun;
import java.util.Arrays;

public class DWGlyphLayout
extends GlyphLayout {
    private static final String LOCALE = "en-us";

    @Override
    protected TextRun addTextRun(PrismTextLayout prismTextLayout, char[] cArray, int n2, int n3, PGFont pGFont, TextSpan textSpan, byte by2) {
        IDWriteFactory iDWriteFactory = DWFactory.getDWriteFactory();
        IDWriteTextAnalyzer iDWriteTextAnalyzer = iDWriteFactory.CreateTextAnalyzer();
        if (iDWriteTextAnalyzer == null) {
            return new TextRun(n2, n3, by2, false, 0, textSpan, 0, false);
        }
        int n4 = (by2 & 1) != 0 ? 1 : 0;
        JFXTextAnalysisSink jFXTextAnalysisSink = OS.NewJFXTextAnalysisSink(cArray, n2, n3, LOCALE, n4);
        if (jFXTextAnalysisSink == null) {
            return new TextRun(n2, n3, by2, false, 0, textSpan, 0, false);
        }
        jFXTextAnalysisSink.AddRef();
        TextRun textRun = null;
        int n5 = iDWriteTextAnalyzer.AnalyzeScript(jFXTextAnalysisSink, 0, n3, jFXTextAnalysisSink);
        if (n5 == 0) {
            while (jFXTextAnalysisSink.Next()) {
                int n6 = jFXTextAnalysisSink.GetStart();
                int n7 = jFXTextAnalysisSink.GetLength();
                DWRITE_SCRIPT_ANALYSIS dWRITE_SCRIPT_ANALYSIS = jFXTextAnalysisSink.GetAnalysis();
                textRun = new TextRun(n2 + n6, n7, by2, true, dWRITE_SCRIPT_ANALYSIS.script, textSpan, dWRITE_SCRIPT_ANALYSIS.shapes, false);
                prismTextLayout.addTextRun(textRun);
            }
        }
        iDWriteTextAnalyzer.Release();
        jFXTextAnalysisSink.Release();
        return textRun;
    }

    @Override
    public void layout(TextRun textRun, PGFont pGFont, FontStrike fontStrike, char[] cArray) {
        int n2;
        IDWriteFontFace iDWriteFontFace;
        int n3 = 0;
        FontResource fontResource = pGFont.getFontResource();
        boolean bl2 = fontResource instanceof CompositeFontResource;
        if (bl2) {
            n3 = this.getInitialSlot(fontResource);
            fontResource = ((CompositeFontResource)fontResource).getSlotResource(n3);
        }
        if ((iDWriteFontFace = ((DWFontFile)fontResource).getFontFace()) == null) {
            return;
        }
        IDWriteFactory iDWriteFactory = DWFactory.getDWriteFactory();
        IDWriteTextAnalyzer iDWriteTextAnalyzer = iDWriteFactory.CreateTextAnalyzer();
        if (iDWriteTextAnalyzer == null) {
            return;
        }
        long[] lArray = null;
        int[] nArray = null;
        int n4 = 0;
        int n5 = textRun.getLength();
        short[] sArray = new short[n5];
        short[] sArray2 = new short[n5];
        int n6 = n5 * 3 / 2 + 16;
        short[] sArray3 = new short[n6];
        short[] sArray4 = new short[n6];
        int[] nArray2 = new int[1];
        boolean bl3 = !textRun.isLeftToRight();
        DWRITE_SCRIPT_ANALYSIS dWRITE_SCRIPT_ANALYSIS = new DWRITE_SCRIPT_ANALYSIS();
        dWRITE_SCRIPT_ANALYSIS.script = (short)textRun.getScript();
        dWRITE_SCRIPT_ANALYSIS.shapes = textRun.getSlot();
        int n7 = textRun.getStart();
        int n8 = iDWriteTextAnalyzer.GetGlyphs(cArray, n7, n5, iDWriteFontFace, false, bl3, dWRITE_SCRIPT_ANALYSIS, null, 0L, lArray, nArray, n4, n6, sArray, sArray2, sArray3, sArray4, nArray2);
        if (n8 == -2147024774) {
            sArray3 = new short[n6 *= 2];
            sArray4 = new short[n6];
            n8 = iDWriteTextAnalyzer.GetGlyphs(cArray, n7, n5, iDWriteFontFace, false, bl3, dWRITE_SCRIPT_ANALYSIS, null, 0L, lArray, nArray, n4, n6, sArray, sArray2, sArray3, sArray4, nArray2);
        }
        if (n8 != 0) {
            iDWriteTextAnalyzer.Release();
            return;
        }
        int n9 = nArray2[0];
        int n10 = bl3 ? -1 : 1;
        int[] nArray3 = new int[n9];
        int n11 = n3 << 24;
        boolean bl4 = false;
        int n12 = 0;
        int n13 = n2 = bl3 ? n9 - 1 : 0;
        while (n12 < n9) {
            if (sArray3[n12] == 0) {
                bl4 = true;
                if (bl2) break;
            }
            nArray3[n12] = sArray3[n2] & 0xFFFF | n11;
            ++n12;
            n2 += n10;
        }
        if (bl4 && bl2) {
            iDWriteTextAnalyzer.Release();
            this.renderShape(cArray, textRun, pGFont, n3);
            return;
        }
        float f2 = pGFont.getSize();
        float[] fArray = new float[n9];
        float[] fArray2 = new float[n9 * 2];
        iDWriteTextAnalyzer.GetGlyphPlacements(cArray, sArray, sArray2, n7, n5, sArray3, sArray4, n9, iDWriteFontFace, f2, false, bl3, dWRITE_SCRIPT_ANALYSIS, null, lArray, nArray, n4, fArray, fArray2);
        iDWriteTextAnalyzer.Release();
        float[] fArray3 = this.getPositions(fArray, fArray2, n9, bl3);
        int[] nArray4 = this.getIndices(sArray, n9, bl3);
        textRun.shape(n9, nArray3, fArray3, nArray4);
    }

    private float[] getPositions(float[] fArray, float[] fArray2, int n2, boolean bl2) {
        float[] fArray3 = new float[n2 * 2 + 2];
        int n3 = 0;
        int n4 = bl2 ? n2 - 1 : 0;
        int n5 = bl2 ? -1 : 1;
        float f2 = 0.0f;
        while (n3 < fArray3.length - 2) {
            int n6 = n4 << 1;
            fArray3[n3++] = (bl2 ? -fArray2[n6] : fArray2[n6]) + f2;
            fArray3[n3++] = -fArray2[n6 + 1];
            f2 += fArray[n4];
            n4 += n5;
        }
        fArray3[n3++] = f2;
        fArray3[n3++] = 0.0f;
        return fArray3;
    }

    private int[] getIndices(short[] sArray, int n2, boolean bl2) {
        int n3;
        int n4;
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        for (n4 = 0; n4 < sArray.length; ++n4) {
            n3 = sArray[n4];
            if (0 > n3 || n3 >= n2 || nArray[n3] != -1) continue;
            nArray[n3] = n4;
        }
        if (nArray.length > 0) {
            if (nArray[0] == -1) {
                nArray[0] = 0;
            }
            for (n4 = 1; n4 < nArray.length; ++n4) {
                if (nArray[n4] != -1) continue;
                nArray[n4] = nArray[n4 - 1];
            }
        }
        if (bl2) {
            for (n4 = 0; n4 < nArray.length / 2; ++n4) {
                n3 = nArray[n4];
                nArray[n4] = nArray[nArray.length - n4 - 1];
                nArray[nArray.length - n4 - 1] = n3;
            }
        }
        return nArray;
    }

    private String getName(IDWriteLocalizedStrings iDWriteLocalizedStrings) {
        if (iDWriteLocalizedStrings == null) {
            return null;
        }
        int n2 = iDWriteLocalizedStrings.FindLocaleName(LOCALE);
        String string = null;
        if (n2 >= 0) {
            int n3 = iDWriteLocalizedStrings.GetStringLength(n2);
            string = iDWriteLocalizedStrings.GetString(n2, n3);
        }
        iDWriteLocalizedStrings.Release();
        return string;
    }

    private FontResource checkFontResource(FontResource fontResource, String string, String string2) {
        if (fontResource == null) {
            return null;
        }
        if (string != null && string.equals(fontResource.getPSName())) {
            return fontResource;
        }
        if (string2 != null) {
            if (string2.equals(fontResource.getFullName())) {
                return fontResource;
            }
            String string3 = fontResource.getFamilyName() + " " + fontResource.getStyleName();
            if (string2.equals(string3)) {
                return fontResource;
            }
        }
        return null;
    }

    private int getFontSlot(IDWriteFontFace iDWriteFontFace, CompositeFontResource compositeFontResource, String string, int n2) {
        Object object;
        if (iDWriteFontFace == null) {
            return -1;
        }
        IDWriteFontCollection iDWriteFontCollection = DWFactory.getFontCollection();
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        IDWriteFont iDWriteFont = iDWriteFontCollection.GetFontFromFontFace(iDWriteFontFace);
        if (iDWriteFont == null) {
            return -1;
        }
        IDWriteFontFamily iDWriteFontFamily = iDWriteFont.GetFontFamily();
        String string2 = this.getName(iDWriteFontFamily.GetFamilyNames());
        iDWriteFontFamily.Release();
        boolean bl2 = iDWriteFont.GetStyle() != 0;
        boolean bl3 = iDWriteFont.GetWeight() > 400;
        int n3 = iDWriteFont.GetSimulations();
        int n4 = 17;
        String string3 = this.getName(iDWriteFont.GetInformationalStrings(n4));
        n4 = 11;
        String string4 = this.getName(iDWriteFont.GetInformationalStrings(n4));
        n4 = 12;
        String string5 = this.getName(iDWriteFont.GetInformationalStrings(n4));
        String string6 = string4 + " " + string5;
        if (PrismFontFactory.debugFonts) {
            object = this.getName(iDWriteFont.GetFaceNames());
            System.err.println("Mapping IDWriteFont=\"" + string2 + " " + (String)object + "\" Postscript name=\"" + string3 + "\" Win32 name=\"" + string6 + "\"");
        }
        iDWriteFont.Release();
        object = prismFontFactory.getFontResource(string2, bl3, bl2, false);
        object = this.checkFontResource((FontResource)object, string3, string6);
        if (object == null) {
            object = prismFontFactory.getFontResource(string2, bl3 &= (n3 & 1) == 0, bl2 &= (n3 & 2) == 0, false);
            object = this.checkFontResource((FontResource)object, string3, string6);
        }
        if (object == null) {
            object = prismFontFactory.getFontResource(string6, null, false);
            object = this.checkFontResource((FontResource)object, string3, string6);
        }
        if (object == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t**** Failed to map IDWriteFont to Prism ****");
            }
            return -1;
        }
        String string7 = object.getFullName();
        if (!string.equalsIgnoreCase(string7)) {
            n2 = compositeFontResource.getSlotForFont(string7);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("\tFallback full name=\"" + string7 + "\" Postscript name=\"" + object.getPSName() + "\" Style name=\"" + object.getStyleName() + "\" slot=" + n2);
        }
        return n2;
    }

    private void renderShape(char[] cArray, TextRun textRun, PGFont pGFont, int n2) {
        int n3;
        IDWriteFontCollection iDWriteFontCollection;
        CompositeFontResource compositeFontResource = (CompositeFontResource)pGFont.getFontResource();
        FontResource fontResource = compositeFontResource.getSlotResource(n2);
        String string = fontResource.getFamilyName();
        String string2 = fontResource.getFullName();
        int n4 = fontResource.isBold() ? 700 : 400;
        int n5 = 5;
        int n6 = fontResource.isItalic() ? 2 : 0;
        float f2 = pGFont.getSize();
        float f3 = f2 > 0.0f ? f2 : 1.0f;
        IDWriteFactory iDWriteFactory = DWFactory.getDWriteFactory();
        IDWriteTextFormat iDWriteTextFormat = iDWriteFactory.CreateTextFormat(string, iDWriteFontCollection = DWFactory.getFontCollection(), n4, n6, n5, f3, LOCALE);
        if (iDWriteTextFormat == null) {
            return;
        }
        int n7 = textRun.getStart();
        IDWriteTextLayout iDWriteTextLayout = iDWriteFactory.CreateTextLayout(cArray, n7, n3 = textRun.getLength(), iDWriteTextFormat, 100000.0f, 100000.0f);
        if (iDWriteTextLayout != null) {
            JFXTextRenderer jFXTextRenderer = OS.NewJFXTextRenderer();
            if (jFXTextRenderer != null) {
                boolean bl2;
                int n8;
                jFXTextRenderer.AddRef();
                iDWriteTextLayout.Draw(0L, jFXTextRenderer, 0.0f, 0.0f);
                int n9 = jFXTextRenderer.GetTotalGlyphCount();
                int[] nArray = new int[n9];
                float[] fArray = new float[n9];
                float[] fArray2 = new float[n9 * 2];
                short[] sArray = new short[n3];
                int n10 = 0;
                int n11 = 0;
                while (jFXTextRenderer.Next()) {
                    IDWriteFontFace iDWriteFontFace = jFXTextRenderer.GetFontFace();
                    n8 = this.getFontSlot(iDWriteFontFace, compositeFontResource, string2, n2);
                    if (n8 >= 0) {
                        jFXTextRenderer.GetGlyphIndices(nArray, n10, n8 << 24);
                        jFXTextRenderer.GetGlyphOffsets(fArray2, n10 * 2);
                    }
                    if (f2 > 0.0f) {
                        jFXTextRenderer.GetGlyphAdvances(fArray, n10);
                    }
                    jFXTextRenderer.GetClusterMap(sArray, n11, n10);
                    n10 += jFXTextRenderer.GetGlyphCount();
                    n11 += jFXTextRenderer.GetLength();
                }
                jFXTextRenderer.Release();
                boolean bl3 = bl2 = !textRun.isLeftToRight();
                if (bl2) {
                    for (n8 = 0; n8 < n9 / 2; ++n8) {
                        int n12 = nArray[n8];
                        nArray[n8] = nArray[n9 - n8 - 1];
                        nArray[n9 - n8 - 1] = n12;
                    }
                }
                float[] fArray3 = this.getPositions(fArray, fArray2, n9, bl2);
                int[] nArray2 = this.getIndices(sArray, n9, bl2);
                textRun.shape(n9, nArray, fArray3, nArray2);
            }
            iDWriteTextLayout.Release();
        }
        iDWriteTextFormat.Release();
    }
}

