/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.FontFaceImpl;
import com.sun.javafx.css.SelectorPartitioning;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.FontFace;
import javafx.css.PseudoClass;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.Stylesheet;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Window;

public final class StyleManager {
    private static final Object styleLock = new Object();
    private static PlatformLogger LOGGER;
    public static final Map<Parent, CacheContainer> cacheContainerMap;
    public final List<StylesheetContainer> userAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    public final List<StylesheetContainer> platformUserAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    public boolean hasDefaultUserAgentStylesheet = false;
    public final Map<String, StylesheetContainer> stylesheetContainerMap = new HashMap<String, StylesheetContainer>();
    private final ImageCache imageCache = new ImageCache();
    private static final String skinPrefix = "com/sun/javafx/scene/control/skin/";
    private static final String skinUtilsClassName = "com.sun.javafx.scene.control.skin.Utils";
    private Key key = null;
    private final WeakHashMap<Region, String> weakRegionUserAgentStylesheetMap = new WeakHashMap();
    private static ObservableList<CssParser.ParseError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private StyleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheContainer getCacheContainer(Styleable styleable, SubScene subScene) {
        Object object;
        Object object2;
        if (styleable == null && subScene == null) {
            return null;
        }
        Parent parent = null;
        if (subScene != null) {
            parent = subScene.getRoot();
        } else if (styleable instanceof Node) {
            object2 = (Node)styleable;
            object = ((Node)object2).getScene();
            if (object != null) {
                parent = ((Scene)object).getRoot();
            }
        } else if (styleable instanceof Window && (object2 = ((Window)((Object)styleable)).getScene()) != null) {
            parent = ((Scene)object2).getRoot();
        }
        if (parent == null) {
            return null;
        }
        object2 = styleLock;
        synchronized (object2) {
            object = cacheContainerMap.get(parent);
            if (object == null) {
                object = new CacheContainer();
                cacheContainerMap.put(parent, (CacheContainer)object);
            }
            return object;
        }
    }

    public StyleCache getSharedCache(Styleable styleable, SubScene subScene, StyleCache.Key key) {
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return null;
        }
        Map<StyleCache.Key, StyleCache> map = cacheContainer.getStyleCache();
        if (map == null) {
            return null;
        }
        StyleCache styleCache = map.get(key);
        if (styleCache == null) {
            styleCache = new StyleCache();
            map.put(new StyleCache.Key(key), styleCache);
        }
        return styleCache;
    }

    public StyleMap getStyleMap(Styleable styleable, SubScene subScene, int n2) {
        if (n2 == -1) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return StyleMap.EMPTY_MAP;
        }
        return cacheContainer.getStyleMap(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Scene scene) {
        if (scene == null) {
            return;
        }
        this.forget(scene.getRoot());
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            String string = null;
            if (scene.getUserAgentStylesheet() != null && !(string = scene.getUserAgentStylesheet().trim()).isEmpty()) {
                for (int i2 = this.userAgentStylesheetContainers.size() - 1; 0 <= i2; --i2) {
                    object2 = this.userAgentStylesheetContainers.get(i2);
                    if (!string.equals(((StylesheetContainer)object2).fname)) continue;
                    ((StylesheetContainer)object2).parentUsers.remove(scene.getRoot());
                    if (((StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    this.userAgentStylesheetContainers.remove(i2);
                }
            }
            Set<Map.Entry<String, StylesheetContainer>> set = this.stylesheetContainerMap.entrySet();
            object2 = set.iterator();
            while (object2.hasNext()) {
                Map.Entry<String, StylesheetContainer> entry = object2.next();
                StylesheetContainer stylesheetContainer = entry.getValue();
                Iterator iterator = stylesheetContainer.parentUsers.list.iterator();
                while (iterator.hasNext()) {
                    Reference reference = iterator.next();
                    Parent parent = (Parent)reference.get();
                    if (parent != null && parent.getScene() != scene && parent.getScene() != null) continue;
                    reference.clear();
                    iterator.remove();
                }
                if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
                object2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Scene scene, ListChangeListener.Change<String> change) {
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Set<Map.Entry<Parent, CacheContainer>> set = cacheContainerMap.entrySet();
            for (Map.Entry<Parent, CacheContainer> object3 : set) {
                object2 = object3.getKey();
                CacheContainer cacheContainer = object3.getValue();
                if (((Node)object2).getScene() != scene) continue;
                cacheContainer.clearCache();
            }
            change.reset();
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (String string : change.getRemoved()) {
                    this.stylesheetRemoved(scene, string);
                    object2 = this.stylesheetContainerMap.get(string);
                    if (object2 == null) continue;
                    ((StylesheetContainer)object2).invalidateChecksum();
                }
            }
        }
    }

    private void stylesheetRemoved(Scene scene, String string) {
        this.stylesheetRemoved(scene.getRoot(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Parent parent) {
        if (parent == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            ObservableList<String> observableList;
            CacheContainer cacheContainer = cacheContainerMap.remove(parent);
            if (cacheContainer != null) {
                cacheContainer.clearCache();
            }
            if ((observableList = parent.getStylesheets()) != null && !observableList.isEmpty()) {
                for (String object2 : observableList) {
                    this.stylesheetRemoved(parent, object2);
                }
            }
            Iterator<Map.Entry<String, StylesheetContainer>> iterator = this.stylesheetContainerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, StylesheetContainer> entry = iterator.next();
                StylesheetContainer stylesheetContainer = entry.getValue();
                stylesheetContainer.parentUsers.remove(parent);
                if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
                iterator.remove();
                if (stylesheetContainer.selectorPartitioning != null) {
                    stylesheetContainer.selectorPartitioning.reset();
                }
                String string = stylesheetContainer.fname;
                this.imageCache.cleanUpImageCache(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Parent parent, ListChangeListener.Change<String> change) {
        Object object = styleLock;
        synchronized (object) {
            change.reset();
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (String string : change.getRemoved()) {
                    this.stylesheetRemoved(parent, string);
                    StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string);
                    if (stylesheetContainer == null) continue;
                    stylesheetContainer.invalidateChecksum();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stylesheetRemoved(Parent parent, String string) {
        Object object = styleLock;
        synchronized (object) {
            StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string);
            if (stylesheetContainer == null) {
                return;
            }
            stylesheetContainer.parentUsers.remove(parent);
            if (stylesheetContainer.parentUsers.list.isEmpty()) {
                this.removeStylesheetContainer(stylesheetContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(SubScene subScene) {
        if (subScene == null) {
            return;
        }
        Parent parent = subScene.getRoot();
        if (parent == null) {
            return;
        }
        this.forget(parent);
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Object object3;
            String string = null;
            if (subScene.getUserAgentStylesheet() != null && !(string = subScene.getUserAgentStylesheet().trim()).isEmpty()) {
                object3 = this.userAgentStylesheetContainers.iterator();
                while (object3.hasNext()) {
                    object2 = (StylesheetContainer)object3.next();
                    if (!string.equals(((StylesheetContainer)object2).fname)) continue;
                    ((StylesheetContainer)object2).parentUsers.remove(subScene.getRoot());
                    if (((StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    object3.remove();
                }
            }
            object3 = new ArrayList<StylesheetContainer>(this.stylesheetContainerMap.values());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                StylesheetContainer stylesheetContainer = (StylesheetContainer)object2.next();
                Iterator iterator = stylesheetContainer.parentUsers.list.iterator();
                block5: while (iterator.hasNext()) {
                    Reference reference = iterator.next();
                    Parent parent2 = (Parent)reference.get();
                    if (parent2 == null) continue;
                    for (Parent parent3 = parent2; parent3 != null; parent3 = parent3.getParent()) {
                        if (parent != parent3.getParent()) continue;
                        reference.clear();
                        iterator.remove();
                        this.forget(parent2);
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStylesheetContainer(StylesheetContainer stylesheetContainer) {
        if (stylesheetContainer == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Object object3;
            String string = stylesheetContainer.fname;
            this.stylesheetContainerMap.remove(string);
            if (stylesheetContainer.selectorPartitioning != null) {
                stylesheetContainer.selectorPartitioning.reset();
            }
            for (Map.Entry<Parent, CacheContainer> entry : cacheContainerMap.entrySet()) {
                Object object4;
                object3 = entry.getValue();
                if (object3 == null || ((CacheContainer)object3).cacheMap == null || ((CacheContainer)object3).cacheMap.isEmpty()) continue;
                object2 = new ArrayList();
                for (Map.Entry<List<String>, Map<Key, Cache>> entry2 : ((CacheContainer)object3).cacheMap.entrySet()) {
                    object4 = entry2.getKey();
                    if (!(object4 != null ? object4.contains(string) : string == null)) continue;
                    object2.add(object4);
                }
                if (object2.isEmpty()) continue;
                Iterator<Map.Entry<List<String>, Map<Key, Cache>>> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    List list = (List)((Object)iterator.next());
                    object4 = ((CacheContainer)object3).cacheMap.remove(list);
                    if (object4 == null) continue;
                    object4.clear();
                }
            }
            this.imageCache.cleanUpImageCache(string);
            List list = stylesheetContainer.parentUsers.list;
            for (int i2 = list.size() - 1; 0 <= i2; --i2) {
                object3 = (Reference)list.remove(i2);
                object2 = (Parent)((Reference)object3).get();
                ((Reference)object3).clear();
                if (object2 == null || ((Node)object2).getScene() == null) continue;
                NodeHelper.reapplyCSS((Node)object2);
            }
        }
    }

    public Image getCachedImage(String string) {
        return this.imageCache.getCachedImage(string);
    }

    private static URL getURL(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            URI uRI = new URI(string.trim());
            if (!uRI.isAbsolute()) {
                if (string.startsWith(skinPrefix) && (string.endsWith(".css") || string.endsWith(".bss"))) {
                    try {
                        ClassLoader classLoader = StyleManager.class.getClassLoader();
                        Class<?> clazz = Class.forName(skinUtilsClassName, true, classLoader);
                        Method method = clazz.getMethod("getResource", String.class);
                        return (URL)method.invoke(null, string.substring(skinPrefix.length()));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                        return null;
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string2 = uRI.getPath();
                URL uRL = null;
                uRL = string2.startsWith("/") ? classLoader.getResource(string2.substring(1)) : classLoader.getResource(string2);
                return uRL;
            }
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(String string) {
        block15: {
            if (string == null || string.isEmpty()) {
                return new byte[0];
            }
            try {
                URL uRL = StyleManager.getURL(string);
                if (uRL == null || !"file".equals(uRL.getProtocol())) break block15;
                try (InputStream inputStream = uRL.openStream();){
                    byte[] byArray;
                    try (DigestInputStream digestInputStream = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));){
                        digestInputStream.getMessageDigest().reset();
                        byte[] byArray2 = new byte[4096];
                        while (digestInputStream.read(byArray2) != -1) {
                        }
                        byArray = digestInputStream.getMessageDigest().digest();
                    }
                    return byArray;
                }
            }
            catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
        }
        return new byte[0];
    }

    public static Stylesheet loadStylesheet(String string) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(string);
        }
        catch (AccessControlException accessControlException) {
            System.err.println("WARNING: security exception trying to load: " + string);
            if (string.length() < 7 && string.indexOf("!/") < string.length() - 7) {
                return null;
            }
            try {
                String string2;
                String string3;
                URI uRI;
                String string4;
                URI uRI2 = new URI(string);
                if ("jar".equals(uRI2.getScheme()) && (string4 = (uRI = AccessController.doPrivileged(() -> StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI())).getSchemeSpecificPart()).equals(string3 = (string2 = uRI2.getSchemeSpecificPart()).substring(string2.indexOf(47), string2.indexOf("!/")))) {
                    String string5 = string.substring(string.indexOf("!/") + 2);
                    if (string.endsWith(".css") || string.endsWith(".bss")) {
                        JarEntry jarEntry;
                        FilePermission filePermission = new FilePermission(string4, "read");
                        PermissionCollection permissionCollection = filePermission.newPermissionCollection();
                        permissionCollection.add(filePermission);
                        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                        JarFile jarFile = null;
                        try {
                            jarFile = AccessController.doPrivileged(() -> new JarFile(string4), accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            return null;
                        }
                        if (jarFile != null && (jarEntry = jarFile.getJarEntry(string5)) != null) {
                            return AccessController.doPrivileged(() -> StyleManager.loadStylesheetUnPrivileged(string), accessControlContext);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Stylesheet loadStylesheetUnPrivileged(String string) {
        Object object = styleLock;
        synchronized (object) {
            block41: {
                Boolean bl2 = AccessController.doPrivileged(() -> {
                    String string2 = System.getProperty("binary.css");
                    return !string.endsWith(".bss") && string2 != null ? !Boolean.valueOf(string2).booleanValue() : Boolean.FALSE;
                });
                try {
                    Object object2;
                    Object object3;
                    String string2 = bl2 != false ? ".css" : ".bss";
                    URL uRL = null;
                    Stylesheet stylesheet = null;
                    if (!string.endsWith(".css") && !string.endsWith(".bss")) {
                        uRL = StyleManager.getURL(string);
                    } else {
                        object3 = string.substring(0, string.length() - 4);
                        uRL = StyleManager.getURL((String)object3 + string2);
                        if (uRL == null && (bl2 = Boolean.valueOf(bl2 == false)).booleanValue()) {
                            uRL = StyleManager.getURL((String)object3 + ".css");
                        }
                        if (uRL != null && !bl2.booleanValue()) {
                            try {
                                stylesheet = Stylesheet.loadBinary(uRL);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (stylesheet == null) {
                                uRL = StyleManager.getURL(string);
                            }
                        }
                    }
                    if (stylesheet == null) {
                        object3 = null;
                        if (uRL != null) {
                            stylesheet = new CssParser().parse(uRL);
                        } else {
                            object3 = DataURI.tryParse(string);
                        }
                        if (object3 != null) {
                            boolean bl3;
                            boolean bl4 = "text".equalsIgnoreCase(((DataURI)object3).getMimeType()) && ("css".equalsIgnoreCase(((DataURI)object3).getMimeSubtype()) || "plain".equalsIgnoreCase(((DataURI)object3).getMimeSubtype()));
                            boolean bl5 = bl3 = "application".equalsIgnoreCase(((DataURI)object3).getMimeType()) && "octet-stream".equalsIgnoreCase(((DataURI)object3).getMimeSubtype());
                            if (bl4) {
                                String object4 = ((DataURI)object3).getParameters().get("charset");
                                try {
                                    object2 = object4 != null ? Charset.forName(object4) : Charset.defaultCharset();
                                }
                                catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                                    String string3 = String.format("Unsupported charset \"%s\" in stylesheet URI \"%s\"", object4, object3);
                                    if (errors != null) {
                                        errors.add(new CssParser.ParseError(string3));
                                    }
                                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                                        StyleManager.getLogger().warning(string3);
                                    }
                                    return null;
                                }
                                String string4 = new String(((DataURI)object3).getData(), (Charset)object2);
                                stylesheet = new CssParser().parse(string4);
                            } else if (bl3) {
                                try (ByteArrayInputStream string5 = new ByteArrayInputStream(((DataURI)object3).getData());){
                                    stylesheet = Stylesheet.loadBinary(string5);
                                }
                            } else {
                                String string5 = String.format("Unexpected MIME type \"%s/%s\" in stylesheet URI \"%s\"", ((DataURI)object3).getMimeType(), ((DataURI)object3).getMimeSubtype(), object3);
                                if (errors != null) {
                                    errors.add(new CssParser.ParseError(string5));
                                }
                                if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                                    StyleManager.getLogger().warning(string5);
                                }
                                return null;
                            }
                        }
                    }
                    if (stylesheet == null) {
                        if (errors != null) {
                            object3 = new CssParser.ParseError("Resource \"" + string + "\" not found.");
                            errors.add((CssParser.ParseError)object3);
                        }
                        if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                            StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", string));
                        }
                    }
                    if (stylesheet != null) {
                        block15: for (FontFace fontFace : stylesheet.getFontFaces()) {
                            if (!(fontFace instanceof FontFaceImpl)) continue;
                            for (FontFaceImpl.FontFaceSrc fontFaceSrc : ((FontFaceImpl)fontFace).getSources()) {
                                if (fontFaceSrc.getType() != FontFaceImpl.FontFaceSrcType.URL) continue;
                                object2 = Font.loadFont(fontFaceSrc.getSrc(), 10.0);
                                if (object2 != null) continue block15;
                                StyleManager.getLogger().info("Could not load @font-face font [" + fontFaceSrc.getSrc() + "]");
                                continue block15;
                            }
                        }
                    }
                    return stylesheet;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (errors != null) {
                        CssParser.ParseError parseError = new CssParser.ParseError("Stylesheet \"" + string + "\" not found.");
                        errors.add(parseError);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                        StyleManager.getLogger().info("Could not find stylesheet: " + string);
                    }
                }
                catch (IOException iOException) {
                    String string6;
                    DataURI dataURI = DataURI.tryParse(string);
                    String string7 = string6 = dataURI != null ? dataURI.toString() : string;
                    if (errors != null) {
                        errors.add(new CssParser.ParseError("Could not load stylesheet: " + string6));
                    }
                    if (!StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) break block41;
                    StyleManager.getLogger().info("Could not load stylesheet: " + string6);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAgentStylesheets(List<String> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            String string;
            String string2;
            int n2;
            int n3;
            boolean bl2;
            if (list.size() == this.platformUserAgentStylesheetContainers.size()) {
                bl2 = true;
                n3 = list.size();
                for (n2 = 0; n2 < n3 && bl2; ++n2) {
                    string2 = list.get(n2);
                    String string3 = string = string2 != null ? string2.trim() : null;
                    if (string == null || string.isEmpty()) break;
                    StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(n2);
                    bl2 = string.equals(stylesheetContainer.fname);
                    if (!bl2) continue;
                    String string4 = stylesheetContainer.stylesheet.getUrl();
                    byte[] byArray = StyleManager.calculateCheckSum(string4);
                    bl2 = Arrays.equals(byArray, stylesheetContainer.checksum);
                }
                if (bl2) {
                    return;
                }
            }
            bl2 = false;
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = list.get(n2);
                String string5 = string = string2 != null ? string2.trim() : null;
                if (string == null || string.isEmpty()) continue;
                if (!bl2) {
                    this.platformUserAgentStylesheetContainers.clear();
                    bl2 = true;
                }
                if (n2 == 0) {
                    this._setDefaultUserAgentStylesheet(string);
                    continue;
                }
                this._addUserAgentStylesheet(string);
            }
            if (bl2) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    public void addUserAgentStylesheet(String string) {
        this.addUserAgentStylesheet(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, String string) {
        String string2;
        String string3 = string2 = string != null ? string.trim() : null;
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            if (this._addUserAgentStylesheet(string2)) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addUserAgentStylesheet(String string) {
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(stylesheetContainer.fname)) continue;
                return false;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string, stylesheet));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String string = stylesheet.getUrl();
        String string2 = string != null ? string.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string2.equals(stylesheetContainer.fname)) continue;
                return;
            }
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string2, stylesheet));
            if (stylesheet != null) {
                stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            }
            this.userAgentStylesheetsChanged();
        }
    }

    public void setDefaultUserAgentStylesheet(String string) {
        this.setDefaultUserAgentStylesheet(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Scene scene, String string) {
        String string2;
        String string3 = string2 = string != null ? string.trim() : null;
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            if (this._setDefaultUserAgentStylesheet(string2)) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _setDefaultUserAgentStylesheet(String string) {
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(stylesheetContainer.fname)) continue;
                if (i2 > 0) {
                    this.platformUserAgentStylesheetContainers.remove(i2);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                    }
                }
                return i2 > 0;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            StylesheetContainer stylesheetContainer = new StylesheetContainer(string, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAgentStylesheet(String string) {
        String string2;
        String string3 = string2 = string != null ? string.trim() : null;
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            boolean bl2 = false;
            for (int i2 = this.platformUserAgentStylesheetContainers.size() - 1; i2 >= 0; --i2) {
                if (string2.equals(Application.getUserAgentStylesheet())) continue;
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string2.equals(stylesheetContainer.fname)) continue;
                this.platformUserAgentStylesheetContainers.remove(i2);
                bl2 = true;
            }
            if (bl2) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            return;
        }
        String string = stylesheet.getUrl();
        String string2 = string != null ? string.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string2.equals(stylesheetContainer.fname)) continue;
                if (i2 > 0) {
                    this.platformUserAgentStylesheetContainers.remove(i2);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                    }
                }
                return;
            }
            StylesheetContainer stylesheetContainer = new StylesheetContainer(string2, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userAgentStylesheetsChanged() {
        ArrayList<Parent> arrayList = new ArrayList<Parent>();
        Iterator iterator = styleLock;
        synchronized (iterator) {
            for (CacheContainer object : cacheContainerMap.values()) {
                object.clearCache();
            }
            StyleConverter.clearCache();
            for (Parent parent : cacheContainerMap.keySet()) {
                if (parent == null) continue;
                arrayList.add(parent);
            }
        }
        for (Object object : arrayList) {
            NodeHelper.reapplyCSS((Node)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> processStylesheets(List<String> list, Parent parent) {
        Object object = styleLock;
        synchronized (object) {
            ArrayList<StylesheetContainer> arrayList = new ArrayList<StylesheetContainer>();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2;
                String string = list.get(i2);
                StylesheetContainer stylesheetContainer = null;
                if (this.stylesheetContainerMap.containsKey(string)) {
                    stylesheetContainer = this.stylesheetContainerMap.get(string);
                    if (!arrayList.contains(stylesheetContainer)) {
                        if (stylesheetContainer.checksumInvalid) {
                            object2 = StyleManager.calculateCheckSum(string);
                            if (!Arrays.equals((byte[])object2, stylesheetContainer.checksum)) {
                                this.removeStylesheetContainer(stylesheetContainer);
                                Stylesheet stylesheet = StyleManager.loadStylesheet(string);
                                stylesheetContainer = new StylesheetContainer(string, stylesheet, (byte[])object2);
                                this.stylesheetContainerMap.put(string, stylesheetContainer);
                            } else {
                                stylesheetContainer.checksumInvalid = false;
                            }
                        }
                        arrayList.add(stylesheetContainer);
                    }
                    stylesheetContainer.parentUsers.add(parent);
                    continue;
                }
                object2 = StyleManager.loadStylesheet(string);
                stylesheetContainer = new StylesheetContainer(string, (Stylesheet)object2);
                stylesheetContainer.parentUsers.add(parent);
                this.stylesheetContainerMap.put(string, stylesheetContainer);
                arrayList.add(stylesheetContainer);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> list = ParentHelper.getAllParentStylesheets(parent);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets(list, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList<String> observableList = scene.getStylesheets();
        if (observableList == null || observableList.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets(observableList, scene.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap findMatchingStyles(Node node, SubScene subScene, Set<PseudoClass>[] setArray) {
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(node, subScene);
        if (cacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            boolean bl2;
            Node node2;
            Parent parent = node instanceof Parent ? (Parent)node : node.getParent();
            List<StylesheetContainer> list = this.gatherParentStylesheets(parent);
            boolean bl3 = !list.isEmpty();
            List<StylesheetContainer> list2 = this.gatherSceneStylesheets(scene);
            boolean bl4 = !list2.isEmpty();
            String string = node.getStyle();
            boolean bl5 = string != null && !string.trim().isEmpty();
            String string2 = scene.getUserAgentStylesheet();
            boolean bl6 = string2 != null && !string2.trim().isEmpty();
            String string3 = subScene != null ? subScene.getUserAgentStylesheet() : null;
            boolean bl7 = string3 != null && !string3.trim().isEmpty();
            String string4 = null;
            for (node2 = node; !(node2 == null || node2 instanceof Region && (string4 = this.weakRegionUserAgentStylesheetMap.computeIfAbsent((Region)node2, Region::getUserAgentStylesheet)) != null); node2 = node2.getParent()) {
            }
            boolean bl8 = bl2 = string4 != null && !string4.trim().isEmpty();
            if (!(bl5 || bl3 || bl4 || bl6 || bl7 || bl2 || !this.platformUserAgentStylesheetContainers.isEmpty())) {
                return StyleMap.EMPTY_MAP;
            }
            String string5 = node.getTypeSelector();
            String string6 = node.getId();
            ObservableList<String> observableList = node.getStyleClass();
            if (this.key == null) {
                this.key = new Key();
            }
            this.key.className = string5;
            this.key.id = string6;
            int n2 = observableList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = (String)observableList.get(i2);
                if (object2 == null || ((String)object2).isEmpty()) continue;
                this.key.styleClasses.add(StyleClassSet.getStyleClass((String)object2));
            }
            Map<Key, Cache> map = cacheContainer.getCacheMap(list, string4);
            Cache cache = map.get(this.key);
            if (cache != null) {
                this.key.styleClasses.clear();
            } else {
                int n3;
                Object object3;
                object2 = new ArrayList();
                if (bl7 || bl6) {
                    object3 = bl7 ? subScene.getUserAgentStylesheet().trim() : scene.getUserAgentStylesheet().trim();
                    StylesheetContainer stylesheetContainer = null;
                    int n4 = this.userAgentStylesheetContainers.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        stylesheetContainer = this.userAgentStylesheetContainers.get(n3);
                        if (((String)object3).equals(stylesheetContainer.fname)) break;
                        stylesheetContainer = null;
                    }
                    if (stylesheetContainer == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet((String)object3);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        stylesheetContainer = new StylesheetContainer((String)object3, stylesheet);
                        this.userAgentStylesheetContainers.add(stylesheetContainer);
                    }
                    if (stylesheetContainer.selectorPartitioning != null) {
                        Parent parent2 = bl7 ? subScene.getRoot() : scene.getRoot();
                        stylesheetContainer.parentUsers.add(parent2);
                        List<Selector> list3 = stylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list3);
                    }
                } else if (!this.platformUserAgentStylesheetContainers.isEmpty()) {
                    int n5 = this.platformUserAgentStylesheetContainers.size();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(i3);
                        if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list4 = stylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list4);
                    }
                }
                if (bl2) {
                    object3 = null;
                    n3 = this.userAgentStylesheetContainers.size();
                    for (int i4 = 0; i4 < n3; ++i4) {
                        object3 = this.userAgentStylesheetContainers.get(i4);
                        if (string4.equals(((StylesheetContainer)object3).fname)) break;
                        object3 = null;
                    }
                    if (object3 == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(string4);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        object3 = new StylesheetContainer(string4, stylesheet);
                        this.userAgentStylesheetContainers.add((StylesheetContainer)object3);
                    }
                    if (((StylesheetContainer)object3).selectorPartitioning != null) {
                        ((StylesheetContainer)object3).parentUsers.add((Parent)node2);
                        List<Selector> list5 = ((StylesheetContainer)object3).selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list5);
                    }
                }
                if (!list2.isEmpty()) {
                    int n6 = list2.size();
                    for (int i5 = 0; i5 < n6; ++i5) {
                        StylesheetContainer stylesheetContainer = list2.get(i5);
                        if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list6 = stylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list6);
                    }
                }
                if (bl3) {
                    int n7 = list == null ? 0 : list.size();
                    for (int i6 = 0; i6 < n7; ++i6) {
                        StylesheetContainer stylesheetContainer = list.get(i6);
                        if (stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list7 = stylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list7);
                    }
                }
                cache = new Cache((List<Selector>)object2);
                map.put(this.key, cache);
                this.key = null;
            }
            object2 = cache.getStyleMap(cacheContainer, node, setArray, bl5);
            return object2;
        }
    }

    public static ObservableList<CssParser.ParseError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssParser.ParseError> getErrors() {
        return errors;
    }

    static {
        cacheContainerMap = new WeakHashMap<Parent, CacheContainer>();
        errors = null;
    }

    private static class InstanceHolder {
        static final StyleManager INSTANCE = new StyleManager();

        private InstanceHolder() {
        }
    }

    private static final class ImageCache {
        private Map<String, SoftReference<Image>> imageCache = new HashMap<String, SoftReference<Image>>();

        private ImageCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Image getCachedImage(String string) {
            Object object = styleLock;
            synchronized (object) {
                Image image;
                block11: {
                    image = null;
                    if (this.imageCache.containsKey(string)) {
                        image = this.imageCache.get(string).get();
                    }
                    if (image == null) {
                        try {
                            image = new Image(string);
                            if (image.isError()) {
                                PlatformLogger platformLogger = StyleManager.getLogger();
                                if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                                    DataURI dataURI = DataURI.tryParse(string);
                                    if (dataURI != null) {
                                        platformLogger.warning("Error loading image: " + dataURI);
                                    } else {
                                        platformLogger.warning("Error loading image: " + string);
                                    }
                                }
                                image = null;
                            }
                            this.imageCache.put(string, new SoftReference<Image>(image));
                        }
                        catch (IllegalArgumentException | NullPointerException runtimeException) {
                            PlatformLogger platformLogger = StyleManager.getLogger();
                            if (platformLogger == null || !platformLogger.isLoggable(PlatformLogger.Level.WARNING)) break block11;
                            platformLogger.warning(runtimeException.getLocalizedMessage());
                        }
                    }
                }
                return image;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUpImageCache(String string) {
            Object object = styleLock;
            synchronized (object) {
                if (string == null || this.imageCache.isEmpty()) {
                    return;
                }
                String string2 = string.trim();
                if (string2.isEmpty()) {
                    return;
                }
                int n2 = string2.lastIndexOf(47);
                String string3 = n2 > 0 ? string2.substring(0, n2) : string2;
                int n3 = string3.length();
                String[] stringArray = new String[this.imageCache.size()];
                int n4 = 0;
                Set<Map.Entry<String, SoftReference<Image>>> set = this.imageCache.entrySet();
                for (Map.Entry<String, SoftReference<Image>> entry : set) {
                    String string4 = entry.getKey();
                    if (entry.getValue().get() == null) {
                        stringArray[n4++] = string4;
                        continue;
                    }
                    n2 = string4.lastIndexOf(47);
                    String string5 = n2 > 0 ? string4.substring(0, n2) : string4;
                    int n5 = string5.length();
                    boolean bl2 = n5 > n3 ? string5.startsWith(string3) : string3.startsWith(string5);
                    if (!bl2) continue;
                    stringArray[n4++] = string4;
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.imageCache.remove(stringArray[i2]);
                }
            }
        }
    }

    private static class Key {
        String className;
        String id;
        final StyleClassSet styleClasses = new StyleClassSet();

        private Key() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                if (this.className == null ? key.className != null : !this.className.equals(key.className)) {
                    return false;
                }
                if (this.id == null ? key.id != null : !this.id.equals(key.id)) {
                    return false;
                }
                return this.styleClasses.equals(key.styleClasses);
            }
            return true;
        }

        public int hashCode() {
            int n2 = 7;
            n2 = 29 * n2 + (this.className != null ? this.className.hashCode() : 0);
            n2 = 29 * n2 + (this.id != null ? this.id.hashCode() : 0);
            n2 = 29 * n2 + this.styleClasses.hashCode();
            return n2;
        }
    }

    static class CacheContainer {
        private Map<StyleCache.Key, StyleCache> styleCache;
        private Map<List<String>, Map<Key, Cache>> cacheMap;
        private List<StyleMap> styleMapList;
        private Map<String, Selector> inlineStylesCache;
        private int styleMapId = 0;
        private int baseStyleMapId = 0;

        CacheContainer() {
        }

        private Map<StyleCache.Key, StyleCache> getStyleCache() {
            if (this.styleCache == null) {
                this.styleCache = new HashMap<StyleCache.Key, StyleCache>();
            }
            return this.styleCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Key, Cache> getCacheMap(List<StylesheetContainer> list, String string) {
            if (this.cacheMap == null) {
                this.cacheMap = new HashMap<List<String>, Map<Key, Cache>>();
            }
            Object object = styleLock;
            synchronized (object) {
                Map<Key, Cache> map;
                if ((list == null || list.isEmpty()) && (string == null || string.isEmpty())) {
                    Map<Key, Cache> map2 = this.cacheMap.get(null);
                    if (map2 == null) {
                        map2 = new HashMap<Key, Cache>();
                        this.cacheMap.put(null, map2);
                    }
                    return map2;
                }
                int n2 = list.size();
                if (cacheMapKey == null) {
                    cacheMapKey = new ArrayList<String>(n2);
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    StylesheetContainer stylesheetContainer = list.get(i2);
                    if (stylesheetContainer == null || stylesheetContainer.fname == null || stylesheetContainer.fname.isEmpty()) continue;
                    cacheMapKey.add(stylesheetContainer.fname);
                }
                if (string != null) {
                    cacheMapKey.add(string);
                }
                if ((map = this.cacheMap.get(cacheMapKey)) == null) {
                    map = new HashMap<Key, Cache>();
                    this.cacheMap.put(cacheMapKey, map);
                    cacheMapKey = null;
                } else {
                    cacheMapKey.clear();
                }
                return map;
            }
        }

        private List<StyleMap> getStyleMapList() {
            if (this.styleMapList == null) {
                this.styleMapList = new ArrayList<StyleMap>();
            }
            return this.styleMapList;
        }

        private int nextSmapId() {
            this.styleMapId = this.baseStyleMapId + this.getStyleMapList().size();
            return this.styleMapId;
        }

        private void addStyleMap(StyleMap styleMap) {
            this.getStyleMapList().add(styleMap);
        }

        public StyleMap getStyleMap(int n2) {
            int n3 = n2 - this.baseStyleMapId;
            if (0 <= n3 && n3 < this.getStyleMapList().size()) {
                return this.getStyleMapList().get(n3);
            }
            return StyleMap.EMPTY_MAP;
        }

        private void clearCache() {
            if (this.cacheMap != null) {
                this.cacheMap.clear();
            }
            if (this.styleCache != null) {
                this.styleCache.clear();
            }
            if (this.styleMapList != null) {
                this.styleMapList.clear();
            }
            this.baseStyleMapId = this.styleMapId;
            if (this.baseStyleMapId > 0x6FFFFFF9) {
                this.styleMapId = 0;
                this.baseStyleMapId = 0;
            }
        }

        private Selector getInlineStyleSelector(String string) {
            Stylesheet stylesheet;
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            if (this.inlineStylesCache != null && this.inlineStylesCache.containsKey(string)) {
                return this.inlineStylesCache.get(string);
            }
            if (this.inlineStylesCache == null) {
                this.inlineStylesCache = new HashMap<String, Selector>();
            }
            if ((stylesheet = new CssParser().parse("*{" + string + "}")) != null) {
                Selector selector;
                stylesheet.setOrigin(StyleOrigin.INLINE);
                List<Rule> list = stylesheet.getRules();
                Rule rule = list != null && !list.isEmpty() ? list.get(0) : null;
                ObservableList<Selector> observableList = rule != null ? rule.getSelectors() : null;
                Selector selector2 = selector = observableList != null && !observableList.isEmpty() ? (Selector)observableList.get(0) : null;
                if (selector != null) {
                    selector.setOrdinal(-1);
                    this.inlineStylesCache.put(string, selector);
                    return selector;
                }
            }
            this.inlineStylesCache.put(string, null);
            return null;
        }
    }

    static class StylesheetContainer {
        final String fname;
        final Stylesheet stylesheet;
        final SelectorPartitioning selectorPartitioning;
        final RefList<Parent> parentUsers;
        final int hash;
        final byte[] checksum;
        boolean checksumInvalid = false;

        StylesheetContainer(String string, Stylesheet stylesheet) {
            this(string, stylesheet, stylesheet != null ? StyleManager.calculateCheckSum(stylesheet.getUrl()) : new byte[]{});
        }

        StylesheetContainer(String string, Stylesheet stylesheet, byte[] byArray) {
            this.fname = string;
            this.hash = string != null ? string.hashCode() : 127;
            this.stylesheet = stylesheet;
            if (stylesheet != null) {
                this.selectorPartitioning = new SelectorPartitioning();
                List<Rule> list = stylesheet.getRules();
                int n2 = list == null || list.isEmpty() ? 0 : list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Rule rule = list.get(i2);
                    ObservableList<Selector> observableList = rule.getSelectors();
                    int n3 = observableList == null || observableList.isEmpty() ? 0 : observableList.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Selector selector = (Selector)observableList.get(i3);
                        this.selectorPartitioning.partition(selector);
                    }
                }
            } else {
                this.selectorPartitioning = null;
            }
            this.parentUsers = new RefList();
            this.checksum = byArray;
        }

        void invalidateChecksum() {
            this.checksumInvalid = this.checksum.length > 0;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StylesheetContainer stylesheetContainer = (StylesheetContainer)object;
            return !(this.fname == null ? stylesheetContainer.fname != null : !this.fname.equals(stylesheetContainer.fname));
        }

        public String toString() {
            return this.fname;
        }
    }

    static class RefList<K> {
        final List<Reference<K>> list = new ArrayList<Reference<K>>();

        RefList() {
        }

        void add(K k2) {
            for (int i2 = this.list.size() - 1; 0 <= i2; --i2) {
                Reference<K> reference = this.list.get(i2);
                K k3 = reference.get();
                if (k3 == null) {
                    this.list.remove(i2);
                    continue;
                }
                if (k3 != k2) continue;
                return;
            }
            this.list.add(new WeakReference<K>(k2));
        }

        void remove(K k2) {
            for (int i2 = this.list.size() - 1; 0 <= i2; --i2) {
                Reference<K> reference = this.list.get(i2);
                K k3 = reference.get();
                if (k3 == null) {
                    this.list.remove(i2);
                    continue;
                }
                if (k3 != k2) continue;
                this.list.remove(i2);
                return;
            }
        }

        boolean contains(K k2) {
            for (int i2 = this.list.size() - 1; 0 <= i2; --i2) {
                Reference<K> reference = this.list.get(i2);
                K k3 = reference.get();
                if (k3 != k2) continue;
                return true;
            }
            return false;
        }
    }

    private static class Cache {
        private final List<Selector> selectors;
        private final Map<Key, Integer> cache;

        Cache(List<Selector> list) {
            this.selectors = list;
            this.cache = new HashMap<Key, Integer>();
        }

        private StyleMap getStyleMap(CacheContainer cacheContainer, Node node, Set<PseudoClass>[] setArray, boolean bl2) {
            int n2;
            Selector selector;
            Object object;
            if ((this.selectors == null || this.selectors.isEmpty()) && !bl2) {
                return StyleMap.EMPTY_MAP;
            }
            int n3 = this.selectors.size();
            long[] lArray = new long[n3 / 64 + 1];
            boolean bl3 = true;
            for (int i2 = 0; i2 < n3; ++i2) {
                long l2;
                object = this.selectors.get(i2);
                if (!((Selector)object).applies(node, setArray, 0)) continue;
                int n4 = i2 / 64;
                lArray[n4] = l2 = lArray[n4] | 1L << i2;
                bl3 = false;
            }
            if (bl3 && !bl2) {
                return StyleMap.EMPTY_MAP;
            }
            String string = node.getStyle();
            object = new Key(lArray, string);
            if (this.cache.containsKey(object)) {
                Integer n5 = this.cache.get(object);
                StyleMap styleMap = n5 != null ? cacheContainer.getStyleMap(n5) : StyleMap.EMPTY_MAP;
                return styleMap;
            }
            ArrayList<Selector> arrayList = new ArrayList<Selector>();
            if (bl2 && (selector = cacheContainer.getInlineStyleSelector(string)) != null) {
                arrayList.add(selector);
            }
            for (n2 = 0; n2 < lArray.length; ++n2) {
                if (lArray[n2] == 0L) continue;
                int n6 = n2 * 64;
                for (int i3 = 0; i3 < 64; ++i3) {
                    long l3 = 1L << i3;
                    if ((l3 & lArray[n2]) != l3) continue;
                    Selector selector2 = this.selectors.get(n6 + i3);
                    arrayList.add(selector2);
                }
            }
            n2 = cacheContainer.nextSmapId();
            this.cache.put((Key)object, n2);
            StyleMap styleMap = new StyleMap(n2, arrayList);
            cacheContainer.addStyleMap(styleMap);
            return styleMap;
        }

        private static class Key {
            final long[] key;
            final String inlineStyle;

            Key(long[] lArray, String string) {
                this.key = lArray;
                this.inlineStyle = string != null && string.trim().isEmpty() ? null : string;
            }

            public String toString() {
                return Arrays.toString(this.key) + (String)(this.inlineStyle != null ? "* {" + this.inlineStyle + "}" : "");
            }

            public int hashCode() {
                int n2 = 3;
                n2 = 17 * n2 + Arrays.hashCode(this.key);
                if (this.inlineStyle != null) {
                    n2 = 17 * n2 + this.inlineStyle.hashCode();
                }
                return n2;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Key key = (Key)object;
                if (this.inlineStyle == null ? key.inlineStyle != null : !this.inlineStyle.equals(key.inlineStyle)) {
                    return false;
                }
                return Arrays.equals(this.key, key.key);
            }
        }
    }
}

