/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.stage.Screen;

public abstract class GlassRobot {
    public static final int MOUSE_LEFT_BTN = 1;
    public static final int MOUSE_RIGHT_BTN = 2;
    public static final int MOUSE_MIDDLE_BTN = 4;
    public static final int MOUSE_BACK_BTN = 8;
    public static final int MOUSE_FORWARD_BTN = 16;

    public abstract void create();

    public abstract void destroy();

    public abstract void keyPress(KeyCode var1);

    public abstract void keyRelease(KeyCode var1);

    public abstract double getMouseX();

    public abstract double getMouseY();

    public abstract void mouseMove(double var1, double var3);

    public abstract void mousePress(MouseButton ... var1);

    public abstract void mouseRelease(MouseButton ... var1);

    public abstract void mouseWheel(int var1);

    public abstract Color getPixelColor(double var1, double var3);

    public void getScreenCapture(int n2, int n3, int n4, int n5, int[] nArray, boolean bl2) {
        throw new InternalError("not implemented");
    }

    public WritableImage getScreenCapture(WritableImage writableImage, double d2, double d3, double d4, double d5, boolean bl2) {
        int n2;
        int n3;
        int[] nArray;
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        Screen screen = Screen.getPrimary();
        Objects.requireNonNull(screen);
        double d6 = screen.getOutputScaleX();
        double d7 = screen.getOutputScaleY();
        if (d6 == 1.0 && d7 == 1.0) {
            nArray = new int[(int)(d4 * d5)];
            this.getScreenCapture((int)d2, (int)d3, (int)d4, (int)d5, nArray, bl2);
            n3 = (int)d4;
            n2 = (int)d5;
        } else {
            int n4 = (int)Math.floor(d2 * d6);
            int n5 = (int)Math.floor(d3 * d7);
            int n6 = (int)Math.ceil((d2 + d4) * d6);
            int n7 = (int)Math.ceil((d3 + d5) * d7);
            int n8 = n6 - n4;
            int n9 = n7 - n5;
            int[] nArray2 = new int[n8 * n9];
            this.getScreenCapture(n4, n5, n8, n9, nArray2, bl2);
            n3 = n8;
            n2 = n9;
            if (!bl2) {
                nArray = nArray2;
            } else {
                nArray = new int[(int)(d4 * d5)];
                int n10 = 0;
                int n11 = 0;
                while ((double)n11 < d5) {
                    double d8 = (d3 + (double)n11 + 0.5) * d7 - (double)((float)n5 + 0.5f);
                    int n12 = (int)Math.floor(d8);
                    int n13 = (int)((d8 - (double)n12) * 256.0);
                    int n14 = 0;
                    while ((double)n14 < d4) {
                        double d9 = (d2 + (double)n14 + 0.5) * d6 - (double)((float)n4 + 0.5f);
                        int n15 = (int)Math.floor(d9);
                        int n16 = (int)((d9 - (double)n15) * 256.0);
                        nArray[n10++] = GlassRobot.interp(nArray2, n15, n12, n8, n9, n16, n13);
                        ++n14;
                    }
                    ++n11;
                }
                n3 = (int)d4;
                n2 = (int)d5;
            }
        }
        return GlassRobot.convertFromPixels(writableImage, Application.GetApplication().createPixels(n3, n2, IntBuffer.wrap(nArray)));
    }

    public static int convertToRobotMouseButton(MouseButton[] mouseButtonArray) {
        int n2 = 0;
        block7: for (MouseButton mouseButton : mouseButtonArray) {
            switch (mouseButton) {
                case PRIMARY: {
                    n2 |= 1;
                    continue block7;
                }
                case SECONDARY: {
                    n2 |= 2;
                    continue block7;
                }
                case MIDDLE: {
                    n2 |= 4;
                    continue block7;
                }
                case BACK: {
                    n2 |= 8;
                    continue block7;
                }
                case FORWARD: {
                    n2 |= 0x10;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + mouseButton + " not supported by Robot");
                }
            }
        }
        return n2;
    }

    public static Color convertFromIntArgb(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        return new Color((double)n4 / 255.0, (double)n5 / 255.0, (double)n6 / 255.0, (double)n3 / 255.0);
    }

    protected static WritableImage convertFromPixels(WritableImage writableImage, Pixels pixels) {
        int n2;
        Objects.requireNonNull(pixels);
        int n3 = pixels.getWidth();
        int n4 = pixels.getHeight();
        if (writableImage == null || writableImage.getWidth() != (double)n3 || writableImage.getHeight() != (double)n4) {
            writableImage = new WritableImage(n3, n4);
        }
        if ((n2 = pixels.getBytesPerComponent()) == 4) {
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            GlassRobot.writeIntBufferToImage(intBuffer, writableImage);
        } else if (n2 == 1) {
            ByteBuffer byteBuffer = (ByteBuffer)pixels.getPixels();
            GlassRobot.writeByteBufferToImage(byteBuffer, writableImage);
        } else {
            throw new IllegalArgumentException("bytesPerComponent must be either 4 or 1 but was: " + n2);
        }
        return writableImage;
    }

    private static void writeIntBufferToImage(IntBuffer intBuffer, WritableImage writableImage) {
        Objects.requireNonNull(writableImage);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        double d2 = writableImage.getWidth();
        double d3 = writableImage.getHeight();
        int n2 = 0;
        while ((double)n2 < d3) {
            int n3 = 0;
            while ((double)n3 < d2) {
                int n4 = intBuffer.get();
                pixelWriter.setArgb(n3, n2, n4);
                ++n3;
            }
            ++n2;
        }
    }

    private static void writeByteBufferToImage(ByteBuffer byteBuffer, WritableImage writableImage) {
        Objects.requireNonNull(writableImage);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        double d2 = writableImage.getWidth();
        double d3 = writableImage.getHeight();
        int n2 = Pixels.getNativeFormat();
        int n3 = 0;
        while ((double)n3 < d3) {
            int n4 = 0;
            while ((double)n4 < d2) {
                if (n2 == 1) {
                    pixelWriter.setArgb(n4, n3, PixelUtils.PretoNonPre(GlassRobot.bgraPreToRgbaPre(byteBuffer.getInt())));
                } else if (n2 == 2) {
                    pixelWriter.setArgb(n4, n3, byteBuffer.getInt());
                } else {
                    throw new IllegalArgumentException("format must be either BYTE_BGRA_PRE or BYTE_ARGB");
                }
                ++n4;
            }
            ++n3;
        }
    }

    private static int bgraPreToRgbaPre(int n2) {
        return Integer.reverseBytes(n2);
    }

    private static int interp(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = 256 - n6;
        int n10 = 256 - n7;
        int n11 = n3 * n4 + n2;
        int n12 = n8 = n2 < 0 || n3 < 0 || n2 >= n4 || n3 >= n5 ? 0 : nArray[n11];
        if (n7 == 0) {
            if (n6 == 0) {
                return n8;
            }
            int n13 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
            return GlassRobot.interp(n8, n13, n9, n6);
        }
        if (n6 == 0) {
            int n14 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
            return GlassRobot.interp(n8, n14, n10, n7);
        }
        int n15 = n3 < 0 || n2 + 1 >= n4 || n3 >= n5 ? 0 : nArray[n11 + 1];
        int n16 = n2 < 0 || n2 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4];
        int n17 = n2 + 1 >= n4 || n3 + 1 >= n5 ? 0 : nArray[n11 + n4 + 1];
        return GlassRobot.interp(GlassRobot.interp(n8, n15, n9, n6), GlassRobot.interp(n16, n17, n9, n6), n10, n7);
    }

    private static int interp(int n2, int n3, int n4, int n5) {
        int n6 = n2 >> 24 & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        int n10 = n3 >> 24 & 0xFF;
        int n11 = n3 >> 16 & 0xFF;
        int n12 = n3 >> 8 & 0xFF;
        int n13 = n3 & 0xFF;
        int n14 = n6 * n4 + n10 * n5 >> 8;
        int n15 = n7 * n4 + n11 * n5 >> 8;
        int n16 = n8 * n4 + n12 * n5 >> 8;
        int n17 = n9 * n4 + n13 * n5 >> 8;
        return n14 << 24 | n15 << 16 | n16 << 8 | n17;
    }
}

