/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class JsonNumEquals {
    private static final JsonNumEquals INSTANCE = new JsonNumEquals();

    private JsonNumEquals() {
    }

    public static JsonNumEquals getInstance() {
        return INSTANCE;
    }

    public final boolean equivalent(@Nullable JsonNode a2, @Nullable JsonNode b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return this.doEquivalent(a2, b2);
    }

    protected boolean doEquivalent(JsonNode a2, JsonNode b2) {
        NodeType typeB;
        if (a2.isNumber() && b2.isNumber()) {
            return JsonNumEquals.numEquals(a2, b2);
        }
        NodeType typeA = NodeType.getNodeType(a2);
        if (typeA != (typeB = NodeType.getNodeType(b2))) {
            return false;
        }
        if (!a2.isContainerNode()) {
            return a2.equals(b2);
        }
        if (a2.size() != b2.size()) {
            return false;
        }
        return typeA == NodeType.ARRAY ? this.arrayEquals(a2, b2) : this.objectEquals(a2, b2);
    }

    public final int hash(@Nullable JsonNode t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    protected int doHash(JsonNode t2) {
        if (t2.isNumber()) {
            return Double.valueOf(t2.doubleValue()).hashCode();
        }
        if (!t2.isContainerNode()) {
            return t2.hashCode();
        }
        int ret = 0;
        if (t2.size() == 0) {
            return ret;
        }
        if (t2.isArray()) {
            for (JsonNode element : t2) {
                ret = 31 * ret + this.hash(element);
            }
            return ret;
        }
        Iterator<Map.Entry<String, JsonNode>> iterator = t2.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret = 31 * ret + (entry.getKey().hashCode() ^ this.hash(entry.getValue()));
        }
        return ret;
    }

    private static boolean numEquals(JsonNode a2, JsonNode b2) {
        if (a2.isIntegralNumber() && b2.isIntegralNumber()) {
            return a2.equals(b2);
        }
        return a2.decimalValue().compareTo(b2.decimalValue()) == 0;
    }

    private boolean arrayEquals(JsonNode a2, JsonNode b2) {
        int size = a2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.equivalent(a2.get(i2), b2.get(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEquals(JsonNode a2, JsonNode b2) {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> iterator1 = a2.fieldNames();
        while (iterator1.hasNext()) {
            String next = iterator1.next();
            if (next != null) {
                keys.add(next);
                continue;
            }
            throw new NullPointerException();
        }
        HashSet<String> set = new HashSet<String>();
        Iterator<String> iterator2 = b2.fieldNames();
        while (iterator2.hasNext()) {
            String next = iterator2.next();
            if (next != null) {
                set.add(next);
                continue;
            }
            throw new NullPointerException();
        }
        if (!set.equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (this.equivalent(a2.get(key), b2.get(key))) continue;
            return false;
        }
        return true;
    }
}

