/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    public FileNamePattern(String patternArg, Context contextArg) {
        this.setPattern(FileFilterUtil.slashify(patternArg));
        this.setContext(contextArg);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            String patternForParsing = this.escapeRightParantesis(this.pattern);
            Parser p2 = new Parser(patternForParsing, new AlmostAsIsEscapeUtil());
            p2.setContext(this.context);
            Node t2 = p2.parse();
            this.headTokenConverter = p2.compile(t2, CONVERTER_MAP);
        }
        catch (ScanException sce) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", sce);
        }
    }

    String escapeRightParantesis(String in2) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNamePattern other = (FileNamePattern)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        for (Converter<Object> p2 = this.headTokenConverter; p2 != null; p2 = p2.getNext()) {
            DateTokenConverter dtc;
            if (!(p2 instanceof DateTokenConverter) || !(dtc = (DateTokenConverter)p2).isPrimary()) continue;
            return dtc;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> p2 = this.headTokenConverter; p2 != null; p2 = p2.getNext()) {
            if (!(p2 instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)p2;
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter itc = this.getIntegerTokenConverter();
        return itc != null;
    }

    public String convertMultipleArguments(Object ... objectList) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> c2 = this.headTokenConverter; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof MonoTypedConverter) {
                MonoTypedConverter monoTyped = (MonoTypedConverter)((Object)c2);
                for (Object o2 : objectList) {
                    if (!monoTyped.isApplicable(o2)) continue;
                    buf.append(c2.convert(o2));
                }
                continue;
            }
            buf.append(c2.convert(objectList));
        }
        return buf.toString();
    }

    public String convert(Object o2) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p2 = this.headTokenConverter; p2 != null; p2 = p2.getNext()) {
            buf.append(p2.convert(o2));
        }
        return buf.toString();
    }

    public String convertInt(int i2) {
        return this.convert(i2);
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegexForFixedDate(Date date) {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p2 = this.headTokenConverter; p2 != null; p2 = p2.getNext()) {
            if (p2 instanceof LiteralConverter) {
                buf.append(p2.convert(null));
                continue;
            }
            if (p2 instanceof IntegerTokenConverter) {
                buf.append("(\\d+)");
                continue;
            }
            if (!(p2 instanceof DateTokenConverter)) continue;
            buf.append(p2.convert(date));
        }
        return buf.toString();
    }

    public String toRegex() {
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p2 = this.headTokenConverter; p2 != null; p2 = p2.getNext()) {
            if (p2 instanceof LiteralConverter) {
                buf.append(p2.convert(null));
                continue;
            }
            if (p2 instanceof IntegerTokenConverter) {
                buf.append("\\d+");
                continue;
            }
            if (!(p2 instanceof DateTokenConverter)) continue;
            DateTokenConverter dtc = (DateTokenConverter)p2;
            buf.append(dtc.toRegex());
        }
        return buf.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }
}

