/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.exception.DataDefinitionException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.impl.QOM;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.sqlite.sqlite_master.SQLiteMaster;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class SQLiteTableDefinition
extends AbstractTableDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(SQLiteTableDefinition.class);
    private static Boolean existsSqliteSequence;
    private Table<?> interpretedTable;

    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    Table<?> interpretedTable() {
        if (this.interpretedTable == null) {
            try {
                Configuration c2 = this.create().configuration().derive();
                c2.settings().withParseWithMetaLookups(ParseWithMetaLookups.THROW_ON_FAILURE);
                Query query = this.create().parser().parseQuery(this.getSource());
                Iterator<Table<?>> iterator = this.create().meta(query).getTables(this.getInputName()).iterator();
                if (iterator.hasNext()) {
                    Table<?> t2 = iterator.next();
                    this.interpretedTable = t2;
                    return this.interpretedTable;
                }
            }
            catch (ParserException e2) {
                log.info((Object)("Cannot parse SQL: " + this.getSource()), e2);
            }
            catch (DataDefinitionException e3) {
                log.info((Object)("Cannot interpret SQL: " + this.getSource()), e3);
            }
        }
        return this.interpretedTable;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Field<String> fName = DSL.field(DSL.name("name"), String.class);
        Field<String> fType = DSL.field(DSL.name("type"), String.class);
        Field<Boolean> fNotnull = DSL.field(DSL.name("notnull"), Boolean.TYPE);
        Field<String> fDefaultValue = DSL.field(DSL.name("dflt_value"), String.class);
        Field<Integer> fPk = DSL.field(DSL.name("pk"), Integer.TYPE);
        Field<Integer> fHidden = DSL.field(DSL.name("hidden"), Integer.TYPE);
        for (Record record : this.create().select(fName, fType, fNotnull, fDefaultValue, fPk, fHidden).from("pragma_table_xinfo({0})", DSL.inline(this.getName())).where("hidden in (0, 2, 3)")) {
            Field<?> f2;
            Table<?> t2;
            String name = record.get(fName);
            String dataType = record.get(fType).replaceAll("\\(\\d+(\\s*,\\s*\\d+)?\\)", "");
            Number precision = this.parsePrecision(record.get(fType));
            Number scale = this.parseScale(record.get(fType));
            int pk2 = record.get(fPk);
            int hidden = record.get(fHidden);
            boolean identity = false;
            boolean generated = hidden == 2 || hidden == 3;
            String generator = null;
            if ((StringUtils.isBlank(dataType) || "other".equals(dataType)) && (t2 = this.interpretedTable()) != null && (f2 = t2.field(name)) != null) {
                dataType = f2.getDataType().getName();
                precision = f2.getDataType().precision();
                scale = f2.getDataType().scale();
            }
            if (generated) {
                dataType = dataType.replaceAll("(?i:\\s*generated\\s+always\\s*)", "");
            }
            if (pk2 > 0 && !(identity |= this.existsSqliteSequence() && this.create().fetchOne("select count(*) from sqlite_sequence where name = ?", this.getName()).get(0, Boolean.class) != false) && !this.create().fetchExists(DSL.selectOne().from("{0}", DSL.name(this.getName())))) {
                identity = this.getSource().matches("(?s:.*\\b" + this.getName() + "\\b[^,]*(?i:\\bautoincrement\\b)[^,]*.*)");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale, (Boolean)(record.get(fNotnull) == false ? 1 : 0), record.get(fDefaultValue)).generatedAlwaysAs(generator).generationOption(hidden == 2 ? QOM.GenerationOption.VIRTUAL : (hidden == 3 ? QOM.GenerationOption.STORED : null));
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), name, result.size() + 1, (DataTypeDefinition)type, identity, null));
        }
        return result;
    }

    private boolean existsSqliteSequence() {
        if (existsSqliteSequence == null) {
            existsSqliteSequence = this.create().selectCount().from((TableLike<?>)SQLiteMaster.SQLITE_MASTER).where(SQLiteMaster.NAME.lower().eq("sqlite_sequence")).fetchOne(0, Boolean.TYPE);
        }
        return existsSqliteSequence;
    }
}

