/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mariadb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.mysql.MySQLDatabase;
import org.jooq.meta.mysql.information_schema.Tables;

public class MariaDBDatabase
extends MySQLDatabase {
    private static final long DEFAULT_SEQUENCE_MAXVALUE = 0x7FFFFFFFFFFFFFFEL;
    private static final long DEFAULT_SEQUENCE_CACHE = 1000L;

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.MARIADB);
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return null;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).from((TableLike<?>)Tables.TABLES).where(Tables.TABLES.TABLE_TYPE.eq("SEQUENCE"))) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, SQLDataType.BIGINT.getTypeName());
            Field<Long> startWith = DSL.nullif(DSL.field("start_value", SQLDataType.BIGINT), DSL.inline(1L));
            Field<Long> incrementBy = DSL.nullif(DSL.field("increment", SQLDataType.BIGINT), DSL.inline(1L));
            Param<Long> minValue = DSL.inline(DSL.field("minimum_value", SQLDataType.BIGINT), DSL.inline(1L));
            Field<Long> maxValue = DSL.nullif(DSL.field("maximum_value", SQLDataType.BIGINT), DSL.inline(0x7FFFFFFFFFFFFFFEL));
            Field<Boolean> cycle = DSL.field("cycle_option", SQLDataType.BOOLEAN);
            Field<Long> cache = DSL.nullif(DSL.field("cache_size", SQLDataType.BIGINT), DSL.inline(1000L));
            Object flags = this.create().select(startWith, incrementBy, minValue, maxValue, cycle, cache).from(DSL.name(schema.getName(), name)).fetchOne();
            result.add(new DefaultSequenceDefinition(schema, name, type, null, flags.get(startWith), flags.get(incrementBy), flags.get(minValue), flags.get(maxValue), flags.get(cycle), flags.get(cache)));
        }
        return result;
    }
}

