/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.CaseConditionStep;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractAggregateFunction;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Product
extends AbstractAggregateFunction<BigDecimal>
implements QOM.Product {
    Product(Field<? extends Number> field, boolean distinct) {
        super(distinct, Names.N_PRODUCT, SQLDataType.NUMERIC, Tools.nullSafeNotNull(field, SQLDataType.INTEGER));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        this.acceptEmulation(ctx);
    }

    private final void acceptEmulation(Context<?> ctx) {
        Field<Integer> f2 = DSL.field("{0}", ((Field)this.arguments.get(0)).getDataType(), new QueryPart[]{this.arguments.get(0)});
        CaseConditionStep<Integer> negatives = DSL.when(f2.lt(DSL.zero()), DSL.inline(-1));
        CustomField<BigDecimal> negativesSum = CustomField.of("sum", SQLDataType.NUMERIC, c2 -> {
            c2.visit(this.distinct ? DSL.sumDistinct(negatives) : DSL.sum(negatives));
            this.acceptFilterClause((Context<?>)c2);
            this.acceptOverClause((Context<?>)c2);
        });
        CustomField<BigDecimal> zerosSum = CustomField.of("sum", SQLDataType.NUMERIC, c2 -> {
            c2.visit(DSL.sum(DSL.choose(f2).when((Field<Integer>)DSL.zero(), DSL.one())));
            this.acceptFilterClause((Context<?>)c2);
            this.acceptOverClause((Context<?>)c2);
        });
        CustomField<BigDecimal> logarithmsSum = CustomField.of("sum", SQLDataType.NUMERIC, c2 -> {
            Field<Integer> abs = DSL.abs(DSL.nullif(f2, DSL.zero()));
            Field<BigDecimal> ln2 = DSL.ln(abs);
            c2.visit(this.distinct ? DSL.sumDistinct(ln2) : DSL.sum(ln2));
            this.acceptFilterClause((Context<?>)c2);
            this.acceptOverClause((Context<?>)c2);
        });
        ctx.visit(Internal.imul(DSL.when(zerosSum.gt(DSL.inline(BigDecimal.ZERO)), DSL.zero()).when(negativesSum.mod(DSL.inline(2)).lt(DSL.inline(BigDecimal.ZERO)), DSL.inline(-1)).otherwise(DSL.one()), DSL.exp(logarithmsSum)));
    }

    @Override
    public final Field<? extends Number> $field() {
        return (Field)this.getArguments().get(0);
    }

    @Override
    public final QOM.Product $field(Field<? extends Number> newValue) {
        return this.constructor().apply((Field<? extends Number>)newValue, (Boolean)this.$distinct());
    }

    @Override
    public final QOM.Product $distinct(boolean newValue) {
        return this.constructor().apply((Field<? extends Number>)this.$field(), (Boolean)newValue);
    }

    public final Function2<? super Field<? extends Number>, ? super Boolean, ? extends QOM.Product> constructor() {
        return (a1, a2) -> new Product((Field<? extends Number>)a1, (boolean)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Product) {
            QOM.Product o2 = (QOM.Product)that;
            return StringUtils.equals(this.$field(), o2.$field()) && this.$distinct() == o2.$distinct();
        }
        return super.equals(that);
    }
}

