/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Check;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.Domain;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Key;
import org.jooq.Param;
import org.jooq.Qualified;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.Convert;
import org.jooq.impl.DSL;
import org.jooq.impl.QOM;
import org.jooq.tools.StringUtils;
import org.jooq.util.xml.jaxb.CheckConstraint;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.DomainConstraint;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;
import org.jooq.util.xml.jaxb.TableType;
import org.jooq.util.xml.jaxb.View;

final class InformationSchemaExport {
    static final InformationSchema exportTables(Configuration configuration, List<Table<?>> tables) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet<Schema> includedSchemas = new LinkedHashSet<Schema>();
        LinkedHashSet includedTables = new LinkedHashSet(tables);
        for (Table<Object> t2 : tables) {
            if (t2.getSchema() == null) continue;
            includedSchemas.add(t2.getSchema());
        }
        for (Schema s2 : includedSchemas) {
            if (s2.getCatalog() == null) continue;
            includedCatalogs.add(s2.getCatalog());
        }
        for (Catalog c2 : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
        }
        for (Schema s2 : includedSchemas) {
            InformationSchemaExport.exportSchema0(result, s2);
        }
        for (Table<Object> t2 : tables) {
            InformationSchemaExport.exportTable0(configuration, result, t2, includedTables);
        }
        return result;
    }

    static final InformationSchema exportSchemas(Configuration configuration, List<Schema> schemas) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Schema s2 : schemas) {
            if (s2.getCatalog() != null) {
                includedCatalogs.add(s2.getCatalog());
            }
            includedTables.addAll(s2.getTables());
        }
        for (Catalog c2 : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
        }
        for (Schema s2 : schemas) {
            InformationSchemaExport.exportSchema0(result, s2);
            for (Domain<?> domain : s2.getDomains()) {
                InformationSchemaExport.exportDomain0(configuration, result, domain);
            }
            for (Table table : s2.getTables()) {
                InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
            }
            for (Sequence sequence : s2.getSequences()) {
                InformationSchemaExport.exportSequence0(configuration, result, sequence);
            }
        }
        return result;
    }

    static final InformationSchema exportCatalogs(Configuration configuration, List<Catalog> catalogs) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Catalog c2 : catalogs) {
            for (Schema s2 : c2.getSchemas()) {
                includedTables.addAll(s2.getTables());
            }
        }
        for (Catalog c2 : catalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
            for (Schema s2 : c2.getSchemas()) {
                InformationSchemaExport.exportSchema0(result, s2);
                for (Domain<?> domain : s2.getDomains()) {
                    InformationSchemaExport.exportDomain0(configuration, result, domain);
                }
                for (Table table : s2.getTables()) {
                    InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
                }
                for (Sequence sequence : s2.getSequences()) {
                    InformationSchemaExport.exportSequence0(configuration, result, sequence);
                }
            }
        }
        return result;
    }

    private static final void exportDomain0(Configuration configuration, InformationSchema result, Domain<?> d2) {
        org.jooq.util.xml.jaxb.Domain id2 = new org.jooq.util.xml.jaxb.Domain();
        String catalogName = InformationSchemaExport.catalogName(d2);
        String schemaName = InformationSchemaExport.schemaName(d2);
        String domainName = d2.getName();
        if (!StringUtils.isBlank(catalogName)) {
            id2.setDomainCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            id2.setDomainSchema(schemaName);
        }
        id2.setDomainName(domainName);
        id2.setDataType(d2.getDataType().getTypeName(configuration));
        if (d2.getDataType().lengthDefined()) {
            id2.setCharacterMaximumLength(d2.getDataType().length());
        }
        if (d2.getDataType().precisionDefined()) {
            id2.setNumericPrecision(d2.getDataType().precision());
        }
        if (d2.getDataType().scaleDefined()) {
            id2.setNumericScale(d2.getDataType().scale());
        }
        result.getDomains().add(id2);
        for (Check<?> c2 : d2.getChecks()) {
            DomainConstraint idc = new DomainConstraint();
            CheckConstraint icc = new CheckConstraint();
            if (!StringUtils.isBlank(catalogName)) {
                idc.setDomainCatalog(catalogName);
                idc.setConstraintCatalog(catalogName);
                icc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                idc.setDomainSchema(schemaName);
                idc.setConstraintSchema(schemaName);
                icc.setConstraintSchema(schemaName);
            }
            idc.setDomainName(domainName);
            idc.setConstraintName(c2.getName());
            icc.setConstraintName(c2.getName());
            icc.setCheckClause(configuration.dsl().render(c2.condition()));
            result.getDomainConstraints().add(idc);
            result.getCheckConstraints().add(icc);
        }
    }

    private static final void exportSequence0(Configuration configuration, InformationSchema result, Sequence<?> q2) {
        org.jooq.util.xml.jaxb.Sequence iq2 = new org.jooq.util.xml.jaxb.Sequence();
        String catalogName = InformationSchemaExport.catalogName(q2);
        String schemaName = InformationSchemaExport.schemaName(q2);
        if (!StringUtils.isBlank(catalogName)) {
            iq2.setSequenceCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            iq2.setSequenceSchema(schemaName);
        }
        iq2.setSequenceName(q2.getName());
        iq2.setDataType(q2.getDataType().getTypeName(configuration));
        if (q2.getDataType().lengthDefined()) {
            iq2.setCharacterMaximumLength(q2.getDataType().length());
        }
        if (q2.getDataType().precisionDefined()) {
            iq2.setNumericPrecision(q2.getDataType().precision());
        }
        if (q2.getDataType().scaleDefined()) {
            iq2.setNumericScale(q2.getDataType().scale());
        }
        if (q2.getStartWith() != null) {
            iq2.setStartValue(Convert.convert(q2.getStartWith() instanceof Param ? ((Param)q2.getStartWith()).getValue() : q2.getStartWith().toString(), BigInteger.class));
        }
        if (q2.getIncrementBy() != null) {
            iq2.setIncrement(Convert.convert(q2.getIncrementBy() instanceof Param ? ((Param)q2.getIncrementBy()).getValue() : q2.getIncrementBy().toString(), BigInteger.class));
        }
        if (q2.getMinvalue() != null) {
            iq2.setMinimumValue(Convert.convert(q2.getMinvalue() instanceof Param ? ((Param)q2.getMinvalue()).getValue() : q2.getMinvalue().toString(), BigInteger.class));
        }
        if (q2.getMaxvalue() != null) {
            iq2.setMaximumValue(Convert.convert(q2.getMaxvalue() instanceof Param ? ((Param)q2.getMaxvalue()).getValue() : q2.getMaxvalue().toString(), BigInteger.class));
        }
        iq2.setCycleOption(q2.getCycle());
        if (q2.getCache() != null) {
            iq2.setCache(Convert.convert(q2.getCache() instanceof Param ? ((Param)q2.getCache()).getValue() : q2.getCache().toString(), BigInteger.class));
        }
        result.getSequences().add(iq2);
    }

    private static final void exportCatalog0(InformationSchema result, Catalog c2) {
        org.jooq.util.xml.jaxb.Catalog ic2 = new org.jooq.util.xml.jaxb.Catalog();
        if (!StringUtils.isBlank(c2.getName())) {
            ic2.setCatalogName(c2.getName());
            ic2.setComment(c2.getComment());
            result.getCatalogs().add(ic2);
        }
    }

    private static final void exportSchema0(InformationSchema result, Schema s2) {
        org.jooq.util.xml.jaxb.Schema is2 = new org.jooq.util.xml.jaxb.Schema();
        String catalogName = InformationSchemaExport.catalogName(s2);
        if (!StringUtils.isBlank(catalogName)) {
            is2.setCatalogName(catalogName);
        }
        if (!StringUtils.isBlank(s2.getName())) {
            is2.setSchemaName(s2.getName());
            is2.setComment(s2.getComment());
            result.getSchemata().add(is2);
        }
    }

    private static final void exportTable0(Configuration configuration, InformationSchema result, Table<?> t2, Set<Table<?>> includedTables) {
        org.jooq.util.xml.jaxb.Table it2 = new org.jooq.util.xml.jaxb.Table();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            it2.setTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            it2.setTableSchema(schemaName);
        }
        switch (t2.getOptions().type()) {
            case MATERIALIZED_VIEW: 
            case VIEW: {
                it2.setTableType(TableType.VIEW);
                break;
            }
            case TEMPORARY: {
                it2.setTableType(TableType.GLOBAL_TEMPORARY);
                break;
            }
            default: {
                it2.setTableType(TableType.BASE_TABLE);
            }
        }
        it2.setTableName(t2.getName());
        it2.setComment(t2.getComment());
        result.getTables().add(it2);
        if (t2.getOptions().type() == TableOptions.TableType.VIEW) {
            View iv2 = new View();
            if (!StringUtils.isBlank(catalogName)) {
                iv2.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                iv2.setTableSchema(schemaName);
            }
            iv2.setTableName(t2.getName());
            iv2.setViewDefinition(t2.getOptions().source());
            result.getViews().add(iv2);
        }
        Field<?>[] fields2 = t2.fields();
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            Field<?> field = fields2[i2];
            DataType type = field.getDataType();
            Column ic2 = new Column();
            if (!StringUtils.isBlank(catalogName)) {
                ic2.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic2.setTableSchema(schemaName);
            }
            ic2.setTableName(t2.getName());
            ic2.setColumnName(field.getName());
            ic2.setComment(field.getComment());
            ic2.setDataType(type.getTypeName(configuration));
            if (type.lengthDefined()) {
                ic2.setCharacterMaximumLength(type.length());
            }
            if (type.precisionDefined()) {
                ic2.setNumericPrecision(type.precision());
            }
            if (type.scaleDefined()) {
                ic2.setNumericScale(type.scale());
            }
            ic2.setColumnDefault(DSL.using(configuration).render(type.defaultValue()));
            ic2.setIsNullable(type.nullable());
            ic2.setOrdinalPosition(i2 + 1);
            ic2.setReadonly(type.readonly());
            if (type.computed()) {
                ic2.setIsGenerated(type.computed());
                ic2.setGenerationExpression(DSL.using(configuration).render(type.generatedAlwaysAs()));
                ic2.setGenerationOption(type.generationOption() == QOM.GenerationOption.VIRTUAL ? "VIRTUAL" : (type.generationOption() == QOM.GenerationOption.STORED ? "STORED" : null));
            }
            result.getColumns().add(ic2);
        }
        for (UniqueKey<?> uniqueKey : t2.getKeys()) {
            InformationSchemaExport.exportKey0(result, t2, uniqueKey, uniqueKey.isPrimary() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
        }
        for (ForeignKey foreignKey : t2.getReferences()) {
            if (!includedTables.contains(foreignKey.getKey().getTable())) continue;
            InformationSchemaExport.exportKey0(result, t2, foreignKey, TableConstraintType.FOREIGN_KEY);
        }
        for (Check check : t2.getChecks()) {
            if (!includedTables.contains(check.getTable())) continue;
            InformationSchemaExport.exportCheck0(configuration, result, t2, check);
        }
        for (Index index : t2.getIndexes()) {
            InformationSchemaExport.exportIndex0(result, t2, index);
        }
    }

    private static final void exportCheck0(Configuration configuration, InformationSchema result, Table<?> t2, Check<?> chk) {
        InformationSchemaExport.exportTableConstraint(result, t2, chk.getName(), TableConstraintType.CHECK);
        CheckConstraint c2 = new CheckConstraint();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            c2.setConstraintCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            c2.setConstraintSchema(schemaName);
        }
        c2.setConstraintName(chk.getName());
        c2.setCheckClause(configuration.dsl().render(chk.condition()));
        result.getCheckConstraints().add(c2);
    }

    private static final void exportIndex0(InformationSchema result, Table<?> t2, Index index) {
        org.jooq.util.xml.jaxb.Index i2 = new org.jooq.util.xml.jaxb.Index();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            i2.withIndexCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            i2.withIndexSchema(schemaName).withTableSchema(schemaName);
        }
        i2.setIndexName(index.getName());
        i2.setTableName(t2.getName());
        i2.setIsUnique(index.getUnique());
        result.getIndexes().add(i2);
        int position = 1;
        for (SortField<?> sortField : index.getFields()) {
            IndexColumnUsage ic2 = new IndexColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                ic2.withIndexCatalog(catalogName).withTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic2.withIndexSchema(schemaName).withTableSchema(schemaName);
            }
            ic2.setIndexName(index.getName());
            ic2.setTableName(t2.getName());
            ic2.setOrdinalPosition(position++);
            ic2.setColumnName(sortField.getName());
            ic2.setIsDescending(sortField.getOrder() == SortOrder.DESC);
            result.getIndexColumnUsages().add(ic2);
        }
    }

    private static final void exportKey0(InformationSchema result, Table<?> t2, Key<?> key, TableConstraintType constraintType) {
        InformationSchemaExport.exportTableConstraint(result, t2, key.getName(), constraintType);
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        int i2 = 0;
        for (Field field : key.getFields()) {
            KeyColumnUsage kc2 = new KeyColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                kc2.setConstraintCatalog(catalogName);
                kc2.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                kc2.setConstraintSchema(schemaName);
                kc2.setTableSchema(schemaName);
            }
            kc2.setColumnName(field.getName());
            kc2.setTableName(t2.getName());
            kc2.setOrdinalPosition(++i2);
            kc2.setConstraintName(key.getName());
            result.getKeyColumnUsages().add(kc2);
        }
        if (constraintType == TableConstraintType.FOREIGN_KEY) {
            ReferentialConstraint rc = new ReferentialConstraint();
            UniqueKey uniqueKey = ((ForeignKey)key).getKey();
            String ukCatalogName = InformationSchemaExport.catalogName(uniqueKey.getTable());
            String ukSchemaName = InformationSchemaExport.schemaName(uniqueKey.getTable());
            if (!StringUtils.isBlank(catalogName)) {
                rc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(ukCatalogName)) {
                rc.setUniqueConstraintCatalog(ukCatalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                rc.setConstraintSchema(schemaName);
            }
            if (!StringUtils.isBlank(ukSchemaName)) {
                rc.setUniqueConstraintSchema(ukSchemaName);
            }
            rc.setConstraintName(key.getName());
            rc.setUniqueConstraintName(uniqueKey.getName());
            result.getReferentialConstraints().add(rc);
        }
    }

    private static final void exportTableConstraint(InformationSchema result, Table<?> t2, String constraintName, TableConstraintType constraintType) {
        TableConstraint tc = new TableConstraint();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        tc.setConstraintName(constraintName);
        tc.setConstraintType(constraintType);
        if (!StringUtils.isBlank(catalogName)) {
            tc.withConstraintCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            tc.withConstraintSchema(schemaName).withTableSchema(schemaName);
        }
        tc.setTableName(t2.getName());
        result.getTableConstraints().add(tc);
    }

    private static final String catalogName(Schema s2) {
        return s2.getCatalog() == null ? null : s2.getCatalog().getName();
    }

    private static final String catalogName(Qualified q2) {
        return q2.getCatalog() == null ? null : q2.getCatalog().getName();
    }

    private static final String schemaName(Qualified q2) {
        return q2.getSchema() == null ? null : q2.getSchema().getName();
    }

    private InformationSchemaExport() {
    }
}

