/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.Attachable;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.ExecuteScope;
import org.jooq.Field;
import org.jooq.Geography;
import org.jooq.Geometry;
import org.jooq.JSON;
import org.jooq.JSONB;
import org.jooq.Param;
import org.jooq.QualifiedRecord;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.RowId;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Scope;
import org.jooq.TableRecord;
import org.jooq.UDTRecord;
import org.jooq.XML;
import org.jooq.conf.NestedCollectionEmulation;
import org.jooq.conf.ParamType;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.MappingException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.BlobBinding;
import org.jooq.impl.Convert;
import org.jooq.impl.ConvertedDataType;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBindingGetResultSetContext;
import org.jooq.impl.DefaultBindingGetStatementContext;
import org.jooq.impl.DefaultBindingSQLContext;
import org.jooq.impl.DefaultBindingSetStatementContext;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.Internal;
import org.jooq.impl.InternalRecord;
import org.jooq.impl.JSONReader;
import org.jooq.impl.Keywords;
import org.jooq.impl.R2DBC;
import org.jooq.impl.RowIdImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.ThrowingSupplier;
import org.jooq.impl.TimestampToJavaUtilDateConverter;
import org.jooq.impl.Tools;
import org.jooq.impl.XMLHandler;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.Longs;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.jdbc.MockArray;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.DayToSecond;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UNumber;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.types.YearToSecond;
import org.jooq.util.postgres.PostgresUtils;

public class DefaultBinding<T, U>
implements Binding<T, U> {
    static final JooqLogger log = JooqLogger.getLogger(DefaultBinding.class);
    private static final Set<SQLDialect> REQUIRE_JDBC_DATE_LITERAL = SQLDialect.supportedBy(SQLDialect.MYSQL);
    private static final long PG_DATE_POSITIVE_INFINITY = 9223372036825200000L;
    private static final long PG_DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    final Binding<T, U> delegate;

    public static final <T, U> Binding<T, U> binding(Converter<T, U> converter) {
        return DefaultBinding.binding(DefaultDataType.getDataType(SQLDialect.DEFAULT, converter.fromType()), converter);
    }

    public static final <T> Binding<T, T> binding(DataType<T> dataType) {
        return DefaultBinding.binding(dataType, Converters.identity(dataType.getType()));
    }

    static final <T, U> Binding<T, U> binding(DataType<T> dataType, Converter<T, U> converter) {
        Class<T> type = converter.fromType();
        if (type == BigDecimal.class) {
            return new DefaultBigDecimalBinding<U>((DataType<BigDecimal>)dataType, converter);
        }
        if (type == BigInteger.class) {
            return new DefaultBigIntegerBinding<U>((DataType<BigInteger>)dataType, converter);
        }
        if (type == Blob.class) {
            return new DefaultBlobBinding<U>((DataType<Blob>)dataType, converter);
        }
        if (type == Boolean.class) {
            return new DefaultBooleanBinding<U>((DataType<Boolean>)dataType, converter);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new DefaultByteBinding<U>((DataType<Byte>)dataType, converter);
        }
        if (type == byte[].class) {
            return new DefaultBytesBinding<U>((DataType<byte[]>)dataType, converter);
        }
        if (type == Clob.class) {
            return new DefaultClobBinding<U>((DataType<Clob>)dataType, converter);
        }
        if (type == java.sql.Date.class) {
            return new DefaultDateBinding<U>((DataType<java.sql.Date>)dataType, converter);
        }
        if (type == DayToSecond.class) {
            return new DefaultDayToSecondBinding<U>((DataType<DayToSecond>)dataType, converter);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DefaultDoubleBinding<U>((DataType<Double>)dataType, converter);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new DefaultFloatBinding<U>((DataType<Float>)dataType, converter);
        }
        if (type == Geometry.class) {
            return new CommercialOnlyBinding<U>(dataType, converter);
        }
        if (type == Geography.class) {
            return new CommercialOnlyBinding<U>(dataType, converter);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new DefaultIntegerBinding<U>((DataType<Integer>)dataType, converter);
        }
        if (type == JSON.class) {
            return new DefaultJSONBinding<U>((DataType<JSON>)dataType, converter);
        }
        if (type == JSONB.class) {
            return new DefaultJSONBBinding<U>((DataType<JSONB>)dataType, converter);
        }
        if (type == XML.class) {
            return new DefaultXMLBinding<U>((DataType<XML>)dataType, converter);
        }
        if (type == LocalDate.class) {
            return new DelegatingBinding<LocalDate, java.sql.Date, U>(dataType, Converter.ofNullable(java.sql.Date.class, LocalDate.class, java.sql.Date::toLocalDate, java.sql.Date::valueOf), converter, c2 -> new DefaultDateBinding(SQLDataType.DATE, c2));
        }
        if (type == LocalDateTime.class) {
            return new DelegatingBinding<LocalDateTime, Timestamp, U>(dataType, Converter.ofNullable(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime, Timestamp::valueOf), converter, c2 -> new DefaultTimestampBinding(SQLDataType.TIMESTAMP, c2));
        }
        if (type == LocalTime.class) {
            return new DelegatingBinding<LocalTime, Time, U>(dataType, Converter.ofNullable(Time.class, LocalTime.class, Time::toLocalTime, Time::valueOf), converter, c2 -> new DefaultTimeBinding(SQLDataType.TIME, c2));
        }
        if (type == Long.class || type == Long.TYPE) {
            return new DefaultLongBinding<U>((DataType<Long>)dataType, converter);
        }
        if (type == OffsetDateTime.class) {
            return new DefaultOffsetDateTimeBinding<U>((DataType<OffsetDateTime>)dataType, converter);
        }
        if (type == OffsetTime.class) {
            return new DefaultOffsetTimeBinding<U>((DataType<OffsetTime>)dataType, converter);
        }
        if (type == Instant.class) {
            return new DefaultInstantBinding<U>((DataType<Instant>)dataType, converter);
        }
        if (type == RowId.class) {
            return new DefaultRowIdBinding<U>((DataType<RowId>)dataType, converter);
        }
        if (type == Short.class || type == Short.TYPE) {
            return new DefaultShortBinding<U>((DataType<Short>)dataType, converter);
        }
        if (type == String.class) {
            if (dataType.isNString()) {
                return new DefaultNStringBinding<U>((DataType<String>)dataType, converter);
            }
            return new DefaultStringBinding<U>((DataType<String>)dataType, converter);
        }
        if (type == Time.class) {
            return new DefaultTimeBinding<U>((DataType<Time>)dataType, converter);
        }
        if (type == Timestamp.class) {
            return new DefaultTimestampBinding<U>((DataType<Timestamp>)dataType, converter);
        }
        if (type == Date.class) {
            return new DefaultTimestampBinding<U>((DataType<Timestamp>)dataType, Converters.of(TimestampToJavaUtilDateConverter.INSTANCE, converter));
        }
        if (type == UByte.class) {
            return new DelegatingBinding<UByte, Short, U>(dataType, Converter.ofNullable(Short.class, UByte.class, UByte::valueOf, Number::shortValue), converter, c2 -> new DefaultShortBinding(SQLDataType.SMALLINT, c2));
        }
        if (type == UInteger.class) {
            return new DelegatingBinding<UInteger, Long, U>(dataType, Converter.ofNullable(Long.class, UInteger.class, UInteger::valueOf, UInteger::longValue), converter, c2 -> new DefaultLongBinding(SQLDataType.BIGINT, c2));
        }
        if (type == ULong.class) {
            return new DelegatingBinding<ULong, BigInteger, U>(dataType, Converter.ofNullable(BigInteger.class, ULong.class, ULong::valueOf, UNumber::toBigInteger), converter, c2 -> new DefaultBigIntegerBinding(SQLDataType.DECIMAL_INTEGER, c2));
        }
        if (type == UShort.class) {
            return new DelegatingBinding<UShort, Integer, U>(dataType, Converter.ofNullable(Integer.class, UShort.class, UShort::valueOf, UShort::intValue), converter, c2 -> new DefaultIntegerBinding(SQLDataType.INTEGER, c2));
        }
        if (type == UUID.class) {
            return new DefaultUUIDBinding<U>((DataType<UUID>)dataType, converter);
        }
        if (type == YearToSecond.class) {
            return new DefaultYearToSecondBinding<U>((DataType<YearToSecond>)dataType, converter);
        }
        if (type == YearToMonth.class) {
            return new DefaultYearToMonthBinding<U>((DataType<YearToMonth>)dataType, converter);
        }
        if (type.isArray()) {
            return new DefaultArrayBinding<U>((DataType<Object[]>)dataType, converter);
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return new DefaultEnumTypeBinding<U>((DataType<EnumType>)dataType, converter);
        }
        if (Record.class.isAssignableFrom(type)) {
            return new DefaultRecordBinding<U>((DataType<Record>)dataType, converter);
        }
        if (Result.class.isAssignableFrom(type)) {
            return new DefaultResultBinding<U>((DataType<Result<?>>)dataType, converter);
        }
        return new DefaultOtherBinding<U>(dataType, converter);
    }

    @Deprecated(forRemoval=true)
    public DefaultBinding(Converter<T, U> converter) {
        this.delegate = DefaultBinding.binding(converter);
    }

    public DefaultBinding(Binding<T, U> delegate) {
        this.delegate = delegate;
    }

    static final <T, X, U> Binding<T, U> newBinding(final Converter<X, U> converter, DataType<T> dataType, final Binding<T, X> binding) {
        Binding<Object, Object> theBinding = converter == null && binding == null ? dataType.getBinding() : (converter == null ? binding : (binding == null ? DefaultBinding.binding(dataType, converter) : new Binding<T, U>(){
            final Converter<T, U> theConverter;
            {
                this.theConverter = Converters.of(binding.converter(), converter);
            }

            @Override
            public Converter<T, U> converter() {
                return this.theConverter;
            }

            @Override
            public void sql(BindingSQLContext<U> ctx) throws SQLException {
                binding.sql(ctx.convert(converter));
            }

            @Override
            public void register(BindingRegisterContext<U> ctx) throws SQLException {
                binding.register(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetStatementContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetStatementContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }
        }));
        return theBinding;
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Scope scope) {
        return DefaultBinding.typeMap(type, scope, new HashMap());
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Scope scope, Map<String, Class<?>> result) {
        try {
            if (QualifiedRecord.class.isAssignableFrom(type)) {
                Class<?> t2 = type;
                result.put(Tools.getMappedUDTName(scope, t2), t2);
                QualifiedRecord r2 = (QualifiedRecord)t2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field<?> field : r2.getQualifier().fields()) {
                    DefaultBinding.typeMap(field.getType(), scope, result);
                }
            }
        }
        catch (Exception e2) {
            throw new MappingException("Error while collecting type map", e2);
        }
        return result;
    }

    private static final long parse(Class<? extends Date> type, String date) throws SQLException {
        Long number = Longs.tryParse(date);
        if (number != null) {
            return number;
        }
        date = StringUtils.replace(date, "T", " ");
        if (type == Timestamp.class) {
            return Timestamp.valueOf(date).getTime();
        }
        if (type == java.sql.Date.class) {
            return java.sql.Date.valueOf(date.split(" ")[0]).getTime();
        }
        if (type == Time.class) {
            return Time.valueOf(date).getTime();
        }
        throw new SQLException("Could not parse date " + date);
    }

    @Override
    public Converter<T, U> converter() {
        return this.delegate.converter();
    }

    @Override
    public void sql(BindingSQLContext<U> ctx) throws SQLException {
        this.delegate.sql(ctx);
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        this.delegate.register(ctx);
    }

    @Override
    public void set(BindingSetStatementContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static final class DefaultYearToMonthBinding<U>
    extends InternalBinding<YearToMonth, U> {
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
        private static final Set<SQLDialect> REQUIRE_STANDARD_INTERVAL = SQLDialect.supportedBy(SQLDialect.H2);

        DefaultYearToMonthBinding(DataType<YearToMonth> dataType, Converter<YearToMonth, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, YearToMonth value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGInterval(value).toString()));
            } else {
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, YearToMonth value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), this.renderYTM(ctx, value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, YearToMonth value) throws SQLException {
            ctx.output().writeString(this.renderYTM(ctx, value));
        }

        @Override
        final YearToMonth get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            return this.parseYTM(ctx, ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final YearToMonth get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            return this.parseYTM(ctx, ctx.statement().getString(ctx.index()));
        }

        @Override
        final YearToMonth get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.parseYTM(ctx, ctx.input().readString());
        }

        private final YearToMonth parseYTM(Scope scope, String string) {
            if (string == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect()) && string.startsWith("INTERVAL")) {
                return (YearToMonth)((Param)scope.dsl().parser().parseField(string)).getValue();
            }
            return YearToMonth.valueOf(string);
        }

        private final String renderYTM(Scope scope, YearToMonth ytm) {
            if (ytm == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect())) {
                return "INTERVAL '" + ytm.toString() + "' YEAR TO MONTH";
            }
            return ytm.toString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultYearToSecondBinding<U>
    extends InternalBinding<YearToSecond, U> {
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

        DefaultYearToSecondBinding(DataType<YearToSecond> dataType, Converter<YearToSecond, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, YearToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGInterval(value).toString()));
            } else {
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, YearToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), value.toString());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, YearToSecond value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final YearToSecond get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToSecond(object);
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final YearToSecond get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToSecond(object);
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final YearToSecond get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultXMLBinding<U>
    extends InternalBinding<XML, U> {
        DefaultXMLBinding(DataType<XML> dataType, Converter<XML, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, XML value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.toString());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, XML value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final XML get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final XML get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final XML get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultJSONBBinding<U>
    extends InternalBinding<JSONB, U> {
        static final Set<SQLDialect> EMULATE_AS_BLOB = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);

        DefaultJSONBBinding(DataType<JSONB> dataType, Converter<JSONB, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).sqlInline0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                super.sqlInline0(ctx, value);
                if (ctx.family() == SQLDialect.H2 && value != null) {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
                }
            }
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, JSONB value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).set0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                ctx.statement().setString(ctx.index(), value.data());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).set0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                ctx.output().writeString(value.data());
            }
        }

        @Override
        final JSONB get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final JSONB get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final JSONB get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.input().readString();
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (EMULATE_AS_BLOB.contains((Object)configuration.dialect())) {
                return this.bytes(configuration).sqltype(statement, configuration);
            }
            return 12;
        }

        private final Converter<byte[], JSONB> bytesConverter(Configuration configuration) {
            return Converter.ofNullable(byte[].class, JSONB.class, t2 -> JSONB.valueOf(new String((byte[])t2, configuration.charsetProvider().provide())), u2 -> u2.toString().getBytes(configuration.charsetProvider().provide()));
        }

        private final DefaultBytesBinding<U> bytes(Configuration configuration) {
            return new DefaultBytesBinding<JSONB>(SQLDataType.BLOB, this.bytesConverter(configuration));
        }
    }

    static final class DefaultJSONBinding<U>
    extends InternalBinding<JSON, U> {
        DefaultJSONBinding(DataType<JSON> dataType, Converter<JSON, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, JSON value) throws SQLException {
            super.sqlInline0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, JSON value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, JSON value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.data());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, JSON value) throws SQLException {
            ctx.output().writeString(value.data());
        }

        @Override
        final JSON get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final JSON get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final JSON get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultUUIDBinding<U>
    extends InternalBinding<UUID, U> {
        DefaultUUIDBinding(DataType<UUID> dataType, Converter<UUID, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UUID value) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    ctx.statement().setString(ctx.index(), value.toString());
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UUID value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final UUID get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    Object o2 = ctx.resultSet().getObject(ctx.index());
                    if (o2 == null) {
                        return null;
                    }
                    if (o2 instanceof UUID) {
                        return (UUID)o2;
                    }
                    return Convert.convert((Object)o2.toString(), UUID.class);
                }
            }
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    return (UUID)ctx.statement().getObject(ctx.index());
                }
            }
            return Convert.convert((Object)ctx.statement().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.input().readString(), UUID.class);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return 1111;
                }
            }
            return 12;
        }
    }

    static final class DefaultTimestampBinding<U>
    extends InternalBinding<Timestamp, U> {
        private static final Set<SQLDialect> INLINE_AS_STRING_LITERAL = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultTimestampBinding(DataType<Timestamp> dataType, Converter<Timestamp, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Timestamp value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql("('")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql("')");
            } else if (ctx.family() == SQLDialect.CUBRID) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATETIME)).sql(" '")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql('\'');
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("{ts '")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql("'}");
            } else {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql(" '")).sql(this.format(value, ctx.render()))).sql('\'');
            }
        }

        private final String format(Timestamp value, RenderContext render) {
            if (render.family() == SQLDialect.POSTGRES) {
                if (value.getTime() == 9223372036825200000L) {
                    return "infinity";
                }
                if (value.getTime() == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            return DefaultTimestampBinding.escape(value, render);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Timestamp value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTimestamp(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Timestamp value) throws SQLException {
            ctx.output().writeTimestamp(value);
        }

        @Override
        final Timestamp get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String timestamp = ctx.resultSet().getString(ctx.index());
                return timestamp == null ? null : new Timestamp(DefaultBinding.parse(Timestamp.class, timestamp));
            }
            return ctx.resultSet().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTimestamp();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 93;
        }
    }

    static final class DefaultTimeBinding<U>
    extends InternalBinding<Time, U> {
        DefaultTimeBinding(DataType<Time> dataType, Converter<Time, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Time value) {
            switch (ctx.family()) {
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(new SimpleDateFormat("HH:mm:ss").format(value))).sql('\'');
                    break;
                }
                case DERBY: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql("('")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql("')");
                    break;
                }
                default: {
                    if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                        ((RenderContext)((RenderContext)ctx.render().sql("{t '")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql("'}");
                        break;
                    }
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql(" '")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Time value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTime(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Time value) throws SQLException {
            ctx.output().writeTime(value);
        }

        @Override
        final Time get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String time = ctx.resultSet().getString(ctx.index());
                return time == null ? null : new Time(DefaultBinding.parse(Time.class, time));
            }
            return ctx.resultSet().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTime();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 92;
        }
    }

    static final class DefaultNStringBinding<U>
    extends InternalBinding<String, U> {
        private final DefaultStringBinding<U> fallback;

        DefaultNStringBinding(DataType<String> dataType, Converter<String, U> converter) {
            super(dataType, converter);
            this.fallback = new DefaultStringBinding<U>(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.sqlInline0(ctx, value);
            } else {
                ctx.render().sql('N');
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.set0(ctx, value);
            } else {
                ctx.statement().setNString(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.set0(ctx, value);
            }
            ctx.output().writeNString(value);
        }

        @Override
        final String get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetResultSetContext)ctx);
            }
            return ctx.resultSet().getNString(ctx.index());
        }

        @Override
        final String get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetStatementContext)ctx);
            }
            return ctx.statement().getNString(ctx.index());
        }

        @Override
        final String get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetSQLInputContext)ctx);
            }
            return ctx.input().readNString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (NO_SUPPORT_NVARCHAR.contains((Object)configuration.dialect())) {
                return this.fallback.sqltype(statement, configuration);
            }
            return -9;
        }
    }

    static final class DefaultStringBinding<U>
    extends InternalBinding<String, U> {
        DefaultStringBinding(DataType<String> dataType, Converter<String, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, String value) throws SQLException {
            if (ctx.family() == SQLDialect.DERBY) {
                this.sqlInlineWorkaround6516(ctx, value, 8192, "");
            } else {
                super.sqlInline0(ctx, value);
            }
        }

        private final void sqlInlineWorkaround6516(BindingSQLContext<U> ctx, String value, int limit, String prefix) throws SQLException {
            int l2 = value.length();
            if (l2 > limit) {
                ctx.render().sql('(');
                for (int i2 = 0; i2 < l2; i2 += limit) {
                    if (i2 > 0) {
                        ctx.render().sql(" || ");
                    }
                    ((RenderContext)ctx.render().sql(prefix)).sql("(");
                    super.sqlInline0(ctx, value.substring(i2, Math.min(l2, i2 + limit)));
                    ctx.render().sql(')');
                }
                ctx.render().sql(')');
            } else {
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, String value) throws SQLException {
            ctx.statement().setString(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, String value) throws SQLException {
            ctx.output().writeString(value);
        }

        @Override
        final String get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultShortBinding<U>
    extends InternalBinding<Short, U> {
        DefaultShortBinding(DataType<Short> dataType, Converter<Short, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Short value) {
            ctx.render().sql(value.shortValue());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Short value) throws SQLException {
            ctx.statement().setShort(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Short value) throws SQLException {
            ctx.output().writeShort(value);
        }

        @Override
        final Short get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Short.valueOf(ctx.resultSet().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Short.valueOf(ctx.statement().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Short.valueOf(ctx.input().readShort()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 5;
        }
    }

    static final class DefaultResultBinding<U>
    extends InternalBinding<Result<?>, U> {
        DefaultResultBinding(DataType<Result<?>> dataType, Converter<Result<?>, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a PreparedStatement");
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a SQLOutput");
        }

        @Override
        final Result<?> get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            Field<?> field = Tools.uncoerce(ctx.field());
            if (field.getDataType().isMultiset()) {
                return DefaultResultBinding.readMultiset(ctx, field.getDataType());
            }
            return ctx.configuration().dsl().fetch(Convert.convert(ctx.resultSet().getObject(ctx.index()), ResultSet.class));
        }

        static final <R extends Record> Result<R> readMultiset(BindingGetResultSetContext<?> ctx, DataType<Result<R>> type) throws SQLException {
            return DefaultResultBinding.readMultiset(ctx, (AbstractRow)type.getRow(), type.getRecordType(), Function.identity(), Function.identity(), Function.identity());
        }

        static final <R extends Record> Result<R> readMultiset(BindingGetResultSetContext<?> ctx, AbstractRow<R> row, Class<R> recordType, Function<byte[], byte[]> jsonBytesPatch, Function<String, String> jsonStringPatch, Function<String, String> xmlStringPatch) throws SQLException {
            NestedCollectionEmulation emulation = Tools.emulateMultiset(ctx.configuration());
            switch (emulation) {
                case JSON: 
                case JSONB: {
                    if (emulation == NestedCollectionEmulation.JSONB && DefaultJSONBBinding.EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                        return Tools.apply(jsonBytesPatch.apply(ctx.resultSet().getBytes(ctx.index())), s2 -> new JSONReader(ctx.dsl(), row, recordType).read(new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])s2), ctx.configuration().charsetProvider().provide()), true));
                    }
                    return Tools.apply(jsonStringPatch.apply(ctx.resultSet().getString(ctx.index())), s2 -> DefaultResultBinding.readMultisetJSON(ctx, row, recordType, s2));
                }
                case XML: {
                    return Tools.apply(xmlStringPatch.apply(ctx.resultSet().getString(ctx.index())), s2 -> DefaultResultBinding.readMultisetXML(ctx, row, recordType, s2));
                }
            }
            throw new UnsupportedOperationException("Multiset emulation not yet supported: " + emulation);
        }

        static <R extends Record> Result<R> readMultisetXML(Scope ctx, AbstractRow<R> row, Class<R> recordType, String s2) {
            return new XMLHandler<R>(ctx.dsl(), row, recordType).read(s2);
        }

        static <R extends Record> Result<R> readMultisetJSON(Scope ctx, AbstractRow<R> row, Class<R> recordType, String s2) {
            return new JSONReader<R>(ctx.dsl(), row, recordType).read(new StringReader(s2), true);
        }

        @Override
        final Result<?> get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.configuration().dsl().fetch(Convert.convert(ctx.statement().getObject(ctx.index()), ResultSet.class));
        }

        @Override
        final Result<?> get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Cannot get a value of type Result from a SQLInput");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case H2: {
                    return -10;
                }
            }
            return 1111;
        }
    }

    static final class DefaultRecordBinding<U>
    extends InternalBinding<Record, U> {
        private static final Set<SQLDialect> REQUIRE_RECORD_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

        DefaultRecordBinding(DataType<Record> dataType, Converter<Record, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()) && value != null) {
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            }
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGString(value)));
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            } else {
                ctx.render().sql("[UDT]");
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Record value) throws SQLException {
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()) && value != null) {
                ctx.statement().setString(ctx.index(), PostgresUtils.toPGString(value));
            } else {
                DefaultExecuteContext.localExecuteContext(ctx.executeContext(), () -> {
                    ctx.statement().setObject(ctx.index(), value);
                    return null;
                });
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Record value) throws SQLException {
            if (!(value instanceof QualifiedRecord)) {
                throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
            }
            ctx.output().writeObject((QualifiedRecord)value);
        }

        @Override
        final Record get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return DefaultRecordBinding.pgNewRecord(ctx, this.dataType.getType(), (AbstractRow)this.dataType.getRow(), ctx.resultSet().getObject(ctx.index()));
                }
            }
            return DefaultExecuteContext.localExecuteContext(ctx.executeContext(), () -> (Record)ctx.resultSet().getObject(ctx.index(), DefaultBinding.typeMap(this.dataType.getType(), ctx)));
        }

        @Override
        final Record get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return DefaultRecordBinding.pgNewRecord(ctx, this.dataType.getType(), (AbstractRow)this.dataType.getRow(), ctx.statement().getObject(ctx.index()));
                }
            }
            return DefaultExecuteContext.localExecuteContext(ctx.executeContext(), () -> (Record)ctx.statement().getObject(ctx.index(), DefaultBinding.typeMap(this.dataType.getType(), ctx)));
        }

        @Override
        final Record get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return (Record)ctx.input().readObject();
        }

        static final <R extends Record> R readMultiset(BindingGetResultSetContext<?> ctx, DataType<R> type) throws SQLException {
            return (R)((Record)DefaultResultBinding.readMultiset(ctx, (AbstractRow)type.getRow(), type.getType(), b2 -> b2, s2 -> "[" + s2 + "]", s2 -> "<result>" + s2 + "</result>").get(0));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2002;
        }

        static final void pgRenderRecordCast(RenderContext render, Record value) {
            if (value instanceof UDTRecord) {
                ((RenderContext)render.sql("::")).visit(((UDTRecord)value).getUDT().getQualifiedName());
            } else if (value instanceof TableRecord) {
                ((RenderContext)render.sql("::")).visit(((TableRecord)value).getTable().getQualifiedName());
            }
        }

        private static final <T> T pgFromString(Scope ctx, Field<T> field, String string) {
            Converter converter = field.getConverter();
            Class type = Reflect.wrapper(converter.toType());
            if (string == null) {
                return null;
            }
            if (type != Blob.class) {
                if (type == Boolean.class) {
                    return (T)Convert.convert((Object)string, Boolean.class);
                }
                if (type == BigInteger.class) {
                    return (T)new BigInteger(string);
                }
                if (type == BigDecimal.class) {
                    return (T)new BigDecimal(string);
                }
                if (type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
                if (type == byte[].class) {
                    return (T)PostgresUtils.toBytes(string);
                }
                if (type != Clob.class) {
                    if (type == java.sql.Date.class) {
                        return (T)java.sql.Date.valueOf(string);
                    }
                    if (type == Double.class) {
                        return (T)Double.valueOf(string);
                    }
                    if (type == Float.class) {
                        return (T)Float.valueOf(string);
                    }
                    if (type == Integer.class) {
                        return (T)Integer.valueOf(string);
                    }
                    if (type == Long.class) {
                        return (T)Long.valueOf(string);
                    }
                    if (type == Short.class) {
                        return (T)Short.valueOf(string);
                    }
                    if (type == String.class) {
                        return (T)string;
                    }
                    if (type == Time.class) {
                        return (T)Time.valueOf(string);
                    }
                    if (type == Timestamp.class) {
                        return (T)Timestamp.valueOf(string);
                    }
                    if (type == LocalTime.class) {
                        return (T)LocalTime.parse(string);
                    }
                    if (type == LocalDate.class) {
                        return (T)LocalDate.parse(string);
                    }
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.parse(string);
                    }
                    if (type == OffsetTime.class) {
                        return (T)OffsetDateTimeParser.offsetTime(string);
                    }
                    if (type == OffsetDateTime.class) {
                        return (T)OffsetDateTimeParser.offsetDateTime(string);
                    }
                    if (type == Instant.class) {
                        return (T)OffsetDateTimeParser.offsetDateTime(string).toInstant();
                    }
                    if (type == JSON.class) {
                        return (T)JSON.json(string);
                    }
                    if (type == JSONB.class) {
                        return (T)JSONB.jsonb(string);
                    }
                    if (type == UByte.class) {
                        return (T)UByte.valueOf(string);
                    }
                    if (type == UShort.class) {
                        return (T)UShort.valueOf(string);
                    }
                    if (type == UInteger.class) {
                        return (T)UInteger.valueOf(string);
                    }
                    if (type == ULong.class) {
                        return (T)ULong.valueOf(string);
                    }
                    if (type == UUID.class) {
                        return (T)UUID.fromString(string);
                    }
                    if (type == XML.class) {
                        return (T)XML.xml(string);
                    }
                    if (type.isArray()) {
                        return (T)DefaultRecordBinding.pgNewArray(ctx, field, type, string);
                    }
                    if (EnumType.class.isAssignableFrom(type)) {
                        return DefaultEnumTypeBinding.getEnumType(type, string);
                    }
                    if (Result.class.isAssignableFrom(type)) {
                        if (string.startsWith("<")) {
                            return (T)DefaultResultBinding.readMultisetXML(ctx, (AbstractRow)field.getDataType().getRow(), field.getDataType().getRecordType(), string);
                        }
                        return (T)DefaultResultBinding.readMultisetJSON(ctx, (AbstractRow)field.getDataType().getRow(), field.getDataType().getRecordType(), string);
                    }
                    if (Record.class.isAssignableFrom(type) && (!InternalRecord.class.isAssignableFrom(type) || type == converter.fromType())) {
                        return (T)DefaultRecordBinding.pgNewRecord(ctx, type, (AbstractRow)field.getDataType().getRow(), string);
                    }
                    if (type == Object.class) {
                        return (T)string;
                    }
                    if (type != converter.fromType()) {
                        Converter c2 = converter;
                        return c2.from(DefaultRecordBinding.pgFromString(ctx, DSL.field("converted_field", ((ConvertedDataType)field.getDataType()).delegate()), string));
                    }
                }
            }
            throw new UnsupportedOperationException("Class " + type + " is not supported");
        }

        static final Record pgNewRecord(Scope ctx, Class<?> type, AbstractRow<?> fields2, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Record) {
                return (Record)object;
            }
            String s2 = object.toString();
            List<String> values = PostgresUtils.toPGObject(s2);
            if (fields2 == null && Record.class.isAssignableFrom(type)) {
                fields2 = Tools.row0(Tools.fields(values.size(), SQLDataType.VARCHAR));
            }
            return Tools.newRecord(true, type, fields2).operate(r2 -> {
                Row row = r2.fieldsRow();
                for (int i2 = 0; i2 < row.size(); ++i2) {
                    DefaultRecordBinding.pgSetValue(ctx, r2, row.field(i2), (String)values.get(i2));
                }
                r2.changed(false);
                return r2;
            });
        }

        private static final <T> void pgSetValue(Scope ctx, Record record, Field<T> field, String value) {
            record.set(field, DefaultRecordBinding.pgFromString(ctx, field, value));
        }

        private static final Object[] pgNewArray(Scope ctx, Field<?> field, Class<?> type, String string) {
            if (string == null) {
                return null;
            }
            try {
                return Tools.map(PostgresUtils.toPGArray(string), v2 -> DefaultRecordBinding.pgFromString(ctx, DSL.field("array_element", field.getDataType().getArrayComponentDataType()), v2), size -> (Object[])Array.newInstance(type.getComponentType(), size));
            }
            catch (Exception e2) {
                if (type.getComponentType().getSimpleName().equals("UnknownType")) {
                    throw new DataTypeException("Error while creating array for UnknownType. Please provide an explicit Class<U> type to your converter, see https://github.com/jOOQ/jOOQ/issues/11823", e2);
                }
                throw new DataTypeException("Error while creating array", e2);
            }
        }
    }

    static final class DefaultRowIdBinding<U>
    extends InternalBinding<RowId, U> {
        DefaultRowIdBinding(DataType<RowId> dataType, Converter<RowId, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, RowId value) throws SQLException {
            ctx.statement().setObject(ctx.index(), value.value());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, RowId value) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final RowId get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return new RowIdImpl(ctx.resultSet().getObject(ctx.index()));
        }

        @Override
        final RowId get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return new RowIdImpl(ctx.statement().getObject(ctx.index()));
        }

        @Override
        final RowId get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -8;
        }
    }

    static final class DefaultOtherBinding<U>
    extends InternalBinding<Object, U> {
        DefaultOtherBinding(DataType<Object> dataType, Converter<Object, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object value) throws SQLException {
            InternalBinding b2 = (InternalBinding)DefaultBinding.binding(DefaultDataType.getDataType(ctx.dialect(), value.getClass()));
            if (b2 instanceof DefaultOtherBinding) {
                ctx.statement().setObject(ctx.index(), value);
            } else {
                b2.set0(ctx, b2.dataType.convert(value));
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                default: 
            }
            ctx.statement().setObject(ctx.index(), null);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object value) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final Object get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.resultSet().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.statement().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.input().readObject());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 1111;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Object unlob(Object object) throws SQLException {
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                try {
                    byte[] byArray = blob.getBytes(1L, Tools.asInt(blob.length()));
                    return byArray;
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            }
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                try {
                    String string = clob.getSubString(1L, Tools.asInt(clob.length()));
                    return string;
                }
                finally {
                    JDBCUtils.safeFree(clob);
                }
            }
            return object;
        }
    }

    static final class CommercialOnlyBinding<U>
    extends InternalBinding<Object, U> {
        CommercialOnlyBinding(DataType<Object> dataType, Converter<Object, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object value) throws SQLException {
            ctx.configuration().requireCommercial(() -> "The out of the box binding for " + this.dataType.getName() + " is available in the commercial jOOQ distribution only. Alternatively, you can implement your own custom binding.");
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object value) throws SQLException {
            ctx.configuration().requireCommercial(() -> "The out of the box binding for " + this.dataType.getName() + " is available in the commercial jOOQ distribution only. Alternatively, you can implement your own custom binding.");
        }

        @Override
        final Object get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            ctx.configuration().requireCommercial(() -> "The out of the box binding for " + this.dataType.getName() + " is available in the commercial jOOQ distribution only. Alternatively, you can implement your own custom binding.");
            return null;
        }

        @Override
        final Object get0(BindingGetStatementContext<U> ctx) throws SQLException {
            ctx.configuration().requireCommercial(() -> "The out of the box binding for " + this.dataType.getName() + " is available in the commercial jOOQ distribution only. Alternatively, you can implement your own custom binding.");
            return null;
        }

        @Override
        final Object get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            ctx.configuration().requireCommercial(() -> "The out of the box binding for " + this.dataType.getName() + " is available in the commercial jOOQ distribution only. Alternatively, you can implement your own custom binding.");
            return null;
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            return 1111;
        }
    }

    static final class DefaultInstantBinding<U>
    extends InternalBinding<Instant, U> {
        private static final Converter<OffsetDateTime, Instant> CONVERTER = Converter.ofNullable(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant, (Function<Instant, OffsetDateTime> & Serializable)i2 -> OffsetDateTime.ofInstant(i2, ZoneOffset.UTC));
        private final DefaultOffsetDateTimeBinding<U> delegate = new DefaultOffsetDateTimeBinding(SQLDataType.OFFSETDATETIME, Converters.of(CONVERTER, this.converter()));

        DefaultInstantBinding(DataType<Instant> dataType, Converter<Instant, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            this.delegate.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Instant value) throws SQLException {
            this.delegate.sqlInline0(ctx, CONVERTER.to(value));
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Instant value) throws SQLException {
            this.delegate.set0(ctx, CONVERTER.to(value));
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Instant value) throws SQLException {
            this.delegate.set0(ctx, CONVERTER.to(value));
        }

        @Override
        final Instant get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetResultSetContext)ctx));
        }

        @Override
        final Instant get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetStatementContext)ctx));
        }

        @Override
        final Instant get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetSQLInputContext)ctx));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            return this.delegate.sqltype(statement, configuration);
        }
    }

    static final class DefaultOffsetTimeBinding<U>
    extends InternalBinding<OffsetTime, U> {
        DefaultOffsetTimeBinding(DataType<OffsetTime> dataType, Converter<OffsetTime, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetTime value) {
            switch (ctx.family()) {
                case HSQLDB: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql(" '")).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                    break;
                }
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                    break;
                }
                default: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME_WITH_TIME_ZONE)).sql(" '")).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetTime value) throws SQLException {
            if (Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                String string = DefaultOffsetTimeBinding.format(value);
                ctx.statement().setString(ctx.index(), string);
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetTime value) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final OffsetTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                return ctx.resultSet().getObject(ctx.index(), OffsetTime.class);
            }
            return OffsetDateTimeParser.offsetTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                return ctx.statement().getObject(ctx.index(), OffsetTime.class);
            }
            return OffsetDateTimeParser.offsetTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (!Boolean.FALSE.equals(configuration.settings().isBindOffsetTimeType())) {
                return 2013;
            }
            return 12;
        }

        private static final String format(OffsetTime val) {
            return StringUtils.replace(val.format(DateTimeFormatter.ISO_OFFSET_TIME), "Z", "+00:00");
        }
    }

    static final class DefaultOffsetDateTimeBinding<U>
    extends InternalBinding<OffsetDateTime, U> {
        private static final DateTimeFormatter F_TIMESTAMPTZ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffset("+HH:MM", "+00:00").toFormatter();
        private static final DateTimeFormatter ERA = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnnZZZZZ G", Locale.US);

        DefaultOffsetDateTimeBinding(DataType<OffsetDateTime> dataType, Converter<OffsetDateTime, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetDateTime value) {
            SQLDialect family = ctx.family();
            switch (family) {
                case HSQLDB: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql(" '")).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                    break;
                }
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                    break;
                }
                default: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(" '")).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetDateTime value) throws SQLException {
            SQLDialect family = ctx.family();
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                ctx.statement().setObject(ctx.index(), value);
            } else {
                ctx.statement().setString(ctx.index(), DefaultOffsetDateTimeBinding.format(value, family));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetDateTime value) throws SQLException {
            if (Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
            }
            ctx.output().writeObject(value, JDBCType.TIMESTAMP_WITH_TIMEZONE);
        }

        @Override
        final OffsetDateTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.resultSet().getObject(ctx.index(), OffsetDateTime.class);
            }
            return OffsetDateTimeParser.offsetDateTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.statement().getObject(ctx.index(), OffsetDateTime.class);
            }
            return OffsetDateTimeParser.offsetDateTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.input().readObject(OffsetDateTime.class);
            }
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (!Boolean.FALSE.equals(configuration.settings().isBindOffsetDateTimeType())) {
                return 2014;
            }
            return 12;
        }

        private static final String format(OffsetDateTime val, SQLDialect family) {
            if (family == SQLDialect.POSTGRES) {
                if (val.toEpochSecond() * 1000L == 9223372036825200000L) {
                    return "infinity";
                }
                if (val.toEpochSecond() * 1000L == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            if (family == SQLDialect.POSTGRES && val.getYear() <= 0) {
                return DefaultOffsetDateTimeBinding.formatEra(val);
            }
            return val.format(F_TIMESTAMPTZ);
        }

        private static final String formatISO(OffsetDateTime val) {
            return val.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        private static final String formatEra(OffsetDateTime val) {
            return val.format(ERA);
        }
    }

    static final class OffsetDateTimeParser {
        OffsetDateTimeParser() {
        }

        static final OffsetTime offsetTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            return OffsetTime.of(OffsetDateTimeParser.parseLocalTime(string, position), OffsetDateTimeParser.parseOffset(string, position));
        }

        static final OffsetDateTime offsetDateTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            LocalDate d2 = OffsetDateTimeParser.parseLocalDate(string, position);
            OffsetDateTimeParser.parseAnyChar(string, position, " T");
            LocalTime t2 = OffsetDateTimeParser.parseLocalTime(string, position);
            ZoneOffset offset = OffsetDateTimeParser.parseOffset(string, position);
            return OffsetDateTimeParser.parseBCIf(string, position) ? OffsetDateTime.of(d2.withYear(1 - d2.getYear()), t2, offset) : OffsetDateTime.of(d2, t2, offset);
        }

        static final LocalDate parseLocalDate(String string, int[] position) {
            int year = OffsetDateTimeParser.parseInt(string, position, 10);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int month = OffsetDateTimeParser.parseInt(string, position, 2);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int day = OffsetDateTimeParser.parseInt(string, position, 2);
            return LocalDate.of(year, month, day);
        }

        static final LocalTime parseLocalTime(String string, int[] position) {
            int hour = OffsetDateTimeParser.parseInt(string, position, 2);
            if (hour == 24) {
                hour %= 24;
            }
            OffsetDateTimeParser.parseChar(string, position, ':');
            int minute = OffsetDateTimeParser.parseInt(string, position, 2);
            int second = 0;
            int nano = 0;
            if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                second = OffsetDateTimeParser.parseInt(string, position, 2);
                if (OffsetDateTimeParser.parseCharIf(string, position, '.')) {
                    nano = OffsetDateTimeParser.parseInt(string, position, 9, true);
                }
            }
            return LocalTime.of(hour, minute, second, nano);
        }

        private static final ZoneOffset parseOffset(String string, int[] position) {
            int offsetHours = 0;
            int offsetMinutes = 0;
            int offsetSeconds = 0;
            if (!OffsetDateTimeParser.parseCharIf(string, position, 'Z')) {
                boolean plus;
                while (OffsetDateTimeParser.parseCharIf(string, position, ' ')) {
                }
                boolean minus = OffsetDateTimeParser.parseCharIf(string, position, '-');
                boolean bl2 = plus = !minus && OffsetDateTimeParser.parseCharIf(string, position, '+');
                if (minus || plus) {
                    offsetHours = OffsetDateTimeParser.parseInt(string, position, 1);
                    if (Character.isDigit(string.charAt(position[0]))) {
                        offsetHours = offsetHours * 10 + OffsetDateTimeParser.parseInt(string, position, 1);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetMinutes = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetSeconds = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (minus) {
                        offsetHours = -offsetHours;
                        offsetMinutes = -offsetMinutes;
                        offsetSeconds = -offsetSeconds;
                    }
                }
            }
            return ZoneOffset.ofHoursMinutesSeconds(offsetHours, offsetMinutes, offsetSeconds);
        }

        private static final void parseAnyChar(String string, int[] position, String expected) {
            for (int i2 = 0; i2 < expected.length(); ++i2) {
                if (string.charAt(position[0]) != expected.charAt(i2)) continue;
                position[0] = position[0] + 1;
                return;
            }
            throw new IllegalArgumentException("Expected any of \"" + expected + "\" at position " + position[0] + " in " + string);
        }

        private static final boolean parseBCIf(String string, int[] position) {
            return OffsetDateTimeParser.parseCharIf(string, position, ' ') && OffsetDateTimeParser.parseCharIf(string, position, 'B') && OffsetDateTimeParser.parseCharIf(string, position, 'C');
        }

        private static final boolean parseCharIf(String string, int[] position, char expected) {
            boolean result;
            boolean bl2 = result = string.length() > position[0] && string.charAt(position[0]) == expected;
            if (result) {
                position[0] = position[0] + 1;
            }
            return result;
        }

        private static final void parseChar(String string, int[] position, char expected) {
            if (!OffsetDateTimeParser.parseCharIf(string, position, expected)) {
                throw new IllegalArgumentException("Expected '" + expected + "' at position " + position[0] + " in " + string);
            }
        }

        private static final int parseInt(String string, int[] position, int maxLength) {
            return OffsetDateTimeParser.parseInt(string, position, maxLength, false);
        }

        private static final int parseInt(String string, int[] position, int maxLength, boolean rightPad) {
            int digit;
            int length;
            int result = 0;
            int pos = position[0];
            for (length = 0; length < maxLength && pos + length < string.length() && (digit = string.charAt(pos + length) - 48) >= 0 && digit < 10; ++length) {
                result = result * 10 + digit;
            }
            if (rightPad && length < maxLength && result > 0) {
                for (int i2 = length; i2 < maxLength; ++i2) {
                    result *= 10;
                }
            }
            position[0] = pos + length;
            return result;
        }
    }

    static final class DefaultLongBinding<U>
    extends InternalBinding<Long, U> {
        DefaultLongBinding(DataType<Long> dataType, Converter<Long, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Long value) {
            ctx.render().sql(value);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Long value) throws SQLException {
            ctx.statement().setLong(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Long value) throws SQLException {
            ctx.output().writeLong(value);
        }

        @Override
        final Long get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Long.valueOf(ctx.resultSet().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Long.valueOf(ctx.statement().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Long.valueOf(ctx.input().readLong()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -5;
        }
    }

    static final class DefaultIntegerBinding<U>
    extends InternalBinding<Integer, U> {
        DefaultIntegerBinding(DataType<Integer> dataType, Converter<Integer, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Integer value) {
            ctx.render().sql(value);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Integer value) throws SQLException {
            ctx.statement().setInt(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Integer value) throws SQLException {
            ctx.output().writeInt(value);
        }

        @Override
        final Integer get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Integer.valueOf(ctx.resultSet().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Integer.valueOf(ctx.statement().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Integer.valueOf(ctx.input().readInt()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 4;
        }
    }

    static final class DefaultFloatBinding<U>
    extends InternalBinding<Float, U> {
        DefaultFloatBinding(DataType<Float> dataType, Converter<Float, U> converter) {
            super(dataType, converter);
        }

        static final Float fixInfinity(Scope scope, ThrowingSupplier<Float, SQLException> doubleSupplier, ThrowingSupplier<String, SQLException> stringSupplier) throws SQLException {
            return DefaultDoubleBinding.fixInfinity(scope, doubleSupplier, stringSupplier, () -> Float.valueOf(Float.POSITIVE_INFINITY), () -> Float.valueOf(Float.NEGATIVE_INFINITY));
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Float value) {
            if (value.isNaN()) {
                ctx.render().visit(DefaultDoubleBinding.nan(ctx, SQLDataType.REAL));
            } else if ((double)value.floatValue() == Double.POSITIVE_INFINITY) {
                ctx.render().visit(DefaultDoubleBinding.infinity(ctx, SQLDataType.REAL, false));
            } else if ((double)value.floatValue() == Double.NEGATIVE_INFINITY) {
                ctx.render().visit(DefaultDoubleBinding.infinity(ctx, SQLDataType.REAL, true));
            } else if (DefaultDoubleBinding.REQUIRES_LITERAL_CAST.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.field(ctx.render().floatFormat().format(value)).cast(SQLDataType.REAL));
            } else {
                ctx.render().sql(value.floatValue());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Float value) throws SQLException {
            ctx.statement().setFloat(ctx.index(), value.floatValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Float value) throws SQLException {
            ctx.output().writeFloat(value.floatValue());
        }

        @Override
        final Float get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), DefaultFloatBinding.fixInfinity(ctx, () -> Float.valueOf(ctx.resultSet().getFloat(ctx.index())), () -> ctx.resultSet().getString(ctx.index())));
        }

        @Override
        final Float get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), DefaultFloatBinding.fixInfinity(ctx, () -> Float.valueOf(ctx.statement().getFloat(ctx.index())), () -> ctx.statement().getString(ctx.index())));
        }

        @Override
        final Float get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), DefaultFloatBinding.fixInfinity(ctx, () -> Float.valueOf(ctx.input().readFloat()), () -> ctx.input().readString()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 6;
        }
    }

    static final class DefaultEnumTypeBinding<U>
    extends InternalBinding<EnumType, U> {
        private static final Set<SQLDialect> REQUIRE_ENUM_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

        DefaultEnumTypeBinding(DataType<EnumType> dataType, Converter<EnumType, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            DefaultBinding.binding(SQLDataType.VARCHAR).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), value.getLiteral()));
            if (REQUIRE_ENUM_CAST.contains((Object)ctx.dialect())) {
                DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
            }
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (REQUIRE_ENUM_CAST.contains((Object)ctx.dialect())) {
                DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, EnumType value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.getLiteral());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, EnumType value) throws SQLException {
            ctx.output().writeString(value.getLiteral());
        }

        @Override
        final EnumType get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.statement().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.input().readString());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }

        static final void pgRenderEnumCast(RenderContext render, Class<?> type) {
            Class<?> enumType = type.isArray() ? type.getComponentType() : type;
            EnumType[] enums = Tools.enums(enumType);
            if (enums == null || enums.length == 0) {
                throw new IllegalArgumentException("Not a valid EnumType : " + type);
            }
            Schema schema = enums[0].getSchema();
            if (schema != null) {
                render.sql("::");
                schema = DSL.using(render.configuration()).map(schema);
                if (schema != null && Boolean.TRUE.equals(render.configuration().settings().isRenderSchema())) {
                    render.visit(schema);
                    render.sql('.');
                }
                render.visit(DSL.name(enums[0].getName()));
            }
            if (type.isArray()) {
                render.sql("[]");
            }
        }

        static final <E extends EnumType> E getEnumType(Class<? extends E> type, String literal) {
            try {
                return (E)Tools.findAny(Tools.enums(type), e2 -> e2.getLiteral().equals(literal));
            }
            catch (Exception e3) {
                throw new DataTypeException("Unknown enum literal found : " + literal);
            }
        }
    }

    static final class DefaultDoubleBinding<U>
    extends InternalBinding<Double, U> {
        static final Set<SQLDialect> REQUIRES_LITERAL_CAST = SQLDialect.supportedBy(SQLDialect.H2);

        DefaultDoubleBinding(DataType<Double> dataType, Converter<Double, U> converter) {
            super(dataType, converter);
        }

        static final Field<?> nan(BindingSQLContext<?> ctx, DataType<?> type) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    return DSL.log(DSL.inline(1), DSL.inline(1));
                }
                case HSQLDB: {
                    return DSL.inline(0.0).div(DSL.field("0.0e0", type));
                }
            }
            return DSL.inline("NaN").cast(type);
        }

        static final Field<?> infinity(BindingSQLContext<?> ctx, DataType<?> type, boolean negative) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    return DSL.log(negative ? DSL.inline(0.5) : DSL.inline(1.5), DSL.inline(1));
                }
                case HSQLDB: {
                    return DSL.inline(negative ? -1.0 : 1.0).div(DSL.field("0.0e0", type));
                }
            }
            return DSL.inline(negative ? "-Infinity" : "Infinity").cast(type);
        }

        static final Double fixInfinity(Scope scope, ThrowingSupplier<Double, SQLException> doubleSupplier, ThrowingSupplier<String, SQLException> stringSupplier) throws SQLException {
            return DefaultDoubleBinding.fixInfinity(scope, doubleSupplier, stringSupplier, () -> Double.POSITIVE_INFINITY, () -> Double.NEGATIVE_INFINITY);
        }

        static final <T> T fixInfinity(Scope scope, ThrowingSupplier<T, SQLException> doubleSupplier, ThrowingSupplier<String, SQLException> stringSupplier, Supplier<T> positive, Supplier<T> negative) throws SQLException {
            return doubleSupplier.get();
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Double value) {
            if (value.isNaN()) {
                ctx.render().visit(DefaultDoubleBinding.nan(ctx, SQLDataType.DOUBLE));
            } else if (value == Double.POSITIVE_INFINITY) {
                ctx.render().visit(DefaultDoubleBinding.infinity(ctx, SQLDataType.DOUBLE, false));
            } else if (value == Double.NEGATIVE_INFINITY) {
                ctx.render().visit(DefaultDoubleBinding.infinity(ctx, SQLDataType.DOUBLE, true));
            } else if (REQUIRES_LITERAL_CAST.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.field(ctx.render().doubleFormat().format(value)).cast(SQLDataType.DOUBLE));
            } else {
                ctx.render().sql(value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Double value) throws SQLException {
            ctx.statement().setDouble(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Double value) throws SQLException {
            ctx.output().writeDouble(value);
        }

        @Override
        final Double get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), DefaultDoubleBinding.fixInfinity(ctx, () -> ctx.resultSet().getDouble(ctx.index()), () -> ctx.resultSet().getString(ctx.index())));
        }

        @Override
        final Double get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), DefaultDoubleBinding.fixInfinity(ctx, () -> ctx.statement().getDouble(ctx.index()), () -> ctx.statement().getString(ctx.index())));
        }

        @Override
        final Double get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), DefaultDoubleBinding.fixInfinity(ctx, () -> ctx.input().readDouble(), () -> ctx.input().readString()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 8;
        }
    }

    static final class DefaultDayToSecondBinding<U>
    extends InternalBinding<DayToSecond, U> {
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
        private static final Set<SQLDialect> REQUIRE_STANDARD_INTERVAL = SQLDialect.supportedBy(SQLDialect.H2);

        DefaultDayToSecondBinding(DataType<DayToSecond> dataType, Converter<DayToSecond, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, DayToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGInterval(value).toString()));
            } else {
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, DayToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), this.renderDTS(ctx, value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, DayToSecond value) throws SQLException {
            ctx.output().writeString(this.renderDTS(ctx, value));
        }

        @Override
        final DayToSecond get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            return this.parseDTS(ctx, ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final DayToSecond get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            return this.parseDTS(ctx, ctx.statement().getString(ctx.index()));
        }

        @Override
        final DayToSecond get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.parseDTS(ctx, ctx.input().readString());
        }

        private final DayToSecond parseDTS(Scope scope, String string) {
            if (string == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect()) && string.startsWith("INTERVAL")) {
                return (DayToSecond)((Param)scope.dsl().parser().parseField(string)).getValue();
            }
            return DayToSecond.valueOf(string);
        }

        private final String renderDTS(Scope scope, DayToSecond dts) {
            if (dts == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect())) {
                return "INTERVAL '" + dts.toString() + "' DAY TO SECOND";
            }
            return dts.toString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultDateBinding<U>
    extends InternalBinding<java.sql.Date, U> {
        private static final Set<SQLDialect> INLINE_AS_STRING_LITERAL = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultDateBinding(DataType<java.sql.Date> dataType, Converter<java.sql.Date, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, java.sql.Date value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultDateBinding.escape(value, ctx.render()))).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql("('")).sql(DefaultDateBinding.escape(value, ctx.render()))).sql("')");
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("{d '")).sql(DefaultDateBinding.escape(value, ctx.render()))).sql("'}");
            } else {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql(" '")).sql(this.format(value, ctx.render()))).sql('\'');
            }
        }

        private final String format(java.sql.Date value, RenderContext render) {
            if (render.family() == SQLDialect.POSTGRES) {
                if (value.getTime() == 9223372036825200000L) {
                    return "infinity";
                }
                if (value.getTime() == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            if (value.getYear() + 1900 >= 10000) {
                return value.getYear() + 1900 + "-" + StringUtils.leftPad("" + (value.getMonth() + 1), 2, '0') + "-" + StringUtils.leftPad("" + value.getDate(), 2, '0');
            }
            return DefaultDateBinding.escape(value, render);
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, java.sql.Date value) throws SQLException {
            super.sqlBind0(ctx, value);
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, java.sql.Date value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setDate(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, java.sql.Date value) throws SQLException {
            ctx.output().writeDate(value);
        }

        @Override
        final java.sql.Date get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            SQLDialect family = ctx.family();
            if (family == SQLDialect.SQLITE) {
                String date = ctx.resultSet().getString(ctx.index());
                return date == null ? null : new java.sql.Date(DefaultBinding.parse(java.sql.Date.class, date));
            }
            return ctx.resultSet().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readDate();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 91;
        }
    }

    static final class DefaultClobBinding<U>
    extends InternalBinding<Clob, U> {
        DefaultClobBinding(DataType<Clob> dataType, Converter<Clob, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Clob value) throws SQLException {
            ctx.statement().setClob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Clob value) throws SQLException {
            ctx.output().writeClob(value);
        }

        @Override
        final Clob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readClob();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2005;
        }
    }

    static final class DefaultBytesBinding<U>
    extends InternalBinding<byte[], U> {
        private final BlobBinding blobs = new BlobBinding();

        DefaultBytesBinding(DataType<byte[]> dataType, Converter<byte[], U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                default: 
            }
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, byte[] value) {
            switch (ctx.family()) {
                case H2: 
                case HSQLDB: 
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql("X'")).sql(Tools.convertBytesToHex(value))).sql('\'');
                    break;
                }
                case DERBY: {
                    ((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql("(X'")).sql(Tools.convertBytesToHex(value))).sql("' ")).visit(Keywords.K_AS)).sql(' ')).visit(SQLDataType.BLOB)).sql(')');
                    break;
                }
                case POSTGRES: 
                case YUGABYTEDB: {
                    ((RenderContext)((RenderContext)ctx.render().sql("E'")).sql(PostgresUtils.toPGString(value))).sql("'::bytea");
                    break;
                }
                default: {
                    ((RenderContext)((RenderContext)ctx.render().sql("X'")).sql(Tools.convertBytesToHex(value))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, byte[] value) throws SQLException {
            switch (ctx.family()) {
                case H2: {
                    this.blobs.set((BindingSetStatementContext<byte[]>)new DefaultBindingSetStatementContext<byte[]>(ctx.executeContext(), ctx.statement(), ctx.index(), value));
                    break;
                }
                default: {
                    ctx.statement().setBytes(ctx.index(), value);
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, byte[] value) throws SQLException {
            ctx.output().writeBytes(value);
        }

        @Override
        final byte[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: {
                    DefaultBindingGetResultSetContext<byte[]> x2 = new DefaultBindingGetResultSetContext<byte[]>(ctx.executeContext(), ctx.resultSet(), ctx.index());
                    this.blobs.get((BindingGetResultSetContext<byte[]>)x2);
                    return x2.value();
                }
            }
            return ctx.resultSet().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: {
                    DefaultBindingGetStatementContext<byte[]> x2 = new DefaultBindingGetStatementContext<byte[]>(ctx.executeContext(), ctx.statement(), ctx.index());
                    this.blobs.get((BindingGetStatementContext<byte[]>)x2);
                    return x2.value();
                }
            }
            return ctx.statement().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBytes();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultByteBinding<U>
    extends InternalBinding<Byte, U> {
        DefaultByteBinding(DataType<Byte> dataType, Converter<Byte, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Byte value) {
            ctx.render().sql(value.byteValue());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Byte value) throws SQLException {
            ctx.statement().setByte(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Byte value) throws SQLException {
            ctx.output().writeByte(value);
        }

        @Override
        final Byte get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Byte.valueOf(ctx.resultSet().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Byte.valueOf(ctx.statement().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Byte.valueOf(ctx.input().readByte()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -6;
        }
    }

    static final class DefaultBooleanBinding<U>
    extends InternalBinding<Boolean, U> {
        private static final Set<SQLDialect> BIND_AS_1_0 = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.SQLITE);

        DefaultBooleanBinding(DataType<Boolean> dataType, Converter<Boolean, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Boolean value) {
            if (BIND_AS_1_0.contains((Object)ctx.dialect())) {
                ctx.render().sql(value != false ? "1" : "0");
            } else {
                ctx.render().visit(value != false ? Keywords.K_TRUE : Keywords.K_FALSE);
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Boolean value) throws SQLException {
            switch (ctx.family()) {
                default: 
            }
            ctx.statement().setBoolean(ctx.index(), value);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Boolean value) throws SQLException {
            ctx.output().writeBoolean(value);
        }

        @Override
        final Boolean get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), (Boolean)ctx.resultSet().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), (Boolean)ctx.statement().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), (Boolean)ctx.input().readBoolean());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            switch (configuration.family()) {
                default: 
            }
            return 16;
        }
    }

    static final class DefaultBlobBinding<U>
    extends InternalBinding<Blob, U> {
        DefaultBlobBinding(DataType<Blob> dataType, Converter<Blob, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Blob value) throws SQLException {
            ctx.statement().setBlob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Blob value) throws SQLException {
            ctx.output().writeBlob(value);
        }

        @Override
        final Blob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBlob();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultBigIntegerBinding<U>
    extends InternalBinding<BigInteger, U> {
        private static final Set<SQLDialect> BIND_AS_STRING = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultBigIntegerBinding(DataType<BigInteger> dataType, Converter<BigInteger, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigInteger value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigInteger value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.dialect())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigInteger value) throws SQLException {
            ctx.output().writeBigDecimal(new BigDecimal(value));
        }

        @Override
        final BigInteger get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigInteger.class);
            }
            BigDecimal b2 = ctx.resultSet().getBigDecimal(ctx.index());
            return b2 == null ? null : b2.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetStatementContext<U> ctx) throws SQLException {
            BigDecimal d2 = ctx.statement().getBigDecimal(ctx.index());
            return d2 == null ? null : d2.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            BigDecimal d2 = ctx.input().readBigDecimal();
            return d2 == null ? null : d2.toBigInteger();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultBigDecimalBinding<U>
    extends InternalBinding<BigDecimal, U> {
        private static final Set<SQLDialect> BIND_AS_STRING = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultBigDecimalBinding(DataType<BigDecimal> dataType, Converter<BigDecimal, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigDecimal value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigDecimal value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.dialect())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigDecimal value) throws SQLException {
            ctx.output().writeBigDecimal(value);
        }

        @Override
        final BigDecimal get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigDecimal.class);
            }
            return ctx.resultSet().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBigDecimal();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultArrayBinding<U>
    extends InternalBinding<Object[], U> {
        private static final Set<SQLDialect> REQUIRES_ARRAY_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

        DefaultArrayBinding(DataType<Object[]> dataType, Converter<Object[], U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            String separator = "";
            if (REQUIRES_ARRAY_CAST.contains((Object)ctx.dialect())) {
                DataType<Object[]> arrayType = this.dataType.getType() == Object[].class ? DefaultDataType.getDataType(ctx.dialect(), this.deriveArrayTypeFromComponentType(value)) : this.dataType;
                ctx.render().visit(DSL.cast(DSL.inline(PostgresUtils.toPGArrayString(value)), arrayType));
            } else {
                boolean squareBrackets = true;
                ctx.render().visit(Keywords.K_ARRAY);
                ctx.render().sql(squareBrackets ? (char)'[' : '(');
                for (Object o2 : value) {
                    ctx.render().sql(separator);
                    DefaultBinding.binding(this.dataType.getArrayComponentDataType()).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o2));
                    separator = ", ";
                }
                ctx.render().sql(squareBrackets ? (char)']' : ')');
                if (REQUIRES_ARRAY_CAST.contains((Object)ctx.dialect()) && this.dataType.getArrayComponentDataType().isEnum()) {
                    DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
                }
            }
        }

        private final Class<? extends Object[]> deriveArrayTypeFromComponentType(Object[] value) {
            for (Object o2 : value) {
                if (o2 == null) continue;
                return Internal.arrayType(o2.getClass());
            }
            return String[].class;
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            super.sqlBind0(ctx, value);
            switch (ctx.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    if (EnumType.class.isAssignableFrom(this.dataType.getType().getComponentType())) {
                        DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
                        break;
                    }
                    ((RenderContext)ctx.render().sql("::")).sql(this.dataType.getCastTypeName(ctx.render().configuration()));
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object[] value) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    ctx.statement().setString(ctx.index(), PostgresUtils.toPGArrayString(value));
                    break;
                }
                case HSQLDB: {
                    Object[] a2 = value;
                    Class<Object> t2 = this.dataType.getType();
                    if (t2 == UUID[].class) {
                        a2 = Convert.convertArray(a2, byte[][].class);
                        t2 = byte[][].class;
                    }
                    ctx.statement().setArray(ctx.index(), new MockArray<Object>(ctx.family(), a2, t2));
                    break;
                }
                case H2: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    throw new SQLDialectNotSupportedException("Cannot bind ARRAY types in dialect " + ctx.family());
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object[] value) throws SQLException {
            ctx.output().writeArray(new MockArray<Object>(ctx.family(), value, this.dataType.getType()));
        }

        @Override
        final Object[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    return (Object[])DefaultArrayBinding.pgGetArray(ctx, ctx.resultSet(), this.dataType, ctx.index());
                }
                case HSQLDB: {
                    if (ctx.resultSet().getObject(ctx.index()) == null) {
                        return null;
                    }
                    return DefaultArrayBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.dataType.getType());
                }
            }
            return DefaultArrayBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.dataType.getType());
        }

        @Override
        final Object[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultArrayBinding.convertArray(ctx.statement().getObject(ctx.index()), this.dataType.getType());
        }

        @Override
        final Object[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            java.sql.Array array = ctx.input().readArray();
            return array == null ? null : (Object[])array.getArray();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2003;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final <T> T pgGetArray(ExecuteScope ctx, ResultSet rs, DataType<T> dataType, int index) throws SQLException {
            java.sql.Array array = null;
            try {
                Object[] objectArray;
                array = rs.getArray(index);
                if (array == null) {
                    T t2 = null;
                    return t2;
                }
                DataType<?> cdt = dataType.getArrayComponentDataType();
                try {
                    if (cdt.isBinary() || cdt.isUDT()) {
                        throw new ControlFlowSignal("GOTO the next array deserialisation strategy");
                    }
                    objectArray = DefaultArrayBinding.convertArray(array, dataType.getType());
                }
                catch (Exception e2) {
                    ArrayList result = new ArrayList();
                    try (ResultSet arrayRs = array.getResultSet();){
                        Binding<?, ?> binding = DefaultBinding.binding(dataType.getArrayComponentDataType());
                        DefaultBindingGetResultSetContext out = new DefaultBindingGetResultSetContext(ctx.executeContext(), arrayRs, 2);
                        while (arrayRs.next()) {
                            binding.get(out);
                            result.add(out.value());
                        }
                    }
                    catch (Exception fatal) {
                        String string = null;
                        try {
                            string = rs.getString(index);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        log.error("Cannot parse array", string, fatal);
                        T t3 = null;
                        JDBCUtils.safeFree(array);
                        return t3;
                    }
                    Object[] objectArray2 = DefaultArrayBinding.convertArray(result.toArray(), dataType.getType());
                    JDBCUtils.safeFree(array);
                    return (T)objectArray2;
                }
                return (T)objectArray;
            }
            finally {
                JDBCUtils.safeFree(array);
            }
        }

        private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
            if (array instanceof Object[]) {
                return Convert.convert(array, type);
            }
            if (array instanceof java.sql.Array) {
                return DefaultArrayBinding.convertArray((java.sql.Array)array, type);
            }
            return null;
        }

        private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
            if (array != null) {
                return Convert.convert(array.getArray(), type);
            }
            return null;
        }
    }

    static final class DelegatingBinding<X, T, U>
    extends InternalBinding<X, U> {
        private final Converter<T, X> delegatingConverter;
        private final InternalBinding<T, U> delegatingBinding;

        DelegatingBinding(DataType<X> originalDataType, Converter<T, X> delegatingConverter, Converter<X, U> originalConverter, Function<? super Converter<T, U>, ? extends InternalBinding<T, U>> f2) {
            super(originalDataType, originalConverter);
            this.delegatingConverter = delegatingConverter;
            this.delegatingBinding = f2.apply(Converters.of(delegatingConverter, originalConverter));
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlInline0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlBind0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            this.delegatingBinding.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final X get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            return this.delegatingBinding.sqltype(statement, configuration);
        }
    }

    static abstract class InternalBinding<T, U>
    implements Binding<T, U> {
        static final Set<SQLDialect> NEEDS_PRECISION_SCALE_ON_BIGDECIMAL = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);
        static final Set<SQLDialect> REQUIRES_JSON_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
        static final Set<SQLDialect> NO_SUPPORT_ENUM_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
        static final Set<SQLDialect> NO_SUPPORT_NVARCHAR = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
        final DataType<T> dataType;
        final Converter<T, U> converter;
        final boolean attachable;

        InternalBinding(DataType<T> dataType, Converter<T, U> converter) {
            this.dataType = dataType;
            this.converter = converter;
            this.attachable = Attachable.class.isAssignableFrom(converter.toType()) || !Modifier.isFinal(converter.toType().getModifiers());
        }

        @Override
        public final Converter<T, U> converter() {
            return this.converter;
        }

        private final boolean shouldCast(BindingSQLContext<U> ctx, T converted) {
            if (ctx.render().paramType() == ParamType.INLINED) {
                if (converted == null) {
                    switch (ctx.family()) {
                        case DERBY: {
                            return true;
                        }
                    }
                }
            } else if (!(converted instanceof EnumType)) {
                switch (ctx.family()) {
                    case DERBY: 
                    case FIREBIRD: 
                    case H2: 
                    case HSQLDB: 
                    case IGNITE: 
                    case CUBRID: 
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        return true;
                    }
                }
            }
            if (this.dataType.isInterval()) {
                switch (ctx.family()) {
                    case H2: 
                    case HSQLDB: 
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        return true;
                    }
                }
            }
            if (this.dataType.isJSON() || this.dataType.isXML()) {
                switch (ctx.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        return true;
                    }
                }
            }
            return false;
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted) throws SQLException {
            DataType<T> sqlDataType = this.dataType.getSQLDataType();
            SQLDialect family = ctx.family();
            if (converted != null && this.dataType.getType() == BigDecimal.class && NEEDS_PRECISION_SCALE_ON_BIGDECIMAL.contains((Object)ctx.dialect())) {
                int precision;
                int scale = ((BigDecimal)converted).scale();
                if (scale >= (precision = ((BigDecimal)converted).precision())) {
                    precision = scale + 1;
                }
                this.sqlCast(ctx, converted, this.dataType, null, precision, scale);
            } else if (SQLDataType.ROWID == sqlDataType) {
                this.sql(ctx, converted);
            } else if (SQLDataType.OTHER == sqlDataType) {
                if (converted != null) {
                    this.sqlCast(ctx, converted, DefaultDataType.getDataType(family, converted.getClass()), null, null, null);
                } else {
                    ctx.render().sql(ctx.variable());
                }
            } else if (REQUIRES_JSON_CAST.contains((Object)ctx.dialect()) && (sqlDataType == null || !sqlDataType.isTemporal() && sqlDataType != SQLDataType.UUID && !sqlDataType.isXML() && !sqlDataType.isJSON())) {
                this.sql(ctx, converted);
            } else if (!NO_SUPPORT_ENUM_CAST.contains((Object)ctx.dialect()) && this.dataType.isEnum()) {
                this.sqlCast(ctx, converted, Tools.emulateEnumType(this.dataType), this.dataType.lengthDefined() ? Integer.valueOf(this.dataType.length()) : null, this.dataType.precisionDefined() ? Integer.valueOf(this.dataType.precision()) : null, this.dataType.scaleDefined() ? Integer.valueOf(this.dataType.scale()) : null);
            } else {
                this.sqlCast(ctx, converted, this.dataType, this.dataType.lengthDefined() ? Integer.valueOf(this.dataType.length()) : null, this.dataType.precisionDefined() ? Integer.valueOf(this.dataType.precision()) : null, this.dataType.scaleDefined() ? Integer.valueOf(this.dataType.scale()) : null);
            }
        }

        private static final int getValueLength(String string) {
            if (string == null) {
                return 1;
            }
            int length = string.length();
            for (int i2 = 0; i2 < length; ++i2) {
                if (string.charAt(i2) <= '\u007f') continue;
                return Math.min(32672, 4 * length);
            }
            return Math.min(32672, length);
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted, DataType<?> t2, Integer length, Integer precision, Integer scale) throws SQLException {
            ((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(');
            this.sql(ctx, converted);
            ((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_AS)).sql(' ')).sql(DefaultDataType.set(t2, length, precision, scale).getCastTypeName(ctx.configuration()))).sql(')');
        }

        @Override
        public final void sql(BindingSQLContext<U> ctx) throws SQLException {
            T converted = this.converter().to(ctx.value());
            switch (ctx.render().castMode()) {
                case NEVER: {
                    this.sql(ctx, converted);
                    return;
                }
                case ALWAYS: {
                    this.sqlCast(ctx, converted);
                    return;
                }
            }
            if (this.shouldCast(ctx, converted)) {
                this.sqlCast(ctx, converted);
            } else {
                this.sql(ctx, converted);
            }
        }

        private final void sql(BindingSQLContext<U> ctx, T value) throws SQLException {
            if (ctx.render().paramType() == ParamType.INLINED) {
                if (value == null) {
                    ctx.render().visit(Keywords.K_NULL);
                } else {
                    this.sqlInline0(ctx, value);
                }
            } else {
                this.sqlBind0(ctx, value);
            }
        }

        static final String escape(Object val, Context<?> ctx) {
            String result = val.toString();
            if (Tools.needsBackslashEscaping(ctx.configuration())) {
                result = StringUtils.replace(result, "\\", "\\\\");
            }
            return StringUtils.replace(result, "'", "''");
        }

        @Override
        public final void register(BindingRegisterContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                log.trace((Object)("Registering variable " + ctx.index()), "" + this.dataType);
            }
            this.register0(ctx);
        }

        @Override
        public final void set(BindingSetStatementContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                if (value != null && value.getClass().isArray() && value.getClass() != byte[].class) {
                    log.trace((Object)("Binding variable " + ctx.index()), Arrays.asList((Object[])value) + " (" + this.dataType + ")");
                } else {
                    log.trace((Object)("Binding variable " + ctx.index()), value + " (" + this.dataType + ")");
                }
            }
            if (value == null) {
                this.setNull0(ctx);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (value == null) {
                ctx.output().writeObject(null);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void get(BindingGetResultSetContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = InternalBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        @Override
        public final void get(BindingGetStatementContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = InternalBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        @Override
        public final void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = InternalBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        private static final <U> U attach(U value, Configuration configuration) {
            if (value instanceof Attachable && Tools.attachRecords(configuration)) {
                ((Attachable)value).attach(configuration);
            }
            return value;
        }

        void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            if (ctx.statement() instanceof R2DBC.R2DBCPreparedStatement) {
                ((R2DBC.R2DBCPreparedStatement)ctx.statement()).setNull(ctx.index(), this.dataType);
            } else {
                ctx.statement().setNull(ctx.index(), this.sqltype(ctx.statement(), ctx.configuration()));
            }
        }

        void register0(BindingRegisterContext<U> ctx) throws SQLException {
            ctx.statement().registerOutParameter(ctx.index(), this.sqltype(ctx.statement(), ctx.configuration()));
        }

        void sqlInline0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(InternalBinding.escape(value, ctx.render()), true)).sql('\'');
        }

        void sqlBind0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ctx.render().sql(ctx.variable());
        }

        abstract void set0(BindingSetStatementContext<U> var1, T var2) throws SQLException;

        abstract void set0(BindingSetSQLOutputContext<U> var1, T var2) throws SQLException;

        abstract T get0(BindingGetResultSetContext<U> var1) throws SQLException;

        abstract T get0(BindingGetStatementContext<U> var1) throws SQLException;

        abstract T get0(BindingGetSQLInputContext<U> var1) throws SQLException;

        abstract int sqltype(Statement var1, Configuration var2) throws SQLException;

        public String toString() {
            return "AbstractBinding [type=" + this.dataType + ", converter=" + this.converter + "]";
        }
    }
}

