/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableConstraintStep;
import org.jooq.CreateTableWithDataStep;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Nullability;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.ConstraintImpl;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

final class CreateTableImpl
extends AbstractDDLQuery
implements CreateTableWithDataStep,
CreateTableColumnStep,
QOM.UNotYetImplemented {
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_WITH_DATA = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_CTAS_COLUMN_NAMES = SQLDialect.supportedBy(SQLDialect.H2);
    private static final Set<SQLDialect> EMULATE_INDEXES_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> EMULATE_SOME_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> EMULATE_STORED_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);
    private static final Set<SQLDialect> REQUIRES_WITH_DATA = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> WRAP_SELECT_IN_PARENS = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_TEMPORARY = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> EMULATE_COMMENT_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> REQUIRE_EXECUTE_IMMEDIATE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_NULLABLE_PRIMARY_KEY = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REQUIRE_NON_PK_COLUMNS = SQLDialect.supportedBy(SQLDialect.IGNITE);
    private final Table<?> table;
    private Select<?> select;
    private Boolean withData;
    private final List<Field<?>> columnFields;
    private final List<DataType<?>> columnTypes;
    private final List<Constraint> constraints;
    private final List<Index> indexes;
    private final boolean temporary;
    private final boolean ifNotExists;
    private TableOptions.OnCommit onCommit;
    private Comment comment;
    private SQL storage;

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.columnFields = new ArrayList();
        this.columnTypes = new ArrayList();
        this.constraints = new ArrayList<Constraint>();
        this.indexes = new ArrayList<Index>();
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $temporary() {
        return this.temporary;
    }

    final TableOptions.OnCommit $onCommit() {
        return this.onCommit;
    }

    final Select<?> $select() {
        return this.select;
    }

    final List<Field<?>> $columnFields() {
        return this.columnFields;
    }

    final List<DataType<?>> $columnTypes() {
        return this.columnTypes;
    }

    final List<Constraint> $constraints() {
        return this.constraints;
    }

    final List<Index> $indexes() {
        return this.indexes;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    final Comment $comment() {
        return this.comment;
    }

    public final CreateTableImpl as(Select<? extends Record> s2) {
        this.select = s2;
        return this;
    }

    @Override
    public final CreateTableImpl withData() {
        this.withData = true;
        return this;
    }

    @Override
    public final CreateTableImpl withNoData() {
        this.withData = false;
        return this;
    }

    @Override
    public final CreateTableImpl column(Field<?> field) {
        return this.column((Field)field, field.getDataType());
    }

    @Override
    public final CreateTableImpl columns(Field<?> ... fields2) {
        return this.columns(Arrays.asList(fields2));
    }

    @Override
    public final CreateTableImpl columns(Name ... fields2) {
        return this.columns((Field[])Tools.fieldsByName(fields2));
    }

    @Override
    public final CreateTableImpl columns(String ... fields2) {
        return this.columns((Field[])Tools.fieldsByName(fields2));
    }

    @Override
    public final CreateTableImpl columns(Collection<? extends Field<?>> fields2) {
        for (Field<?> field : fields2) {
            this.column((Field)field);
        }
        return this;
    }

    @Override
    public final <T> CreateTableImpl column(Field<T> field, DataType<T> type) {
        this.columnFields.add(field);
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl column(Name field, DataType<?> type) {
        this.columnFields.add(DSL.field(field, type));
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl column(String field, DataType<?> type) {
        return this.column(DSL.name(field), (DataType)type);
    }

    @Override
    public final CreateTableImpl constraint(Constraint c2) {
        return this.constraints(Arrays.asList(c2));
    }

    @Override
    public final CreateTableImpl constraints(Constraint ... c2) {
        return this.constraints(Arrays.asList(c2));
    }

    @Override
    public final CreateTableImpl constraints(Collection<? extends Constraint> c2) {
        this.constraints.addAll(c2);
        return this;
    }

    @Override
    public final CreateTableConstraintStep primaryKey(String ... fields2) {
        return this.constraint(DSL.primaryKey(fields2));
    }

    @Override
    public final CreateTableConstraintStep primaryKey(Name ... fields2) {
        return this.constraint(DSL.primaryKey(fields2));
    }

    @Override
    public final CreateTableConstraintStep primaryKey(Field<?> ... fields2) {
        return this.constraint(DSL.primaryKey(fields2));
    }

    @Override
    public final CreateTableConstraintStep primaryKey(Collection<? extends Field<?>> fields2) {
        return this.constraint(DSL.primaryKey(fields2));
    }

    @Override
    public final CreateTableConstraintStep unique(String ... fields2) {
        return this.constraint(DSL.unique(fields2));
    }

    @Override
    public final CreateTableConstraintStep unique(Name ... fields2) {
        return this.constraint(DSL.unique(fields2));
    }

    @Override
    public final CreateTableConstraintStep unique(Field<?> ... fields2) {
        return this.constraint(DSL.unique(fields2));
    }

    @Override
    public final CreateTableConstraintStep unique(Collection<? extends Field<?>> fields2) {
        return this.constraint(DSL.unique(fields2));
    }

    @Override
    public final CreateTableConstraintStep check(Condition condition) {
        return this.constraint(DSL.check(condition));
    }

    @Override
    public final CreateTableImpl index(Index i2) {
        return this.indexes(Arrays.asList(i2));
    }

    @Override
    public final CreateTableImpl indexes(Index ... i2) {
        return this.indexes(Arrays.asList(i2));
    }

    @Override
    public final CreateTableImpl indexes(Collection<? extends Index> i2) {
        this.indexes.addAll(i2);
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDeleteRows() {
        this.onCommit = TableOptions.OnCommit.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitPreserveRows() {
        this.onCommit = TableOptions.OnCommit.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDrop() {
        this.onCommit = TableOptions.OnCommit.DROP;
        return this;
    }

    @Override
    public final CreateTableImpl comment(String c2) {
        return this.comment(DSL.comment(c2));
    }

    @Override
    public final CreateTableImpl comment(Comment c2) {
        this.comment = c2;
        return this;
    }

    @Override
    public final CreateTableImpl storage(SQL sql) {
        this.storage = sql;
        return this;
    }

    @Override
    public final CreateTableImpl storage(String sql) {
        return this.storage(DSL.sql(sql));
    }

    @Override
    public final CreateTableImpl storage(String sql, Object ... bindings) {
        return this.storage(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateTableImpl storage(String sql, QueryPart ... parts) {
        return this.storage(DSL.sql(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_TABLE, c2 -> this.accept0((Context<?>)c2));
        } else {
            this.accept0(ctx);
        }
    }

    private static final void executeImmediateIf(boolean wrap, Context<?> ctx, Consumer<? super Context<?>> runnable) {
        if (wrap) {
            Tools.executeImmediate(ctx, runnable);
        } else {
            runnable.accept(ctx);
            ctx.sql(';');
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean bi2;
        boolean bc2 = this.comment != null && EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect());
        boolean bl2 = bi2 = !this.indexes.isEmpty() && EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect());
        if (bc2 || bi2) {
            Tools.begin(ctx, c1 -> {
                CreateTableImpl.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)c1.dialect()), c1, c2 -> this.accept1((Context<?>)c2));
                if (bc2) {
                    c1.formatSeparator();
                    CreateTableImpl.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect()), c1, c2 -> c2.visit(DSL.commentOnTable(this.table).is(this.comment)));
                }
                if (bi2) {
                    for (Index index : this.indexes) {
                        c1.formatSeparator();
                        CreateTableImpl.executeImmediateIf(REQUIRE_EXECUTE_IMMEDIATE.contains((Object)c1.dialect()), c1, c2 -> {
                            if ("".equals(index.getName())) {
                                c2.visit(DSL.createIndex().on(index.getTable(), index.getFields()));
                            } else {
                                c2.visit(DSL.createIndex(index.getUnqualifiedName()).on(index.getTable(), index.getFields()));
                            }
                        });
                    }
                }
            });
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            this.toSQLCreateTable(ctx);
            this.toSQLOnCommit(ctx);
        }
        if (this.comment != null && !EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_COMMENT).sql(' ');
            ctx.visit(this.comment);
        }
        if (this.storage != null && ctx.configuration().data("org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(this.storage);
        }
        ctx.end(Clause.CREATE_TABLE);
    }

    private void toSQLCreateTable(Context<?> ctx) {
        this.toSQLCreateTableName(ctx);
        if (!(this.columnFields.isEmpty() || this.select != null && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect()))) {
            DataType<EnumType> type;
            int i2;
            ctx.sqlIndentStart(" (").start(Clause.CREATE_TABLE_COLUMNS);
            Field<?> identity = null;
            boolean qualify = ctx.qualify();
            for (i2 = 0; i2 < this.columnFields.size(); ++i2) {
                type = this.columnType(ctx, i2);
                if (identity == null && type.identity()) {
                    identity = this.columnFields.get(i2);
                }
                ctx.qualify(false);
                ctx.visit(Tools.uncollate(this.columnFields.get(i2)));
                ctx.qualify(qualify);
                if (this.select == null) {
                    ctx.sql(' ');
                    Tools.toSQLDDLTypeDeclarationForAddition(ctx, type);
                }
                if (i2 >= this.columnFields.size() - 1) continue;
                ctx.sql(',').formatSeparator();
            }
            this.toSQLDummyColumns(ctx);
            ctx.end(Clause.CREATE_TABLE_COLUMNS).start(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.constraints.isEmpty()) {
                for (Constraint constraint : this.constraints) {
                    if (!((ConstraintImpl)constraint).supported(ctx) || ctx.family() == SQLDialect.SQLITE && this.matchingPrimaryKey(constraint, identity)) continue;
                    ctx.sql(',').formatSeparator().visit(constraint);
                }
            }
            if (EMULATE_SOME_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect())) {
                for (i2 = 0; i2 < this.columnFields.size(); ++i2) {
                    type = this.columnTypes.get(i2);
                    if (!EnumType.class.isAssignableFrom(type.getType())) continue;
                    DataType<EnumType> enumType = type;
                    if (!EMULATE_STORED_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect()) && Tools.storedEnumType(enumType)) continue;
                    Field<Field> field = this.columnFields.get(i2);
                    List<Field> literals = Tools.map(Tools.enums(enumType.getType()), e2 -> DSL.inline(e2.getLiteral()));
                    ctx.sql(',').formatSeparator().visit(DSL.constraint(this.table.getName() + "_" + field.getName() + "_chk").check(field.in((Collection<?>)literals)));
                }
            }
            ctx.end(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.indexes.isEmpty() && !EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect())) {
                ctx.qualify(false);
                for (Index index : this.indexes) {
                    ctx.sql(',').formatSeparator();
                    if (index.getUnique()) {
                        ctx.visit(Keywords.K_UNIQUE).sql(' ');
                    }
                    ctx.visit(Keywords.K_INDEX);
                    if (!"".equals(index.getName())) {
                        ctx.sql(' ').visit(index.getUnqualifiedName());
                    }
                    ctx.sql(" (").visit(new SortFieldList(index.getFields())).sql(')');
                }
                ctx.qualify(qualify);
            }
            ctx.sqlIndentEnd(')');
        }
    }

    private final void toSQLDummyColumns(Context<?> ctx) {
        Field<?>[] primaryKeyColumns;
        if (REQUIRE_NON_PK_COLUMNS.contains((Object)ctx.dialect()) && (primaryKeyColumns = this.primaryKeyColumns()) != null && primaryKeyColumns.length == this.columnFields.size()) {
            ctx.sql(',').formatSeparator();
            ctx.visit(DSL.field(DSL.name("dummy")));
            if (this.select == null) {
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, SQLDataType.INTEGER);
            }
        }
    }

    private final DataType<?> columnType(Context<?> ctx, int i2) {
        DataType<?> type = this.columnTypes.get(i2);
        if (NO_SUPPORT_NULLABLE_PRIMARY_KEY.contains((Object)ctx.dialect()) && type.nullability() == Nullability.DEFAULT && this.isPrimaryKey(i2)) {
            type = type.nullable(false);
        }
        return type;
    }

    private final Field<?>[] primaryKeyColumns() {
        return Tools.findAny(this.constraints, c2 -> c2 instanceof ConstraintImpl && ((ConstraintImpl)c2).$primaryKey() != null, c2 -> ((ConstraintImpl)c2).$primaryKey());
    }

    private final boolean isPrimaryKey(int i2) {
        return Tools.anyMatch(this.primaryKeyColumns(), this.columnFields.get(i2)::equals);
    }

    private final boolean matchingPrimaryKey(Constraint constraint, Field<?> identity) {
        if (constraint instanceof ConstraintImpl) {
            return ((ConstraintImpl)constraint).matchingPrimaryKey(identity);
        }
        return false;
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        this.toSQLCreateTable(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().visit(Keywords.K_AS);
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.sqlIndentStart(" (");
        } else {
            ctx.formatSeparator();
        }
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_SELECT_NO_DATA, true);
        }
        ctx.start(Clause.CREATE_TABLE_AS);
        if (!this.columnFields.isEmpty() && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.select.asTable(DSL.table(DSL.name("t")), this.columnFields.toArray(Tools.EMPTY_FIELD))));
        } else {
            ctx.visit(this.select);
        }
        ctx.end(Clause.CREATE_TABLE_AS);
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_SELECT_NO_DATA);
        }
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.sqlIndentEnd(')');
        }
        if (Boolean.FALSE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_NO_DATA);
        } else if (Boolean.TRUE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        } else if (REQUIRES_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        }
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).visit(Keywords.K_CREATE).sql(' ');
        if (this.temporary) {
            if (SUPPORT_TEMPORARY.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_TEMPORARY).sql(' ');
            } else {
                ctx.visit(Keywords.K_GLOBAL_TEMPORARY).sql(' ');
            }
        }
        ctx.visit(Keywords.K_TABLE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DELETE_ROWS);
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_PRESERVE_ROWS);
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DROP);
                }
            }
        }
    }
}

