/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import io.r2dbc.spi.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.BatchBindStep;
import org.jooq.Configuration;
import org.jooq.ExecuteListener;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.RowCountQuery;
import org.jooq.conf.ParamType;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractBatch;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.BatchMultiple;
import org.jooq.impl.DefaultBindContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.NoConnectionFactory;
import org.jooq.impl.ParamCollector;
import org.jooq.impl.R2DBC;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.reactivestreams.Subscriber;

final class BatchSingle
extends AbstractBatch
implements BatchBindStep {
    private static final JooqLogger log = JooqLogger.getLogger(BatchSingle.class);
    final Query query;
    final Map<String, List<Integer>> nameToIndexMapping;
    final List<Object[]> allBindValues;
    final int expectedBindValues;

    public BatchSingle(Configuration configuration, Query query) {
        super(configuration);
        int i2 = 0;
        ParamCollector collector = new ParamCollector(configuration, false);
        collector.visit(query);
        this.query = query;
        this.allBindValues = new ArrayList<Object[]>();
        this.nameToIndexMapping = new LinkedHashMap<String, List<Integer>>();
        this.expectedBindValues = collector.resultList.size();
        for (Map.Entry<String, Param<?>> entry : collector.resultList) {
            this.nameToIndexMapping.computeIfAbsent(entry.getKey(), e2 -> new ArrayList()).add(i2++);
        }
    }

    @Override
    public final BatchSingle bind(Object ... bindValues) {
        this.allBindValues.add(bindValues);
        return this;
    }

    @Override
    public final BatchSingle bind(Object[] ... bindValues) {
        for (Object[] v2 : bindValues) {
            this.bind(v2);
        }
        return this;
    }

    @Override
    public final BatchSingle bind(Map<String, Object> namedBindValues) {
        return this.bind(new Map[]{namedBindValues});
    }

    @Override
    @SafeVarargs
    public final BatchSingle bind(Map<String, Object> ... namedBindValues) {
        List<Object> defaultValues = this.dsl.extractBindValues(this.query);
        Object[][] bindValues = new Object[namedBindValues.length][];
        for (int i2 = 0; i2 < bindValues.length; ++i2) {
            bindValues[i2] = defaultValues.toArray();
            Object[] row = bindValues[i2];
            namedBindValues[i2].forEach((k2, v2) -> {
                List<Integer> indexes = this.nameToIndexMapping.get(k2);
                if (indexes != null) {
                    for (int index : indexes) {
                        row[index] = v2;
                    }
                }
            });
        }
        this.bind(bindValues);
        return this;
    }

    @Override
    public final int size() {
        return this.allBindValues.size();
    }

    @Override
    public final void subscribe(Subscriber<? super Integer> subscriber) {
        ConnectionFactory cf2 = this.configuration.connectionFactory();
        if (cf2 instanceof NoConnectionFactory) {
            throw new UnsupportedOperationException("The blocking, JDBC backed implementation of reactive batching has not yet been implemented. Use the R2DBC backed implementation, instead, or avoid batching.");
        }
        subscriber.onSubscribe(new R2DBC.BatchSubscription<BatchSingle>(this, subscriber, s2 -> new R2DBC.BatchSingleSubscriber(this, (R2DBC.BatchSubscription<BatchSingle>)s2)));
    }

    @Override
    public final int[] execute() {
        if (this.allBindValues.isEmpty()) {
            log.info((Object)"Single batch", "No bind variables have been provided with a single statement batch execution. This may be due to accidental API misuse");
            return BatchMultiple.execute(this.configuration, new Query[]{this.query});
        }
        this.checkBindValues();
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    final void checkBindValues() {
        if (this.expectedBindValues > 0) {
            for (int i2 = 0; i2 < this.allBindValues.size(); ++i2) {
                if (this.allBindValues.get(i2).length == this.expectedBindValues) continue;
                log.info((Object)"Bind value count", "Batch bind value set " + i2 + " has " + this.allBindValues.get(i2).length + " values when " + this.expectedBindValues + " values were expected");
            }
        }
    }

    private final int[] executePrepared() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, new Query[]{this.query});
        ExecuteListener listener = ExecuteListeners.get(ctx);
        Connection connection = AbstractQuery.connection(ctx);
        Param<?>[] params = this.extractParams();
        try {
            listener.start(ctx);
            listener.renderStart(ctx);
            ctx.sql(this.dsl.render(this.query));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            if (ctx.statement() == null) {
                ctx.statement(connection.prepareStatement(ctx.sql()));
            }
            listener.prepareEnd(ctx);
            int t2 = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t2 != 0) {
                ctx.statement().setQueryTimeout(t2);
            }
            for (Object[] bindValues : this.allBindValues) {
                listener.bindStart(ctx);
                Tools.visitAll(new DefaultBindContext(this.configuration, ctx, ctx.statement()), params.length > 0 ? Tools.fields(bindValues, params) : Tools.fields(bindValues));
                listener.bindEnd(ctx);
                ctx.statement().addBatch();
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i2 = 0; i2 < batchRows.length && i2 < result.length; ++i2) {
                batchRows[i2] = result[i2];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            ctx.exception(e3);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e4) {
            ctx.sqlException(e4);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }

    final Param<?>[] extractParams() {
        ParamCollector collector = new ParamCollector(this.configuration, false);
        collector.visit(this.query);
        return Tools.map(collector.resultList, e2 -> (Param)e2.getValue(), Param[]::new);
    }

    private final int[] executeStatic() {
        ArrayList<RowCountQuery> queries = new ArrayList<RowCountQuery>(this.allBindValues.size());
        for (Object[] bindValues : this.allBindValues) {
            for (int i2 = 0; i2 < bindValues.length; ++i2) {
                this.query.bind(i2 + 1, bindValues[i2]);
            }
            queries.add(this.dsl.query(this.query.getSQL(ParamType.INLINED)));
        }
        return this.dsl.batch(queries).execute();
    }
}

