/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterViewFinalStep;
import org.jooq.AlterViewStep;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Function4;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;

final class AlterViewImpl
extends AbstractDDLQuery
implements QOM.AlterView,
AlterViewStep,
AlterViewFinalStep {
    final Table<?> view;
    final boolean ifExists;
    Comment comment;
    Table<?> renameTo;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_VIEW};
    private static final Set<SQLDialect> SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_ALTER_TABLE_RENAME = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.YUGABYTEDB);

    AlterViewImpl(Configuration configuration, Table<?> view, boolean ifExists) {
        this(configuration, view, ifExists, null, null);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, boolean ifExists, Comment comment, Table<?> renameTo) {
        super(configuration);
        this.view = view;
        this.ifExists = ifExists;
        this.comment = comment;
        this.renameTo = renameTo;
    }

    @Override
    public final AlterViewImpl comment(String comment) {
        return this.comment(DSL.comment(comment));
    }

    @Override
    public final AlterViewImpl comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(String renameTo) {
        return this.renameTo((Table)DSL.table(DSL.name(renameTo)));
    }

    @Override
    public final AlterViewImpl renameTo(Name renameTo) {
        return this.renameTo((Table)DSL.table(renameTo));
    }

    @Override
    public final AlterViewImpl renameTo(Table<?> renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_VIEW, c2 -> this.accept0((Context<?>)c2));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        if (this.comment != null) {
            ctx.visit(DSL.commentOnView(this.view).is(this.comment));
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_VIEW_VIEW).visit(Keywords.K_ALTER).sql(' ').visit(SUPPORT_ALTER_TABLE_RENAME.contains((Object)ctx.dialect()) ? Keywords.K_TABLE : Keywords.K_VIEW);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.view).end(Clause.ALTER_VIEW_VIEW).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            ctx.start(Clause.ALTER_VIEW_RENAME).visit(Keywords.K_RENAME_TO).sql(' ').qualify(false, c2 -> c2.visit(this.renameTo)).end(Clause.ALTER_VIEW_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final Table<?> $renameTo() {
        return this.renameTo;
    }

    @Override
    public final QOM.AlterView $view(Table<?> newValue) {
        return this.constructor().apply(newValue, this.$ifExists(), this.$comment(), this.$renameTo());
    }

    @Override
    public final QOM.AlterView $ifExists(boolean newValue) {
        return this.constructor().apply(this.$view(), newValue, this.$comment(), this.$renameTo());
    }

    @Override
    public final QOM.AlterView $comment(Comment newValue) {
        return this.constructor().apply(this.$view(), this.$ifExists(), newValue, this.$renameTo());
    }

    @Override
    public final QOM.AlterView $renameTo(Table<?> newValue) {
        return this.constructor().apply(this.$view(), this.$ifExists(), this.$comment(), newValue);
    }

    public final Function4<? super Table<?>, ? super Boolean, ? super Comment, ? super Table<?>, ? extends QOM.AlterView> constructor() {
        return (a1, a2, a3, a4) -> new AlterViewImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (Comment)a3, (Table<?>)a4);
    }
}

