/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jooq.Record;
import org.jooq.codegen.AbstractGeneratorStrategy;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.Language;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.StringUtils;

class GeneratorStrategyWrapper
extends AbstractGeneratorStrategy {
    private final Map<Class<?>, Map<Integer, Set<String>>> reservedColumns = new HashMap();
    final Generator generator;
    final GeneratorStrategy delegate;

    GeneratorStrategyWrapper(Generator generator, GeneratorStrategy delegate) {
        this.generator = generator;
        this.delegate = delegate;
    }

    @Override
    public String getTargetDirectory() {
        return this.delegate.getTargetDirectory();
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.delegate.setTargetDirectory(directory);
    }

    @Override
    public String getTargetPackage() {
        return this.delegate.getTargetPackage();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.delegate.setTargetPackage(packageName);
    }

    @Override
    public Locale getTargetLocale() {
        return this.delegate.getTargetLocale();
    }

    @Override
    public void setTargetLocale(Locale targetLocale) {
        this.delegate.setTargetLocale(targetLocale);
    }

    @Override
    public Language getTargetLanguage() {
        return this.delegate.getTargetLanguage();
    }

    @Override
    public void setTargetLanguage(Language targetLanguage) {
        this.delegate.setTargetLanguage(targetLanguage);
    }

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.delegate.setInstanceFields(instanceFields);
    }

    @Override
    public boolean getInstanceFields() {
        return this.delegate.getInstanceFields();
    }

    @Override
    public void setJavaBeansGettersAndSetters(boolean javaBeansGettersAndSetters) {
        this.delegate.setJavaBeansGettersAndSetters(javaBeansGettersAndSetters);
    }

    @Override
    public boolean getJavaBeansGettersAndSetters() {
        return this.delegate.getJavaBeansGettersAndSetters();
    }

    @Override
    public String getGlobalReferencesFileHeader(Definition container, Class<? extends Definition> objectType) {
        return this.delegate.getGlobalReferencesFileHeader(container, objectType);
    }

    @Override
    public String getFileHeader(Definition definition, GeneratorStrategy.Mode mode) {
        return this.delegate.getFileHeader(definition, mode);
    }

    @Override
    public String getJavaEnumLiteral(EnumDefinition definition, String literal) {
        Object result = this.delegate.getJavaEnumLiteral(definition, literal);
        if (((String)result).equals(this.getJavaPackageName(definition).replaceAll("\\..*", ""))) {
            result = (String)result + "_";
        }
        return result;
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        CatalogDefinition catalog;
        SchemaDefinition schema;
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaIdentifier(definition), this.getTargetLanguage());
        if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) {
            TypedElementDefinition e2 = (TypedElementDefinition)definition;
            if (identifier.equals(this.getJavaIdentifier((Definition)e2.getContainer()))) {
                return identifier + "_";
            }
            if (identifier.equals(this.getJavaPackageName((Definition)e2.getContainer()).replaceAll("\\..*", ""))) {
                return identifier + "_";
            }
        } else if (definition instanceof TableDefinition ? identifier.equals(this.getJavaIdentifier(schema = definition.getSchema())) : definition instanceof SchemaDefinition && identifier.equals(this.getJavaIdentifier(catalog = definition.getCatalog()))) {
            return identifier + "_";
        }
        identifier = this.overload(definition, GeneratorStrategy.Mode.DEFAULT, identifier);
        return identifier;
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaSetterName(definition, mode));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaGetterName(definition, mode));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaMethodName(definition, mode));
    }

    private String fixMethodName(Definition definition, GeneratorStrategy.Mode mode, String methodName) {
        methodName = this.overload(definition, mode, methodName);
        methodName = GenerationUtil.convertToIdentifier(methodName, this.getTargetLanguage());
        return this.disambiguateMethod(definition, methodName);
    }

    private String overload(Definition definition, GeneratorStrategy.Mode mode, String identifier) {
        if (!StringUtils.isBlank(definition.getOverload())) {
            identifier = (String)identifier + this.getOverloadSuffix(definition, mode, definition.getOverload());
        }
        return identifier;
    }

    private String disambiguateMethod(Definition definition, String method) {
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            reserved = this.reservedColumns(UDTRecordImpl.class, 0);
        } else if (definition instanceof ColumnDefinition) {
            reserved = ((TableDefinition)((ColumnDefinition)definition).getContainer()).getPrimaryKey() != null ? this.reservedColumns(UpdatableRecordImpl.class, 0) : this.reservedColumns(TableRecordImpl.class, 0);
        } else if (definition instanceof ParameterDefinition) {
            reserved = this.reservedColumns(AbstractRoutine.class, 0);
        } else if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() instanceof UDTDefinition && routine.getInParameters().size() > 0 && "SELF".equalsIgnoreCase(routine.getInParameters().get(0).getName())) {
                reserved = this.reservedColumns(UDTRecordImpl.class, routine.getInParameters().size() - 1);
            }
        } else if (definition instanceof ForeignKeyDefinition) {
            reserved = this.reservedColumns(TableImpl.class, 0);
        }
        if (reserved != null) {
            String base;
            if (reserved.contains(method)) {
                return method + "_";
            }
            if (method.startsWith("set") && (reserved.contains("get" + (base = method.substring(3))) || reserved.contains("is" + base))) {
                return method + "_";
            }
        }
        return method;
    }

    private Set<String> reservedColumns(Class<?> clazz, int length) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Map map = this.reservedColumns.computeIfAbsent(clazz, k2 -> new HashMap());
        HashSet<String> result = (HashSet<String>)map.get(length);
        if (result == null) {
            result = new HashSet<String>();
            map.put(length, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass(), length));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2, length));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                if (((Method)genericDeclaration).getParameterTypes().length != length) continue;
                result.add(((Method)genericDeclaration).getName());
            }
            if (this.getTargetLanguage() == Language.SCALA) {
                for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
                    result.add(((Field)annotatedElement).getName());
                }
            }
        }
        return result;
    }

    @Override
    public String getGlobalReferencesJavaClassExtends(Definition container, Class<? extends Definition> objectType) {
        return this.delegate.getGlobalReferencesJavaClassExtends(container, objectType);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        return this.delegate.getJavaClassExtends(definition, mode);
    }

    @Override
    public List<String> getGlobalReferencesJavaClassImplements(Definition container, Class<? extends Definition> objectType) {
        return this.delegate.getGlobalReferencesJavaClassImplements(container, objectType);
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getJavaClassImplements(definition, mode));
        if (mode == GeneratorStrategy.Mode.INTERFACE && this.generator.generateSerializableInterfaces()) {
            result.add(Serializable.class.getName());
        } else if (!(mode != GeneratorStrategy.Mode.POJO || !this.generator.generateSerializablePojos() || this.generator.generateInterfaces() && this.generator.generateSerializableInterfaces())) {
            result.add(Serializable.class.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public String getGlobalReferencesJavaClassName(Definition container, Class<? extends Definition> objectType) {
        Object name = this.delegate.getGlobalReferencesJavaClassName(container, objectType);
        if (((String)name).equals(this.delegate.getJavaClassName(container))) {
            name = (String)name + "_";
        }
        return this.fixJavaClassName((String)name);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String name = this.getFixedJavaClassName(definition);
        if (name != null) {
            return name;
        }
        if (definition instanceof TableDefinition && !this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD) {
            return Record.class.getSimpleName();
        }
        String className = this.delegate.getJavaClassName(definition, mode);
        className = this.overload(definition, mode, className);
        return this.fixJavaClassName(className);
    }

    private String fixJavaClassName(String className) {
        className = GenerationUtil.convertToIdentifier(className, this.getTargetLanguage());
        className = GenerationUtil.escapeWindowsForbiddenNames(className);
        return className;
    }

    @Override
    public String getGlobalReferencesJavaPackageName(Definition container, Class<? extends Definition> objectType) {
        return this.fixJavaPackageName(this.delegate.getGlobalReferencesJavaPackageName(container, objectType));
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        if (!this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD && definition instanceof TableDefinition) {
            return Record.class.getPackage().getName();
        }
        return this.fixJavaPackageName(this.delegate.getJavaPackageName(definition, mode));
    }

    private String fixJavaPackageName(String packageName) {
        Object[] split = packageName.split("\\.");
        for (int i2 = 0; i2 < split.length; ++i2) {
            split[i2] = GenerationUtil.convertToIdentifier((String)split[i2], this.getTargetLanguage());
            split[i2] = GenerationUtil.escapeWindowsForbiddenNames((String)split[i2]);
        }
        return StringUtils.join(split, ".").replaceAll("\\._?\\.", ".");
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        String identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaMemberName(definition, mode), this.getTargetLanguage());
        if (identifier.equals(this.getJavaPackageName(definition, mode).replaceAll("\\..*", ""))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return this.delegate.getOverloadSuffix(definition, mode, overloadIndex);
    }
}

