/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Log;
import org.jooq.SQLDialect;
import org.jooq.codegen.ConstantCatalogVersionProvider;
import org.jooq.codegen.ConstantSchemaVersionProvider;
import org.jooq.codegen.Constants;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorException;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaGenerator;
import org.jooq.codegen.MatcherStrategy;
import org.jooq.codegen.SQLCatalogVersionProvider;
import org.jooq.codegen.SQLSchemaVersionProvider;
import org.jooq.impl.DSL;
import org.jooq.meta.CatalogVersionProvider;
import org.jooq.meta.Databases;
import org.jooq.meta.SchemaVersionProvider;
import org.jooq.meta.jaxb.CatalogMappingType;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.Property;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;

public class GenerationTool {
    public static final String DEFAULT_TARGET_ENCODING = "UTF-8";
    public static final String DEFAULT_TARGET_DIRECTORY = "target/generated-sources/jooq";
    public static final String DEFAULT_TARGET_PACKAGENAME = "org.jooq.generated";
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);
    private static final JooqLogger unusedLogger = JooqLogger.getLogger(Unused.class);
    private ClassLoader loader;
    private DataSource dataSource;
    private Connection connection;
    private DSLContext ctx;
    private Boolean autoCommit;
    private boolean close;

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.ctx = DSL.using(connection);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] files;
        JooqLogger.initSimpleFormatter();
        if (args.length > 0) {
            files = args;
        } else {
            String property = System.getProperty("jooq.codegen.configurationFile");
            if (property != null) {
                files = new String[]{property};
            } else {
                log.error("Usage : GenerationTool <configuration-file>");
                System.exit(-1);
                return;
            }
        }
        for (String file : files) {
            try (InputStream in2 = GenerationTool.class.getResourceAsStream(file);){
                if (in2 == null && !file.startsWith("/")) {
                    in2 = GenerationTool.class.getResourceAsStream("/" + file);
                }
                if (in2 == null && new File(file).exists()) {
                    in2 = new FileInputStream(file);
                }
                if (in2 == null) {
                    log.error("Cannot find " + file + " on classpath, or in directory " + new File(".").getCanonicalPath());
                    log.error("-----------");
                    log.error("Please be sure it is located");
                    log.error("  - on the classpath and qualified as a classpath location.");
                    log.error("  - in the local directory or at a global path in the file system.");
                    System.exit(-1);
                    return;
                }
                Configuration configuration = GenerationTool.load(in2);
                GenerationTool.setGlobalLoggingThreshold(configuration);
                log.info((Object)"Initialising properties", file);
                GenerationTool.generate(configuration);
            }
        }
    }

    @Deprecated
    public static void main(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public static void generate(String xml) throws Exception {
        new GenerationTool().run(GenerationTool.load(new ByteArrayInputStream(xml.getBytes(DEFAULT_TARGET_ENCODING))));
    }

    public static void generate(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public void run(Configuration configuration) throws Exception {
        try {
            this.run0(configuration);
        }
        catch (Exception e2) {
            OnError onError = configuration.getOnError();
            if (onError == null) {
                onError = OnError.FAIL;
            }
            switch (onError) {
                case SILENT: {
                    break;
                }
                case LOG: {
                    log.warn((Object)"Code generation failed", e2);
                    break;
                }
                case FAIL: {
                    throw e2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0(Configuration configuration) throws Exception {
        DSL.selectOne().toString();
        if (configuration.getLogging() != null) {
            GenerationTool.setGlobalLoggingThreshold(configuration);
        } else {
            String property = System.getProperty("jooq.codegen.logging");
            if (property != null) {
                try {
                    Logging.valueOf(property);
                }
                catch (IllegalArgumentException e2) {
                    log.error((Object)"Unsupported property", "Unsupported value for system property jooq.codegen.logging: " + property + ". Supported values include: " + Arrays.asList(Logging.values()));
                }
            }
        }
        if (Boolean.getBoolean("jooq.codegen.skip")) {
            log.info("Skipping jOOQ code generation");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Input configuration", "" + configuration);
        }
        if (configuration.getBasedir() == null) {
            configuration.setBasedir(new File(".").getAbsolutePath());
        }
        Jdbc j2 = configuration.getJdbc();
        org.jooq.meta.jaxb.Generator g2 = configuration.getGenerator();
        if (g2 == null) {
            throw new GeneratorException("The <generator/> tag is mandatory. For details, see http://www.jooq.org/xsd/jooq-codegen-3.16.5.xsd");
        }
        if (g2.getDatabase() == null) {
            g2.setDatabase(new Database());
        }
        Database d2 = g2.getDatabase();
        String databaseName = GenerationTool.trim(d2.getName());
        if (g2.getGenerate() == null) {
            g2.setGenerate(new Generate());
        }
        if (g2.getStrategy() == null) {
            g2.setStrategy(new Strategy());
        }
        if (g2.getTarget() == null) {
            g2.setTarget(new Target());
        }
        Locale locale = Locale.getDefault();
        if (!StringUtils.isBlank(g2.getTarget().getLocale())) {
            locale = Locale.forLanguageTag(g2.getTarget().getLocale());
        }
        org.jooq.meta.Database database = null;
        try {
            GeneratorStrategy strategy;
            if (this.connection == null) {
                this.close = true;
                if (this.dataSource != null) {
                    this.setConnection(this.dataSource.getConnection());
                } else {
                    String url = System.getProperty("jooq.codegen.jdbc.url");
                    if (url != null) {
                        String a2;
                        if ((j2 = StringUtils.defaultIfNull(j2, new Jdbc())).getDriver() == null) {
                            j2.setDriver(System.getProperty("jooq.codegen.jdbc.driver"));
                        }
                        if (j2.getUrl() == null) {
                            j2.setUrl(url);
                        }
                        if (j2.getUser() == null) {
                            j2.setUser(System.getProperty("jooq.codegen.jdbc.user"));
                        }
                        if (j2.getUsername() == null) {
                            j2.setUsername(System.getProperty("jooq.codegen.jdbc.username"));
                        }
                        if (j2.getPassword() == null) {
                            j2.setPassword(System.getProperty("jooq.codegen.jdbc.password"));
                        }
                        if (j2.isAutoCommit() == null && (a2 = System.getProperty("jooq.codegen.jdbc.autoCommit")) != null) {
                            j2.setAutoCommit(Boolean.valueOf(a2));
                        }
                        if (j2.getInitScript() == null) {
                            j2.setInitScript(System.getProperty("jooq.codegen.jdbc.initScript"));
                        }
                        if (j2.getInitSeparator() == null) {
                            j2.setInitSeparator(System.getProperty("jooq.codegen.jdbc.initSeparator"));
                        }
                    }
                    if (j2 != null && !StringUtils.isBlank(j2.getUrl())) {
                        try {
                            Connection c2;
                            Class<?> driver = this.loadClass(this.driverClass(j2));
                            Properties properties = this.properties(j2.getProperties());
                            if (!properties.containsKey("user")) {
                                properties.put("user", StringUtils.defaultString(StringUtils.defaultString(j2.getUser(), j2.getUsername())));
                            }
                            if (!properties.containsKey("password")) {
                                properties.put("password", StringUtils.defaultString(j2.getPassword()));
                            }
                            if ((c2 = ((Driver)driver.newInstance()).connect(StringUtils.defaultString(j2.getUrl()), properties)) == null) {
                                throw new SQLException("Cannot connect to database using JDBC URL: " + j2.getUrl() + ". Please review your JDBC configuration in the code generator configuration.");
                            }
                            this.setConnection(c2);
                            if (j2.getInitScript() != null) {
                                for (String sql : j2.getInitScript().split(StringUtils.defaultIfBlank(j2.getInitSeparator(), ";"))) {
                                    if (StringUtils.isBlank(sql)) continue;
                                    this.ctx.execute(sql);
                                }
                            }
                        }
                        catch (Exception e3) {
                            if (databaseName != null && (databaseName.contains("DDLDatabase") || databaseName.contains("XMLDatabase") || databaseName.contains("JPADatabase"))) {
                                log.warn((Object)"Error while connecting to database. Note that file based database implementations do not need a <jdbc/> configuration in the code generator.", e3);
                            }
                            throw e3;
                        }
                    }
                }
            }
            j2 = StringUtils.defaultIfNull(j2, new Jdbc());
            if (this.connection != null && j2.isAutoCommit() != null) {
                this.autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(j2.isAutoCommit());
            }
            Class<JavaGenerator> generatorClass = !StringUtils.isBlank(g2.getName()) ? this.loadClass(GenerationTool.trim(g2.getName())) : JavaGenerator.class;
            Generator generator = (Generator)generatorClass.newInstance();
            Matchers matchers = g2.getStrategy().getMatchers();
            if (matchers != null) {
                strategy = new MatcherStrategy(matchers);
                if (g2.getStrategy().getName() != null) {
                    if (!DefaultGeneratorStrategy.class.getName().equals(g2.getStrategy().getName())) {
                        log.warn("WARNING: Matchers take precedence over custom strategy. Strategy ignored: " + g2.getStrategy().getName());
                    }
                    g2.getStrategy().setName(null);
                }
            } else {
                Class<DefaultGeneratorStrategy> strategyClass = !StringUtils.isBlank(g2.getStrategy().getName()) ? this.loadClass(GenerationTool.trim(g2.getStrategy().getName())) : DefaultGeneratorStrategy.class;
                strategy = (GeneratorStrategy)strategyClass.newInstance();
            }
            generator.setStrategy(strategy);
            Class<?> databaseClass = !StringUtils.isBlank(databaseName) ? this.loadClass(databaseName) : (this.connection != null ? this.databaseClass(this.connection) : this.databaseClass(j2));
            database = (org.jooq.meta.Database)databaseClass.newInstance();
            database.setBasedir(configuration.getBasedir());
            database.setProperties(this.properties(d2.getProperties()));
            database.setOnError(configuration.getOnError());
            List<CatalogMappingType> catalogs = d2.getCatalogs();
            List<SchemaMappingType> schemata = d2.getSchemata();
            boolean catalogsEmpty = catalogs.isEmpty();
            boolean schemataEmpty = schemata.isEmpty();
            if (catalogsEmpty) {
                if (StringUtils.isBlank(d2.getInputCatalog()) && !StringUtils.isBlank(d2.getOutputCatalog())) {
                    log.warn("WARNING: /configuration/generator/database/outputCatalog must be paired with /configuration/generator/database/inputCatalog");
                }
                CatalogMappingType catalog = new CatalogMappingType();
                catalog.setInputCatalog(GenerationTool.trim(d2.getInputCatalog()));
                catalog.setOutputCatalog(GenerationTool.trim(d2.getOutputCatalog()));
                catalog.setOutputCatalogToDefault(d2.isOutputCatalogToDefault());
                catalogs.add(catalog);
                if (!StringUtils.isBlank(catalog.getInputCatalog())) {
                    catalogsEmpty = false;
                }
                if (schemataEmpty) {
                    if (StringUtils.isBlank(d2.getInputSchema()) && !StringUtils.isBlank(d2.getOutputSchema())) {
                        log.warn("WARNING: /configuration/generator/database/outputSchema must be paired with /configuration/generator/database/inputSchema");
                    }
                    SchemaMappingType schema = new SchemaMappingType();
                    schema.setInputSchema(GenerationTool.trim(d2.getInputSchema()));
                    schema.setOutputSchema(GenerationTool.trim(d2.getOutputSchema()));
                    schema.setOutputSchemaToDefault(d2.isOutputSchemaToDefault());
                    catalog.getSchemata().add(schema);
                    if (!StringUtils.isBlank(schema.getInputSchema())) {
                        schemataEmpty = false;
                    }
                } else {
                    catalog.getSchemata().addAll(schemata);
                    if (!StringUtils.isBlank(d2.getInputSchema())) {
                        log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/schemata");
                    }
                    if (!StringUtils.isBlank(d2.getOutputSchema())) {
                        log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/schemata");
                    }
                }
            } else {
                if (!StringUtils.isBlank(d2.getInputCatalog())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d2.getOutputCatalog())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d2.getInputSchema())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d2.getOutputSchema())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/catalogs");
                }
                if (!schemataEmpty) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/catalogs and /configuration/generator/database/schemata");
                }
            }
            for (CatalogMappingType catalog : catalogs) {
                if ("".equals(catalog.getOutputCatalog())) {
                    log.warn("WARNING: Empty <outputCatalog/> should not be used to model default outputCatalogs. Use <outputCatalogToDefault>true</outputCatalogToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                }
                if (Boolean.TRUE.equals(catalog.isOutputCatalogToDefault())) {
                    catalog.setOutputCatalog("");
                } else if (catalog.getOutputCatalog() == null) {
                    catalog.setOutputCatalog(GenerationTool.trim(catalog.getInputCatalog()));
                }
                for (SchemaMappingType schema : catalog.getSchemata()) {
                    if (catalogsEmpty && schemataEmpty && StringUtils.isBlank(schema.getInputSchema())) {
                        if (!StringUtils.isBlank(j2.getSchema())) {
                            log.warn("WARNING: The configuration property jdbc.Schema is deprecated and will be removed in the future. Use /configuration/generator/database/inputSchema instead");
                        }
                        schema.setInputSchema(GenerationTool.trim(j2.getSchema()));
                    }
                    if ("".equals(schema.getOutputSchema())) {
                        log.warn("WARNING: Empty <outputSchema/> should not be used to model default outputSchemas. Use <outputSchemaToDefault>true</outputSchemaToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                    }
                    if (Boolean.TRUE.equals(schema.isOutputSchemaToDefault())) {
                        schema.setOutputSchema("");
                        continue;
                    }
                    if (schema.getOutputSchema() != null) continue;
                    schema.setOutputSchema(GenerationTool.trim(schema.getInputSchema()));
                }
            }
            if (catalogsEmpty) {
                log.info("No <inputCatalog/> was provided. Generating ALL available catalogs instead.");
            }
            if (catalogsEmpty && schemataEmpty) {
                log.info("No <inputSchema/> was provided. Generating ALL available schemata instead.");
            }
            database.setConnection(this.connection);
            database.setConfiguredCatalogs(catalogs);
            database.setConfiguredSchemata(schemata);
            database.setIncludes(new String[]{StringUtils.defaultString(d2.getIncludes())});
            database.setExcludes(new String[]{StringUtils.defaultString(d2.getExcludes())});
            database.setIncludeExcludeColumns(Boolean.TRUE.equals(d2.isIncludeExcludeColumns()));
            database.setIncludeExcludePackageRoutines(Boolean.TRUE.equals(d2.isIncludeExcludePackageRoutines()));
            database.setIncludeForeignKeys(!Boolean.FALSE.equals(d2.isIncludeForeignKeys()));
            database.setIncludePackages(!Boolean.FALSE.equals(d2.isIncludePackages()));
            database.setIncludePackageRoutines(!Boolean.FALSE.equals(d2.isIncludePackageRoutines()));
            database.setIncludePackageUDTs(!Boolean.FALSE.equals(d2.isIncludePackageUDTs()));
            database.setIncludePackageConstants(!Boolean.FALSE.equals(d2.isIncludePackageConstants()));
            database.setIncludeIndexes(!Boolean.FALSE.equals(d2.isIncludeIndexes()));
            database.setIncludeCheckConstraints(!Boolean.FALSE.equals(d2.isIncludeCheckConstraints()));
            database.setIncludeSystemTables(Boolean.TRUE.equals(d2.isIncludeSystemTables()));
            database.setIncludeSystemIndexes(Boolean.TRUE.equals(d2.isIncludeSystemIndexes()));
            database.setIncludeSystemCheckConstraints(Boolean.TRUE.equals(d2.isIncludeSystemCheckConstraints()));
            database.setIncludeSystemSequences(Boolean.TRUE.equals(d2.isIncludeSystemSequences()));
            database.setIncludeSystemUDTs(Boolean.TRUE.equals(d2.isIncludeSystemUDTs()));
            database.setIncludeInvisibleColumns(!Boolean.FALSE.equals(d2.isIncludeInvisibleColumns()));
            database.setIncludePrimaryKeys(!Boolean.FALSE.equals(d2.isIncludePrimaryKeys()));
            database.setIncludeRoutines(!Boolean.FALSE.equals(d2.isIncludeRoutines()));
            database.setIncludeDomains(!Boolean.FALSE.equals(d2.isIncludeDomains()));
            database.setIncludeSequences(!Boolean.FALSE.equals(d2.isIncludeSequences()));
            database.setIncludeTables(!Boolean.FALSE.equals(d2.isIncludeTables()));
            database.setIncludeEmbeddables(!Boolean.FALSE.equals(d2.isIncludeEmbeddables()));
            database.setIncludeTriggerRoutines(Boolean.TRUE.equals(d2.isIncludeTriggerRoutines()));
            database.setIncludeUDTs(!Boolean.FALSE.equals(d2.isIncludeUDTs()));
            database.setIncludeUniqueKeys(!Boolean.FALSE.equals(d2.isIncludeUniqueKeys()));
            database.setForceIntegerTypesOnZeroScaleDecimals(!Boolean.FALSE.equals(d2.isForceIntegerTypesOnZeroScaleDecimals()));
            database.setRecordVersionFields(new String[]{StringUtils.defaultString(d2.getRecordVersionFields())});
            database.setRecordTimestampFields(new String[]{StringUtils.defaultString(d2.getRecordTimestampFields())});
            database.setSyntheticPrimaryKeys(new String[]{StringUtils.defaultString(d2.getSyntheticPrimaryKeys())});
            database.setOverridePrimaryKeys(new String[]{StringUtils.defaultString(d2.getOverridePrimaryKeys())});
            database.setSyntheticIdentities(new String[]{StringUtils.defaultString(d2.getSyntheticIdentities())});
            database.setConfiguredCustomTypes(d2.getCustomTypes());
            database.setConfiguredEnumTypes(d2.getEnumTypes());
            database.setConfiguredForcedTypes(d2.getForcedTypes());
            database.setConfiguredEmbeddables(d2.getEmbeddables());
            database.setConfiguredComments(d2.getComments());
            database.setConfiguredSyntheticObjects(d2.getSyntheticObjects());
            database.setEmbeddablePrimaryKeys(d2.getEmbeddablePrimaryKeys());
            database.setEmbeddableUniqueKeys(d2.getEmbeddableUniqueKeys());
            database.setEmbeddableDomains(d2.getEmbeddableDomains());
            database.setReadonlyIdentities(Boolean.TRUE.equals(d2.isReadonlyIdentities()));
            database.setReadonlyComputedColumns(!Boolean.FALSE.equals(d2.isReadonlyComputedColumns()));
            database.setReadonlyNonUpdatableColumns(!Boolean.FALSE.equals(d2.isReadonlyNonUpdatableColumns()));
            database.setLogSlowQueriesAfterSeconds(StringUtils.defaultIfNull(d2.getLogSlowQueriesAfterSeconds(), 5));
            database.setLogSlowResultsAfterSeconds(StringUtils.defaultIfNull(d2.getLogSlowResultsAfterSeconds(), 5));
            if (d2.getRegexFlags() != null) {
                database.setRegexFlags(d2.getRegexFlags());
                if (strategy instanceof MatcherStrategy) {
                    ((MatcherStrategy)strategy).getPatterns().setRegexFlags(d2.getRegexFlags());
                }
            }
            database.setRegexMatchesPartialQualification(!Boolean.FALSE.equals(d2.isRegexMatchesPartialQualification()));
            database.setSqlMatchesPartialQualification(!Boolean.FALSE.equals(d2.isSqlMatchesPartialQualification()));
            SchemaVersionProvider svp = null;
            CatalogVersionProvider cvp = null;
            if (!StringUtils.isBlank(d2.getSchemaVersionProvider())) {
                try {
                    svp = (SchemaVersionProvider)Class.forName(d2.getSchemaVersionProvider()).newInstance();
                    log.info("Using custom schema version provider : " + svp);
                }
                catch (Exception ignore) {
                    if (d2.getSchemaVersionProvider().toLowerCase(locale).startsWith("select")) {
                        svp = new SQLSchemaVersionProvider(this.connection, d2.getSchemaVersionProvider());
                        log.info("Using SQL schema version provider : " + d2.getSchemaVersionProvider());
                    }
                    svp = new ConstantSchemaVersionProvider(d2.getSchemaVersionProvider());
                }
            }
            if (!StringUtils.isBlank(d2.getCatalogVersionProvider())) {
                try {
                    cvp = (CatalogVersionProvider)Class.forName(d2.getCatalogVersionProvider()).newInstance();
                    log.info("Using custom catalog version provider : " + cvp);
                }
                catch (Exception ignore) {
                    if (d2.getCatalogVersionProvider().toLowerCase(locale).startsWith("select")) {
                        cvp = new SQLCatalogVersionProvider(this.connection, d2.getCatalogVersionProvider());
                        log.info("Using SQL catalog version provider : " + d2.getCatalogVersionProvider());
                    }
                    cvp = new ConstantCatalogVersionProvider(d2.getCatalogVersionProvider());
                }
            }
            if (svp == null) {
                svp = new ConstantSchemaVersionProvider(null);
            }
            if (cvp == null) {
                cvp = new ConstantCatalogVersionProvider(null);
            }
            database.setSchemaVersionProvider(svp);
            database.setCatalogVersionProvider(cvp);
            if (!StringUtils.isBlank(d2.getOrderProvider())) {
                Class<?> orderProvider = Class.forName(d2.getOrderProvider());
                if (Comparator.class.isAssignableFrom(orderProvider)) {
                    database.setOrderProvider((Comparator)orderProvider.newInstance());
                } else {
                    log.warn("Order provider must be of type java.util.Comparator: " + orderProvider);
                }
            }
            if (d2.getEnumTypes().size() > 0) {
                log.warn((Object)"DEPRECATED", "The configuration property /configuration/generator/database/enumTypes is experimental and deprecated and will be removed in the future.");
            }
            if (Boolean.TRUE.equals(d2.isDateAsTimestamp())) {
                log.warn((Object)"DEPRECATED", "The configuration property /configuration/generator/database/dateAsTimestamp is deprecated as it is superseded by custom bindings and converters. It will thus be removed in the future.");
            }
            if (d2.isDateAsTimestamp() != null) {
                database.setDateAsTimestamp(d2.isDateAsTimestamp());
            }
            if (g2.getGenerate().isJavaTimeTypes() != null) {
                database.setJavaTimeTypes(g2.getGenerate().isJavaTimeTypes());
            }
            if (d2.isUnsignedTypes() != null) {
                database.setSupportsUnsignedTypes(d2.isUnsignedTypes());
            }
            if (d2.isIntegerDisplayWidths() != null) {
                database.setIntegerDisplayWidths(d2.isIntegerDisplayWidths());
            }
            if (d2.isIgnoreProcedureReturnValues() != null) {
                database.setIgnoreProcedureReturnValues(d2.isIgnoreProcedureReturnValues());
            }
            if (Boolean.TRUE.equals(d2.isIgnoreProcedureReturnValues())) {
                log.warn((Object)"DEPRECATED", "The <ignoreProcedureReturnValues/> flag is deprecated and used for backwards-compatibility only. It will be removed in the future.");
            }
            if (StringUtils.isBlank(g2.getTarget().getPackageName())) {
                g2.getTarget().setPackageName(DEFAULT_TARGET_PACKAGENAME);
            }
            if (StringUtils.isBlank(g2.getTarget().getDirectory())) {
                g2.getTarget().setDirectory(DEFAULT_TARGET_DIRECTORY);
            }
            if (StringUtils.isBlank(g2.getTarget().getEncoding())) {
                g2.getTarget().setEncoding(DEFAULT_TARGET_ENCODING);
            }
            if (!new File(g2.getTarget().getDirectory()).isAbsolute()) {
                g2.getTarget().setDirectory(new File(configuration.getBasedir(), g2.getTarget().getDirectory()).getCanonicalPath());
            }
            generator.setTargetPackage(g2.getTarget().getPackageName());
            generator.setTargetDirectory(g2.getTarget().getDirectory());
            generator.setTargetEncoding(g2.getTarget().getEncoding());
            if (g2.getTarget().isClean() != null) {
                generator.setTargetClean(g2.getTarget().isClean());
            }
            generator.setTargetLocale(locale);
            if (g2.getGenerate().isIndexes() != null) {
                generator.setGenerateIndexes(g2.getGenerate().isIndexes());
            }
            if (g2.getGenerate().isRelations() != null) {
                generator.setGenerateRelations(g2.getGenerate().isRelations());
            }
            if (g2.getGenerate().isImplicitJoinPathsToOne() != null) {
                generator.setGenerateImplicitJoinPathsToOne(g2.getGenerate().isImplicitJoinPathsToOne());
            }
            if (g2.getGenerate().isDeprecated() != null) {
                generator.setGenerateDeprecated(g2.getGenerate().isDeprecated());
            }
            if (g2.getGenerate().isDeprecationOnUnknownTypes() != null) {
                generator.setGenerateDeprecationOnUnknownTypes(g2.getGenerate().isDeprecationOnUnknownTypes());
            }
            if (g2.getGenerate().isInstanceFields() != null) {
                generator.setGenerateInstanceFields(g2.getGenerate().isInstanceFields());
            }
            if (g2.getGenerate().getVisibilityModifier() != null) {
                generator.setGenerateVisibilityModifier(g2.getGenerate().getVisibilityModifier());
            }
            if (g2.getGenerate().isGeneratedAnnotation() != null) {
                generator.setGenerateGeneratedAnnotation(g2.getGenerate().isGeneratedAnnotation());
            }
            if (g2.getGenerate().getGeneratedAnnotationType() != null) {
                generator.setGenerateGeneratedAnnotationType(g2.getGenerate().getGeneratedAnnotationType());
            }
            if (g2.getGenerate().isGeneratedAnnotationDate() != null) {
                generator.setGenerateGeneratedAnnotationDate(g2.getGenerate().isGeneratedAnnotationDate());
            }
            if (g2.getGenerate().isNonnullAnnotation() != null) {
                generator.setGenerateNonnullAnnotation(g2.getGenerate().isNonnullAnnotation());
            }
            if (g2.getGenerate().getNonnullAnnotationType() != null) {
                generator.setGeneratedNonnullAnnotationType(g2.getGenerate().getNonnullAnnotationType());
            }
            if (g2.getGenerate().isNullableAnnotation() != null) {
                generator.setGenerateNullableAnnotation(g2.getGenerate().isNullableAnnotation());
            }
            if (g2.getGenerate().getNullableAnnotationType() != null) {
                generator.setGeneratedNullableAnnotationType(g2.getGenerate().getNullableAnnotationType());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotation() != null) {
                generator.setGenerateConstructorPropertiesAnnotation(g2.getGenerate().isConstructorPropertiesAnnotation());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotationOnPojos() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnPojos(g2.getGenerate().isConstructorPropertiesAnnotationOnPojos());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotationOnRecords() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnRecords(g2.getGenerate().isConstructorPropertiesAnnotationOnRecords());
            }
            if (g2.getGenerate().isRoutines() != null) {
                generator.setGenerateRoutines(g2.getGenerate().isRoutines());
            }
            if (g2.getGenerate().isSequences() != null) {
                generator.setGenerateSequences(g2.getGenerate().isSequences());
            }
            if (g2.getGenerate().isSequenceFlags() != null) {
                generator.setGenerateSequenceFlags(g2.getGenerate().isSequenceFlags());
            }
            if (g2.getGenerate().isUdts() != null) {
                generator.setGenerateUDTs(g2.getGenerate().isUdts());
            }
            if (g2.getGenerate().isTables() != null) {
                generator.setGenerateTables(g2.getGenerate().isTables());
            }
            if (g2.getGenerate().isEmbeddables() != null) {
                generator.setGenerateEmbeddables(g2.getGenerate().isEmbeddables());
            }
            if (g2.getGenerate().isRecords() != null) {
                generator.setGenerateRecords(g2.getGenerate().isRecords());
            }
            if (g2.getGenerate().isRecordsImplementingRecordN() != null) {
                generator.setGenerateRecordsImplementingRecordN(g2.getGenerate().isRecordsImplementingRecordN());
            }
            if (g2.getGenerate().isEnumsAsScalaSealedTraits() != null) {
                generator.setGenerateEnumsAsScalaSealedTraits(g2.getGenerate().isEnumsAsScalaSealedTraits());
            }
            if (g2.getGenerate().isPojos() != null) {
                generator.setGeneratePojos(g2.getGenerate().isPojos());
            }
            if (g2.getGenerate().isPojosAsJavaRecordClasses() != null) {
                generator.setGeneratePojosAsJavaRecordClasses(g2.getGenerate().isPojosAsJavaRecordClasses());
            }
            if (g2.getGenerate().isPojosAsScalaCaseClasses() != null) {
                generator.setGeneratePojosAsScalaCaseClasses(g2.getGenerate().isPojosAsScalaCaseClasses());
            }
            if (g2.getGenerate().isPojosAsKotlinDataClasses() != null) {
                generator.setGeneratePojosAsKotlinDataClasses(g2.getGenerate().isPojosAsKotlinDataClasses());
            }
            if (g2.getGenerate().isImmutablePojos() != null) {
                generator.setGenerateImmutablePojos(g2.getGenerate().isImmutablePojos());
            }
            if (g2.getGenerate().isSerializablePojos() != null) {
                generator.setGenerateSerializablePojos(g2.getGenerate().isSerializablePojos());
            }
            if (g2.getGenerate().isInterfaces() != null) {
                generator.setGenerateInterfaces(g2.getGenerate().isInterfaces());
            }
            if (g2.getGenerate().isImmutableInterfaces() != null) {
                generator.setGenerateImmutableInterfaces(g2.getGenerate().isImmutableInterfaces());
            }
            if (g2.getGenerate().isSerializableInterfaces() != null) {
                generator.setGenerateSerializableInterfaces(g2.getGenerate().isSerializableInterfaces());
            }
            if (g2.getGenerate().isDaos() != null) {
                generator.setGenerateDaos(g2.getGenerate().isDaos());
            }
            if (g2.getGenerate().isJooqVersionReference() != null) {
                generator.setGenerateJooqVersionReference(g2.getGenerate().isJooqVersionReference());
            }
            if (g2.getGenerate().isJpaAnnotations() != null) {
                generator.setGenerateJPAAnnotations(g2.getGenerate().isJpaAnnotations());
            }
            if (g2.getGenerate().getJpaVersion() != null) {
                generator.setGenerateJPAVersion(g2.getGenerate().getJpaVersion());
            }
            if (g2.getGenerate().isValidationAnnotations() != null) {
                generator.setGenerateValidationAnnotations(g2.getGenerate().isValidationAnnotations());
            }
            if (g2.getGenerate().isSpringAnnotations() != null) {
                generator.setGenerateSpringAnnotations(g2.getGenerate().isSpringAnnotations());
            }
            if (g2.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix() != null) {
                generator.setGenerateKotlinSetterJvmNameAnnotationsOnIsPrefix(g2.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix());
            }
            if (g2.getGenerate().getGeneratedSerialVersionUID() != null) {
                generator.setGenerateGeneratedSerialVersionUID(g2.getGenerate().getGeneratedSerialVersionUID());
            }
            if (g2.getGenerate().getMaxMembersPerInitialiser() != null) {
                generator.setMaxMembersPerInitialiser(g2.getGenerate().getMaxMembersPerInitialiser());
            }
            if (g2.getGenerate().isQueues() != null) {
                generator.setGenerateQueues(g2.getGenerate().isQueues());
            }
            if (g2.getGenerate().isLinks() != null) {
                generator.setGenerateLinks(g2.getGenerate().isLinks());
            }
            if (g2.getGenerate().isKeys() != null) {
                generator.setGenerateKeys(g2.getGenerate().isKeys());
            }
            if (g2.getGenerate().isGlobalObjectReferences() != null) {
                generator.setGenerateGlobalObjectReferences(g2.getGenerate().isGlobalObjectReferences());
            }
            if (g2.getGenerate().isGlobalCatalogReferences() != null) {
                generator.setGenerateGlobalCatalogReferences(g2.getGenerate().isGlobalCatalogReferences());
            }
            if (g2.getGenerate().isGlobalDomainReferences() != null) {
                generator.setGenerateGlobalDomainReferences(g2.getGenerate().isGlobalDomainReferences());
            }
            if (g2.getGenerate().isGlobalSchemaReferences() != null) {
                generator.setGenerateGlobalSchemaReferences(g2.getGenerate().isGlobalSchemaReferences());
            }
            if (g2.getGenerate().isGlobalRoutineReferences() != null) {
                generator.setGenerateGlobalRoutineReferences(g2.getGenerate().isGlobalRoutineReferences());
            }
            if (g2.getGenerate().isGlobalSequenceReferences() != null) {
                generator.setGenerateGlobalSequenceReferences(g2.getGenerate().isGlobalSequenceReferences());
            }
            if (g2.getGenerate().isGlobalTableReferences() != null) {
                generator.setGenerateGlobalTableReferences(g2.getGenerate().isGlobalTableReferences());
            }
            if (g2.getGenerate().isGlobalUDTReferences() != null) {
                generator.setGenerateGlobalUDTReferences(g2.getGenerate().isGlobalUDTReferences());
            }
            if (g2.getGenerate().isGlobalQueueReferences() != null) {
                generator.setGenerateGlobalQueueReferences(g2.getGenerate().isGlobalQueueReferences());
            }
            if (g2.getGenerate().isGlobalLinkReferences() != null) {
                generator.setGenerateGlobalLinkReferences(g2.getGenerate().isGlobalLinkReferences());
            }
            if (g2.getGenerate().isGlobalKeyReferences() != null) {
                generator.setGenerateGlobalKeyReferences(g2.getGenerate().isGlobalKeyReferences());
            }
            if (g2.getGenerate().isGlobalIndexReferences() != null) {
                generator.setGenerateGlobalIndexReferences(g2.getGenerate().isGlobalIndexReferences());
            }
            if (g2.getGenerate().isJavadoc() != null) {
                generator.setGenerateJavadoc(g2.getGenerate().isJavadoc());
            }
            if (g2.getGenerate().isComments() != null) {
                generator.setGenerateComments(g2.getGenerate().isComments());
            }
            if (g2.getGenerate().isCommentsOnAttributes() != null) {
                generator.setGenerateCommentsOnAttributes(g2.getGenerate().isCommentsOnAttributes());
            }
            if (g2.getGenerate().isCommentsOnCatalogs() != null) {
                generator.setGenerateCommentsOnCatalogs(g2.getGenerate().isCommentsOnCatalogs());
            }
            if (g2.getGenerate().isCommentsOnColumns() != null) {
                generator.setGenerateCommentsOnColumns(g2.getGenerate().isCommentsOnColumns());
            }
            if (g2.getGenerate().isCommentsOnKeys() != null) {
                generator.setGenerateCommentsOnKeys(g2.getGenerate().isCommentsOnKeys());
            }
            if (g2.getGenerate().isCommentsOnLinks() != null) {
                generator.setGenerateCommentsOnLinks(g2.getGenerate().isCommentsOnLinks());
            }
            if (g2.getGenerate().isCommentsOnPackages() != null) {
                generator.setGenerateCommentsOnPackages(g2.getGenerate().isCommentsOnPackages());
            }
            if (g2.getGenerate().isCommentsOnParameters() != null) {
                generator.setGenerateCommentsOnParameters(g2.getGenerate().isCommentsOnParameters());
            }
            if (g2.getGenerate().isCommentsOnQueues() != null) {
                generator.setGenerateCommentsOnQueues(g2.getGenerate().isCommentsOnQueues());
            }
            if (g2.getGenerate().isCommentsOnRoutines() != null) {
                generator.setGenerateCommentsOnRoutines(g2.getGenerate().isCommentsOnRoutines());
            }
            if (g2.getGenerate().isCommentsOnSchemas() != null) {
                generator.setGenerateCommentsOnSchemas(g2.getGenerate().isCommentsOnSchemas());
            }
            if (g2.getGenerate().isCommentsOnSequences() != null) {
                generator.setGenerateCommentsOnSequences(g2.getGenerate().isCommentsOnSequences());
            }
            if (g2.getGenerate().isCommentsOnTables() != null) {
                generator.setGenerateCommentsOnTables(g2.getGenerate().isCommentsOnTables());
            }
            if (g2.getGenerate().isCommentsOnEmbeddables() != null) {
                generator.setGenerateCommentsOnEmbeddables(g2.getGenerate().isCommentsOnEmbeddables());
            }
            if (g2.getGenerate().isCommentsOnUDTs() != null) {
                generator.setGenerateCommentsOnUDTs(g2.getGenerate().isCommentsOnUDTs());
            }
            if (g2.getGenerate().isSources() != null) {
                generator.setGenerateSources(g2.getGenerate().isSources());
            }
            if (g2.getGenerate().isSourcesOnViews() != null) {
                generator.setGenerateSourcesOnViews(g2.getGenerate().isSourcesOnViews());
            }
            if (g2.getGenerate().isFluentSetters() != null) {
                generator.setGenerateFluentSetters(g2.getGenerate().isFluentSetters());
            }
            if (g2.getGenerate().isJavaBeansGettersAndSetters() != null) {
                generator.setGenerateJavaBeansGettersAndSetters(g2.getGenerate().isJavaBeansGettersAndSetters());
            }
            if (g2.getGenerate().isVarargSetters() != null) {
                generator.setGenerateVarargsSetters(g2.getGenerate().isVarargSetters());
            }
            if (g2.getGenerate().isPojosEqualsAndHashCode() != null) {
                generator.setGeneratePojosEqualsAndHashCode(g2.getGenerate().isPojosEqualsAndHashCode());
            }
            if (g2.getGenerate().isPojosToString() != null) {
                generator.setGeneratePojosToString(g2.getGenerate().isPojosToString());
            }
            if (g2.getGenerate().getFullyQualifiedTypes() != null) {
                generator.setGenerateFullyQualifiedTypes(g2.getGenerate().getFullyQualifiedTypes());
            }
            if (g2.getGenerate().isJavaTimeTypes() != null) {
                generator.setGenerateJavaTimeTypes(g2.getGenerate().isJavaTimeTypes());
            }
            if (g2.getGenerate().isSpatialTypes() != null) {
                generator.setGenerateSpatialTypes(g2.getGenerate().isSpatialTypes());
            }
            if (g2.getGenerate().isXmlTypes() != null) {
                generator.setGenerateXmlTypes(g2.getGenerate().isXmlTypes());
            }
            if (g2.getGenerate().isJsonTypes() != null) {
                generator.setGenerateJsonTypes(g2.getGenerate().isJsonTypes());
            }
            if (g2.getGenerate().isIntervalTypes() != null) {
                generator.setGenerateIntervalTypes(g2.getGenerate().isIntervalTypes());
            }
            if (g2.getGenerate().isEmptyCatalogs() != null) {
                generator.setGenerateEmptyCatalogs(g2.getGenerate().isEmptyCatalogs());
            }
            if (g2.getGenerate().isEmptySchemas() != null) {
                generator.setGenerateEmptySchemas(g2.getGenerate().isEmptySchemas());
            }
            if (g2.getGenerate().getNewline() != null) {
                generator.setGenerateNewline(g2.getGenerate().getNewline());
            }
            if (g2.getGenerate().getIndentation() != null) {
                generator.setGenerateIndentation(g2.getGenerate().getIndentation());
            }
            if (g2.getGenerate().getPrintMarginForBlockComment() != null) {
                generator.setGeneratePrintMarginForBlockComment(g2.getGenerate().getPrintMarginForBlockComment());
            }
            if (!StringUtils.isBlank(d2.getSchemaVersionProvider())) {
                generator.setUseSchemaVersionProvider(true);
            }
            if (!StringUtils.isBlank(d2.getCatalogVersionProvider())) {
                generator.setUseCatalogVersionProvider(true);
            }
            if (d2.isTableValuedFunctions() != null) {
                generator.setGenerateTableValuedFunctions(d2.isTableValuedFunctions());
            } else {
                generator.setGenerateTableValuedFunctions(true);
            }
            strategy.setInstanceFields(generator.generateInstanceFields());
            strategy.setJavaBeansGettersAndSetters(generator.generateJavaBeansGettersAndSetters());
            this.verifyVersions();
            generator.generate(database);
            this.logUnused("forced type", "forced types", database.getUnusedForcedTypes());
            this.logUnused("embeddable", "embeddables", database.getUnusedEmbeddables());
            this.logUnused("comment", "comments", database.getUnusedComments());
            this.logUnused("synthetic readonly column", "synthetic readonly columns", database.getUnusedSyntheticReadonlyColumns());
            this.logUnused("synthetic readonly rowid", "synthetic readonly rowids", database.getUnusedSyntheticReadonlyRowids());
            this.logUnused("synthetic identity", "synthetic identities", database.getUnusedSyntheticIdentities());
            this.logUnused("synthetic primary key", "synthetic primary keys", database.getUnusedSyntheticPrimaryKeys());
            this.logUnused("synthetic unique key", "synthetic unique keys", database.getUnusedSyntheticUniqueKeys());
            this.logUnused("synthetic foreign key", "synthetic foreign keys", database.getUnusedSyntheticForeignKeys());
            this.logUnused("synthetic view", "synthetic views", database.getUnusedSyntheticViews());
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (Exception e4) {
                    log.error((Object)"Error while closing database", e4);
                }
            }
            if (this.connection != null) {
                if (this.close) {
                    if (this.ctx != null && this.ctx.family() == SQLDialect.HSQLDB && this.dataSource == null) {
                        this.ctx.execute("shutdown");
                    }
                    this.connection.close();
                } else if (this.autoCommit != null) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
            }
        }
    }

    private void verifyVersions() {
        try {
            Field[] f1 = org.jooq.Constants.class.getFields();
            Field[] f2 = org.jooq.meta.Constants.class.getFields();
            Field[] f3 = Constants.class.getFields();
            Arrays.sort(f1, Comparator.comparing(Field::getName));
            Arrays.sort(f2, Comparator.comparing(Field::getName));
            Arrays.sort(f3, Comparator.comparing(Field::getName));
            if (f1.length != f2.length) {
                log.warn((Object)"Version check", "org.jooq.Constants and org.jooq.meta.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            if (f1.length != f3.length) {
                log.warn((Object)"Version check", "org.jooq.Constants and org.jooq.codegen.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            String v1 = "3.16.21";
            String v2 = "3.16.21";
            String v3 = "3.16.21";
            for (int i2 = 0; i2 < f1.length && i2 < f2.length && i2 < f3.length; ++i2) {
                Object c1 = f1[i2].get(org.jooq.Constants.class);
                Object c2 = f2[i2].get(org.jooq.meta.Constants.class);
                Object c3 = f3[i2].get(Constants.class);
                if (!Objects.equals(c1, c2)) {
                    log.warn((Object)"Version check", "org.jooq.Constants." + f1[i2].getName() + " contents mismatch: " + c1 + " vs " + c2 + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.meta (" + v2 + ")");
                }
                if (Objects.equals(c1, c3)) continue;
                log.warn((Object)"Version check", "org.jooq.Constants." + f1[i2].getName() + " contents mismatch: " + c1 + " vs " + c3 + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.codegen (" + v3 + ")");
            }
        }
        catch (Throwable e2) {
            log.warn("Version check", "Something went wrong when comparing versions of org.jooq, org.jooq.meta, and org.jooq.codegen", e2);
        }
    }

    private void logUnused(String objectType, String objectTypes, List<?> list) {
        if (!list.isEmpty() && Boolean.parseBoolean(System.getProperty("jooq.codegen.logunused", "true"))) {
            unusedLogger.warn((Object)("Unused " + objectTypes), "There are unused " + objectTypes + ", which have not been used by this generation run.\nThis can be because of misconfigurations, such as, for example:\n- case sensitive regular expressions\n- regular expressions depending on whitespace (Pattern.COMMENTS is turned on!)\n- missing or inadequate object qualification\n- the object to which the configuration was applied in the past has been dropped\nTry turning on DEBUG logging (-X in Maven, and <logging/> in jOOQ) to get additional info about the schema");
            for (Object o2 : list) {
                unusedLogger.warn((Object)("Unused " + objectType), o2);
            }
        }
    }

    private static void setGlobalLoggingThreshold(Configuration configuration) {
        if (configuration.getLogging() != null) {
            switch (configuration.getLogging()) {
                case TRACE: {
                    JooqLogger.globalThreshold(Log.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    JooqLogger.globalThreshold(Log.Level.DEBUG);
                    break;
                }
                case INFO: {
                    JooqLogger.globalThreshold(Log.Level.INFO);
                    break;
                }
                case WARN: {
                    JooqLogger.globalThreshold(Log.Level.WARN);
                    break;
                }
                case ERROR: {
                    JooqLogger.globalThreshold(Log.Level.ERROR);
                    break;
                }
                case FATAL: {
                    JooqLogger.globalThreshold(Log.Level.FATAL);
                }
            }
        }
    }

    private Properties properties(List<Property> properties) {
        Properties result = new Properties();
        for (Property p2 : properties) {
            result.put(p2.getKey(), p2.getValue());
        }
        return result;
    }

    private String driverClass(Jdbc j2) {
        String result = j2.getDriver();
        if (result == null) {
            result = JDBCUtils.driver(j2.getUrl());
            log.info((Object)"Database", "Inferring driver " + result + " from URL " + j2.getUrl());
        }
        return result;
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Jdbc j2) {
        return this.databaseClass(j2.getUrl());
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Connection c2) {
        try {
            return this.databaseClass(c2.getMetaData().getURL());
        }
        catch (SQLException e2) {
            throw new GeneratorException("Error when reading URL from JDBC connection", e2);
        }
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(String url) {
        if (StringUtils.isBlank(url)) {
            throw new GeneratorException("No JDBC URL configured.");
        }
        Class<? extends org.jooq.meta.Database> result = Databases.databaseClass(JDBCUtils.dialect(url));
        log.info((Object)"Database", "Inferring database " + result.getName() + " from URL " + url);
        return result;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.loader == null) {
                return this.loadClass0(className);
            }
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e2) {
            String message = null;
            if (className.startsWith("org.jooq.util.")) {
                String alternative = null;
                for (String pkg : new String[]{"org.jooq.meta", "org.jooq.meta.extensions", "org.jooq.codegen", "org.jooq.codegen.maven"}) {
                    try {
                        alternative = this.loadClass0(className.replace("org.jooq.util", pkg)).getName();
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                message = "Your configured " + className + " type was not found.\n" + (String)(alternative != null ? "Did you mean " + alternative + "?\n" : "") + "Do note that in jOOQ 3.11, jOOQ-meta and jOOQ-codegen packages have been renamed. New package names are:\n- org.jooq.meta\n- org.jooq.meta.extensions\n- org.jooq.codegen\n- org.jooq.codegen.maven\nSee https://github.com/jOOQ/jOOQ/issues/7419 for details";
                log.warn((Object)"Type not found", message);
            } else if (className.equals("org.jooq.meta.extensions.liquibase.LiquibaseDatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-liquibase dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", message);
            } else if (className.equals("org.jooq.meta.extensions.jpa.JPADatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-hibernate dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", message);
            } else if (className.startsWith("org.jooq.meta.") && className.endsWith("Database")) {
                message = "Your configured database type was not found: " + className + ". This can have several reasons:\n- You want to use a commercial jOOQ Edition, but you pulled the Open Source Edition from Maven Central.\n- You have mis-typed your class name.";
                log.warn((Object)"Type not found", message);
            }
            if (message == null) {
                throw e2;
            }
            throw new ClassNotFoundException(message, e2);
        }
    }

    private Class<?> loadClass0(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n2 = 0;
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            count += (long)n2;
        }
        return count;
    }

    public static Configuration load(InputStream in2) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenerationTool.copyLarge(in2, out);
        String xml = out.toString();
        xml = xml.replaceAll("<(\\w+:)?configuration xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-codegen-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1configuration xmlns$2=\"http://www.jooq.org/xsd/jooq-codegen-3.16.5.xsd\">");
        return MiniJAXB.unmarshal(xml, Configuration.class);
    }

    private static class Unused {
        private Unused() {
        }
    }
}

