/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.curve;

import org.geolatte.geom.Envelope;
import org.geolatte.geom.Point;
import org.geolatte.geom.crs.CrsId;

public class MortonContext {
    private static final String ERR_MSG_MAX_DEPTH = "Max. depth is limited to 31";
    private static final String ERR_MSG_NULL = "No Null arguments allowed.";
    private final int depth;
    private final Envelope extent;
    private final int numOfDivisionsAlongAxis;
    private final double leafWidth;
    private final double leafHeight;

    public MortonContext(Envelope extent, int depth) {
        if (extent == null) {
            throw new IllegalArgumentException(ERR_MSG_NULL);
        }
        if (depth >= 32) {
            throw new IllegalArgumentException(ERR_MSG_MAX_DEPTH);
        }
        this.depth = depth;
        this.extent = extent;
        this.numOfDivisionsAlongAxis = (int)Math.pow(2.0, depth);
        this.leafWidth = (extent.getMaxX() - extent.getMinX()) / (double)this.numOfDivisionsAlongAxis;
        this.leafHeight = (extent.getMaxY() - extent.getMinY()) / (double)this.numOfDivisionsAlongAxis;
    }

    public double getMaxX() {
        return this.extent.getMaxX();
    }

    public double getMaxY() {
        return this.extent.getMaxY();
    }

    public double getMinX() {
        return this.extent.getMinX();
    }

    public double getMinY() {
        return this.extent.getMinY();
    }

    public int getDepth() {
        return this.depth;
    }

    public CrsId getCrsId() {
        return this.extent.getCrsId();
    }

    int getNumberOfDivisionsAlongAxis() {
        return this.numOfDivisionsAlongAxis;
    }

    double getLeafWidth() {
        return this.leafWidth;
    }

    double getLeafHeight() {
        return this.leafHeight;
    }

    public boolean extentContains(Point pnt) {
        return this.extent.contains(pnt);
    }

    public boolean extentContains(Envelope envelope) {
        return this.extent.contains(envelope);
    }

    public Envelope getExtent() {
        return this.extent;
    }
}

