/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsIdentifiable;

public class Unit
extends CrsIdentifiable {
    public static final Unit DEGREE = new Unit(new CrsId("EPSG", 9122), "degree", Type.ANGULAR, 0.01745329251994328);
    public static final Unit RADIAN = new Unit(new CrsId("EPSG", 9101), "radian", Type.ANGULAR, 1.0);
    public static final Unit METER = new Unit(new CrsId("EPSG", 9001), "metre", Type.LINEAR, 1.0);
    public static final Unit UNKNOWN = new Unit(CrsId.UNDEFINED, "unknown", Type.LINEAR, 1.0);
    private final Type type;
    private final double conversionFactor;

    public Unit(CrsId crsId, String name, Type type, double conversionFactor) {
        super(crsId, name);
        this.type = type;
        this.conversionFactor = conversionFactor;
    }

    public static Unit getFundamentalUnit(Type type) {
        if (type == Type.ANGULAR) {
            return RADIAN;
        }
        return METER;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public boolean isAngular() {
        return this.type == Type.ANGULAR;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Unit unit = (Unit)o2;
        if (Double.compare(unit.conversionFactor, this.conversionFactor) != 0) {
            return false;
        }
        return this.type == unit.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        long temp = this.conversionFactor != 0.0 ? Double.doubleToLongBits(this.conversionFactor) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Unit{SRID=" + this.getCrsId().toString() + "type=" + (Object)((Object)this.type) + ", conversionFactor=" + this.conversionFactor + '}';
    }

    public static enum Type {
        LINEAR,
        ANGULAR;

    }
}

