/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktNumberToken;
import org.geolatte.geom.codec.WktTextToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;

abstract class AbstractWktTokenizer {
    protected final CharSequence wkt;
    protected final WktVariant variant;
    protected int currentPos = 0;

    AbstractWktTokenizer(CharSequence wkt, WktVariant variant) {
        this.wkt = wkt;
        this.variant = variant;
    }

    boolean moreTokens() {
        this.skipWhitespace();
        return this.currentPos < this.wkt.length();
    }

    WktToken nextToken() {
        if (!this.moreTokens()) {
            return this.variant.end();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getOpenListChar()) {
            ++this.currentPos;
            return this.variant.getOpenList();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getCloseListChar()) {
            ++this.currentPos;
            return this.variant.getCloseList();
        }
        if (this.wkt.charAt(this.currentPos) == '\"') {
            return this.readText();
        }
        if (Character.isLetter(this.wkt.charAt(this.currentPos))) {
            return this.readToken();
        }
        if (Character.isDigit(this.wkt.charAt(this.currentPos)) || this.wkt.charAt(this.currentPos) == '.' || this.wkt.charAt(this.currentPos) == '-') {
            return this.numericToken();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getElemSepChar()) {
            ++this.currentPos;
            return this.variant.getElementSeparator();
        }
        throw new WktDecodeException(String.format("Illegal Character at pos %d in Wkt text: %s", this.currentPos, this.wkt));
    }

    abstract WktToken numericToken();

    protected double readNumber() {
        this.skipWhitespace();
        StringBuilder stb = new StringBuilder();
        char c2 = this.wkt.charAt(this.currentPos);
        if (c2 == '-') {
            stb.append(c2);
            c2 = this.wkt.charAt(++this.currentPos);
        }
        if ((c2 = this.readDigits(stb, c2)) == '.') {
            stb.append(c2);
            c2 = this.wkt.charAt(++this.currentPos);
            this.readDigits(stb, c2);
        }
        return Double.parseDouble(stb.toString());
    }

    private char readDigits(StringBuilder stb, char c2) {
        while (Character.isDigit(c2)) {
            stb.append(c2);
            c2 = this.wkt.charAt(++this.currentPos);
        }
        return c2;
    }

    protected WktToken readNumberToken() {
        double d2 = this.readNumber();
        return new WktNumberToken(d2);
    }

    protected WktToken readText() {
        StringBuilder builder = new StringBuilder();
        char c2 = this.wkt.charAt(++this.currentPos);
        while (c2 != '\"') {
            builder.append(c2);
            c2 = this.wkt.charAt(++this.currentPos);
        }
        ++this.currentPos;
        return new WktTextToken(builder.toString());
    }

    protected void skipWhitespace() {
        while (this.currentPos < this.wkt.length() && Character.isWhitespace(this.wkt.charAt(this.currentPos))) {
            ++this.currentPos;
        }
    }

    private WktToken readToken() {
        int endPos;
        for (endPos = this.currentPos; endPos < this.wkt.length() && this.isWordChar(this.wkt.charAt(endPos)); ++endPos) {
        }
        WktToken nextToken = this.matchKeyword(this.currentPos, endPos);
        this.currentPos = endPos;
        return nextToken;
    }

    protected boolean isWordChar(char c2) {
        return Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_';
    }

    protected WktToken matchKeyword(int currentPos, int endPos) {
        return this.variant.matchKeyword(this.wkt, currentPos, endPos);
    }

    public int position() {
        return this.currentPos;
    }
}

