/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.BufferAccessException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.WkbDecodeException;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbGeometryType;
import org.geolatte.geom.crs.CrsId;

abstract class AbstractWkbDecoder
implements WkbDecoder {
    private CrsId crsId;

    AbstractWkbDecoder() {
    }

    @Override
    public Geometry decode(ByteBuffer byteBuffer) {
        this.crsId = CrsId.UNDEFINED;
        byteBuffer.rewind();
        try {
            this.prepare(byteBuffer);
            Geometry geom = this.decodeGeometry(byteBuffer);
            byteBuffer.rewind();
            return geom;
        }
        catch (BufferAccessException e2) {
            throw new WkbDecodeException(e2);
        }
    }

    private Geometry decodeGeometry(ByteBuffer byteBuffer) {
        this.alignByteOrder(byteBuffer);
        int typeCode = this.readTypeCode(byteBuffer);
        WkbGeometryType wkbType = WkbGeometryType.parse((byte)typeCode);
        this.readSridIfPresent(byteBuffer, typeCode);
        DimensionalFlag flag = this.determineDimensionalFlag(typeCode);
        switch (wkbType) {
            case POINT: {
                return this.decodePoint(byteBuffer, flag);
            }
            case LINE_STRING: {
                return this.decodeLineString(byteBuffer, flag);
            }
            case POLYGON: {
                return this.decodePolygon(byteBuffer, flag);
            }
            case GEOMETRY_COLLECTION: {
                return this.decodeGeometryCollection(byteBuffer);
            }
            case MULTI_POINT: {
                return this.decodeMultiPoint(byteBuffer);
            }
            case MULTI_POLYGON: {
                return this.decodeMultiPolygon(byteBuffer);
            }
            case MULTI_LINE_STRING: {
                return this.decodeMultiLineString(byteBuffer);
            }
        }
        throw new WkbDecodeException(String.format("WKBType %s is not supported.", new Object[]{wkbType}));
    }

    private MultiLineString decodeMultiLineString(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        LineString[] geometries = new LineString[numGeometries];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = (LineString)this.decodeGeometry(byteBuffer);
        }
        return new MultiLineString(geometries);
    }

    private MultiPoint decodeMultiPoint(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Point[] geometries = new Point[numGeometries];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = (Point)this.decodeGeometry(byteBuffer);
        }
        return new MultiPoint(geometries);
    }

    private MultiPolygon decodeMultiPolygon(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Polygon[] geometries = new Polygon[numGeometries];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = (Polygon)this.decodeGeometry(byteBuffer);
        }
        return new MultiPolygon(geometries);
    }

    private GeometryCollection decodeGeometryCollection(ByteBuffer byteBuffer) {
        int numGeometries = byteBuffer.getInt();
        Geometry[] geometries = new Geometry[numGeometries];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = this.decodeGeometry(byteBuffer);
        }
        return new GeometryCollection(geometries);
    }

    private Polygon decodePolygon(ByteBuffer byteBuffer, DimensionalFlag flag) {
        int numRings = byteBuffer.getInt();
        LinearRing[] rings = this.readPolygonRings(numRings, byteBuffer, flag, this.crsId);
        return new Polygon(rings);
    }

    private LineString decodeLineString(ByteBuffer byteBuffer, DimensionalFlag flag) {
        int numPoints = byteBuffer.getInt();
        PointSequence points = this.readPoints(numPoints, byteBuffer, flag);
        return new LineString(points);
    }

    private Point decodePoint(ByteBuffer byteBuffer, DimensionalFlag flag) {
        PointSequence points = this.readPoints(1, byteBuffer, flag);
        return new Point(points);
    }

    private PointSequence readPoints(int numPoints, ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag) {
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(numPoints, dimensionalFlag, this.crsId);
        double[] coordinates = new double[dimensionalFlag.getCoordinateDimension()];
        for (int i2 = 0; i2 < numPoints; ++i2) {
            this.readPoint(byteBuffer, dimensionalFlag, coordinates);
            psBuilder.add(coordinates);
        }
        return psBuilder.toPointSequence();
    }

    private void readPoint(ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, double[] coordinates) {
        for (int ci2 = 0; ci2 < dimensionalFlag.getCoordinateDimension(); ++ci2) {
            coordinates[ci2] = byteBuffer.getDouble();
        }
    }

    private LinearRing[] readPolygonRings(int numRings, ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, CrsId crsId) {
        LinearRing[] rings = new LinearRing[numRings];
        for (int i2 = 0; i2 < numRings; ++i2) {
            rings[i2] = this.readRing(byteBuffer, dimensionalFlag, crsId);
        }
        return rings;
    }

    private LinearRing readRing(ByteBuffer byteBuffer, DimensionalFlag dimensionalFlag, CrsId crsId) {
        int numPoints = byteBuffer.getInt();
        PointSequence ps2 = this.readPoints(numPoints, byteBuffer, dimensionalFlag);
        try {
            return new LinearRing(ps2);
        }
        catch (IllegalArgumentException e2) {
            throw new WkbDecodeException(e2);
        }
    }

    protected abstract void prepare(ByteBuffer var1);

    protected abstract DimensionalFlag determineDimensionalFlag(int var1);

    protected abstract void readSridIfPresent(ByteBuffer var1, int var2);

    protected abstract boolean hasSrid(int var1);

    protected int readTypeCode(ByteBuffer byteBuffer) {
        return (int)byteBuffer.getUInt();
    }

    protected CrsId getCrsId() {
        return this.crsId;
    }

    protected void setCrsId(CrsId crsId) {
        this.crsId = crsId;
    }

    private void alignByteOrder(ByteBuffer byteBuffer) {
        byte orderByte = byteBuffer.get();
        ByteOrder byteOrder = ByteOrder.valueOf(orderByte);
        byteBuffer.setByteOrder(byteOrder);
    }
}

