/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.builder;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.builder.internal.GeometryBuilder2D;
import org.geolatte.geom.builder.internal.GeometryBuilder2DM;
import org.geolatte.geom.builder.internal.GeometryBuilder3D;
import org.geolatte.geom.builder.internal.GeometryBuilder3DM;
import org.geolatte.geom.builder.internal.SimpleGeometryBuilder;
import org.geolatte.geom.crs.CrsId;

public class LinearRings {
    public static GeometryBuilder2D<LinearRing> create2D(CrsId crsId) {
        return new LinearRingBuilder2D(crsId);
    }

    public static GeometryBuilder2DM<LinearRing> create2DM(CrsId crsId) {
        return new LinearRingBuilder2DM(crsId);
    }

    public static GeometryBuilder3D<LinearRing> create3D(CrsId crsId) {
        return new LinearRingBuilder3D(crsId);
    }

    public static GeometryBuilder3DM<LinearRing> create3DM(CrsId crsId) {
        return new LinearRingBuilder3DM(crsId);
    }

    private static class LinearRingBuilder3DM
    extends Builder
    implements GeometryBuilder3DM<LinearRing> {
        LinearRingBuilder3DM(CrsId crsId) {
            super(DimensionalFlag.d3DM, crsId);
        }

        public LinearRingBuilder3DM add(double x2, double y2, double z2, double m4) {
            this.pointSequenceBuilder.add(x2, y2, z2, m4);
            return this;
        }
    }

    private static class LinearRingBuilder3D
    extends Builder
    implements GeometryBuilder3D<LinearRing> {
        LinearRingBuilder3D(CrsId crsId) {
            super(DimensionalFlag.d3D, crsId);
        }

        public LinearRingBuilder3D add(double x2, double y2, double z2) {
            this.pointSequenceBuilder.add(x2, y2, z2);
            return this;
        }
    }

    private static class LinearRingBuilder2DM
    extends Builder
    implements GeometryBuilder2DM<LinearRing> {
        LinearRingBuilder2DM(CrsId crsId) {
            super(DimensionalFlag.d2DM, crsId);
        }

        public LinearRingBuilder2DM add(double x2, double y2, double m4) {
            this.pointSequenceBuilder.add(x2, y2, m4);
            return this;
        }
    }

    private static class LinearRingBuilder2D
    extends Builder
    implements GeometryBuilder2D<LinearRing> {
        LinearRingBuilder2D(CrsId crsId) {
            super(DimensionalFlag.d2D, crsId);
        }

        public LinearRingBuilder2D add(double x2, double y2) {
            this.pointSequenceBuilder.add(x2, y2);
            return this;
        }
    }

    private static abstract class Builder
    implements SimpleGeometryBuilder<LinearRing> {
        protected PointSequenceBuilder pointSequenceBuilder;

        Builder(DimensionalFlag dimFlag, CrsId crsId) {
            this.pointSequenceBuilder = PointSequenceBuilders.variableSized(dimFlag, crsId);
        }

        @Override
        public LinearRing build() {
            return new LinearRing(this.pointSequenceBuilder.toPointSequence());
        }
    }
}

