/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.PackedPointSequence;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;

public class PointSequenceIterator
implements Iterator<Point> {
    private final PointSequence sequence;
    private int index = 0;

    PointSequenceIterator(PointSequence sequence) {
        if (sequence == null) {
            this.sequence = EmptyPointSequence.INSTANCE;
            return;
        }
        this.sequence = sequence;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.sequence.size();
    }

    @Override
    public Point next() {
        if (this.hasNext()) {
            return new Point(this.createSingleElementPointSequenceFrom(this.sequence, this.index++));
        }
        throw new NoSuchElementException();
    }

    private PointSequence createSingleElementPointSequenceFrom(PointSequence sequence, int i2) {
        double[] coordinates = new double[sequence.getCoordinateDimension()];
        sequence.getCoordinates(coordinates, i2);
        return new PackedPointSequence(coordinates, sequence.getDimensionalFlag(), sequence.getCrsId());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove method not supported on " + this.getClass().getName());
    }
}

