/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.ComplexPointCollection;
import org.geolatte.geom.ExactCoordinatePointEquality;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointCollectionEquality;
import org.geolatte.geom.PointEquality;
import org.geolatte.geom.PointSequence;

public class PointCollectionPointEquality
implements PointCollectionEquality {
    private final PointEquality pointEquality;

    public PointCollectionPointEquality(PointEquality pointEquality) {
        this.pointEquality = pointEquality;
    }

    public PointCollectionPointEquality() {
        this.pointEquality = new ExactCoordinatePointEquality();
    }

    @Override
    public boolean equals(PointCollection first, PointCollection second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.size() != second.size()) {
            return false;
        }
        if (first instanceof ComplexPointCollection && second instanceof ComplexPointCollection) {
            return this.testComplexPointSetEquality((ComplexPointCollection)first, (ComplexPointCollection)second);
        }
        if (first instanceof PointSequence && second instanceof PointSequence) {
            return this.testPointSequenceEquality(first, second);
        }
        return false;
    }

    private boolean testPointSequenceEquality(PointCollection first, PointCollection second) {
        double[] c1 = new double[first.getCoordinateDimension()];
        double[] c2 = new double[second.getCoordinateDimension()];
        for (int idx = 0; idx < first.size(); ++idx) {
            first.getCoordinates(c1, idx);
            second.getCoordinates(c2, idx);
            if (this.pointEquality.equals(c1, first.getDimensionalFlag(), c2, second.getDimensionalFlag())) continue;
            return false;
        }
        return true;
    }

    private boolean testComplexPointSetEquality(ComplexPointCollection first, ComplexPointCollection second) {
        PointCollection[] secondCollection;
        PointCollection[] firstCollection = first.getPointSets();
        if (firstCollection.length != (secondCollection = second.getPointSets()).length) {
            return false;
        }
        for (int i2 = 0; i2 < firstCollection.length; ++i2) {
            if (this.equals(firstCollection[i2], secondCollection[i2])) continue;
            return false;
        }
        return true;
    }
}

