/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.AbstractPointCollection;
import org.geolatte.geom.CoordinateComponent;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollectionPointEquality;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceIterator;
import org.geolatte.geom.crs.CrsId;

class PackedPointSequence
extends AbstractPointCollection
implements PointSequence {
    private final double[] coordinates;

    PackedPointSequence(double[] coordinates, DimensionalFlag dimensionalFlag, CrsId crsId) {
        super(dimensionalFlag, crsId);
        this.coordinates = coordinates == null ? new double[0] : coordinates;
        if (this.coordinates.length % this.getCoordinateDimension() != 0) {
            throw new IllegalArgumentException(String.format("coordinate array size should be a multiple of %d. Current size = %d", this.getCoordinateDimension(), this.coordinates.length));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.length == 0;
    }

    @Override
    public double getCoordinate(int position, CoordinateComponent component) {
        try {
            int index = this.getDimensionalFlag().index(component);
            return index > -1 ? this.coordinates[position * this.getCoordinateDimension() + index] : Double.NaN;
        }
        catch (IndexOutOfBoundsException e2) {
            throw new IndexOutOfBoundsException(String.format("Index %d out of getPointSequenceElementAt 0..%d", position, this.size() - 1));
        }
    }

    @Override
    public int size() {
        return this.coordinates.length / this.getCoordinateDimension();
    }

    @Override
    public Iterator<Point> iterator() {
        return new PointSequenceIterator(this);
    }

    @Override
    public PointSequence clone() {
        return this;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof PointSequence)) {
            return false;
        }
        PointSequence that = (PointSequence)o2;
        if (this.is3D() != that.is3D()) {
            return false;
        }
        if (this.isMeasured() != that.isMeasured()) {
            return false;
        }
        if (!this.getCrsId().equals(that.getCrsId())) {
            return false;
        }
        return new PointCollectionPointEquality().equals(this, that);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.coordinates);
        result = 31 * result + (this.isMeasured() ? 1 : 0);
        result = 31 * result + (this.is3D() ? 1 : 0);
        result = 31 * result + this.getCrsId().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (i2 > 0) {
                builder.append(",");
            }
            this.addCoordinate(i2, builder);
        }
        builder.append("]");
        return builder.toString();
    }

    private void addCoordinate(int index, StringBuilder builder) {
        builder.append(this.getOrdinate(index, 0)).append(" ").append(this.getOrdinate(index, 1)).append(" ");
        if (this.is3D()) {
            builder.append(this.getOrdinate(index, 2)).append(" ");
        }
        if (this.isMeasured()) {
            builder.append(this.getOrdinate(index, 3)).append(" ");
        }
    }
}

