/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.Points;

public class LineString
extends Geometry {
    static final LineString EMPTY = new LineString(EmptyPointSequence.INSTANCE, null);
    private final PointSequence points;

    public static LineString createEmpty() {
        return EMPTY;
    }

    protected LineString(LineString base) {
        super(base.getGeometryOperations());
        this.points = base.points;
    }

    public LineString(PointSequence points, GeometryOperations geometryOperations) {
        super(geometryOperations);
        if (points == null) {
            points = EmptyPointSequence.INSTANCE;
        }
        if (!points.isEmpty() && points.size() < 2) {
            throw new IllegalArgumentException(String.format("Constructor of class %s requires PointSequence of size at least 2.", this.getClass().getSimpleName()));
        }
        this.points = points;
    }

    public LineString(PointSequence points) {
        this(points, null);
    }

    private boolean determineSimple() {
        return super.isSimple();
    }

    @Override
    public PointSequence getPoints() {
        return this.points;
    }

    public double getLength() {
        double length = 0.0;
        Point prev = null;
        for (Point pnt : this.getPoints()) {
            if (prev == null) {
                prev = pnt;
                continue;
            }
            length += Math.hypot(pnt.getX() - prev.getX(), pnt.getY() - prev.getY());
            prev = pnt;
        }
        return length;
    }

    public Point getStartPoint() {
        return this.isEmpty() ? Points.createEmpty() : this.getPointN(0);
    }

    public Point getEndPoint() {
        return this.isEmpty() ? Points.createEmpty() : this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        return !this.isEmpty() && this.getStartPoint().equals(this.getEndPoint());
    }

    public boolean isRing() {
        return !this.isEmpty() && this.isClosed() && this.isSimple();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINE_STRING;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

