/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import org.geolatte.common.transformer.ObservableTransformerSource;
import org.geolatte.common.transformer.TransformerSourceErrorEvent;
import org.geolatte.common.transformer.TransformerSourceEventListener;

public abstract class AbstractObservableTransformerSource<T>
extends ObservableTransformerSource<T> {
    private ArrayList<TransformerSourceEventListener> transformerSourceEventListeners = new ArrayList();

    @Override
    public void addTransformerSourceEventListener(TransformerSourceEventListener listener) {
        if (listener != null) {
            this.transformerSourceEventListeners.add(listener);
        }
    }

    @Override
    public void removeTransformerSourceEventListener(TransformerSourceEventListener listener) {
        this.transformerSourceEventListeners.remove(listener);
    }

    protected void onSourceErrorOccurred(boolean isTerminating, Exception exception) {
        for (TransformerSourceEventListener listener : this.transformerSourceEventListeners) {
            this.fireErrorEvent(listener, new TransformerSourceErrorEvent(this, exception, isTerminating));
        }
    }

    protected void onSourceErrorOccurred(TransformerSourceErrorEvent event) {
        for (TransformerSourceEventListener listener : this.transformerSourceEventListeners) {
            this.fireErrorEvent(listener, event);
        }
    }

    private void fireErrorEvent(TransformerSourceEventListener listener, TransformerSourceErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e2) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bed behaved listener.");
            e2.printStackTrace();
            this.removeTransformerSourceEventListener(listener);
        }
    }
}

