/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geolatte.common.Feature;
import org.geolatte.geom.Geometry;

public class DefaultFeature
implements Feature {
    private Set<String> propertyNames = new HashSet<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String geomPropertyName;
    private String idPropertyName;
    private Geometry geomValue;
    private Object idValue;

    public DefaultFeature() {
    }

    public DefaultFeature(Feature feature) {
        if (feature.hasGeometry()) {
            this.setGeometry(feature.getGeometryName(), feature.getGeometry());
        }
        if (feature.hasId()) {
            this.setId("id", feature.getId());
        }
        for (String propertyName : feature.getProperties()) {
            if ("id".equals(propertyName)) continue;
            this.addProperty(propertyName, feature.getProperty(propertyName));
        }
    }

    public void setGeometry(String name, Geometry value) {
        if (name == null) {
            this.geomPropertyName = null;
            this.geomValue = null;
        } else {
            this.geomPropertyName = name;
            this.geomValue = value;
        }
    }

    public void setId(String name, Object value) {
        if (name == null) {
            this.idPropertyName = null;
            this.idValue = null;
        } else {
            this.idPropertyName = name;
            this.idValue = value;
        }
    }

    public void addProperty(String propertyName, Object value) {
        if (propertyName != null) {
            this.propertyNames.add(propertyName);
            if (value == null) {
                this.properties.remove(propertyName);
            } else {
                this.properties.put(propertyName, value);
            }
        }
    }

    public void wipeProperty(String propertyName) {
        if (propertyName != null) {
            this.propertyNames.remove(propertyName);
            if (this.properties.containsKey(propertyName)) {
                this.properties.remove(propertyName);
            }
        }
    }

    @Override
    public boolean hasProperty(String propertyName, boolean trueForSpecialProperties) {
        return this.propertyNames.contains(propertyName) || trueForSpecialProperties && (this.geomPropertyName != null && this.geomPropertyName.equals(propertyName) || this.idPropertyName != null && this.idPropertyName.equals(propertyName));
    }

    @Override
    public Collection<String> getProperties() {
        return new ArrayList<String>(this.propertyNames);
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Object getId() {
        if (this.idPropertyName != null) {
            return this.idValue;
        }
        return null;
    }

    @Override
    public Geometry getGeometry() {
        if (this.geomPropertyName != null) {
            return this.geomValue;
        }
        return null;
    }

    @Override
    public String getGeometryName() {
        return this.geomPropertyName;
    }

    @Override
    public boolean hasId() {
        return this.idPropertyName != null;
    }

    @Override
    public boolean hasGeometry() {
        return this.geomPropertyName != null;
    }
}

