/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class TCPNetworkModule
implements NetworkModule {
    private static final String CLASS_NAME = TCPNetworkModule.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    protected Socket socket;
    private SocketFactory factory;
    private String host;
    private int port;
    private int conTimeout;

    public TCPNetworkModule(SocketFactory factory, String host, int port, String resourceContext) {
        this.log.setResourceName(resourceContext);
        this.factory = factory;
        this.host = host;
        this.port = port;
    }

    @Override
    public void start() throws IOException, MqttException {
        String methodName = "start";
        try {
            this.log.fine(CLASS_NAME, "start", "252", new Object[]{this.host, this.port, (long)(this.conTimeout * 1000)});
            InetSocketAddress sockaddr = new InetSocketAddress(this.host, this.port);
            this.socket = this.factory.createSocket();
            this.socket.connect(sockaddr, this.conTimeout * 1000);
            this.socket.setSoTimeout(1000);
        }
        catch (ConnectException ex2) {
            this.log.fine(CLASS_NAME, "start", "250", null, ex2);
            throw new MqttException(32103, (Throwable)ex2);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void stop() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void setConnectTimeout(int timeout) {
        this.conTimeout = timeout;
    }

    @Override
    public String getServerURI() {
        return "tcp://" + this.host + ":" + this.port;
    }
}

