/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance DEFAULT_INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public static LevenshteinDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private static int limitedCompare(CharSequence left, CharSequence right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = left.length();
        int m4 = right.length();
        if (n2 == 0) {
            return m4 <= threshold ? m4 : -1;
        }
        if (m4 == 0) {
            return n2 <= threshold ? n2 : -1;
        }
        if (n2 > m4) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n2 = m4;
            m4 = right.length();
        }
        if (m4 - n2 > threshold) {
            return -1;
        }
        int[] p2 = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        int boundary = Math.min(n2, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p2[i2] = i2;
        }
        Arrays.fill(p2, boundary, p2.length, Integer.MAX_VALUE);
        Arrays.fill(d2, Integer.MAX_VALUE);
        for (int j2 = 1; j2 <= m4; ++j2) {
            int max;
            char rightJ = right.charAt(j2 - 1);
            d2[0] = j2;
            int min2 = Math.max(1, j2 - threshold);
            int n3 = max = j2 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, j2 + threshold);
            if (min2 > 1) {
                d2[min2 - 1] = Integer.MAX_VALUE;
            }
            int lowerBound = Integer.MAX_VALUE;
            for (int i3 = min2; i3 <= max; ++i3) {
                d2[i3] = left.charAt(i3 - 1) == rightJ ? p2[i3 - 1] : 1 + Math.min(Math.min(d2[i3 - 1], p2[i3]), p2[i3 - 1]);
                lowerBound = Math.min(lowerBound, d2[i3]);
            }
            if (lowerBound > threshold) {
                return -1;
            }
            int[] tempD = p2;
            p2 = d2;
            d2 = tempD;
        }
        if (p2[n2] <= threshold) {
            return p2[n2];
        }
        return -1;
    }

    private static int unlimitedCompare(CharSequence left, CharSequence right) {
        int i2;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n2 = left.length();
        int m4 = right.length();
        if (n2 == 0) {
            return m4;
        }
        if (m4 == 0) {
            return n2;
        }
        if (n2 > m4) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n2 = m4;
            m4 = right.length();
        }
        int[] p2 = new int[n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            p2[i2] = i2;
        }
        for (int j2 = 1; j2 <= m4; ++j2) {
            int upperLeft = p2[0];
            char rightJ = right.charAt(j2 - 1);
            p2[0] = j2;
            for (i2 = 1; i2 <= n2; ++i2) {
                int upper = p2[i2];
                int cost = left.charAt(i2 - 1) == rightJ ? 0 : 1;
                p2[i2] = Math.min(Math.min(p2[i2 - 1] + 1, p2[i2] + 1), upperLeft + cost);
                upperLeft = upper;
            }
        }
        return p2[n2];
    }

    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

