/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.SwallowedExceptionLogger;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSourceFactory;
import org.apache.commons.dbcp2.datasources.PoolKey;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionManager;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = 7872747993848065028L;
    private static final Log log = LogFactory.getLog(PerUserPoolDataSource.class);
    private Map<String, Boolean> perUserBlockWhenExhausted;
    private Map<String, String> perUserEvictionPolicyClassName;
    private Map<String, Boolean> perUserLifo;
    private Map<String, Integer> perUserMaxIdle;
    private Map<String, Integer> perUserMaxTotal;
    private Map<String, Long> perUserMaxWaitMillis;
    private Map<String, Long> perUserMinEvictableIdleTimeMillis;
    private Map<String, Integer> perUserMinIdle;
    private Map<String, Integer> perUserNumTestsPerEvictionRun;
    private Map<String, Long> perUserSoftMinEvictableIdleTimeMillis;
    private Map<String, Boolean> perUserTestOnCreate;
    private Map<String, Boolean> perUserTestOnBorrow;
    private Map<String, Boolean> perUserTestOnReturn;
    private Map<String, Boolean> perUserTestWhileIdle;
    private Map<String, Long> perUserTimeBetweenEvictionRunsMillis;
    private Map<String, Boolean> perUserDefaultAutoCommit;
    private Map<String, Integer> perUserDefaultTransactionIsolation;
    private Map<String, Boolean> perUserDefaultReadOnly;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    public void clear() {
        for (PooledConnectionManager manager : this.managers.values()) {
            try {
                this.getCPDSConnectionFactoryPool(manager).clear();
            }
            catch (Exception exception) {}
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    @Override
    public void close() {
        for (PooledConnectionManager manager : this.managers.values()) {
            Utils.closeQuietly(this.getCPDSConnectionFactoryPool(manager));
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    private HashMap<String, Boolean> createMap() {
        return new HashMap<String, Boolean>();
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upKey) {
        return this.managers.get(this.getPoolKey(upKey.getUserName()));
    }

    private ObjectPool<PooledConnectionAndInfo> getCPDSConnectionFactoryPool(PooledConnectionManager manager) {
        return ((CPDSConnectionFactory)manager).getPool();
    }

    public int getNumActive() {
        return this.getNumActive(null);
    }

    public int getNumActive(String userName) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(userName));
        return pool == null ? 0 : pool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null);
    }

    public int getNumIdle(String userName) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(userName));
        return pool == null ? 0 : pool.getNumIdle();
    }

    public boolean getPerUserBlockWhenExhausted(String userName) {
        Boolean value = null;
        if (this.perUserBlockWhenExhausted != null) {
            value = this.perUserBlockWhenExhausted.get(userName);
        }
        if (value == null) {
            return this.getDefaultBlockWhenExhausted();
        }
        return value;
    }

    public Boolean getPerUserDefaultAutoCommit(String userName) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = this.perUserDefaultAutoCommit.get(userName);
        }
        return value;
    }

    public Boolean getPerUserDefaultReadOnly(String userName) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = this.perUserDefaultReadOnly.get(userName);
        }
        return value;
    }

    public Integer getPerUserDefaultTransactionIsolation(String userName) {
        Integer value = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            value = this.perUserDefaultTransactionIsolation.get(userName);
        }
        return value;
    }

    public String getPerUserEvictionPolicyClassName(String userName) {
        String value = null;
        if (this.perUserEvictionPolicyClassName != null) {
            value = this.perUserEvictionPolicyClassName.get(userName);
        }
        if (value == null) {
            return this.getDefaultEvictionPolicyClassName();
        }
        return value;
    }

    public boolean getPerUserLifo(String userName) {
        Boolean value = null;
        if (this.perUserLifo != null) {
            value = this.perUserLifo.get(userName);
        }
        if (value == null) {
            return this.getDefaultLifo();
        }
        return value;
    }

    public int getPerUserMaxIdle(String userName) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = this.perUserMaxIdle.get(userName);
        }
        if (value == null) {
            return this.getDefaultMaxIdle();
        }
        return value;
    }

    public int getPerUserMaxTotal(String userName) {
        Integer value = null;
        if (this.perUserMaxTotal != null) {
            value = this.perUserMaxTotal.get(userName);
        }
        if (value == null) {
            return this.getDefaultMaxTotal();
        }
        return value;
    }

    public long getPerUserMaxWaitMillis(String userName) {
        Long value = null;
        if (this.perUserMaxWaitMillis != null) {
            value = this.perUserMaxWaitMillis.get(userName);
        }
        if (value == null) {
            return this.getDefaultMaxWaitMillis();
        }
        return value;
    }

    public long getPerUserMinEvictableIdleTimeMillis(String userName) {
        Long value = null;
        if (this.perUserMinEvictableIdleTimeMillis != null) {
            value = this.perUserMinEvictableIdleTimeMillis.get(userName);
        }
        if (value == null) {
            return this.getDefaultMinEvictableIdleTimeMillis();
        }
        return value;
    }

    public int getPerUserMinIdle(String userName) {
        Integer value = null;
        if (this.perUserMinIdle != null) {
            value = this.perUserMinIdle.get(userName);
        }
        if (value == null) {
            return this.getDefaultMinIdle();
        }
        return value;
    }

    public int getPerUserNumTestsPerEvictionRun(String userName) {
        Integer value = null;
        if (this.perUserNumTestsPerEvictionRun != null) {
            value = this.perUserNumTestsPerEvictionRun.get(userName);
        }
        if (value == null) {
            return this.getDefaultNumTestsPerEvictionRun();
        }
        return value;
    }

    public long getPerUserSoftMinEvictableIdleTimeMillis(String userName) {
        Long value = null;
        if (this.perUserSoftMinEvictableIdleTimeMillis != null) {
            value = this.perUserSoftMinEvictableIdleTimeMillis.get(userName);
        }
        if (value == null) {
            return this.getDefaultSoftMinEvictableIdleTimeMillis();
        }
        return value;
    }

    public boolean getPerUserTestOnBorrow(String userName) {
        Boolean value = null;
        if (this.perUserTestOnBorrow != null) {
            value = this.perUserTestOnBorrow.get(userName);
        }
        if (value == null) {
            return this.getDefaultTestOnBorrow();
        }
        return value;
    }

    public boolean getPerUserTestOnCreate(String userName) {
        Boolean value = null;
        if (this.perUserTestOnCreate != null) {
            value = this.perUserTestOnCreate.get(userName);
        }
        if (value == null) {
            return this.getDefaultTestOnCreate();
        }
        return value;
    }

    public boolean getPerUserTestOnReturn(String userName) {
        Boolean value = null;
        if (this.perUserTestOnReturn != null) {
            value = this.perUserTestOnReturn.get(userName);
        }
        if (value == null) {
            return this.getDefaultTestOnReturn();
        }
        return value;
    }

    public boolean getPerUserTestWhileIdle(String userName) {
        Boolean value = null;
        if (this.perUserTestWhileIdle != null) {
            value = this.perUserTestWhileIdle.get(userName);
        }
        if (value == null) {
            return this.getDefaultTestWhileIdle();
        }
        return value;
    }

    public long getPerUserTimeBetweenEvictionRunsMillis(String userName) {
        Long value = null;
        if (this.perUserTimeBetweenEvictionRunsMillis != null) {
            value = this.perUserTimeBetweenEvictionRunsMillis.get(userName);
        }
        if (value == null) {
            return this.getDefaultTimeBetweenEvictionRunsMillis();
        }
        return value;
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey poolKey) {
        CPDSConnectionFactory mgr = (CPDSConnectionFactory)this.managers.get(poolKey);
        return mgr == null ? null : mgr.getPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String userName, String password) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> pool;
        PooledConnectionManager manager;
        PoolKey key = this.getPoolKey(userName);
        PerUserPoolDataSource perUserPoolDataSource = this;
        synchronized (perUserPoolDataSource) {
            manager = this.managers.get(key);
            if (manager == null) {
                try {
                    this.registerPool(userName, password);
                    manager = this.managers.get(key);
                }
                catch (NamingException e2) {
                    throw new SQLException("RegisterPool failed", e2);
                }
            }
            pool = this.getCPDSConnectionFactoryPool(manager);
        }
        PooledConnectionAndInfo info = null;
        try {
            info = pool.borrowObject();
        }
        catch (NoSuchElementException ex2) {
            throw new SQLException("Could not retrieve connection info from pool", ex2);
        }
        catch (Exception e3) {
            try {
                this.testCPDS(userName, password);
            }
            catch (Exception ex3) {
                throw new SQLException("Could not retrieve connection info from pool", ex3);
            }
            manager.closePool(userName);
            PerUserPoolDataSource ex3 = this;
            synchronized (ex3) {
                this.managers.remove(key);
            }
            try {
                this.registerPool(userName, password);
                pool = this.getPool(key);
            }
            catch (NamingException ne2) {
                throw new SQLException("RegisterPool failed", ne2);
            }
            try {
                info = pool.borrowObject();
            }
            catch (Exception ex2) {
                throw new SQLException("Could not retrieve connection info from pool", ex2);
            }
        }
        return info;
    }

    private PoolKey getPoolKey(String userName) {
        return new PoolKey(this.getDataSourceName(), userName);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return ref;
    }

    private void readObject(ObjectInputStream in2) throws IOException, ClassNotFoundException {
        try {
            in2.defaultReadObject();
            PerUserPoolDataSource oldDS = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = oldDS.managers;
        }
        catch (NamingException e2) {
            throw new IOException("NamingException: " + e2);
        }
    }

    private synchronized void registerPool(String userName, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(userName, password);
        CPDSConnectionFactory factory = new CPDSConnectionFactory(cpds, this.getValidationQuery(), this.getValidationQueryTimeout(), this.isRollbackAfterValidation(), userName, password);
        factory.setMaxConnLifetime(this.getMaxConnLifetime());
        GenericObjectPool<PooledConnectionAndInfo> pool = new GenericObjectPool<PooledConnectionAndInfo>(factory);
        factory.setPool(pool);
        pool.setBlockWhenExhausted(this.getPerUserBlockWhenExhausted(userName));
        pool.setEvictionPolicyClassName(this.getPerUserEvictionPolicyClassName(userName));
        pool.setLifo(this.getPerUserLifo(userName));
        pool.setMaxIdle(this.getPerUserMaxIdle(userName));
        pool.setMaxTotal(this.getPerUserMaxTotal(userName));
        pool.setMaxWaitMillis(this.getPerUserMaxWaitMillis(userName));
        pool.setMinEvictableIdleTimeMillis(this.getPerUserMinEvictableIdleTimeMillis(userName));
        pool.setMinIdle(this.getPerUserMinIdle(userName));
        pool.setNumTestsPerEvictionRun(this.getPerUserNumTestsPerEvictionRun(userName));
        pool.setSoftMinEvictableIdleTimeMillis(this.getPerUserSoftMinEvictableIdleTimeMillis(userName));
        pool.setTestOnCreate(this.getPerUserTestOnCreate(userName));
        pool.setTestOnBorrow(this.getPerUserTestOnBorrow(userName));
        pool.setTestOnReturn(this.getPerUserTestOnReturn(userName));
        pool.setTestWhileIdle(this.getPerUserTestWhileIdle(userName));
        pool.setTimeBetweenEvictionRunsMillis(this.getPerUserTimeBetweenEvictionRunsMillis(userName));
        pool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log));
        PooledConnectionManager old = this.managers.put(this.getPoolKey(userName), factory);
        if (old != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + userName);
        }
    }

    void setPerUserBlockWhenExhausted(Map<String, Boolean> userDefaultBlockWhenExhausted) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = this.createMap();
        } else {
            this.perUserBlockWhenExhausted.clear();
        }
        this.perUserBlockWhenExhausted.putAll(userDefaultBlockWhenExhausted);
    }

    public void setPerUserBlockWhenExhausted(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = this.createMap();
        }
        this.perUserBlockWhenExhausted.put(userName, value);
    }

    void setPerUserDefaultAutoCommit(Map<String, Boolean> userDefaultAutoCommit) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = this.createMap();
        } else {
            this.perUserDefaultAutoCommit.clear();
        }
        this.perUserDefaultAutoCommit.putAll(userDefaultAutoCommit);
    }

    public void setPerUserDefaultAutoCommit(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = this.createMap();
        }
        this.perUserDefaultAutoCommit.put(userName, value);
    }

    void setPerUserDefaultReadOnly(Map<String, Boolean> userDefaultReadOnly) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = this.createMap();
        } else {
            this.perUserDefaultReadOnly.clear();
        }
        this.perUserDefaultReadOnly.putAll(userDefaultReadOnly);
    }

    public void setPerUserDefaultReadOnly(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = this.createMap();
        }
        this.perUserDefaultReadOnly.put(userName, value);
    }

    void setPerUserDefaultTransactionIsolation(Map<String, Integer> userDefaultTransactionIsolation) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        } else {
            this.perUserDefaultTransactionIsolation.clear();
        }
        this.perUserDefaultTransactionIsolation.putAll(userDefaultTransactionIsolation);
    }

    public void setPerUserDefaultTransactionIsolation(String userName, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(userName, value);
    }

    void setPerUserEvictionPolicyClassName(Map<String, String> userDefaultEvictionPolicyClassName) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        } else {
            this.perUserEvictionPolicyClassName.clear();
        }
        this.perUserEvictionPolicyClassName.putAll(userDefaultEvictionPolicyClassName);
    }

    public void setPerUserEvictionPolicyClassName(String userName, String value) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        }
        this.perUserEvictionPolicyClassName.put(userName, value);
    }

    void setPerUserLifo(Map<String, Boolean> userDefaultLifo) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = this.createMap();
        } else {
            this.perUserLifo.clear();
        }
        this.perUserLifo.putAll(userDefaultLifo);
    }

    public void setPerUserLifo(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = this.createMap();
        }
        this.perUserLifo.put(userName, value);
    }

    void setPerUserMaxIdle(Map<String, Integer> userDefaultMaxIdle) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMaxIdle.clear();
        }
        this.perUserMaxIdle.putAll(userDefaultMaxIdle);
    }

    public void setPerUserMaxIdle(String userName, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(userName, value);
    }

    void setPerUserMaxTotal(Map<String, Integer> userDefaultMaxTotal) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        } else {
            this.perUserMaxTotal.clear();
        }
        this.perUserMaxTotal.putAll(userDefaultMaxTotal);
    }

    public void setPerUserMaxTotal(String userName, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        }
        this.perUserMaxTotal.put(userName, value);
    }

    void setPerUserMaxWaitMillis(Map<String, Long> userDefaultMaxWaitMillis) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitMillis == null) {
            this.perUserMaxWaitMillis = new HashMap<String, Long>();
        } else {
            this.perUserMaxWaitMillis.clear();
        }
        this.perUserMaxWaitMillis.putAll(userDefaultMaxWaitMillis);
    }

    public void setPerUserMaxWaitMillis(String userName, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitMillis == null) {
            this.perUserMaxWaitMillis = new HashMap<String, Long>();
        }
        this.perUserMaxWaitMillis.put(userName, value);
    }

    void setPerUserMinEvictableIdleTimeMillis(Map<String, Long> userDefaultMinEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        if (this.perUserMinEvictableIdleTimeMillis == null) {
            this.perUserMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        } else {
            this.perUserMinEvictableIdleTimeMillis.clear();
        }
        this.perUserMinEvictableIdleTimeMillis.putAll(userDefaultMinEvictableIdleTimeMillis);
    }

    public void setPerUserMinEvictableIdleTimeMillis(String userName, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserMinEvictableIdleTimeMillis == null) {
            this.perUserMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        }
        this.perUserMinEvictableIdleTimeMillis.put(userName, value);
    }

    void setPerUserMinIdle(Map<String, Integer> userDefaultMinIdle) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMinIdle.clear();
        }
        this.perUserMinIdle.putAll(userDefaultMinIdle);
    }

    public void setPerUserMinIdle(String userName, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        }
        this.perUserMinIdle.put(userName, value);
    }

    void setPerUserNumTestsPerEvictionRun(Map<String, Integer> userDefaultNumTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        } else {
            this.perUserNumTestsPerEvictionRun.clear();
        }
        this.perUserNumTestsPerEvictionRun.putAll(userDefaultNumTestsPerEvictionRun);
    }

    public void setPerUserNumTestsPerEvictionRun(String userName, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        }
        this.perUserNumTestsPerEvictionRun.put(userName, value);
    }

    void setPerUserSoftMinEvictableIdleTimeMillis(Map<String, Long> userDefaultSoftMinEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        if (this.perUserSoftMinEvictableIdleTimeMillis == null) {
            this.perUserSoftMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        } else {
            this.perUserSoftMinEvictableIdleTimeMillis.clear();
        }
        this.perUserSoftMinEvictableIdleTimeMillis.putAll(userDefaultSoftMinEvictableIdleTimeMillis);
    }

    public void setPerUserSoftMinEvictableIdleTimeMillis(String userName, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserSoftMinEvictableIdleTimeMillis == null) {
            this.perUserSoftMinEvictableIdleTimeMillis = new HashMap<String, Long>();
        }
        this.perUserSoftMinEvictableIdleTimeMillis.put(userName, value);
    }

    void setPerUserTestOnBorrow(Map<String, Boolean> userDefaultTestOnBorrow) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = this.createMap();
        } else {
            this.perUserTestOnBorrow.clear();
        }
        this.perUserTestOnBorrow.putAll(userDefaultTestOnBorrow);
    }

    public void setPerUserTestOnBorrow(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = this.createMap();
        }
        this.perUserTestOnBorrow.put(userName, value);
    }

    void setPerUserTestOnCreate(Map<String, Boolean> userDefaultTestOnCreate) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = this.createMap();
        } else {
            this.perUserTestOnCreate.clear();
        }
        this.perUserTestOnCreate.putAll(userDefaultTestOnCreate);
    }

    public void setPerUserTestOnCreate(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = this.createMap();
        }
        this.perUserTestOnCreate.put(userName, value);
    }

    void setPerUserTestOnReturn(Map<String, Boolean> userDefaultTestOnReturn) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = this.createMap();
        } else {
            this.perUserTestOnReturn.clear();
        }
        this.perUserTestOnReturn.putAll(userDefaultTestOnReturn);
    }

    public void setPerUserTestOnReturn(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = this.createMap();
        }
        this.perUserTestOnReturn.put(userName, value);
    }

    void setPerUserTestWhileIdle(Map<String, Boolean> userDefaultTestWhileIdle) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = this.createMap();
        } else {
            this.perUserTestWhileIdle.clear();
        }
        this.perUserTestWhileIdle.putAll(userDefaultTestWhileIdle);
    }

    public void setPerUserTestWhileIdle(String userName, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = this.createMap();
        }
        this.perUserTestWhileIdle.put(userName, value);
    }

    void setPerUserTimeBetweenEvictionRunsMillis(Map<String, Long> userDefaultTimeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        if (this.perUserTimeBetweenEvictionRunsMillis == null) {
            this.perUserTimeBetweenEvictionRunsMillis = new HashMap<String, Long>();
        } else {
            this.perUserTimeBetweenEvictionRunsMillis.clear();
        }
        this.perUserTimeBetweenEvictionRunsMillis.putAll(userDefaultTimeBetweenEvictionRunsMillis);
    }

    public void setPerUserTimeBetweenEvictionRunsMillis(String userName, Long value) {
        this.assertInitializationAllowed();
        if (this.perUserTimeBetweenEvictionRunsMillis == null) {
            this.perUserTimeBetweenEvictionRunsMillis = new HashMap<String, Long>();
        }
        this.perUserTimeBetweenEvictionRunsMillis.put(userName, value);
    }

    @Override
    protected void setupDefaults(Connection con, String userName) throws SQLException {
        Integer userMax;
        Boolean userMax2;
        Boolean userMax3;
        Boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (userName != null && (userMax3 = this.getPerUserDefaultAutoCommit(userName)) != null) {
            defaultAutoCommit = userMax3;
        }
        Boolean defaultReadOnly = this.isDefaultReadOnly();
        if (userName != null && (userMax2 = this.getPerUserDefaultReadOnly(userName)) != null) {
            defaultReadOnly = userMax2;
        }
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (userName != null && (userMax = this.getPerUserDefaultTransactionIsolation(userName)) != null) {
            defaultTransactionIsolation = userMax;
        }
        if (defaultAutoCommit != null && con.getAutoCommit() != defaultAutoCommit.booleanValue()) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        if (defaultReadOnly != null && con.isReadOnly() != defaultReadOnly.booleanValue()) {
            con.setReadOnly(defaultReadOnly);
        }
    }
}

