/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.Serializable;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.format.CalendarType;
import net.time4j.tz.model.DayOfWeekInMonthPattern;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.FixedDayPattern;
import net.time4j.tz.model.LastWeekdayPattern;
import net.time4j.tz.model.OffsetIndicator;

@CalendarType(value="iso8601")
public class GregorianTimezoneRule
extends DaylightSavingRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient byte month;

    protected GregorianTimezoneRule(Month month, int n2, OffsetIndicator offsetIndicator, int n3) {
        super(n2, offsetIndicator, n3);
        this.month = (byte)month.getValue();
    }

    public static GregorianTimezoneRule ofFixedDay(Month month, int n2, PlainTime plainTime, OffsetIndicator offsetIndicator, int n3) {
        return GregorianTimezoneRule.ofFixedDay(month, n2, plainTime.getInt(PlainTime.SECOND_OF_DAY), offsetIndicator, n3);
    }

    public static GregorianTimezoneRule ofFixedDay(Month month, int n2, int n3, OffsetIndicator offsetIndicator, int n4) {
        return new FixedDayPattern(month, n2, n3, offsetIndicator, n4);
    }

    public static GregorianTimezoneRule ofLastWeekday(Month month, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2) {
        return GregorianTimezoneRule.ofLastWeekday(month, weekday, plainTime.getInt(PlainTime.SECOND_OF_DAY), offsetIndicator, n2);
    }

    public static GregorianTimezoneRule ofLastWeekday(Month month, Weekday weekday, int n2, OffsetIndicator offsetIndicator, int n3) {
        return new LastWeekdayPattern(month, weekday, n2, offsetIndicator, n3);
    }

    public static GregorianTimezoneRule ofWeekdayAfterDate(Month month, int n2, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n3) {
        return GregorianTimezoneRule.ofWeekdayAfterDate(month, n2, weekday, plainTime.getInt(PlainTime.SECOND_OF_DAY), offsetIndicator, n3);
    }

    public static GregorianTimezoneRule ofWeekdayAfterDate(Month month, int n2, Weekday weekday, int n3, OffsetIndicator offsetIndicator, int n4) {
        return new DayOfWeekInMonthPattern(month, n2, weekday, n3, offsetIndicator, n4, true);
    }

    public static GregorianTimezoneRule ofWeekdayBeforeDate(Month month, int n2, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n3) {
        return GregorianTimezoneRule.ofWeekdayBeforeDate(month, n2, weekday, plainTime.getInt(PlainTime.SECOND_OF_DAY), offsetIndicator, n3);
    }

    public static GregorianTimezoneRule ofWeekdayBeforeDate(Month month, int n2, Weekday weekday, int n3, OffsetIndicator offsetIndicator, int n4) {
        return new DayOfWeekInMonthPattern(month, n2, weekday, n3, offsetIndicator, n4, false);
    }

    @Override
    public final PlainDate getDate(int n2) {
        return this.getDate0(n2).plus(this.getDayOverflow(), CalendarUnit.DAYS);
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    protected PlainDate getDate0(int n2) {
        throw new AbstractMethodError("Implemented by subclasses.");
    }

    @Override
    protected int toCalendarYear(long l2) {
        return GregorianMath.readYear(GregorianMath.toPackedDate(l2));
    }

    @Override
    protected int toCalendarYear(GregorianDate gregorianDate) {
        return gregorianDate.getYear();
    }

    @Override
    protected String getCalendarType() {
        return "iso8601";
    }

    protected boolean isEqual(GregorianTimezoneRule gregorianTimezoneRule) {
        return this.getTimeOfDay().equals(gregorianTimezoneRule.getTimeOfDay()) && this.getDayOverflow() == gregorianTimezoneRule.getDayOverflow() && this.getIndicator() == gregorianTimezoneRule.getIndicator() && this.getSavings() == gregorianTimezoneRule.getSavings() && this.month == gregorianTimezoneRule.month;
    }

    byte getMonthValue() {
        return this.month;
    }
}

