/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class ZonalTransition
implements Comparable<ZonalTransition>,
Serializable {
    private static final long serialVersionUID = 4594838367057225304L;
    private final long posix;
    private final int previous;
    private final int total;
    private final int extra;

    public ZonalTransition(long l2, int n2, int n3, int n4) {
        this.posix = l2;
        this.previous = n2;
        this.total = n3;
        this.extra = n4;
        ZonalTransition.checkRange(n2);
        ZonalTransition.checkRange(n3);
        ZonalTransition.checkDST(n4);
    }

    public long getPosixTime() {
        return this.posix;
    }

    public int getPreviousOffset() {
        return this.previous;
    }

    public int getTotalOffset() {
        return this.total;
    }

    public int getRawOffset() {
        return this.total - this.getExtraOffset();
    }

    public int getExtraOffset() {
        return this.extra == Integer.MAX_VALUE ? 0 : this.extra;
    }

    public int getSize() {
        return this.total - this.previous;
    }

    public boolean isGap() {
        return this.total > this.previous;
    }

    public boolean isOverlap() {
        return this.total < this.previous;
    }

    @Override
    public int compareTo(ZonalTransition zonalTransition) {
        long l2 = this.posix - zonalTransition.posix;
        if (l2 == 0L && (l2 = (long)(this.previous - zonalTransition.previous)) == 0L && (l2 = (long)(this.total - zonalTransition.total)) == 0L && (l2 = (long)(this.getExtraOffset() - zonalTransition.getExtraOffset())) == 0L) {
            return 0;
        }
        return l2 < 0L ? -1 : 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalTransition) {
            ZonalTransition zonalTransition = (ZonalTransition)object;
            return this.posix == zonalTransition.posix && this.previous == zonalTransition.previous && this.total == zonalTransition.total && this.getExtraOffset() == zonalTransition.getExtraOffset();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.posix ^ this.posix >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("[POSIX=");
        stringBuilder.append(this.posix);
        stringBuilder.append(", previous-offset=");
        stringBuilder.append(this.previous);
        stringBuilder.append(", total-offset=");
        stringBuilder.append(this.total);
        stringBuilder.append(", extra-offset=");
        stringBuilder.append(this.getExtraOffset());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Deprecated
    public int getStandardOffset() {
        return this.getRawOffset();
    }

    @Deprecated
    public int getDaylightSavingOffset() {
        return this.getExtraOffset();
    }

    private static void checkRange(int n2) {
        if (n2 < -64800 || n2 > 64800) {
            throw new IllegalArgumentException("Offset out of range: " + n2);
        }
    }

    private static void checkDST(int n2) {
        if (n2 != Integer.MAX_VALUE) {
            ZonalTransition.checkRange(n2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            ZonalTransition.checkRange(this.previous);
            ZonalTransition.checkRange(this.total);
            ZonalTransition.checkDST(this.extra);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
    }
}

