/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.tz.FallbackTimezone;
import net.time4j.tz.GapResolver;
import net.time4j.tz.HistorizedTimezone;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionResolver;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class SPX
implements Externalizable {
    static final int FALLBACK_TIMEZONE_TYPE = 12;
    static final int TRANSITION_RESOLVER_TYPE = 13;
    static final int HISTORIZED_TIMEZONE_TYPE = 14;
    static final int ZONAL_OFFSET_TYPE = 15;
    private static final long serialVersionUID = -1000776907354520172L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 12: {
                this.writeFallback(objectOutput);
                break;
            }
            case 13: {
                this.writeStrategy(objectOutput);
                break;
            }
            case 14: {
                this.writeZone(objectOutput);
                break;
            }
            case 15: {
                this.writeOffset(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        switch ((by2 & 0xFF) >> 4) {
            case 12: {
                this.obj = this.readFallback(objectInput, by2);
                break;
            }
            case 13: {
                this.obj = this.readStrategy(by2);
                break;
            }
            case 14: {
                this.obj = this.readZone(objectInput, by2);
                break;
            }
            case 15: {
                this.obj = this.readOffset(objectInput, by2);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeFallback(ObjectOutput objectOutput) throws IOException {
        FallbackTimezone fallbackTimezone = (FallbackTimezone)this.obj;
        int n2 = 192;
        objectOutput.writeByte(n2);
        objectOutput.writeObject(fallbackTimezone.getID());
        objectOutput.writeObject(fallbackTimezone.getFallback());
    }

    private Object readFallback(ObjectInput objectInput, byte by2) throws IOException, ClassNotFoundException {
        TZID tZID = (TZID)objectInput.readObject();
        Timezone timezone = (Timezone)objectInput.readObject();
        return new FallbackTimezone(tZID, timezone);
    }

    private void writeStrategy(ObjectOutput objectOutput) throws IOException {
        TransitionResolver transitionResolver = (TransitionResolver)this.obj;
        int n2 = 208;
        objectOutput.writeByte(n2 |= transitionResolver.getKey());
    }

    private Object readStrategy(byte by2) {
        int n2 = by2 & 0xF;
        GapResolver gapResolver = GapResolver.values()[n2 / 2];
        OverlapResolver overlapResolver = OverlapResolver.values()[n2 % 2];
        return TransitionResolver.of(gapResolver, overlapResolver);
    }

    private void writeZone(ObjectOutput objectOutput) throws IOException {
        boolean bl2;
        HistorizedTimezone historizedTimezone = (HistorizedTimezone)this.obj;
        int n2 = 224;
        boolean bl3 = bl2 = historizedTimezone.getStrategy() != Timezone.DEFAULT_CONFLICT_STRATEGY;
        if (bl2) {
            n2 |= 1;
        }
        objectOutput.writeByte(n2);
        objectOutput.writeObject(historizedTimezone.getID());
        objectOutput.writeObject(historizedTimezone.getHistory());
        if (bl2) {
            objectOutput.writeObject(historizedTimezone.getStrategy());
        }
    }

    private Object readZone(ObjectInput objectInput, byte by2) throws IOException, ClassNotFoundException {
        TZID tZID = (TZID)objectInput.readObject();
        TransitionHistory transitionHistory = (TransitionHistory)objectInput.readObject();
        TransitionStrategy transitionStrategy = Timezone.DEFAULT_CONFLICT_STRATEGY;
        if ((by2 & 0xF) == 1) {
            transitionStrategy = (TransitionStrategy)objectInput.readObject();
        }
        return new HistorizedTimezone(tZID, transitionHistory, transitionStrategy);
    }

    private void writeOffset(ObjectOutput objectOutput) throws IOException {
        ZonalOffset zonalOffset = (ZonalOffset)this.obj;
        boolean bl2 = zonalOffset.getFractionalAmount() != 0;
        int n2 = 240;
        if (bl2) {
            n2 |= 1;
        }
        objectOutput.writeByte(n2);
        objectOutput.writeInt(zonalOffset.getIntegralAmount());
        if (bl2) {
            objectOutput.writeInt(zonalOffset.getFractionalAmount());
        }
    }

    private Object readOffset(ObjectInput objectInput, byte by2) throws IOException {
        int n2 = objectInput.readInt();
        int n3 = 0;
        if ((by2 & 0xF) == 1) {
            n3 = objectInput.readInt();
        }
        return ZonalOffset.ofTotalSeconds(n2, n3);
    }
}

