/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;

final class SimpleDate
implements GregorianDate {
    private final int year;
    private final int month;
    private final int dayOfMonth;

    SimpleDate(int n2, int n3, int n4) {
        GregorianMath.checkDate(n2, n3, n4);
        this.year = n2;
        this.month = n3;
        this.dayOfMonth = n4;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleDate) {
            SimpleDate simpleDate = (SimpleDate)object;
            return this.year == simpleDate.year && this.month == simpleDate.month && this.dayOfMonth == simpleDate.dayOfMonth;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.year + 23 * this.month + 31 * this.dayOfMonth;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        if (this.year >= 10000) {
            stringBuilder.append('+');
        } else if (this.year < 0) {
            stringBuilder.append('-');
        }
        int n2 = Math.abs(this.year);
        if (n2 < 1000) {
            stringBuilder.append('0');
            if (n2 < 100) {
                stringBuilder.append('0');
                if (n2 < 10) {
                    stringBuilder.append('0');
                }
            }
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (this.month < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.month);
        stringBuilder.append('-');
        if (this.dayOfMonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.dayOfMonth);
        return stringBuilder.toString();
    }
}

