/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.time4j.base.GregorianDate;
import net.time4j.base.ResourceLoader;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.SimpleDate;

final class DefaultLeapSecondProviderSPI
implements LeapSecondProvider {
    private final String source;
    private final SimpleDate expires;
    private final Map<GregorianDate, Integer> table;

    DefaultLeapSecondProviderSPI() {
        SimpleDate simpleDate = new SimpleDate(-999999999, 1, 1);
        this.table = new LinkedHashMap<GregorianDate, Integer>(50);
        String string = LeapSeconds.PATH_TO_LEAPSECONDS;
        URI uRI = ResourceLoader.getInstance().locate("base", LeapSecondProvider.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            inputStream = LeapSecondProvider.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream != null) {
            this.source = uRI.toString();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n2;
                    Integer n3;
                    int n4;
                    String string3;
                    int n5;
                    if (string2.startsWith("#")) continue;
                    if (string2.startsWith("@expires=")) {
                        String string4 = string2.substring(9);
                        int n6 = Integer.parseInt(string4.substring(0, 4));
                        int n7 = Integer.parseInt(string4.substring(5, 7));
                        n5 = Integer.parseInt(string4.substring(8, 10));
                        simpleDate = new SimpleDate(n6, n7, n5);
                        continue;
                    }
                    int n8 = string2.indexOf(44);
                    Boolean bl2 = null;
                    if (n8 == -1) {
                        string3 = string2.trim();
                        bl2 = Boolean.TRUE;
                    } else {
                        string3 = string2.substring(0, n8).trim();
                        String string5 = string2.substring(n8 + 1).trim();
                        if (string5.length() == 1) {
                            n4 = string5.charAt(0);
                            if (n4 == 43) {
                                bl2 = Boolean.TRUE;
                            } else if (n4 == 45) {
                                bl2 = Boolean.FALSE;
                            }
                        }
                        if (bl2 == null) {
                            throw new IllegalStateException("Missing leap second sign.");
                        }
                    }
                    if ((n3 = this.table.put(new SimpleDate(n5 = Integer.parseInt(string3.substring(0, 4)), n4 = Integer.parseInt(string3.substring(5, 7)), n2 = Integer.parseInt(string3.substring(8, 10))), bl2 != false ? 1 : -1)) == null) continue;
                    throw new IllegalStateException("Duplicate leap second event found.");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        this.source = "";
        System.err.println("Warning: File \"" + string + "\" not found.");
        this.expires = simpleDate;
    }

    @Override
    public Map<GregorianDate, Integer> getLeapSecondTable() {
        return Collections.unmodifiableMap(this.table);
    }

    @Override
    public boolean supportsNegativeLS() {
        return true;
    }

    @Override
    public GregorianDate getDateOfEvent(int n2, int n3, int n4) {
        return new SimpleDate(n2, n3, n4);
    }

    @Override
    public GregorianDate getDateOfExpiration() {
        return this.expires;
    }

    public String toString() {
        return this.source;
    }
}

