/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarWeek;
import net.time4j.range.SingleUnitTimeSpan;

public final class Weeks
extends SingleUnitTimeSpan<CalendarUnit, Weeks> {
    public static final Weeks ZERO = new Weeks(0);
    public static final Weeks ONE = new Weeks(1);
    private static final long serialVersionUID = 78946640166405240L;

    private Weeks(int n2) {
        super(n2, CalendarUnit.WEEKS);
    }

    public static Weeks of(int n2) {
        return n2 == 0 ? ZERO : (n2 == 1 ? ONE : new Weeks(n2));
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Weeks between(T t2, T t3) {
        long l2 = CalendarUnit.WEEKS.between(t2, t3);
        return Weeks.of(MathUtils.safeCast(l2));
    }

    public static Weeks between(CalendarWeek calendarWeek, CalendarWeek calendarWeek2) {
        PlainDate plainDate = calendarWeek.at(Weekday.MONDAY);
        PlainDate plainDate2 = calendarWeek2.at(Weekday.MONDAY);
        return Weeks.between(plainDate, plainDate2);
    }

    public static Weeks parsePeriod(String string) throws ParseException {
        int n2 = SingleUnitTimeSpan.parsePeriod(string, 'W');
        return Weeks.of(n2);
    }

    @Override
    Weeks with(int n2) {
        return Weeks.of(n2);
    }

    @Override
    Weeks self() {
        return this;
    }
}

