/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.time4j.AdjustableElement;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.MachineTime;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.InfinityStyle;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class MomentInterval
extends IsoInterval<Moment, MomentInterval>
implements Serializable {
    public static final MomentInterval ALWAYS = MomentIntervalFactory.INSTANCE.between(Boundary.infinitePast(), Boundary.infiniteFuture());
    public static double LEFT_ALIGNED = 1.0;
    public static double CENTERED = 0.5;
    public static double RIGHT_ALIGNED = 0.0;
    private static final int MRD = 1000000000;
    private static final long serialVersionUID = -5403584519478162113L;
    private static final Comparator<ChronoInterval<Moment>> COMPARATOR = new IntervalComparator<Moment>(Moment.axis());
    private static final ChronoPrinter<Integer> NOOP = (n2, stringBuilder, attributeQuery) -> Collections.emptySet();

    MomentInterval(Boundary<Moment> boundary, Boundary<Moment> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<Moment>> comparator() {
        return COMPARATOR;
    }

    public static MomentInterval between(Moment moment, Moment moment2) {
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), Boundary.of(IntervalEdge.OPEN, moment2));
    }

    public static MomentInterval between(Instant instant, Instant instant2) {
        return MomentInterval.between(Moment.from(instant), Moment.from(instant2));
    }

    public static MomentInterval since(Moment moment) {
        Boundary<Moment> boundary = Boundary.infiniteFuture();
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), boundary);
    }

    public static MomentInterval since(Instant instant) {
        return MomentInterval.since(Moment.from(instant));
    }

    public static MomentInterval until(Moment moment) {
        Boundary<Moment> boundary = Boundary.infinitePast();
        return new MomentInterval(boundary, Boundary.of(IntervalEdge.OPEN, moment));
    }

    public static MomentInterval until(Instant instant) {
        return MomentInterval.until(Moment.from(instant));
    }

    public static MomentInterval surrounding(Moment moment, MachineTime<?> machineTime, double d2) {
        if (Double.compare(d2, 0.0) < 0 || Double.compare(d2, 1.0) > 0) {
            throw new IllegalArgumentException("Out of range: " + d2);
        }
        Moment moment2 = MomentInterval.subtract(moment, machineTime.multipliedBy(d2));
        return MomentInterval.between(moment2, d2 == 1.0 ? moment : MomentInterval.add(moment2, machineTime));
    }

    public static MomentInterval surrounding(Instant instant, java.time.Duration duration, double d2) {
        return MomentInterval.surrounding(Moment.from(instant), MachineTime.from(duration), d2);
    }

    public static MomentInterval from(ChronoInterval<Moment> chronoInterval) {
        if (chronoInterval instanceof MomentInterval) {
            return (MomentInterval)MomentInterval.class.cast(chronoInterval);
        }
        return new MomentInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public Moment getStartAsMoment() {
        return (Moment)this.getStart().getTemporal();
    }

    public Instant getStartAsInstant() {
        Moment moment = this.getStartAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public Moment getEndAsMoment() {
        return (Moment)this.getEnd().getTemporal();
    }

    public Instant getEndAsInstant() {
        Moment moment = this.getEndAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public TimestampInterval toLocalInterval() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toLocalTimestamp();
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toLocalTimestamp();
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(TZID tZID) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(tZID);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(tZID);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(String string) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(string);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(string);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public Duration<IsoUnit> getNominalDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        return this.toZonalInterval(timezone.getID()).getDuration(timezone, isoUnitArray);
    }

    public MachineTime<TimeUnit> getSimpleDuration() {
        boolean bl2;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl3 = bl2 = moment == null;
        if (bl2) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime<TimeUnit> machineTime = MachineTime.ON_POSIX_SCALE.between((Moment)this.getTemporalOfClosedStart(), moment);
        if (bl2) {
            return machineTime.plus(1L, TimeUnit.NANOSECONDS);
        }
        return machineTime;
    }

    public MachineTime<SI> getRealDuration() {
        boolean bl2;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl3 = bl2 = moment == null;
        if (bl2) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime<SI> machineTime = MachineTime.ON_UTC_SCALE.between((Moment)this.getTemporalOfClosedStart(), moment);
        if (bl2) {
            return machineTime.plus(1L, SI.NANOSECONDS);
        }
        return machineTime;
    }

    public MomentInterval move(long l2, TimeUnit timeUnit) {
        if (l2 == 0L) {
            return this;
        }
        Boundary<Moment> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Moment)((Moment)this.getStart().getTemporal()).plus(l2, timeUnit));
        Boundary<Moment> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Moment)((Moment)this.getEnd().getTemporal()).plus(l2, timeUnit));
        return new MomentInterval(boundary, boundary2);
    }

    public MomentInterval move(long l2, SI sI) {
        if (l2 == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((Moment)this.getStart().getTemporal()).plus(l2, sI));
        Boundary<Moment> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((Moment)this.getEnd().getTemporal()).plus(l2, sI));
        return new MomentInterval((Boundary<Moment>)boundary, boundary2);
    }

    public Stream<Moment> stream(MachineTime<?> machineTime) {
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        Moment moment = momentInterval.getStartAsMoment();
        Moment moment2 = momentInterval.getEndAsMoment();
        if (moment == null || moment2 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        return MomentInterval.stream(machineTime, moment, moment2);
    }

    public static Stream<Moment> stream(MachineTime<?> machineTime, Moment moment, Moment moment2) {
        if (!machineTime.isPositive()) {
            throw new IllegalArgumentException("Duration must be positive: " + machineTime);
        }
        int n2 = moment.compareTo(moment2);
        if (n2 > 0) {
            throw new IllegalArgumentException("Start after end: " + moment + "/" + moment2);
        }
        if (n2 == 0) {
            return Stream.empty();
        }
        if (machineTime.getScale() == TimeScale.UTC) {
            return MomentInterval.streamUTC((MachineTime)MomentInterval.cast(machineTime), moment, moment2);
        }
        return MomentInterval.streamPOSIX((MachineTime)MomentInterval.cast(machineTime), moment, moment2);
    }

    public Moment random() {
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        if (momentInterval.isFinite() && !momentInterval.isEmpty()) {
            int n2;
            Moment moment = momentInterval.getStartAsMoment();
            Moment moment2 = momentInterval.getEndAsMoment();
            double d2 = 1.0E9;
            double d3 = (double)moment.getPosixTime() + (double)moment.getNanosecond() / d2;
            double d4 = (double)moment2.getPosixTime() + (double)moment2.getNanosecond() / d2;
            double d5 = ThreadLocalRandom.current().nextDouble(d3, d4);
            long l2 = (long)Math.floor(d5);
            Moment moment3 = Moment.of(l2, n2 = (int)(1.0E9 * (d5 - (double)l2)), TimeScale.POSIX);
            if (moment3.isBefore(moment)) {
                moment3 = moment;
            } else if (moment3.isAfterOrEqual(moment2)) {
                moment3 = (Moment)moment2.minus(1L, TimeUnit.NANOSECONDS);
            }
            return moment3;
        }
        throw new IllegalStateException("Cannot get random moment in an empty or infinite interval: " + this);
    }

    public String formatISO(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset, InfinityStyle infinityStyle) {
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder(65);
        ChronoPrinter<Moment> chronoPrinter = Iso8601Format.ofMoment(isoDateStyle, isoDecimalStyle, clockUnit, zonalOffset);
        if (momentInterval.getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter.print(momentInterval.getStartAsMoment(), stringBuilder);
        }
        stringBuilder.append('/');
        if (momentInterval.getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter.print(momentInterval.getEndAsMoment(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String formatReduced(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset, InfinityStyle infinityStyle) {
        ChronoPrinter<Moment> chronoPrinter;
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        Moment moment = momentInterval.getStartAsMoment();
        Moment moment2 = momentInterval.getEndAsMoment();
        StringBuilder stringBuilder = new StringBuilder(65);
        ChronoPrinter<Moment> chronoPrinter2 = Iso8601Format.ofMoment(isoDateStyle, isoDecimalStyle, clockUnit, zonalOffset);
        if (momentInterval.getStart().isInfinite()) {
            chronoPrinter = null;
            if (infinityStyle == InfinityStyle.MIN_MAX) {
                chronoPrinter = Iso8601Format.ofMoment(isoDateStyle, isoDecimalStyle, clockUnit, ZonalOffset.UTC);
            }
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter2.print(moment, stringBuilder);
        }
        stringBuilder.append('/');
        if (momentInterval.isFinite()) {
            PlainDate plainDate;
            chronoPrinter = moment2.toZonalTimestamp(zonalOffset);
            PlainDate plainDate2 = moment.toZonalTimestamp(zonalOffset).getCalendarDate();
            if (!plainDate2.equals(plainDate = ((PlainTimestamp)((Object)chronoPrinter)).getCalendarDate())) {
                DateInterval.getEndPrinter(isoDateStyle, plainDate2, plainDate).print(plainDate, stringBuilder);
            }
            stringBuilder.append('T');
            ChronoPrinter<PlainTime> chronoPrinter3 = isoDateStyle.isExtended() ? Iso8601Format.ofExtendedTime(isoDecimalStyle, clockUnit) : Iso8601Format.ofBasicTime(isoDecimalStyle, clockUnit);
            Set<ElementPosition> set = chronoPrinter3.print(((PlainTimestamp)((Object)chronoPrinter)).getWallTime(), stringBuilder);
            if (moment2.isLeapSecond()) {
                for (ElementPosition elementPosition : set) {
                    if (elementPosition.getElement() != PlainTime.SECOND_OF_MINUTE) continue;
                    stringBuilder.replace(elementPosition.getStartIndex(), elementPosition.getEndIndex(), "60");
                    break;
                }
            }
        } else if (momentInterval.getEnd().isInfinite()) {
            chronoPrinter = null;
            if (infinityStyle == InfinityStyle.MIN_MAX) {
                chronoPrinter = Iso8601Format.ofMoment(isoDateStyle, isoDecimalStyle, clockUnit, ZonalOffset.UTC);
            }
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter2.print(moment2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser) throws ParseException {
        return MomentInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, MomentIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        MomentInterval momentInterval = (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
        if (momentInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length() && !chronoParser.getAttributes().get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return momentInterval;
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, char c2, ChronoParser<Moment> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c2).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static MomentInterval parseISO(String string) throws ParseException {
        int n2;
        int n3;
        int n4;
        boolean bl2;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n5 = 0;
        int n6 = Math.min(string.length(), 117);
        boolean bl3 = true;
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        boolean bl4 = bl2 = string.charAt(0) == '-';
        if (string.charAt(0) == 'P' || bl2) {
            for (n4 = 1; n4 < n6; ++n4) {
                if (string.charAt(n4) != '/') continue;
                if (n4 + 1 == n6) {
                    throw new ParseException("Missing end component.", n6);
                }
                if (bl2) {
                    if (string.charAt(1) != '\u221e' && n4 != 1) break;
                    n5 = n4 + 1;
                    break;
                }
                n5 = n4 + 1;
                break;
            }
        }
        n4 = 0;
        int n10 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int n11 = -1;
        for (n3 = n5 + 1; n3 < n6; ++n3) {
            n2 = string.charAt(n3);
            if (bl8) {
                if (n2 == 80 || n2 == 45 && n3 == n6 - 1 || n2 == 43 && n3 == n6 - 2 && string.charAt(n3 + 1) == '\u221e') {
                    bl8 = false;
                    break;
                }
                if (n2 == 84 || n9 > 0) {
                    ++n9;
                    continue;
                }
                if (n2 == 87) {
                    bl7 = true;
                } else if (n2 == 45 && n3 > n11 + 1) {
                    ++n10;
                }
                ++n8;
                continue;
            }
            if (n2 == 47) {
                if (n11 == -1) {
                    n11 = n3;
                    bl8 = true;
                    n9 = 0;
                    continue;
                }
                throw new ParseException("Interval with two slashes found: " + string, n3);
            }
            if (n2 == 84 || n9 > 0) {
                ++n9;
                continue;
            }
            if (n2 == 45) {
                ++n7;
                ++n4;
                continue;
            }
            if (n2 == 87) {
                ++n7;
                bl6 = true;
                continue;
            }
            ++n7;
        }
        if (bl8 && bl6 != bl7) {
            throw new ParseException("Mixed date styles not allowed.", n6);
        }
        n3 = string.charAt(n5);
        n2 = n7 - 4;
        if (n3 == 43 || n3 == 45) {
            n2 -= 2;
        }
        if (!bl6) {
            bl5 = n4 == 1 || n4 == 0 && n2 == 3;
        }
        boolean bl9 = n4 > 0;
        boolean bl10 = true;
        if (bl8) {
            if (n9 == 0) {
                bl10 = false;
                n9 = n8;
                n8 = 0;
            }
            bl3 = n7 == n8 && n4 == n10 && MomentInterval.hasSecondOffset(string, n6);
        }
        ChronoFormatter<Moment> chronoFormatter = bl9 ? Iso8601Format.EXTENDED_DATE_TIME_OFFSET : Iso8601Format.BASIC_DATE_TIME_OFFSET;
        ChronoFormatter<Moment> chronoFormatter2 = bl3 ? chronoFormatter : null;
        Parser parser = new Parser(chronoFormatter, chronoFormatter2, bl9, bl6, bl5, n9, bl10);
        return (MomentInterval)parser.parse(string);
    }

    @Override
    IntervalFactory<Moment, MomentInterval> getFactory() {
        return MomentIntervalFactory.INSTANCE;
    }

    @Override
    MomentInterval getContext() {
        return this;
    }

    private static boolean hasSecondOffset(String string, int n2) {
        char c2;
        if (string.charAt(n2 - 1) == 'Z') {
            return true;
        }
        int n3 = Math.max(0, n2 - 6);
        for (int i2 = n2 - 1; i2 >= n3 && (c2 = string.charAt(i2)) != 'T' && c2 != '/' && c2 != '.' && c2 != ','; --i2) {
            if (c2 != '+' && c2 != '-') continue;
            return true;
        }
        return false;
    }

    private static Moment add(Moment moment, MachineTime<?> machineTime) {
        if (machineTime.getScale() == TimeScale.UTC) {
            MachineTime<SI> machineTime2 = machineTime;
            return moment.plus(machineTime2);
        }
        MachineTime<SI> machineTime3 = machineTime;
        return (Moment)moment.plus(machineTime3);
    }

    private static Moment subtract(Moment moment, MachineTime<?> machineTime) {
        if (machineTime.getScale() == TimeScale.UTC) {
            MachineTime<SI> machineTime2 = machineTime;
            return moment.minus(machineTime2);
        }
        MachineTime<SI> machineTime3 = machineTime;
        return (Moment)moment.minus(machineTime3);
    }

    private static Stream<Moment> streamPOSIX(MachineTime<TimeUnit> machineTime, Moment moment, Moment moment2) {
        int n3;
        double d2 = 0.0;
        for (TimeSpan.Item<TimeUnit> item : machineTime.getTotalLength()) {
            d2 += (double)TimeUnit.SECONDS.convert(item.getAmount(), item.getUnit());
        }
        double d3 = d2 < 1.0 ? (double)moment.until(moment2, TimeUnit.NANOSECONDS) / (d2 * 1.0E9) : (double)moment.until(moment2, TimeUnit.SECONDS) / d2;
        if (Double.compare(d3, 2.147483647E9) >= 0) {
            throw new ArithmeticException();
        }
        boolean bl2 = false;
        for (n3 = (int)Math.floor(d3); n3 > 0 && !((Moment)moment.plus(machineTime.multipliedBy(n3))).isBefore(moment2); --n3) {
            bl2 = true;
        }
        int n4 = n3 + 1;
        if (!bl2) {
            do {
                n4 = Math.addExact(n3, 1);
            } while (((Moment)moment.plus(machineTime.multipliedBy(++n3))).isBefore(moment2));
        }
        if (n4 == 1) {
            return Stream.of(moment);
        }
        return IntStream.range(0, n4).mapToObj(n2 -> (Moment)moment.plus(machineTime.multipliedBy(n2)));
    }

    private static Stream<Moment> streamUTC(MachineTime<SI> machineTime, Moment moment, Moment moment2) {
        int n3;
        double d2 = 0.0;
        for (TimeSpan.Item<SI> item : machineTime.getTotalLength()) {
            d2 += item.getUnit().getLength() * (double)item.getAmount();
        }
        double d3 = d2 < 1.0 ? (double)SI.NANOSECONDS.between(moment, moment2) / (d2 * 1.0E9) : (double)SI.SECONDS.between(moment, moment2) / d2;
        if (Double.compare(d3, 2.147483647E9) >= 0) {
            throw new ArithmeticException();
        }
        boolean bl2 = false;
        for (n3 = (int)Math.floor(d3); n3 > 0 && !moment.plus(machineTime.multipliedBy(n3)).isBefore(moment2); --n3) {
            bl2 = true;
        }
        int n4 = n3 + 1;
        if (!bl2) {
            do {
                n4 = Math.addExact(n3, 1);
            } while (moment.plus(machineTime.multipliedBy(++n3)).isBefore(moment2));
        }
        if (n4 == 1) {
            return Stream.of(moment);
        }
        return IntStream.range(0, n4).mapToObj(n2 -> moment.plus(machineTime.multipliedBy(n2)));
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private Object writeReplace() {
        return new SPX(this, 35);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class Parser
    extends IntervalParser<Moment, MomentInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;
        private final int protectedArea;
        private final boolean hasT;

        Parser(ChronoParser<Moment> chronoParser, ChronoParser<Moment> chronoParser2, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl2;
            this.weekStyle = bl3;
            this.ordinalStyle = bl4;
            this.protectedArea = n2;
            this.hasT = bl5;
        }

        @Override
        protected Moment parseReducedEnd(CharSequence charSequence, Moment moment, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoEntity<?> chronoEntity = parseLog.getRawValues();
            Set<ChronoElement<?>> set = MomentIntervalFactory.INSTANCE.stdElements(chronoEntity);
            TZID tZID = chronoEntity.hasTimezone() ? chronoEntity.getTimezone() : (TZID)attributeQuery.get(Attributes.TIMEZONE_ID, ZonalOffset.UTC);
            Attributes attributes = new Attributes.Builder().setTimezone(tZID).build();
            ChronoFormatter<Moment> chronoFormatter = this.createEndFormat(Moment.axis().preformat(moment, attributes), set, attributes);
            return chronoFormatter.parse(charSequence, parseLog2);
        }

        private ChronoFormatter<Moment> createEndFormat(ChronoDisplay chronoDisplay, Set<ChronoElement<?>> set, Attributes attributes) {
            int n2;
            AdjustableElement<Integer, PlainDate> adjustableElement;
            ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
            AdjustableElement<Integer, PlainDate> adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n2 = (this.ordinalStyle ? 3 : 5) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
                builder.addCustomized(adjustableElement, NOOP, this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR);
            } else {
                n2 = (this.ordinalStyle ? 3 : 4) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
                builder.addInteger(adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + this.protectedArea);
                builder.addCustomized(Weekmodel.ISO.weekOfYear(), NOOP, this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR);
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1);
                builder.endSection();
            } else if (this.ordinalStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger(PlainDate.DAY_OF_YEAR, 3);
                builder.endSection();
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + this.protectedArea);
                if (this.extended) {
                    builder.addCustomized(PlainDate.MONTH_AS_NUMBER, NOOP, FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger(PlainDate.DAY_OF_MONTH, 2);
                builder.endSection();
            }
            if (this.hasT) {
                builder.addLiteral('T');
            }
            builder.addCustomized(PlainTime.COMPONENT, this.extended ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
            builder.startOptionalSection();
            builder.addTimezoneOffset(FormatStyle.SHORT, this.extended, Collections.singletonList("Z"));
            builder.endSection();
            for (ChronoElement<?> chronoElement : set) {
                Parser.setDefault(builder, chronoElement, chronoDisplay);
            }
            return builder.build(attributes);
        }

        private static <V> void setDefault(ChronoFormatter.Builder<Moment> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

