/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.function.LongFunction;
import net.time4j.Quarter;
import net.time4j.engine.TimeLine;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.CalendarWeek;
import net.time4j.range.CalendarYear;
import net.time4j.range.FixedCalendarInterval;

final class FixedCalendarTimeLine<T extends FixedCalendarInterval<T>>
implements TimeLine<T>,
Serializable {
    private static final FixedCalendarTimeLine<CalendarYear> Y = new FixedCalendarTimeLine<CalendarYear>('Y', CalendarYear::from, CalendarYear.from(-999999999L), CalendarYear.from(999999999L));
    private static final FixedCalendarTimeLine<CalendarQuarter> Q = new FixedCalendarTimeLine<CalendarQuarter>('Q', CalendarQuarter::from, CalendarQuarter.of(-999999999, Quarter.Q1), CalendarQuarter.of(999999999, Quarter.Q4));
    private static final FixedCalendarTimeLine<CalendarMonth> M = new FixedCalendarTimeLine<CalendarMonth>('M', CalendarMonth::from, CalendarMonth.of(-999999999, 1), CalendarMonth.of(999999999, 12));
    private static final FixedCalendarTimeLine<CalendarWeek> W = new FixedCalendarTimeLine<CalendarWeek>('W', CalendarWeek::from, CalendarWeek.of(-999999999, 1), CalendarWeek.of(999999999, 52));
    private static final long serialVersionUID = 9110377577503410192L;
    private final char type;
    private final transient LongFunction<T> from;
    private final transient T min;
    private final transient T max;

    private FixedCalendarTimeLine(char c2, LongFunction<T> longFunction, T t2, T t3) {
        this.type = c2;
        this.from = longFunction;
        this.min = t2;
        this.max = t3;
    }

    static FixedCalendarTimeLine<CalendarYear> forYears() {
        return Y;
    }

    static FixedCalendarTimeLine<CalendarQuarter> forQuarters() {
        return Q;
    }

    static FixedCalendarTimeLine<CalendarMonth> forMonths() {
        return M;
    }

    static FixedCalendarTimeLine<CalendarWeek> forWeeks() {
        return W;
    }

    @Override
    public T stepForward(T t2) {
        if (t2.equals(this.max)) {
            return null;
        }
        return (T)((FixedCalendarInterval)this.from.apply(((FixedCalendarInterval)t2).toProlepticNumber() + 1L));
    }

    @Override
    public T stepBackwards(T t2) {
        if (t2.equals(this.min)) {
            return null;
        }
        return (T)((FixedCalendarInterval)this.from.apply(((FixedCalendarInterval)t2).toProlepticNumber() - 1L));
    }

    @Override
    public T getMinimum() {
        return this.min;
    }

    @Override
    public T getMaximum() {
        return this.max;
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    @Override
    public int compare(T t2, T t3) {
        long l2;
        long l3 = ((FixedCalendarInterval)t2).toProlepticNumber();
        return l3 < (l2 = ((FixedCalendarInterval)t3).toProlepticNumber()) ? -1 : (l3 > l2 ? 1 : 0);
    }

    LongFunction<T> mapper() {
        return this.from;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.type) {
            case 'Y': {
                return Y;
            }
            case 'Q': {
                return Q;
            }
            case 'M': {
                return M;
            }
            case 'W': {
                return W;
            }
        }
        throw new StreamCorruptedException();
    }
}

