/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Serializable;
import java.util.stream.Stream;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.engine.ChronoEntity;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.ValueInterval;

public abstract class FixedCalendarInterval<T extends FixedCalendarInterval<T>>
extends ChronoEntity<T>
implements Comparable<T>,
ChronoInterval<PlainDate>,
Iterable<PlainDate>,
Serializable {
    FixedCalendarInterval() {
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(ChronoInterval<PlainDate> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getStart().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            if (plainDate2.equals(PlainDate.axis().getMaximum())) {
                return false;
            }
            plainDate2 = plainDate2.plus(1L, CalendarUnit.DAYS);
        }
        if (plainDate.isAfter(plainDate2)) {
            return false;
        }
        PlainDate plainDate3 = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate4 = chronoInterval.getEnd().getTemporal();
        if (chronoInterval.getEnd().isOpen()) {
            if (plainDate2.isSimultaneous(plainDate4)) {
                return !plainDate2.isAfter(plainDate3);
            }
            if (plainDate4.equals(PlainDate.axis().getMinimum())) {
                return false;
            }
            plainDate4 = plainDate4.minus(1L, CalendarUnit.DAYS);
        }
        return !plainDate3.isBefore(plainDate4);
    }

    @Override
    public boolean isBefore(ChronoInterval<PlainDate> chronoInterval) {
        if (chronoInterval.getStart().isInfinite()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            if (plainDate2.equals(PlainDate.axis().getMaximum())) {
                return true;
            }
            plainDate2 = plainDate2.plus(1L, CalendarUnit.DAYS);
        }
        return plainDate.isBefore(plainDate2);
    }

    @Override
    public boolean abuts(ChronoInterval<PlainDate> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getStart().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (plainDate2 != null && chronoInterval.getStart().isOpen()) {
            plainDate2 = plainDate2.plus(1L, CalendarUnit.DAYS);
        }
        PlainDate plainDate3 = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate4 = chronoInterval.getEnd().getTemporal();
        try {
            plainDate3 = plainDate3.plus(1L, CalendarUnit.DAYS);
        }
        catch (ArithmeticException arithmeticException) {
            return plainDate4 != null && plainDate.isSimultaneous(plainDate4);
        }
        try {
            if (plainDate4 == null) {
                return plainDate2 != null && plainDate3.isSimultaneous(plainDate2);
            }
            if (chronoInterval.getEnd().isClosed()) {
                plainDate4 = plainDate4.plus(1L, CalendarUnit.DAYS);
            }
        }
        catch (ArithmeticException arithmeticException) {
            return plainDate2 != null && plainDate3.isSimultaneous(plainDate2);
        }
        if (plainDate2 == null) {
            return plainDate.isSimultaneous(plainDate4);
        }
        if (plainDate4 == null) {
            return plainDate3.isSimultaneous(plainDate2);
        }
        return plainDate3.isSimultaneous(plainDate2) ^ plainDate.isSimultaneous(plainDate4);
    }

    public boolean isSimultaneous(T t2) {
        return this.compareTo(t2) == 0;
    }

    public DateInterval toFlexInterval() {
        return new DateInterval(this.getStart(), this.getEnd());
    }

    public Stream<PlainDate> streamDaily() {
        return DateInterval.streamDaily((PlainDate)this.getStart().getTemporal(), (PlainDate)this.getEnd().getTemporal());
    }

    public <V> ValueInterval<PlainDate, T, V> withValue(V v2) {
        return new ValueInterval((FixedCalendarInterval)this.getContext(), v2);
    }

    static void formatYear(StringBuilder stringBuilder, int n2) {
        int n3 = n2;
        if (n3 < 0) {
            stringBuilder.append('-');
            n3 = Math.negateExact(n2);
        }
        if (n3 >= 10000) {
            if (n2 > 0) {
                stringBuilder.append('+');
            }
        } else if (n3 < 1000) {
            stringBuilder.append('0');
            if (n3 < 100) {
                stringBuilder.append('0');
                if (n3 < 10) {
                    stringBuilder.append('0');
                }
            }
        }
        stringBuilder.append(n3);
    }

    abstract long toProlepticNumber();
}

