/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.time4j.AdjustableElement;
import net.time4j.CalendarUnit;
import net.time4j.Duration;
import net.time4j.IsoDateUnit;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekcycle;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.PatternType;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateIntervalFactory;
import net.time4j.range.DayPartitionRule;
import net.time4j.range.FixedNumParser;
import net.time4j.range.InfinityStyle;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;
import net.time4j.tz.GapResolver;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class DateInterval
extends IsoInterval<PlainDate, DateInterval>
implements Serializable {
    public static final DateInterval ALWAYS = DateIntervalFactory.INSTANCE.between(Boundary.infinitePast(), Boundary.infiniteFuture());
    private static final long serialVersionUID = 8074261825266036014L;
    private static final Comparator<ChronoInterval<PlainDate>> COMPARATOR = new IntervalComparator<PlainDate>(PlainDate.axis());
    private static final ChronoPrinter<PlainDate> REDUCED_DD = ChronoFormatter.ofDatePattern("dd", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_MMDD = ChronoFormatter.ofDatePattern("MMdd", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_MM_DD = ChronoFormatter.ofDatePattern("MM-dd", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_E = ChronoFormatter.ofDatePattern("e", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_W_WWE = ChronoFormatter.ofDatePattern("'W'wwe", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_W_WW_E = ChronoFormatter.ofDatePattern("'W'ww-e", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<PlainDate> REDUCED_DDD = ChronoFormatter.ofDatePattern("DDD", PatternType.CLDR, Locale.ROOT);
    private static final ChronoPrinter<Integer> NOOP = (n2, stringBuilder, attributeQuery) -> Collections.emptySet();

    DateInterval(Boundary<PlainDate> boundary, Boundary<PlainDate> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<PlainDate>> comparator() {
        return COMPARATOR;
    }

    public static DateInterval between(PlainDate plainDate, PlainDate plainDate2) {
        return new DateInterval(Boundary.of(IntervalEdge.CLOSED, plainDate), Boundary.of(IntervalEdge.CLOSED, plainDate2));
    }

    public static DateInterval between(LocalDate localDate, LocalDate localDate2) {
        return DateInterval.between(PlainDate.from(localDate), PlainDate.from(localDate2));
    }

    public static DateInterval since(PlainDate plainDate) {
        Boundary<PlainDate> boundary = Boundary.infiniteFuture();
        return new DateInterval(Boundary.of(IntervalEdge.CLOSED, plainDate), boundary);
    }

    public static DateInterval since(LocalDate localDate) {
        return DateInterval.since(PlainDate.from(localDate));
    }

    public static DateInterval until(PlainDate plainDate) {
        Boundary<PlainDate> boundary = Boundary.infinitePast();
        return new DateInterval(boundary, Boundary.of(IntervalEdge.CLOSED, plainDate));
    }

    public static DateInterval until(LocalDate localDate) {
        return DateInterval.until(PlainDate.from(localDate));
    }

    public static DateInterval atomic(PlainDate plainDate) {
        return DateInterval.between(plainDate, plainDate);
    }

    public static DateInterval atomic(LocalDate localDate) {
        return DateInterval.atomic(PlainDate.from(localDate));
    }

    public static DateInterval emptyWithAnchor(PlainDate plainDate) {
        return new DateInterval(Boundary.of(IntervalEdge.CLOSED, plainDate), Boundary.of(IntervalEdge.OPEN, plainDate));
    }

    public static DateInterval emptyWithAnchor(LocalDate localDate) {
        return DateInterval.emptyWithAnchor(PlainDate.from(localDate));
    }

    public static DateInterval ofCurrentWeek(TimeSource timeSource, TZID tZID, Weekday weekday) {
        PlainDate plainDate = Moment.from(timeSource.currentTime()).toZonalTimestamp(tZID).toDate();
        PlainDate plainDate2 = plainDate.with(PlainDate.DAY_OF_WEEK.setToPreviousOrSame(weekday));
        PlainDate plainDate3 = plainDate2.plus(6L, CalendarUnit.DAYS);
        return DateInterval.between(plainDate2, plainDate3);
    }

    public static DateInterval from(ChronoInterval<PlainDate> chronoInterval) {
        if (chronoInterval instanceof DateInterval) {
            return (DateInterval)DateInterval.class.cast(chronoInterval);
        }
        return new DateInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public PlainDate getStartAsCalendarDate() {
        return (PlainDate)this.getStart().getTemporal();
    }

    public LocalDate getStartAsLocalDate() {
        PlainDate plainDate = this.getStartAsCalendarDate();
        return plainDate == null ? null : plainDate.toTemporalAccessor();
    }

    public PlainDate getEndAsCalendarDate() {
        return (PlainDate)this.getEnd().getTemporal();
    }

    public LocalDate getEndAsLocalDate() {
        PlainDate plainDate = this.getEndAsCalendarDate();
        return plainDate == null ? null : plainDate.toTemporalAccessor();
    }

    public TimestampInterval toFullDays() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        PlainDate plainDate;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainDate = (PlainDate)this.getStart().getTemporal();
            plainTimestamp = this.getStart().isOpen() ? plainDate.at(PlainTime.midnightAtEndOfDay()) : plainDate.atStartOfDay();
            boundary2 = Boundary.of(IntervalEdge.CLOSED, plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainDate = (PlainDate)this.getEnd().getTemporal();
            plainTimestamp = this.getEnd().isOpen() ? plainDate.atStartOfDay() : plainDate.at(PlainTime.midnightAtEndOfDay());
            boundary = Boundary.of(IntervalEdge.OPEN, plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public MomentInterval inTimezone(TZID tZID) {
        return this.toFullDays().in(Timezone.of(tZID).with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET)));
    }

    public long getLengthInDays() {
        if (this.isFinite()) {
            long l2 = CalendarUnit.DAYS.between((PlainDate)this.getStart().getTemporal(), (PlainDate)this.getEnd().getTemporal());
            if (this.getStart().isOpen()) {
                --l2;
            }
            if (this.getEnd().isClosed()) {
                ++l2;
            }
            return l2;
        }
        throw new UnsupportedOperationException("An infinite interval has no finite duration.");
    }

    public Duration<CalendarUnit> getDurationInYearsMonthsDays() {
        boolean bl2;
        PlainDate plainDate = (PlainDate)this.getTemporalOfOpenEnd();
        boolean bl3 = bl2 = plainDate == null;
        if (bl2) {
            plainDate = (PlainDate)this.getEnd().getTemporal();
        }
        Duration<CalendarUnit> duration = Duration.inYearsMonthsDays().between((PlainDate)this.getTemporalOfClosedStart(), plainDate);
        if (bl2) {
            return duration.plus(1L, CalendarUnit.DAYS);
        }
        return duration;
    }

    public Duration<CalendarUnit> getDuration(CalendarUnit ... calendarUnitArray) {
        boolean bl2;
        PlainDate plainDate = (PlainDate)this.getTemporalOfOpenEnd();
        boolean bl3 = bl2 = plainDate == null;
        if (bl2) {
            plainDate = (PlainDate)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in((IsoUnit[])calendarUnitArray).between((PlainDate)this.getTemporalOfClosedStart(), plainDate);
        if (bl2) {
            return duration.plus(1L, CalendarUnit.DAYS);
        }
        return duration;
    }

    public DateInterval move(long l2, IsoDateUnit isoDateUnit) {
        if (l2 == 0L) {
            return this;
        }
        Boundary<PlainDate> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (PlainDate)((PlainDate)this.getStart().getTemporal()).plus(l2, isoDateUnit));
        Boundary<PlainDate> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (PlainDate)((PlainDate)this.getEnd().getTemporal()).plus(l2, isoDateUnit));
        return new DateInterval(boundary, boundary2);
    }

    public Stream<PlainDate> streamDaily() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        PlainDate plainDate = dateInterval.getStartAsCalendarDate();
        PlainDate plainDate2 = dateInterval.getEndAsCalendarDate();
        if (plainDate == null || plainDate2 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        return StreamSupport.stream(new DailySpliterator(plainDate, plainDate2), false);
    }

    public static Stream<PlainDate> streamDaily(PlainDate plainDate, PlainDate plainDate2) {
        long l2;
        long l3 = plainDate.getDaysSinceEpochUTC();
        if (l3 > (l2 = plainDate2.getDaysSinceEpochUTC())) {
            throw new IllegalArgumentException("Start after end: " + plainDate + "/" + plainDate2);
        }
        return StreamSupport.stream(new DailySpliterator(plainDate, l3, l2), false);
    }

    public Stream<PlainDate> stream(Duration<CalendarUnit> duration) {
        if (this.isEmpty() && duration.isPositive()) {
            return Stream.empty();
        }
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        PlainDate plainDate = dateInterval.getStartAsCalendarDate();
        PlainDate plainDate2 = dateInterval.getEndAsCalendarDate();
        if (plainDate == null || plainDate2 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        return DateInterval.stream(duration, plainDate, plainDate2);
    }

    public static Stream<PlainDate> stream(Duration<CalendarUnit> duration, PlainDate plainDate, PlainDate plainDate2) {
        long l2;
        PlainDate plainDate3;
        long l3;
        long l5;
        if (!duration.isPositive()) {
            throw new IllegalArgumentException("Duration must be positive: " + duration);
        }
        long l6 = 0L;
        long l7 = 0L;
        block10: for (TimeSpan.Item<CalendarUnit> item : duration.getTotalLength()) {
            l5 = item.getAmount();
            switch (item.getUnit()) {
                case MILLENNIA: {
                    l6 = Math.addExact(l6, Math.multiplyExact(12000L, l5));
                    continue block10;
                }
                case CENTURIES: {
                    l6 = Math.addExact(l6, Math.multiplyExact(1200L, l5));
                    continue block10;
                }
                case DECADES: {
                    l6 = Math.addExact(l6, Math.multiplyExact(120L, l5));
                    continue block10;
                }
                case YEARS: {
                    l6 = Math.addExact(l6, Math.multiplyExact(12L, l5));
                    continue block10;
                }
                case QUARTERS: {
                    l6 = Math.addExact(l6, Math.multiplyExact(3L, l5));
                    continue block10;
                }
                case MONTHS: {
                    l6 = Math.addExact(l6, l5);
                    continue block10;
                }
                case WEEKS: {
                    l7 = Math.addExact(l7, Math.multiplyExact(7L, l5));
                    continue block10;
                }
                case DAYS: {
                    l7 = Math.addExact(l7, l5);
                    continue block10;
                }
            }
            throw new UnsupportedOperationException(item.getUnit().name());
        }
        long l8 = l6;
        l5 = l7;
        if (l8 == 0L && l5 == 1L) {
            return DateInterval.streamDaily(plainDate, plainDate2);
        }
        long l9 = plainDate.getDaysSinceEpochUTC();
        if (l9 > (l3 = plainDate2.getDaysSinceEpochUTC())) {
            throw new IllegalArgumentException("Start after end: " + plainDate + "/" + plainDate2);
        }
        long l10 = 1L + (l3 - l9) / Math.addExact(Math.multiplyExact(l8, 31L), l5);
        do {
            l2 = l10;
            long l11 = Math.multiplyExact(l8, l10);
            long l12 = Math.multiplyExact(l5, l10);
            plainDate3 = plainDate.plus(l11, CalendarUnit.MONTHS).plus(l12, CalendarUnit.DAYS);
            ++l10;
        } while (!plainDate3.isAfter(plainDate2));
        if (l2 == 1L) {
            return Stream.of(plainDate);
        }
        return LongStream.range(0L, l2).mapToObj(l4 -> plainDate.plus(l8 * l4, CalendarUnit.MONTHS).plus(l5 * l4, CalendarUnit.DAYS));
    }

    public Stream<PlainDate> streamExcluding(Predicate<? super PlainDate> predicate) {
        return this.streamDaily().filter(predicate.negate());
    }

    public Stream<PlainDate> streamWeekBased(int n2, int n3, int n4) {
        long l2;
        PlainDate plainDate;
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Found illegal negative duration component.");
        }
        long l3 = n2;
        long l5 = 7L * (long)n3 + (long)n4;
        if (n2 == 0 && l5 == 0L) {
            throw new IllegalArgumentException("Cannot create stream with empty duration.");
        }
        if (this.isEmpty()) {
            return Stream.empty();
        }
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        PlainDate plainDate2 = dateInterval.getStartAsCalendarDate();
        PlainDate plainDate3 = dateInterval.getEndAsCalendarDate();
        if (plainDate2 == null || plainDate3 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        if (l3 == 0L && l5 == 1L) {
            return DateInterval.streamDaily(plainDate2, plainDate3);
        }
        long l6 = plainDate2.getDaysSinceEpochUTC();
        long l7 = plainDate3.getDaysSinceEpochUTC();
        long l8 = 1L + (l7 - l6) / Math.addExact(Math.multiplyExact(l3, 371L), l5);
        do {
            l2 = l8;
            long l9 = Math.multiplyExact(l3, l8);
            long l10 = Math.multiplyExact(l5, l8);
            plainDate = ((PlainDate)plainDate2.plus(l9, Weekcycle.YEARS)).plus(l10, CalendarUnit.DAYS);
            ++l8;
        } while (!plainDate.isAfter(plainDate3));
        if (l2 == 1L) {
            return Stream.of(plainDate2);
        }
        return LongStream.range(0L, l2).mapToObj(l4 -> ((PlainDate)plainDate2.plus(l3 * l4, Weekcycle.YEARS)).plus(l5 * l4, CalendarUnit.DAYS));
    }

    public Stream<TimestampInterval> streamPartitioned(DayPartitionRule dayPartitionRule) {
        return this.streamDaily().flatMap(plainDate -> dayPartitionRule.getPartitions((PlainDate)plainDate).stream().map(chronoInterval -> TimestampInterval.between(plainDate.at((PlainTime)chronoInterval.getStart().getTemporal()), plainDate.at((PlainTime)chronoInterval.getEnd().getTemporal()))));
    }

    public Stream<MomentInterval> streamPartitioned(DayPartitionRule dayPartitionRule, TZID tZID) {
        Timezone timezone = Timezone.of(tZID).with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET));
        return this.streamPartitioned(dayPartitionRule).map(timestampInterval -> timestampInterval.in(timezone)).filter(momentInterval -> !momentInterval.isEmpty());
    }

    public PlainDate random() {
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        if (dateInterval.isFinite() && !dateInterval.isEmpty()) {
            long l2 = ThreadLocalRandom.current().nextLong(dateInterval.getStartAsCalendarDate().getDaysSinceEpochUTC(), dateInterval.getEndAsCalendarDate().getDaysSinceEpochUTC() + 1L);
            return PlainDate.of(l2, EpochDays.UTC);
        }
        throw new IllegalStateException("Cannot get random date in an empty or infinite interval: " + this);
    }

    public String formatISO(IsoDateStyle isoDateStyle, InfinityStyle infinityStyle) {
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder(21);
        ChronoPrinter<PlainDate> chronoPrinter = Iso8601Format.ofDate(isoDateStyle);
        if (dateInterval.getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, PlainDate.axis()));
        } else {
            chronoPrinter.print(dateInterval.getStartAsCalendarDate(), stringBuilder);
        }
        stringBuilder.append('/');
        if (dateInterval.getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, PlainDate.axis()));
        } else {
            chronoPrinter.print(dateInterval.getEndAsCalendarDate(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String formatReduced(IsoDateStyle isoDateStyle, InfinityStyle infinityStyle) {
        DateInterval dateInterval = (DateInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder(21);
        ChronoPrinter<PlainDate> chronoPrinter = Iso8601Format.ofDate(isoDateStyle);
        PlainDate plainDate = dateInterval.getStartAsCalendarDate();
        if (dateInterval.getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, PlainDate.axis()));
        } else {
            chronoPrinter.print(plainDate, stringBuilder);
        }
        stringBuilder.append('/');
        PlainDate plainDate2 = dateInterval.getEndAsCalendarDate();
        if (dateInterval.isFinite()) {
            DateInterval.getEndPrinter(isoDateStyle, plainDate, plainDate2).print(plainDate2, stringBuilder);
        } else if (dateInterval.getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, PlainDate.axis()));
        } else {
            chronoPrinter.print(plainDate2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static DateInterval parse(String string, ChronoParser<PlainDate> chronoParser) throws ParseException {
        return DateInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static DateInterval parse(String string, ChronoParser<PlainDate> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, DateIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static DateInterval parse(CharSequence charSequence, ChronoParser<PlainDate> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        DateInterval dateInterval = (DateInterval)IntervalParser.of(DateIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
        if (dateInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length() && !chronoParser.getAttributes().get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return dateInterval;
    }

    public static DateInterval parse(CharSequence charSequence, ChronoParser<PlainDate> chronoParser, char c2, ChronoParser<PlainDate> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (DateInterval)IntervalParser.of(DateIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c2).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static DateInterval parseISO(String string) throws ParseException {
        char c2;
        int n2;
        int n3;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n4 = 0;
        int n5 = Math.min(string.length(), 48);
        boolean bl2 = true;
        int n6 = 0;
        for (n3 = 1; n3 < n5; ++n3) {
            if (string.charAt(n3) != '/') continue;
            if (n3 + 1 == n5) {
                throw new ParseException("Missing end component.", n5);
            }
            if (string.charAt(0) == 'P' || string.charAt(0) == '-' && (n3 == 1 || string.charAt(1) == '\u221e')) {
                n4 = n3 + 1;
                n6 = n5 - n3 - 1;
                break;
            }
            if (string.charAt(n3 + 1) == 'P' || string.charAt(n3 + 1) == '-' && n3 + 2 == n5 || string.charAt(n3 + 1) == '+' && n3 + 2 < n5 && string.charAt(n3 + 2) == '\u221e') {
                n6 = n3;
                break;
            }
            bl2 = 2 * n3 + 1 == n5;
            n6 = n3;
            break;
        }
        n3 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n2 = n4 + 1; n2 < n5; n2 += 1) {
            c2 = string.charAt(n2);
            if (c2 == '-') {
                ++n3;
                continue;
            }
            if (c2 == 'W') {
                bl4 = true;
                break;
            }
            if (c2 == '/') break;
        }
        n2 = n3 > 0 ? 1 : 0;
        c2 = string.charAt(n4);
        n6 -= 4;
        if (c2 == '+' || c2 == '-') {
            n6 -= 2;
        }
        if (!bl4) {
            boolean bl5 = bl3 = n3 == 1 || n3 == 0 && n6 == 3;
        }
        ChronoFormatter<PlainDate> chronoFormatter = n2 ? (bl3 ? Iso8601Format.EXTENDED_ORDINAL_DATE : (bl4 ? Iso8601Format.EXTENDED_WEEK_DATE : Iso8601Format.EXTENDED_CALENDAR_DATE)) : (bl3 ? Iso8601Format.BASIC_ORDINAL_DATE : (bl4 ? Iso8601Format.BASIC_WEEK_DATE : Iso8601Format.BASIC_CALENDAR_DATE));
        ChronoFormatter<PlainDate> chronoFormatter2 = bl2 ? chronoFormatter : null;
        Parser parser = new Parser(chronoFormatter, chronoFormatter2, n2 != 0, bl4, bl3);
        return (DateInterval)parser.parse(string);
    }

    static ChronoPrinter<PlainDate> getEndPrinter(IsoDateStyle isoDateStyle, PlainDate plainDate, PlainDate plainDate2) {
        ChronoPrinter<PlainDate> chronoPrinter = Iso8601Format.ofDate(isoDateStyle);
        int n2 = plainDate.getYear();
        int n3 = plainDate2.getYear();
        switch (isoDateStyle) {
            case BASIC_CALENDAR_DATE: {
                if (n2 != n3) break;
                chronoPrinter = plainDate.getMonth() == plainDate2.getMonth() ? REDUCED_DD : REDUCED_MMDD;
                break;
            }
            case BASIC_ORDINAL_DATE: {
                if (n2 != n3) break;
                chronoPrinter = REDUCED_DDD;
                break;
            }
            case BASIC_WEEK_DATE: {
                n2 = plainDate.getInt(PlainDate.YEAR_OF_WEEKDATE);
                n3 = plainDate2.getInt(PlainDate.YEAR_OF_WEEKDATE);
                if (n2 != n3) break;
                if (plainDate.getInt(Weekmodel.ISO.weekOfYear()) == plainDate2.getInt(Weekmodel.ISO.weekOfYear())) {
                    chronoPrinter = REDUCED_E;
                    break;
                }
                chronoPrinter = REDUCED_W_WWE;
                break;
            }
            case EXTENDED_CALENDAR_DATE: {
                if (n2 != n3) break;
                chronoPrinter = plainDate.getMonth() == plainDate2.getMonth() ? REDUCED_DD : REDUCED_MM_DD;
                break;
            }
            case EXTENDED_ORDINAL_DATE: {
                if (n2 != n3) break;
                chronoPrinter = REDUCED_DDD;
                break;
            }
            case EXTENDED_WEEK_DATE: {
                n2 = plainDate.getInt(PlainDate.YEAR_OF_WEEKDATE);
                n3 = plainDate2.getInt(PlainDate.YEAR_OF_WEEKDATE);
                if (n2 != n3) break;
                if (plainDate.getInt(Weekmodel.ISO.weekOfYear()) == plainDate2.getInt(Weekmodel.ISO.weekOfYear())) {
                    chronoPrinter = REDUCED_E;
                    break;
                }
                chronoPrinter = REDUCED_W_WW_E;
                break;
            }
            default: {
                throw new UnsupportedOperationException(isoDateStyle.name());
            }
        }
        return chronoPrinter;
    }

    @Override
    IntervalFactory<PlainDate, DateInterval> getFactory() {
        return DateIntervalFactory.INSTANCE;
    }

    @Override
    DateInterval getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 32);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class DailySpliterator
    implements Spliterator<PlainDate> {
        private long startEpoch;
        private final long endEpoch;
        private PlainDate current;

        DailySpliterator(PlainDate plainDate, PlainDate plainDate2) {
            this(plainDate, plainDate.getDaysSinceEpochUTC(), plainDate2.getDaysSinceEpochUTC());
        }

        private DailySpliterator(PlainDate plainDate, long l2, long l3) {
            this.startEpoch = l2;
            this.endEpoch = l3;
            this.current = l2 > l3 ? null : (PlainDate)plainDate.with(PlainDate.DAY_OF_WEEK, Weekday.valueOf((int)Math.floorMod(l2 + 5L, 7L) + 1));
        }

        @Override
        public boolean tryAdvance(Consumer<? super PlainDate> consumer) {
            if (this.current == null) {
                return false;
            }
            consumer.accept(this.current);
            this.current = this.startEpoch == this.endEpoch ? null : this.current.plus(1L, CalendarUnit.DAYS);
            ++this.startEpoch;
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super PlainDate> consumer) {
            if (this.current == null) {
                return;
            }
            PlainDate plainDate = this.current;
            long l2 = this.endEpoch;
            for (long i2 = this.startEpoch; i2 <= l2; ++i2) {
                consumer.accept(plainDate);
                if (i2 >= l2) continue;
                plainDate = plainDate.plus(1L, CalendarUnit.DAYS);
            }
            this.current = null;
            this.startEpoch = this.endEpoch + 1L;
        }

        @Override
        public Spliterator<PlainDate> trySplit() {
            boolean bl2;
            if (this.current == null) {
                return null;
            }
            long l2 = this.endEpoch - this.startEpoch - 3L;
            if (l2 < 7L) {
                return null;
            }
            long l3 = (l2 >>> 1) + this.startEpoch;
            PlainDate plainDate = PlainDate.of(l3, EpochDays.UTC);
            int n2 = plainDate.getYear();
            int n3 = plainDate.getMonth();
            int n4 = plainDate.getDayOfMonth();
            boolean bl3 = bl2 = this.estimateSize() < 180L && n4 <= 15;
            l3 = bl2 ? (l3 += (long)(15 - n4)) : (l3 += (long)(GregorianMath.getLengthOfMonth(n2, n3) - n4));
            if (l3 > this.endEpoch - 7L) {
                return null;
            }
            DailySpliterator dailySpliterator = new DailySpliterator(this.current, this.startEpoch, l3);
            Weekday weekday = this.current.getDayOfWeek().roll((int)(l3 - this.startEpoch + 1L));
            this.startEpoch = l3 + 1L;
            if (bl2) {
                this.current = PlainDate.of(n2, n3, 16);
            } else {
                if (++n3 == 13) {
                    ++n2;
                    n3 = 1;
                }
                this.current = PlainDate.of(n2, n3, 1);
            }
            this.current = (PlainDate)this.current.with(PlainDate.DAY_OF_WEEK, weekday);
            return dailySpliterator;
        }

        @Override
        public long estimateSize() {
            return this.endEpoch - this.startEpoch + 1L;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super PlainDate> getComparator() {
            return null;
        }
    }

    private static class Parser
    extends IntervalParser<PlainDate, DateInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;

        Parser(ChronoParser<PlainDate> chronoParser, ChronoParser<PlainDate> chronoParser2, boolean bl2, boolean bl3, boolean bl4) {
            super(DateIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl2;
            this.weekStyle = bl3;
            this.ordinalStyle = bl4;
        }

        @Override
        protected PlainDate parseReducedEnd(CharSequence charSequence, PlainDate plainDate, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoFormatter<PlainDate> chronoFormatter = this.createEndFormat(PlainDate.axis().preformat(plainDate, attributeQuery), parseLog.getRawValues());
            return chronoFormatter.parse(charSequence, parseLog2);
        }

        private ChronoFormatter<PlainDate> createEndFormat(ChronoDisplay chronoDisplay, ChronoEntity<?> chronoEntity) {
            int n2;
            AdjustableElement<Integer, PlainDate> adjustableElement;
            ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT);
            AdjustableElement<Integer, PlainDate> adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n2 = this.ordinalStyle ? 3 : 5;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
                builder.addCustomized(adjustableElement, NOOP, this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR);
            } else {
                n2 = this.ordinalStyle ? 3 : 4;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
                builder.addInteger(adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, true);
                builder.addCustomized(Weekmodel.ISO.weekOfYear(), NOOP, this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR);
                builder.endSection();
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1);
            } else if (this.ordinalStyle) {
                builder.addFixedInteger(PlainDate.DAY_OF_YEAR, 3);
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2);
                if (this.extended) {
                    builder.addCustomized(PlainDate.MONTH_AS_NUMBER, NOOP, FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.addFixedInteger(PlainDate.DAY_OF_MONTH, 2);
            }
            for (ChronoElement<?> chronoElement : DateIntervalFactory.INSTANCE.stdElements(chronoEntity)) {
                Parser.setDefault(builder, chronoElement, chronoDisplay);
            }
            return builder.build();
        }

        private static <V> void setDefault(ChronoFormatter.Builder<PlainDate> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

