/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockIntervalFactory;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;

public final class ClockInterval
extends IsoInterval<PlainTime, ClockInterval>
implements Serializable {
    public static final ClockInterval FULL_DAY = ClockInterval.between(PlainTime.midnightAtStartOfDay(), PlainTime.midnightAtEndOfDay());
    private static final long serialVersionUID = -6020908050362634577L;
    private static final Comparator<ChronoInterval<PlainTime>> COMPARATOR = new IntervalComparator<PlainTime>(PlainTime.axis());

    ClockInterval(Boundary<PlainTime> boundary, Boundary<PlainTime> boundary2) {
        super(boundary, boundary2);
        if (boundary.isInfinite() || boundary2.isInfinite()) {
            throw new IllegalArgumentException("Clock (time) intervals must be finite.");
        }
    }

    public static Comparator<ChronoInterval<PlainTime>> comparator() {
        return COMPARATOR;
    }

    public static ClockInterval between(PlainTime plainTime, PlainTime plainTime2) {
        return new ClockInterval(Boundary.of(IntervalEdge.CLOSED, plainTime), Boundary.of(IntervalEdge.OPEN, plainTime2));
    }

    public static ClockInterval between(LocalTime localTime, LocalTime localTime2) {
        return ClockInterval.between(PlainTime.from(localTime), PlainTime.from(localTime2));
    }

    public static ClockInterval since(PlainTime plainTime) {
        return ClockInterval.between(plainTime, PlainTime.midnightAtEndOfDay());
    }

    public static ClockInterval since(LocalTime localTime) {
        return ClockInterval.since(PlainTime.from(localTime));
    }

    public static ClockInterval until(PlainTime plainTime) {
        return ClockInterval.between(PlainTime.midnightAtStartOfDay(), plainTime);
    }

    public static ClockInterval until(LocalTime localTime) {
        return ClockInterval.until(PlainTime.from(localTime));
    }

    public static ClockInterval from(ChronoInterval<PlainTime> chronoInterval) {
        if (chronoInterval instanceof ClockInterval) {
            return (ClockInterval)ClockInterval.class.cast(chronoInterval);
        }
        return new ClockInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public TimestampInterval on(PlainDate plainDate) {
        return TimestampInterval.between(plainDate.at(this.getStartAsClockTime()), plainDate.at(this.getEndAsClockTime()));
    }

    public PlainTime getStartAsClockTime() {
        return (PlainTime)this.getStart().getTemporal();
    }

    public LocalTime getStartAsLocalTime() {
        return this.getStartAsClockTime().toTemporalAccessor();
    }

    public PlainTime getEndAsClockTime() {
        return (PlainTime)this.getEnd().getTemporal();
    }

    public LocalTime getEndAsLocalTime() {
        return this.getEndAsClockTime().toTemporalAccessor();
    }

    public Duration<ClockUnit> getDuration() {
        PlainTime plainTime = (PlainTime)this.getTemporalOfClosedStart();
        PlainTime plainTime2 = (PlainTime)this.getEnd().getTemporal();
        if (this.getEnd().isClosed()) {
            if (plainTime2.getHour() == 24) {
                if (plainTime.equals(PlainTime.midnightAtStartOfDay())) {
                    return Duration.of(24L, ClockUnit.HOURS).plus(1L, ClockUnit.NANOS);
                }
                plainTime = plainTime.minus(1L, ClockUnit.NANOS);
            } else {
                plainTime2 = plainTime2.plus(1L, ClockUnit.NANOS);
            }
        }
        return Duration.inClockUnits().between(plainTime, plainTime2);
    }

    public ClockInterval move(long l2, ClockUnit clockUnit) {
        if (l2 == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((PlainTime)this.getStart().getTemporal()).plus(l2, clockUnit));
        Boundary<PlainTime> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((PlainTime)this.getEnd().getTemporal()).plus(l2, clockUnit));
        return new ClockInterval((Boundary<PlainTime>)boundary, boundary2);
    }

    public Stream<PlainTime> stream(Duration<ClockUnit> duration) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        return ClockInterval.stream(duration, clockInterval.getStartAsClockTime(), clockInterval.getEndAsClockTime());
    }

    public static Stream<PlainTime> stream(Duration<ClockUnit> duration, PlainTime plainTime, PlainTime plainTime2) {
        int n3;
        if (!duration.isPositive()) {
            throw new IllegalArgumentException("Duration must be positive: " + duration);
        }
        int n4 = plainTime.compareTo(plainTime2);
        if (n4 > 0) {
            throw new IllegalArgumentException("Start after end: " + plainTime + "/" + plainTime2);
        }
        if (n4 == 0) {
            return Stream.empty();
        }
        double d2 = 0.0;
        for (TimeSpan.Item<ClockUnit> item : duration.getTotalLength()) {
            d2 += item.getUnit().getLength() * (double)item.getAmount();
        }
        double d3 = d2 < 1.0 ? (double)ClockUnit.NANOS.between(plainTime, plainTime2) / (d2 * 1.0E9) : (double)ClockUnit.SECONDS.between(plainTime, plainTime2) / d2;
        if (Double.compare(d3, 2.147483647E9) >= 0) {
            throw new ArithmeticException();
        }
        boolean bl2 = false;
        for (n3 = (int)Math.floor(d3); n3 > 0 && !((PlainTime)plainTime.plus(duration.multipliedBy(n3))).isBefore(plainTime2); --n3) {
            bl2 = true;
        }
        int n5 = n3 + 1;
        if (!bl2) {
            do {
                n5 = Math.addExact(n3, 1);
            } while (((PlainTime)plainTime.plus(duration.multipliedBy(++n3))).isBefore(plainTime2));
        }
        if (n5 == 1) {
            return Stream.of(plainTime);
        }
        return IntStream.range(0, n5).mapToObj(n2 -> (PlainTime)plainTime.plus(duration.multipliedBy(n2)));
    }

    public PlainTime random() {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        if (clockInterval.isEmpty()) {
            throw new IllegalStateException("Cannot get random time in an empty interval: " + this);
        }
        long l2 = (Long)clockInterval.getStartAsClockTime().get(PlainTime.NANO_OF_DAY);
        long l3 = (Long)clockInterval.getEndAsClockTime().get(PlainTime.NANO_OF_DAY);
        long l4 = ThreadLocalRandom.current().nextLong(l2, l3);
        return PlainTime.midnightAtStartOfDay().plus(l4, ClockUnit.NANOS);
    }

    public String formatBasicISO(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder();
        ChronoPrinter<PlainTime> chronoPrinter = Iso8601Format.ofBasicTime(isoDecimalStyle, clockUnit);
        chronoPrinter.print(clockInterval.getStartAsClockTime(), stringBuilder);
        stringBuilder.append('/');
        chronoPrinter.print(clockInterval.getEndAsClockTime(), stringBuilder);
        return stringBuilder.toString();
    }

    public String formatExtendedISO(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder();
        ChronoPrinter<PlainTime> chronoPrinter = Iso8601Format.ofExtendedTime(isoDecimalStyle, clockUnit);
        chronoPrinter.print(clockInterval.getStartAsClockTime(), stringBuilder);
        stringBuilder.append('/');
        chronoPrinter.print(clockInterval.getEndAsClockTime(), stringBuilder);
        return stringBuilder.toString();
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser) throws ParseException {
        return ClockInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, ClockIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        ClockInterval clockInterval = (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
        if (clockInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length() && !chronoParser.getAttributes().get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return clockInterval;
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, char c2, ChronoParser<PlainTime> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c2).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static ClockInterval parseISO(String string) throws ParseException {
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        ChronoFormatter<PlainTime> chronoFormatter = string.indexOf(58) == -1 ? Iso8601Format.BASIC_WALL_TIME : Iso8601Format.EXTENDED_WALL_TIME;
        ParseLog parseLog = new ParseLog();
        ClockInterval clockInterval = (ClockInterval)new IntervalParser<PlainTime, ClockInterval>(ClockIntervalFactory.INSTANCE, chronoFormatter, chronoFormatter, BracketPolicy.SHOW_NEVER, Character.valueOf('/')).parse(string, parseLog, chronoFormatter.getAttributes());
        if (clockInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < string.length()) {
            throw new ParseException("Trailing characters found: " + string, parseLog.getPosition());
        }
        return clockInterval;
    }

    @Override
    IntervalFactory<PlainTime, ClockInterval> getFactory() {
        return ClockIntervalFactory.INSTANCE;
    }

    @Override
    ClockInterval getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 33);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

