/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.CutOverEvent;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearRule;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.YearDefinition;
import net.time4j.history.internal.StdHistoricalElement;

final class HistoricIntegerElement
extends StdHistoricalElement
implements DualFormatElement {
    static final int YEAR_OF_ERA_INDEX = 2;
    static final int MONTH_INDEX = 3;
    static final int DAY_OF_MONTH_INDEX = 4;
    static final int DAY_OF_YEAR_INDEX = 5;
    static final int YEAR_AFTER_INDEX = 6;
    static final int YEAR_BEFORE_INDEX = 7;
    static final int CENTURY_INDEX = 8;
    private static final long serialVersionUID = -6283098762945747308L;
    private final ChronoHistory history;
    private final transient int index;

    HistoricIntegerElement(char c2, int n2, int n3, ChronoHistory chronoHistory, int n4) {
        super(HistoricIntegerElement.toName(n4), c2, n2, n3);
        this.history = chronoHistory;
        this.index = n4;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        char c2 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c2, 1, 10);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c2, int n2, int n3) throws IOException {
        if (this.index == 5) {
            appendable.append(String.valueOf(chronoDisplay.get(this.history.dayOfYear())));
            return;
        }
        HistoricDate historicDate = chronoDisplay instanceof GregorianDate ? this.history.convert(PlainDate.from((GregorianDate)((Object)chronoDisplay))) : chronoDisplay.get(this.history.date());
        switch (this.index) {
            case 2: {
                int n4;
                NewYearStrategy newYearStrategy = this.history.getNewYearStrategy();
                int n5 = historicDate.getYearOfEra();
                String string = null;
                if (!NewYearStrategy.DEFAULT.equals(newYearStrategy) && (n4 = historicDate.getYearOfEra(newYearStrategy)) != n5) {
                    if (attributeQuery.get(ChronoHistory.YEAR_DEFINITION, YearDefinition.DUAL_DATING) == YearDefinition.DUAL_DATING) {
                        string = this.dual(numberSystem, c2, n4, n5, n2);
                    } else {
                        n5 = n4;
                    }
                }
                if (string == null) {
                    string = numberSystem.isDecimal() ? HistoricIntegerElement.pad(numberSystem.toNumeral(n5), n2, c2) : numberSystem.toNumeral(n5);
                }
                if (numberSystem.hasDecimalCodepoints()) {
                    n4 = numberSystem.getDigits().charAt(0);
                    if (c2 != n4) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n6 = string.length();
                        for (int i2 = 0; i2 < n6; ++i2) {
                            char c3 = string.charAt(i2);
                            if (numberSystem.contains(c3)) {
                                int n7 = c2 - n4;
                                stringBuilder.append((char)(c3 + n7));
                                continue;
                            }
                            stringBuilder.append(c3);
                        }
                        string = stringBuilder.toString();
                    }
                    this.checkLength(string, n3);
                }
                appendable.append(string);
                break;
            }
            case 3: {
                int n8 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
                int n9 = historicDate.getMonth();
                if (n8 == 0) {
                    OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                    appendable.append(this.monthAccessor(attributeQuery, outputContext).print(Month.valueOf(n9)));
                    break;
                }
                String string = numberSystem.toNumeral(n9);
                if (numberSystem.isDecimal()) {
                    string = HistoricIntegerElement.pad(string, n8, c2);
                }
                appendable.append(string);
                break;
            }
            case 4: {
                appendable.append(String.valueOf(historicDate.getDayOfMonth()));
                break;
            }
            default: {
                throw new ChronoException("Not printable as text: " + this.name());
            }
        }
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        return this.parse(charSequence, parsePosition, attributeQuery, null);
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
        int n2;
        int n3;
        if (this.index == 3) {
            int n4 = parsePosition.getIndex();
            n3 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            if (n3 == 0) {
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                Month month = this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
                if (month == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
                    parsePosition.setErrorIndex(-1);
                    parsePosition.setIndex(n4);
                    outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
                    month = this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
                }
                if (month == null) {
                    return null;
                }
                return month.getValue();
            }
        } else if (this.index == 6 || this.index == 7 || this.index == 8) {
            throw new ChronoException("Not parseable as text element: " + this.name());
        }
        NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        n3 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (int)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (int)numberSystem.getDigits().charAt(0) : 48);
        Leniency leniency = numberSystem.isDecimal() ? Leniency.SMART : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n5 = n2 = parsePosition.getIndex();
        int n6 = HistoricIntegerElement.parseNum(numberSystem, (char)n3, charSequence, n5, parsePosition, leniency);
        n5 = parsePosition.getIndex();
        if (this.index == 2 && n5 > n2 && !NewYearStrategy.DEFAULT.equals(this.history.getNewYearStrategy()) && n5 < charSequence.length() && charSequence.charAt(n5) == '/' && attributeQuery.get(ChronoHistory.YEAR_DEFINITION, YearDefinition.DUAL_DATING) == YearDefinition.DUAL_DATING) {
            int n7 = n5;
            int n8 = HistoricIntegerElement.parseNum(numberSystem, (char)n3, charSequence, n5 + 1, parsePosition, leniency);
            int n9 = parsePosition.getIndex();
            if (n9 == n5 + 1) {
                parsePosition.setIndex(n5);
            } else {
                n5 = n9;
                int n10 = n6;
                int n11 = this.history.getNewYearStrategy().rule(HistoricEra.AD, n10) == NewYearRule.CALCULUS_PISANUS ? 2 : 1;
                int n12 = this.getAncientYear(n10, n8, n11);
                if (numberSystem.isDecimal() && n12 != Integer.MAX_VALUE) {
                    n6 = n12;
                    if (chronoEntity != null) {
                        chronoEntity.with(StdHistoricalElement.YEAR_OF_DISPLAY, n10);
                    }
                } else if (Math.abs(n8 - n10) <= n11) {
                    n6 = n8;
                    if (chronoEntity != null) {
                        chronoEntity.with(StdHistoricalElement.YEAR_OF_DISPLAY, n10);
                    }
                } else {
                    n6 = n10;
                    n5 = n7;
                    parsePosition.setIndex(n5);
                }
            }
        }
        if (n5 == n2) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        return n6;
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.COMPONENT)) {
            return new Rule(this.index, this.history);
        }
        return null;
    }

    @Override
    protected boolean isSingleton() {
        return false;
    }

    @Override
    protected boolean doEquals(BasicElement<?> basicElement) {
        return this.history.equals(((HistoricIntegerElement)basicElement).history);
    }

    private int getAncientYear(int n2, int n3, int n4) {
        if (n3 >= 0 && n3 < 100 && n2 >= 100) {
            int n5;
            int n6 = n5 = n3 < 10 ? 10 : 100;
            if (Math.abs(n3 - MathUtils.floorModulo(n2, n5)) <= n4) {
                return MathUtils.floorDivide(n2, n5) * n5 + n3;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String dual(NumberSystem numberSystem, char c2, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(numberSystem.toNumeral(n2));
        stringBuilder.append('/');
        if (numberSystem.isDecimal() && n3 >= 100 && MathUtils.floorDivide(n2, 100) == MathUtils.floorDivide(n3, 100)) {
            int n5 = MathUtils.floorModulo(n3, 100);
            if (n5 < 10) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(numberSystem.toNumeral(n5));
        } else {
            stringBuilder.append(numberSystem.toNumeral(n3));
        }
        if (numberSystem.isDecimal()) {
            return HistoricIntegerElement.pad(stringBuilder.toString(), n4, c2);
        }
        return stringBuilder.toString();
    }

    private static String pad(String string, int n2, char c2) {
        int n3 = string.length();
        if (n2 <= n3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n2 - n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private void checkLength(String string, int n2) {
        int n3 = string.length();
        if (n3 > n2) {
            throw new IllegalArgumentException("Element " + this.name() + " cannot be printed as the formatted value " + string + " exceeds the maximum width of " + n2 + ".");
        }
    }

    private TextAccessor monthAccessor(AttributeQuery attributeQuery, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getIsoInstance(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        return calendarText.getStdMonths(textWidth, outputContext);
    }

    private static int parseNum(NumberSystem numberSystem, char c2, CharSequence charSequence, int n2, ParsePosition parsePosition, Leniency leniency) {
        long l2 = 0L;
        int n3 = n2;
        if (numberSystem.hasDecimalCodepoints()) {
            boolean bl2 = false;
            if (numberSystem == NumberSystem.ARABIC && charSequence.charAt(n3) == '-') {
                bl2 = true;
                ++n3;
            }
            char c3 = leniency.isStrict() ? (char)'\u0000' : numberSystem.getDigits().charAt(0);
            int n4 = Math.min(n3 + 9, charSequence.length());
            for (int i2 = n3; i2 < n4; ++i2) {
                int n5 = charSequence.charAt(i2) - c2;
                if (n5 >= 0 && n5 <= 9) {
                    l2 = l2 * 10L + (long)n5;
                    ++n3;
                    continue;
                }
                if (c3 == '\u0000' || c2 == c3 || (n5 = charSequence.charAt(i2) - c3) < 0 || n5 > 9) break;
                c2 = c3;
                l2 = l2 * 10L + (long)n5;
                ++n3;
            }
            if (l2 > Integer.MAX_VALUE) {
                parsePosition.setErrorIndex(n2);
                return Integer.MIN_VALUE;
            }
            if (bl2) {
                if (n3 == n2 + 1) {
                    n3 = n2;
                } else {
                    l2 = MathUtils.safeNegate(l2);
                }
            }
        } else {
            int n6 = 0;
            int n7 = charSequence.length();
            for (int i3 = n3; i3 < n7 && numberSystem.contains(charSequence.charAt(i3)); ++i3) {
                ++n6;
            }
            if (n6 > 0) {
                l2 = numberSystem.toInteger(charSequence.subSequence(n3, n3 + n6).toString(), leniency);
                n3 += n6;
            }
        }
        parsePosition.setIndex(n3);
        return (int)l2;
    }

    private static String toName(int n2) {
        switch (n2) {
            case 2: {
                return "YEAR_OF_ERA";
            }
            case 3: {
                return "HISTORIC_MONTH";
            }
            case 4: {
                return "HISTORIC_DAY_OF_MONTH";
            }
            case 5: {
                return "HISTORIC_DAY_OF_YEAR";
            }
            case 6: {
                return "YEAR_AFTER";
            }
            case 7: {
                return "YEAR_BEFORE";
            }
            case 8: {
                return "CENTURY_OF_ERA";
            }
        }
        throw new UnsupportedOperationException("Unknown element index: " + n2);
    }

    private Object readResolve() throws ObjectStreamException {
        String string;
        switch (string = this.name()) {
            case "YEAR_OF_ERA": {
                return this.history.yearOfEra();
            }
            case "HISTORIC_MONTH": {
                return this.history.month();
            }
            case "HISTORIC_DAY_OF_MONTH": {
                return this.history.dayOfMonth();
            }
            case "HISTORIC_DAY_OF_YEAR": {
                return this.history.dayOfYear();
            }
            case "YEAR_AFTER": {
                return this.history.yearOfEra(YearDefinition.AFTER_NEW_YEAR);
            }
            case "YEAR_BEFORE": {
                return this.history.yearOfEra(YearDefinition.BEFORE_NEW_YEAR);
            }
            case "CENTURY_OF_ERA": {
                return this.history.centuryOfEra();
            }
        }
        throw new InvalidObjectException("Unknown element: " + string);
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, Integer> {
        private final int index;
        private final ChronoHistory history;

        Rule(int n2, ChronoHistory chronoHistory) {
            this.index = n2;
            this.history = chronoHistory;
        }

        @Override
        public Integer getValue(C c2) {
            try {
                int n2;
                PlainDate plainDate = ((ChronoEntity)c2).get(PlainDate.COMPONENT);
                HistoricDate historicDate = this.history.convert(plainDate);
                switch (this.index) {
                    case 2: {
                        n2 = historicDate.getYearOfEra();
                        break;
                    }
                    case 3: {
                        n2 = historicDate.getMonth();
                        break;
                    }
                    case 4: {
                        n2 = historicDate.getDayOfMonth();
                        break;
                    }
                    case 5: {
                        long l2 = plainDate.getDaysSinceEpochUTC();
                        int n3 = historicDate.getYearOfEra(this.history.getNewYearStrategy());
                        HistoricDate historicDate2 = this.history.getBeginOfYear(historicDate.getEra(), n3);
                        n2 = (int)(l2 - this.history.convert(historicDate2).getDaysSinceEpochUTC() + 1L);
                        break;
                    }
                    case 6: 
                    case 7: {
                        n2 = historicDate.getYearOfEra(this.history.getNewYearStrategy());
                        break;
                    }
                    case 8: {
                        n2 = (historicDate.getYearOfEra() - 1) / 100 + 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown element index: " + this.index);
                    }
                }
                return n2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public Integer getMinimum(C c2) {
            try {
                int n2;
                HistoricDate historicDate = this.history.convert(((ChronoEntity)c2).get(PlainDate.COMPONENT));
                if (this.index == 2 || this.index == 6 || this.index == 7 || this.index == 8) {
                    if (historicDate.getEra() == HistoricEra.BYZANTINE && historicDate.getMonth() >= 9) {
                        return 0;
                    }
                    return 1;
                }
                HistoricDate historicDate2 = this.adjust(c2, 1);
                if (this.history.isValid(historicDate2)) {
                    return 1;
                }
                if (this.index == 5) {
                    throw new ChronoException("Historic New Year cannot be determined.");
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    CutOverEvent cutOverEvent = list.get(n2);
                    if (historicDate.compareTo(cutOverEvent.dateAtCutOver) < 0) continue;
                    historicDate2 = cutOverEvent.dateAtCutOver;
                    break;
                }
                n2 = this.index == 3 ? historicDate2.getMonth() : historicDate2.getDayOfMonth();
                return n2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public Integer getMaximum(C c2) {
            try {
                HistoricDate historicDate;
                int n2;
                HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c2).get(PlainDate.COMPONENT));
                switch (this.index) {
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n3;
                        if (this.history == ChronoHistory.PROLEPTIC_BYZANTINE) {
                            n3 = 999984973;
                        } else if (this.history == ChronoHistory.PROLEPTIC_JULIAN) {
                            n3 = 999979465;
                            if (historicDate2.getEra() == HistoricEra.BC) {
                                ++n3;
                            }
                        } else if (this.history == ChronoHistory.PROLEPTIC_GREGORIAN) {
                            n3 = 999999999;
                            if (historicDate2.getEra() == HistoricEra.BC) {
                                ++n3;
                            }
                        } else {
                            int n4 = n3 = historicDate2.getEra() == HistoricEra.BC ? 45 : 9999;
                        }
                        if (this.index == 8) {
                            n3 = (n3 - 1) / 100 + 1;
                        }
                        return n3;
                    }
                    case 3: {
                        n2 = historicDate2.getEra() == HistoricEra.BYZANTINE && historicDate2.getYearOfEra() == 999984973 ? 8 : 12;
                        historicDate = this.adjust(c2, n2);
                        break;
                    }
                    case 4: {
                        n2 = this.history.getAlgorithm(historicDate2).getMaximumDayOfMonth(historicDate2);
                        historicDate = this.adjust(c2, n2);
                        break;
                    }
                    case 5: {
                        int n5 = historicDate2.getYearOfEra(this.history.getNewYearStrategy());
                        int n6 = this.history.getLengthOfYear(historicDate2.getEra(), n5);
                        if (n6 == -1) {
                            throw new ChronoException("Length of historic year undefined.");
                        }
                        return n6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown element index: " + this.index);
                    }
                }
                if (this.history.isValid(historicDate)) {
                    return n2;
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    CutOverEvent cutOverEvent;
                    CutOverEvent cutOverEvent2 = cutOverEvent = list.get(i2);
                    if (historicDate2.compareTo(cutOverEvent.dateAtCutOver) >= 0) continue;
                    historicDate = cutOverEvent2.dateBeforeCutOver;
                    break;
                }
                n2 = this.index == 3 ? historicDate.getMonth() : historicDate.getDayOfMonth();
                return n2;
            }
            catch (RuntimeException runtimeException) {
                throw new ChronoException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public boolean isValid(C c2, Integer n2) {
            if (n2 == null) {
                return false;
            }
            try {
                HistoricDate historicDate = this.adjust(c2, n2);
                return this.history.isValid(historicDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public C withValue(C c2, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing historic element value.");
            }
            HistoricDate historicDate = this.adjust(c2, n2);
            return (C)((ChronoEntity)c2).with((ChronoElement<PlainDate>)PlainDate.COMPONENT, (PlainDate)this.history.convert(historicDate));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(C c2) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(C c2) {
            throw new UnsupportedOperationException("Never called.");
        }

        private HistoricDate adjust(C c2, int n2) {
            HistoricDate historicDate;
            HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c2).get(PlainDate.COMPONENT));
            YearDefinition yearDefinition = YearDefinition.DUAL_DATING;
            NewYearStrategy newYearStrategy = this.history.getNewYearStrategy();
            switch (this.index) {
                case 6: 
                case 7: {
                    yearDefinition = this.index == 6 ? YearDefinition.AFTER_NEW_YEAR : YearDefinition.BEFORE_NEW_YEAR;
                }
                case 2: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), n2, historicDate2.getMonth(), historicDate2.getDayOfMonth(), yearDefinition, newYearStrategy);
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 3: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), n2, historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 4: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), historicDate2.getMonth(), n2);
                    break;
                }
                case 5: {
                    int n3 = historicDate2.getYearOfEra(this.history.getNewYearStrategy());
                    HistoricDate historicDate3 = this.history.getBeginOfYear(historicDate2.getEra(), n3);
                    int n4 = this.history.getLengthOfYear(historicDate2.getEra(), n3);
                    if (n2 == 1) {
                        historicDate = historicDate3;
                        break;
                    }
                    if (n2 > 1 && n2 <= n4) {
                        PlainDate plainDate = this.history.convert(historicDate3);
                        plainDate = (PlainDate)plainDate.plus(CalendarDays.of(n2 - 1));
                        historicDate = this.history.convert(plainDate);
                        break;
                    }
                    throw new IllegalArgumentException("Out of range: " + n2);
                }
                case 8: {
                    int n5 = historicDate2.getYearOfEra() % 100;
                    int n6 = (n2 - 1) * 100 + (n5 == 0 ? 100 : n5);
                    historicDate = HistoricDate.of(historicDate2.getEra(), n6, historicDate2.getMonth(), historicDate2.getDayOfMonth(), yearDefinition, newYearStrategy);
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return historicDate;
        }
    }
}

