/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class LocalizedGMTProcessor
implements FormatProcessor<TZID> {
    private static final ZonalOffset PROTOTYPE = ZonalOffset.ofTotalSeconds(64800);
    private static final ConcurrentMap<Locale, String> UTC_LITERALS = new ConcurrentHashMap<Locale, String>();
    private static final ConcurrentMap<Locale, Info> STD_PATTERN_INFOS = new ConcurrentHashMap<Locale, Info>();
    private final boolean abbreviated;
    private final boolean caseInsensitive;
    private final boolean noPrefix;
    private final Locale locale;
    private final String plusSign;
    private final String minusSign;
    private final char zeroDigit;
    private final Leniency lenientMode;

    LocalizedGMTProcessor(boolean bl2) {
        this(bl2, true, false, Locale.ROOT, "+", "-", '0', Leniency.SMART);
    }

    private LocalizedGMTProcessor(boolean bl2, boolean bl3, boolean bl4, Locale locale, String string, String string2, char c2, Leniency leniency) {
        this.abbreviated = bl2;
        this.caseInsensitive = bl3;
        this.noPrefix = bl4;
        this.locale = locale;
        this.plusSign = string;
        this.minusSign = string2;
        this.zeroDigit = c2;
        this.lenientMode = leniency;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        ZonalOffset zonalOffset;
        int n2 = -1;
        int n3 = 0;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = LocalizedGMTProcessor.getOffset(chronoDisplay, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of(tZID).getOffset((UnixTime)((Object)chronoDisplay));
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        Locale locale = bl2 ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        char c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        String string = bl2 ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string2 = bl2 ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        boolean bl3 = bl2 ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        int n4 = zonalOffset.getIntegralAmount();
        int n5 = zonalOffset.getFractionalAmount();
        if (!bl3 && n4 == 0 && n5 == 0) {
            String string3 = LocalizedGMTProcessor.getLiteralUTC(locale);
            appendable.append(string3);
            n3 = string3.length();
        } else {
            Info info = LocalizedGMTProcessor.getPatternInfo(locale);
            int n6 = info.pattern.length();
            for (int i2 = 0; i2 < n6; ++i2) {
                int n7;
                char c3 = info.pattern.charAt(i2);
                if (info.start > i2 || info.end <= i2) {
                    if (bl3) continue;
                    appendable.append(c3);
                    ++n3;
                    continue;
                }
                if (zonalOffset.getSign() == OffsetSign.BEHIND_UTC) {
                    appendable.append(string2);
                    n3 += string2.length();
                } else {
                    appendable.append(string);
                    n3 += string.length();
                }
                int n8 = zonalOffset.getAbsoluteHours();
                int n9 = zonalOffset.getAbsoluteMinutes();
                int n10 = zonalOffset.getAbsoluteSeconds();
                if (n8 < 10 && !this.abbreviated) {
                    appendable.append(c2);
                    ++n3;
                }
                String string4 = String.valueOf(n8);
                for (int i3 = 0; i3 < string4.length(); ++i3) {
                    n7 = string4.charAt(i3) - 48 + c2;
                    appendable.append((char)n7);
                    ++n3;
                }
                if (n9 != 0 || n10 != 0 || !this.abbreviated) {
                    int n11;
                    appendable.append(info.separator);
                    n3 += info.separator.length();
                    if (n9 < 10) {
                        appendable.append(c2);
                        ++n3;
                    }
                    String string5 = String.valueOf(n9);
                    for (n7 = 0; n7 < string5.length(); ++n7) {
                        n11 = string5.charAt(n7) - 48 + c2;
                        appendable.append((char)n11);
                        ++n3;
                    }
                    if (n10 != 0) {
                        appendable.append(info.separator);
                        n3 += info.separator.length();
                        if (n10 < 10) {
                            appendable.append(c2);
                            ++n3;
                        }
                        String string6 = String.valueOf(n10);
                        for (n11 = 0; n11 < string6.length(); ++n11) {
                            char c4 = (char)(string6.charAt(n11) - 48 + c2);
                            appendable.append(c4);
                            ++n3;
                        }
                    }
                }
                i2 = info.end - 1;
            }
        }
        if (n2 != -1 && n3 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n2, n2 + n3));
        }
        return n3;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing localized time zone offset.");
            return;
        }
        Locale locale = bl2 ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        boolean bl3 = CalendarText.isRTL(locale);
        boolean bl4 = bl2 ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        boolean bl5 = bl2 ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        char c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        String string = bl2 ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string2 = bl2 ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        Info info = LocalizedGMTProcessor.getPatternInfo(locale);
        int n5 = info.pattern.length();
        ZonalOffset zonalOffset = null;
        int n6 = n4;
        for (int i2 = 0; i2 < n5; ++i2) {
            OffsetSign offsetSign;
            int n7;
            int n8;
            char c3 = info.pattern.charAt(i2);
            if (info.start > i2 || info.end <= i2) {
                char c4;
                if (bl4) continue;
                char c5 = c4 = n4 < n2 ? charSequence.charAt(n4) : (char)'\u0000';
                if (!bl5 && c3 == c4 || bl5 && LocalizedGMTProcessor.charEqualsIgnoreCase(c3, c4)) {
                    ++n4;
                    continue;
                }
                n8 = LocalizedGMTProcessor.parseUTC(charSequence, n2, n6, locale, bl5);
                if (n8 > 0) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                    parseLog.setPosition(n6 + n8);
                } else {
                    parseLog.setError(n3, "Literal mismatched in localized time zone offset.");
                }
                return;
            }
            n8 = LiteralProcessor.subSequenceEquals(charSequence, n4, string, bl5, bl3);
            if (n8 == -1) {
                n8 = LiteralProcessor.subSequenceEquals(charSequence, n4, string2, bl5, bl3);
                if (n8 == -1) {
                    int n9 = n7 = bl4 ? 0 : LocalizedGMTProcessor.parseUTC(charSequence, n2, n6, locale, bl5);
                    if (n7 > 0) {
                        parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                        parseLog.setPosition(n6 + n7);
                        return;
                    }
                    parseLog.setError(n3, "Missing sign in localized time zone offset.");
                    return;
                }
                offsetSign = OffsetSign.BEHIND_UTC;
            } else {
                offsetSign = OffsetSign.AHEAD_OF_UTC;
            }
            n7 = LocalizedGMTProcessor.parseHours(charSequence, n4 += n8, c2);
            if (n7 == -1000) {
                parseLog.setError(n4, "Missing hour part in localized time zone offset.");
                return;
            }
            if (n7 < 0) {
                n7 ^= 0xFFFFFFFF;
                ++n4;
            } else {
                n4 += 2;
            }
            if (n4 >= n2) {
                if (this.abbreviated) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n7));
                    parseLog.setPosition(n4);
                } else {
                    parseLog.setError(n4, "Missing minute part in localized time zone offset.");
                }
                return;
            }
            Leniency leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
            int n10 = LiteralProcessor.subSequenceEquals(charSequence, n4, info.separator, bl5, bl3);
            if (n10 != -1) {
                n4 += n10;
            } else {
                if (this.abbreviated) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n7));
                    parseLog.setPosition(n4);
                    return;
                }
                if (leniency.isStrict()) {
                    parseLog.setError(n4, "Mismatch of localized time zone offset separator.");
                    return;
                }
            }
            int n11 = LocalizedGMTProcessor.parseTwoDigits(charSequence, n4, c2);
            if (n11 == -1000) {
                parseLog.setError(n4, "Minute part in localized time zone offset does not match expected pattern mm.");
                return;
            }
            int n12 = 0;
            if ((n4 += 2) < n2 && (n10 = LiteralProcessor.subSequenceEquals(charSequence, n4, info.separator, bl5, bl3)) != -1) {
                n12 = LocalizedGMTProcessor.parseTwoDigits(charSequence, n4 += n10, c2);
                n4 = n12 == -1000 ? (n4 -= n10) : (n4 += 2);
            }
            if (n12 == 0 || n12 == -1000) {
                zonalOffset = ZonalOffset.ofHoursMinutes(offsetSign, n7, n11);
            } else {
                int n13 = n7 * 3600 + n11 * 60 + n12;
                if (offsetSign == OffsetSign.BEHIND_UTC) {
                    n13 = -n13;
                }
                zonalOffset = ZonalOffset.ofTotalSeconds(n13);
            }
            i2 = info.end - 1;
        }
        if (zonalOffset == null) {
            parseLog.setError(n4, "Unable to determine localized time zone offset.");
        } else {
            parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
            parseLog.setPosition(n4);
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new LocalizedGMTProcessor(this.abbreviated, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT), attributeQuery.get(AttributeSet.PLUS_SIGN, "+"), attributeQuery.get(AttributeSet.MINUS_SIGN, "-"), attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalizedGMTProcessor) {
            LocalizedGMTProcessor localizedGMTProcessor = (LocalizedGMTProcessor)object;
            return this.abbreviated == localizedGMTProcessor.abbreviated;
        }
        return false;
    }

    public int hashCode() {
        return this.abbreviated ? 1 : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[abbreviated=");
        stringBuilder.append(this.abbreviated);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        TZID tZID;
        if (attributeQuery.contains(Attributes.TIMEZONE_ID) && (tZID = attributeQuery.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
            return (ZonalOffset)tZID;
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseUTC(CharSequence charSequence, int n2, int n3, Locale locale, boolean bl2) {
        String[] stringArray;
        String string = LocalizedGMTProcessor.getLiteralUTC(locale);
        for (String string2 : stringArray = new String[]{"GMT", string, "UTC", "UT"}) {
            int n4 = string2.length();
            if (n2 - n3 < n4) continue;
            String string3 = charSequence.subSequence(n3, n3 + n4).toString();
            if ((!bl2 || !string3.equalsIgnoreCase(string2)) && (bl2 || !string3.equals(string2))) continue;
            return n4;
        }
        return 0;
    }

    private static int parseTwoDigits(CharSequence charSequence, int n2, char c2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (n2 + i2 >= charSequence.length()) {
                return -1000;
            }
            int n4 = charSequence.charAt(n2 + i2) - c2;
            if (n4 < 0 || n4 > 9) {
                return -1000;
            }
            n3 = n3 * 10 + n4;
        }
        return n3;
    }

    private static int parseHours(CharSequence charSequence, int n2, char c2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (n2 + i2 >= charSequence.length()) {
                if (i2 == 0) {
                    return -1000;
                }
                return ~n3;
            }
            int n4 = charSequence.charAt(n2 + i2) - c2;
            if (n4 < 0 || n4 > 9) {
                if (i2 == 0) {
                    return -1000;
                }
                return ~n3;
            }
            n3 = n3 * 10 + n4;
        }
        return n3;
    }

    private static boolean charEqualsIgnoreCase(char c2, char c3) {
        return c2 == c3 || Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3);
    }

    private static String getLiteralUTC(Locale locale) {
        String string;
        String string2 = (String)UTC_LITERALS.get(locale);
        if (string2 == null && (string = UTC_LITERALS.putIfAbsent(locale, string2 = ZonalOffset.UTC.getStdFormatPattern(locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    private static Info getPatternInfo(Locale locale) {
        Info info = (Info)STD_PATTERN_INFOS.get(locale);
        if (info == null) {
            String string = PROTOTYPE.getStdFormatPattern(locale);
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                if (string.charAt(i2) != '\u00b1') continue;
                int n4 = string.indexOf("hh", i2) + 2;
                info = new Info(string, string.substring(n4, n3 = string.indexOf("mm", n4)), i2, n3 + 2);
                Info info2 = STD_PATTERN_INFOS.putIfAbsent(locale, info);
                if (info2 == null) break;
                info = info2;
                break;
            }
        }
        assert (info != null);
        return info;
    }

    private static class Info {
        private final String pattern;
        private final String separator;
        private final int start;
        private final int end;

        Info(String string, String string2, int n2, int n3) {
            this.pattern = string;
            this.separator = string2;
            this.start = n2;
            this.end = n3;
        }
    }
}

