/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class LiteralProcessor
implements FormatProcessor<Void> {
    private final char single;
    private final char alt;
    private final String multi;
    private final AttributeKey<Character> attribute;
    private final boolean caseInsensitive;
    private final boolean interpunctuationMode;
    private final boolean rtl;

    LiteralProcessor(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing literal.");
        }
        this.alt = this.single = string.charAt(0);
        this.attribute = null;
        this.multi = string;
        if (this.single < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
        this.caseInsensitive = true;
        this.interpunctuationMode = string.length() == 1 && LiteralProcessor.isInterpunctuation(this.single);
        this.rtl = false;
    }

    LiteralProcessor(char c2, char c3) {
        this.single = c2;
        this.alt = c3;
        this.attribute = null;
        this.multi = null;
        if (c2 < ' ' || c3 < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
        if (Character.isDigit(c2) || Character.isDigit(c3)) {
            throw new IllegalArgumentException("Literal must not be a decimal digit.");
        }
        this.caseInsensitive = true;
        this.interpunctuationMode = false;
        this.rtl = false;
    }

    LiteralProcessor(AttributeKey<Character> attributeKey) {
        if (attributeKey == null) {
            throw new NullPointerException("Missing format attribute.");
        }
        this.alt = this.single = '\u0000';
        this.attribute = attributeKey;
        this.multi = null;
        this.caseInsensitive = true;
        this.interpunctuationMode = false;
        this.rtl = false;
    }

    private LiteralProcessor(char c2, char c3, String string, AttributeKey<Character> attributeKey, boolean bl2, boolean bl3, boolean bl4) {
        this.single = c2;
        this.alt = c3;
        this.multi = string;
        this.attribute = attributeKey;
        this.caseInsensitive = bl2;
        this.interpunctuationMode = bl3;
        this.rtl = bl4;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        if (this.attribute != null) {
            char c2 = ((Character)attributeQuery.get(this.attribute, null)).charValue();
            appendable.append(c2);
            return 1;
        }
        if (this.multi == null) {
            appendable.append(this.single);
            return 1;
        }
        appendable.append(this.multi);
        return this.multi.length();
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        if (bl2 && this.interpunctuationMode) {
            int n2 = parseLog.getPosition();
            if (n2 < charSequence.length() && charSequence.charAt(n2) == this.single) {
                parseLog.setPosition(n2 + 1);
            } else if (this.single != '.' || !attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
                this.logError(charSequence, parseLog);
            }
        } else if (this.multi == null) {
            this.parseChar(charSequence, parseLog, attributeQuery, bl2);
        } else {
            this.parseMulti(charSequence, parseLog, attributeQuery, bl2);
        }
    }

    private void parseChar(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl2) {
        boolean bl3;
        int n2 = parseLog.getPosition();
        char c2 = '\u0000';
        char c3 = this.single;
        if (n2 >= charSequence.length()) {
            bl3 = true;
        } else {
            c2 = charSequence.charAt(n2);
            char c4 = this.alt;
            if (this.attribute == null) {
                bl3 = c2 != c3 && c2 != c4;
            } else {
                c3 = attributeQuery.get(this.attribute, Character.valueOf('\u0000')).charValue();
                if (c3 == '\u0000' || Character.isDigit(c3)) {
                    bl3 = true;
                } else {
                    if (Attributes.DECIMAL_SEPARATOR.name().equals(this.attribute.name()) && Locale.ROOT.equals(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT))) {
                        c4 = c3 == ',' ? (char)'.' : (c3 == '.' ? (char)',' : (char)c3);
                    }
                    boolean bl4 = bl3 = c2 != c3 && c2 != c4;
                }
            }
            if (bl3) {
                boolean bl5;
                boolean bl6 = bl5 = bl2 ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
                if (bl5 && (LiteralProcessor.charEqualsIgnoreCase(c2, c3) || LiteralProcessor.charEqualsIgnoreCase(c2, c4))) {
                    bl3 = false;
                }
            }
        }
        if (bl3) {
            StringBuilder stringBuilder = new StringBuilder("Cannot parse: \"");
            stringBuilder.append(charSequence);
            stringBuilder.append("\" (expected: [");
            stringBuilder.append(c3);
            stringBuilder.append("], found: [");
            if (c2 != '\u0000') {
                stringBuilder.append(c2);
            }
            stringBuilder.append("])");
            parseLog.setError(n2, stringBuilder.toString());
        } else {
            parseLog.setPosition(n2 + 1);
        }
    }

    private void parseMulti(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl2) {
        boolean bl3;
        boolean bl4;
        int n2 = parseLog.getPosition();
        int n3 = LiteralProcessor.subSequenceEquals(charSequence, n2, this.multi, bl4 = bl2 ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), bl3 = bl2 ? this.rtl : CalendarText.isRTL(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT)));
        if (n3 == -1) {
            this.logError(charSequence, parseLog);
        } else {
            parseLog.setPosition(n2 + n3);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LiteralProcessor) {
            LiteralProcessor literalProcessor = (LiteralProcessor)object;
            if (this.attribute != null) {
                return this.attribute.equals(literalProcessor.attribute);
            }
            if (this.multi == null) {
                return literalProcessor.multi == null && this.single == literalProcessor.single && this.alt == literalProcessor.alt;
            }
            return this.multi.equals(literalProcessor.multi) && this.interpunctuationMode == literalProcessor.interpunctuationMode;
        }
        return false;
    }

    public int hashCode() {
        String string = this.attribute == null ? (this.multi == null ? "" : this.multi) : this.attribute.name();
        return this.single ^ string.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[literal=");
        if (this.attribute != null) {
            stringBuilder.append('{');
            stringBuilder.append(this.attribute);
            stringBuilder.append('}');
        } else if (this.multi == null) {
            stringBuilder.append(this.single);
            if (this.alt != this.single) {
                stringBuilder.append(", alternative=");
                stringBuilder.append(this.alt);
            }
        } else {
            stringBuilder.append(this.multi);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        if (this.multi == null) {
            return false;
        }
        return this.getPrefixedDigitArea() == this.multi.length();
    }

    @Override
    public FormatProcessor<Void> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        boolean bl2 = CalendarText.isRTL(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        return new LiteralProcessor(this.single, this.alt, this.multi, this.attribute, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), this.interpunctuationMode && !bl2, bl2);
    }

    int getPrefixedDigitArea() {
        if (this.multi == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.multi.length();
        for (int i2 = 0; i2 < n3 && Character.isDigit(this.multi.charAt(i2)); ++i2) {
            ++n2;
        }
        return n2;
    }

    static int subSequenceEquals(CharSequence charSequence, int n2, CharSequence charSequence2, boolean bl2, boolean bl3) {
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        for (int i2 = 0; i2 < n5; ++i2) {
            char c2 = '\u0000';
            char c3 = charSequence2.charAt(i2);
            if (LiteralProcessor.isBidi(c3)) continue;
            if (bl3) {
                while (n3 + n2 < n4 && LiteralProcessor.isBidi(c2 = charSequence.charAt(n3 + n2))) {
                    ++n3;
                }
            } else if (n3 + n2 < n4) {
                c2 = charSequence.charAt(n3 + n2);
            }
            if (n3 + n2 >= n4) {
                return -1;
            }
            ++n3;
            if (!(bl2 ? !LiteralProcessor.charEqualsIgnoreCase(c2, c3) : c2 != c3)) continue;
            return -1;
        }
        if (bl3) {
            while (n3 + n2 < n4 && LiteralProcessor.isBidi(charSequence.charAt(n3 + n2))) {
                ++n3;
            }
        }
        return n3;
    }

    private static boolean charEqualsIgnoreCase(char c2, char c3) {
        return c2 == c3 || Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3);
    }

    private static boolean isBidi(char c2) {
        return c2 == '\u200e' || c2 == '\u200f' || c2 == '\u061c';
    }

    private static boolean isInterpunctuation(char c2) {
        return !Character.isLetter(c2) && !Character.isDigit(c2) && !LiteralProcessor.isBidi(c2);
    }

    private void logError(CharSequence charSequence, ParseLog parseLog) {
        int n2 = parseLog.getPosition();
        StringBuilder stringBuilder = new StringBuilder("Cannot parse: \"");
        stringBuilder.append(charSequence);
        stringBuilder.append("\" (expected: [");
        stringBuilder.append(this.multi);
        stringBuilder.append("], found: [");
        stringBuilder.append(charSequence.subSequence(n2, Math.min(n2 + this.multi.length(), charSequence.length())));
        stringBuilder.append("])");
        parseLog.setError(n2, stringBuilder.toString());
    }
}

