/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.engine.TimeSpan;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;

public abstract class TimeSpanFormatter<U, S extends TimeSpan<U>> {
    private static final Object SIGN_KEY = new Object();
    private final Class<U> type;
    private final List<FormatItem<U>> items;
    private final String pattern;

    protected TimeSpanFormatter(Class<U> clazz, String string) {
        int n2;
        if (clazz == null) {
            throw new NullPointerException("Missing unit type.");
        }
        int n3 = string.length();
        ArrayList<List<FormatItem<U>>> arrayList = new ArrayList<List<FormatItem<U>>>();
        arrayList.add(new ArrayList());
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '#') {
                ++n4;
                continue;
            }
            if (TimeSpanFormatter.isSymbol(c2)) {
                n2 = i2++;
                while (i2 < n3 && string.charAt(i2) == c2) {
                    ++i2;
                }
                this.addSymbol(c2, i2 - n2, n4, arrayList);
                n4 = 0;
                --i2;
                continue;
            }
            if (n4 > 0) {
                throw new IllegalArgumentException("Char # must be followed by unit symbol.");
            }
            if (c2 == '\'') {
                n2 = i2++;
                while (i2 < n3) {
                    if (string.charAt(i2) == '\'') {
                        if (i2 + 1 >= n3 || string.charAt(i2 + 1) != '\'') break;
                        ++i2;
                    }
                    ++i2;
                }
                if (i2 >= n3) {
                    throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                }
                if (n2 + 1 == i2) {
                    this.addLiteral('\'', arrayList);
                    continue;
                }
                String i3 = string.substring(n2 + 1, i2);
                this.addLiteral(i3.replace("''", "'"), arrayList);
                continue;
            }
            if (c2 == '[') {
                TimeSpanFormatter.startOptionalSection(arrayList);
                continue;
            }
            if (c2 == ']') {
                TimeSpanFormatter.endOptionalSection(arrayList);
                continue;
            }
            if (c2 == '.') {
                TimeSpanFormatter.lastOn(arrayList).add(new SeparatorItem('.', ','));
                continue;
            }
            if (c2 == ',') {
                TimeSpanFormatter.lastOn(arrayList).add(new SeparatorItem(',', '.'));
                continue;
            }
            if (c2 == '-') {
                TimeSpanFormatter.lastOn(arrayList).add(new SignItem(false));
                continue;
            }
            if (c2 == '+') {
                TimeSpanFormatter.lastOn(arrayList).add(new SignItem(true));
                continue;
            }
            if (c2 == '{') {
                n2 = ++i2;
                while (i2 < n3 && string.charAt(i2) != '}') {
                    ++i2;
                }
                this.addPluralItem(string.substring(n2, i2), arrayList);
                continue;
            }
            if (c2 == '|') {
                TimeSpanFormatter.lastOn(arrayList).add(OrItem.getInstance());
                continue;
            }
            this.addLiteral(c2, arrayList);
        }
        if (arrayList.size() > 1) {
            throw new IllegalArgumentException("Open square bracket without closing one.");
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Empty or invalid pattern.");
        }
        List list = (List)arrayList.get(0);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing format pattern.");
        }
        if (list.get(0) == OrItem.INSTANCE || list.get(list.size() - 1) == OrItem.INSTANCE) {
            throw new IllegalArgumentException("Pattern must not start or end with an or-operator.");
        }
        int n5 = list.size();
        n2 = ((FormatItem)list.get(n5 - 1)).getMinWidth();
        for (int i2 = n5 - 2; i2 >= 0; --i2) {
            FormatItem formatItem = (FormatItem)list.get(i2);
            if (formatItem == OrItem.INSTANCE) {
                n2 = 0;
                continue;
            }
            list.set(i2, formatItem.update(n2));
            n2 += formatItem.getMinWidth();
        }
        this.type = clazz;
        this.items = Collections.unmodifiableList(list);
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Class<U> getType() {
        return this.type;
    }

    public String format(TimeSpan<? super U> timeSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.print(timeSpan, stringBuilder);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
        for (FormatItem<? super U> formatItem : this.items) {
            if (formatItem == OrItem.INSTANCE) break;
            formatItem.print(timeSpan, appendable);
        }
    }

    public S parse(CharSequence charSequence) throws ParseException {
        return this.parse(charSequence, 0);
    }

    public S parse(CharSequence charSequence, int n2) throws ParseException {
        FormatItem<U> formatItem;
        int n3;
        int n4 = n2;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        int n5 = this.items.size();
        for (n3 = 0; n3 < n5 && (formatItem = this.items.get(n3)) != OrItem.INSTANCE; ++n3) {
            int n6 = formatItem.parse(hashMap, charSequence, n4);
            if (n6 < 0) {
                int n7 = -1;
                for (int i2 = n3 + 1; i2 < n5; ++i2) {
                    if (this.items.get(i2) != OrItem.INSTANCE) continue;
                    n7 = i2;
                    break;
                }
                if (n7 == -1) {
                    throw new ParseException("Cannot parse: " + charSequence, ~n6);
                }
                hashMap.clear();
                n3 = n7;
                continue;
            }
            n4 = n6;
        }
        n3 = charSequence.length();
        if (n4 < n3) {
            throw new ParseException("Unparsed trailing characters found: \"" + charSequence.subSequence(n4, n3) + "\" in \"" + charSequence, n4);
        }
        Long l2 = (Long)hashMap.remove(SIGN_KEY);
        boolean bl2 = l2 != null && l2 < 0L;
        HashMap<U, Long> hashMap2 = new HashMap<U, Long>();
        for (Object k2 : hashMap.keySet()) {
            if (this.type.isInstance(k2)) {
                hashMap2.put(this.type.cast(k2), (Long)hashMap.get(k2));
                continue;
            }
            throw new ParseException("Duration type mismatched: " + hashMap, n4);
        }
        return this.convert(hashMap2, bl2);
    }

    protected abstract S convert(Map<U, Long> var1, boolean var2);

    protected abstract U getUnit(char var1);

    private static boolean isSymbol(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    private void addSymbol(char c2, int n2, int n3, List<List<FormatItem<U>>> list) {
        U u2 = this.getUnit(c2);
        List<FormatItem<U>> list2 = list.get(list.size() - 1);
        if (c2 == 'f') {
            if (n3 > 0) {
                throw new IllegalArgumentException("Combination of # and f-symbol not allowed.");
            }
            list2.add(new FractionItem(0, n2, this.getUnit(c2)));
        } else {
            list2.add(new NumberItem(0, n2, n2 + n3, u2));
        }
    }

    private void addLiteral(char c2, List<List<FormatItem<U>>> list) {
        this.addLiteral(String.valueOf(c2), list);
    }

    private void addLiteral(String string, List<List<FormatItem<U>>> list) {
        TimeSpanFormatter.lastOn(list).add(new LiteralItem(string));
    }

    private void addPluralItem(String string, List<List<FormatItem<U>>> list) {
        Locale locale;
        Object object;
        Object object2;
        String[] stringArray = string.split(":");
        if (stringArray.length > 9 || stringArray.length < 4) {
            throw new IllegalArgumentException("Plural information has wrong format: " + string);
        }
        if (stringArray[0].length() != 1) {
            throw new IllegalArgumentException("Plural information has wrong symbol: " + string);
        }
        U u2 = this.getUnit(stringArray[0].charAt(0));
        String[] stringArray2 = stringArray[2].split("-|_");
        String string2 = stringArray2[0];
        if (stringArray2.length > 1) {
            object2 = stringArray2[1];
            if (stringArray2.length > 2) {
                object = stringArray2[2];
                if (stringArray2.length > 3) {
                    throw new IllegalArgumentException("Plural information has wrong locale: " + string);
                }
                locale = new Locale(string2, (String)object2, (String)object);
            } else {
                locale = new Locale(string2, (String)object2);
            }
        } else {
            locale = new Locale(string2);
        }
        object2 = new EnumMap(PluralCategory.class);
        object = PluralRules.of(locale, NumberType.CARDINALS);
        for (int i2 = 3; i2 < stringArray.length; ++i2) {
            String[] stringArray3 = stringArray[i2].split("=");
            if (stringArray3.length != 2) {
                throw new IllegalArgumentException("Plural information has wrong format: " + string);
            }
            object2.put(PluralCategory.valueOf(stringArray3[0]), stringArray3[1]);
        }
        if (object2.isEmpty()) {
            throw new IllegalArgumentException("Missing plural forms: " + string);
        }
        if (!object2.containsKey((Object)PluralCategory.OTHER)) {
            throw new IllegalArgumentException("Missing plural category OTHER: " + string);
        }
        TimeSpanFormatter.lastOn(list).add(new PluralItem(u2, stringArray[1], (PluralRules)object, (Map)object2));
    }

    private static <U> void startOptionalSection(List<List<FormatItem<U>>> list) {
        list.add(new ArrayList());
    }

    private static <U> void endOptionalSection(List<List<FormatItem<U>>> list) {
        int n2 = list.size() - 1;
        if (n2 < 1) {
            throw new IllegalArgumentException("Closing square bracket without open one.");
        }
        List<FormatItem<U>> list2 = list.remove(n2);
        list.get(n2 - 1).add(new OptionalSectionItem(list2));
    }

    private static <U> List<FormatItem<U>> lastOn(List<List<FormatItem<U>>> list) {
        return list.get(list.size() - 1);
    }

    private static class SeparatorItem<U>
    extends FormatItem<U> {
        private final char separator;
        private final char alt;

        private SeparatorItem(char c2, char c3) {
            this(0, c2, c3);
        }

        private SeparatorItem(int n2, char c2, char c3) {
            super(n2);
            this.separator = c2;
            this.alt = c3;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            appendable.append(this.separator);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            if (n2 >= charSequence.length() - this.getReserved()) {
                return ~n2;
            }
            char c2 = charSequence.charAt(n2);
            if (c2 != this.separator && c2 != this.alt) {
                return ~n2;
            }
            return n2 + 1;
        }

        @Override
        int getMinWidth() {
            return 1;
        }

        @Override
        FormatItem<U> update(int n2) {
            return new SeparatorItem<U>(n2, this.separator, this.alt);
        }
    }

    private static class SignItem<U>
    extends FormatItem<U> {
        private final boolean always;

        private SignItem(boolean bl2) {
            super(0);
            this.always = bl2;
        }

        private SignItem(int n2, boolean bl2) {
            super(n2);
            this.always = bl2;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            if (this.always) {
                appendable.append(timeSpan.isNegative() ? (char)'-' : '+');
            } else if (timeSpan.isNegative()) {
                appendable.append('-');
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            if (n2 >= charSequence.length() - this.getReserved()) {
                if (this.always) {
                    return ~n2;
                }
                Long l2 = map.put(SIGN_KEY, 1L);
                if (l2 == null || l2 == 1L) return n2;
                return ~n2;
            }
            char c2 = charSequence.charAt(n2);
            Long l3 = 1L;
            int n3 = n2;
            if (this.always) {
                if (c2 == '+') {
                    n3 = n2 + 1;
                } else {
                    if (c2 != '-') return ~n2;
                    l3 = -1L;
                    n3 = n2 + 1;
                }
            } else {
                if (c2 == '+') {
                    return ~n2;
                }
                if (c2 == '-') {
                    l3 = -1L;
                    n3 = n2 + 1;
                }
            }
            Long l4 = map.put(SIGN_KEY, l3);
            if (l4 == null || l4.longValue() == l3.longValue()) return n3;
            return ~n2;
        }

        @Override
        int getMinWidth() {
            return this.always ? 1 : 0;
        }

        @Override
        FormatItem<U> update(int n2) {
            return new SignItem<U>(n2, this.always);
        }
    }

    private static class OrItem<U>
    extends FormatItem<U> {
        static final OrItem INSTANCE = new OrItem();

        private OrItem() {
            super(0);
        }

        static <U> FormatItem<U> getInstance() {
            return INSTANCE;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            return n2;
        }

        @Override
        int getMinWidth() {
            return 0;
        }

        @Override
        FormatItem<U> update(int n2) {
            return this;
        }
    }

    private static abstract class FormatItem<U> {
        private final int reserved;

        FormatItem(int n2) {
            this.reserved = n2;
        }

        boolean isZero(TimeSpan<? super U> timeSpan) {
            return true;
        }

        abstract void print(TimeSpan<? super U> var1, Appendable var2) throws IOException;

        abstract int parse(Map<Object, Long> var1, CharSequence var2, int var3);

        int getReserved() {
            return this.reserved;
        }

        abstract int getMinWidth();

        abstract FormatItem<U> update(int var1);
    }

    private static class FractionItem<U>
    extends FormatItem<U> {
        private final int width;
        private final U nanosecond;

        private FractionItem(int n2, int n3, U u2) {
            super(n2);
            if (n3 < 1 || n3 > 9) {
                throw new IllegalArgumentException("Fraction width out of bounds: " + n3);
            }
            this.width = n3;
            this.nanosecond = u2;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            String string = String.valueOf(timeSpan.getPartialAmount(this.nanosecond));
            int n2 = string.length();
            if (n2 > 9) {
                throw new IllegalArgumentException("Too many nanoseconds, consider normalization: " + timeSpan);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < 9 - n2; ++i2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            appendable.append(stringBuilder.toString().substring(0, this.width));
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            char c2;
            int n3;
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = n2;
            int n5 = Math.min(charSequence.length() - this.getReserved(), n2 + this.width);
            for (n3 = n2; n3 < n5 && (c2 = charSequence.charAt(n3)) >= '0' && c2 <= '9'; ++n3) {
                stringBuilder.append(c2);
                ++n4;
            }
            if (n4 == n2) {
                return ~n2;
            }
            n5 = n4 - n2;
            for (n3 = 0; n3 < 9 - n5; ++n3) {
                stringBuilder.append('0');
            }
            Long l2 = Long.parseLong(stringBuilder.toString());
            Long l3 = map.put(this.nanosecond, l2);
            if (l3 == null || ((Object)l3).equals(l2)) {
                return n4;
            }
            return ~n2;
        }

        @Override
        int getMinWidth() {
            return this.width;
        }

        @Override
        FormatItem<U> update(int n2) {
            return new FractionItem<U>(n2, this.width, this.nanosecond);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return timeSpan.getPartialAmount(this.nanosecond) == 0L;
        }
    }

    private static class NumberItem<U>
    extends FormatItem<U> {
        private final int minWidth;
        private final int maxWidth;
        private final U unit;

        private NumberItem(int n2, int n3, int n4, U u2) {
            super(n2);
            if (n3 < 1 || n3 > 18) {
                throw new IllegalArgumentException("Min width out of bounds: " + n3);
            }
            if (n4 < n3) {
                throw new IllegalArgumentException("Max width smaller than min width.");
            }
            if (n4 > 18) {
                throw new IllegalArgumentException("Max width out of bounds: " + n4);
            }
            if (u2 == null) {
                throw new NullPointerException("Missing unit.");
            }
            this.minWidth = n3;
            this.maxWidth = n4;
            this.unit = u2;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            String string = String.valueOf(this.getAmount(timeSpan));
            if (string.length() > this.maxWidth) {
                throw new IllegalArgumentException("Too many digits for: " + this.unit + " [" + timeSpan + "]");
            }
            for (int i2 = this.minWidth - string.length(); i2 > 0; --i2) {
                appendable.append('0');
            }
            appendable.append(string);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            char c2;
            long l2 = 0L;
            int n3 = n2;
            int n4 = charSequence.length() - this.getReserved();
            for (int i2 = n2; i2 < n4 && (c2 = charSequence.charAt(i2)) >= '0' && c2 <= '9' && i2 - n2 < this.maxWidth; ++i2) {
                int n5 = c2 - 48;
                l2 = l2 * 10L + (long)n5;
                ++n3;
            }
            if (n3 == n2) {
                return ~n2;
            }
            Long l3 = l2;
            Long l4 = map.put(this.unit, l3);
            if (l4 == null || ((Object)l4).equals(l3)) {
                return n3;
            }
            return ~n2;
        }

        @Override
        int getMinWidth() {
            return this.minWidth;
        }

        @Override
        FormatItem<U> update(int n2) {
            return new NumberItem<U>(n2, this.minWidth, this.maxWidth, this.unit);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return this.getAmount(timeSpan) == 0L;
        }

        long getAmount(TimeSpan<? super U> timeSpan) {
            return timeSpan.getPartialAmount(this.unit);
        }

        U getUnit() {
            return this.unit;
        }
    }

    private static class LiteralItem<U>
    extends FormatItem<U> {
        private final String literal;

        private LiteralItem(String string) {
            this(string, false);
        }

        private LiteralItem(String string, boolean bl2) {
            super(0);
            if (!bl2 && string.isEmpty()) {
                throw new IllegalArgumentException("Literal is empty.");
            }
            this.literal = string;
        }

        private LiteralItem(int n2, String string) {
            super(n2);
            this.literal = string;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            appendable.append(this.literal);
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            int n3 = n2 + this.literal.length();
            if (n3 > charSequence.length() - this.getReserved()) {
                return ~n2;
            }
            for (int i2 = n2; i2 < n3; ++i2) {
                if (charSequence.charAt(i2) == this.literal.charAt(i2 - n2)) continue;
                return ~n2;
            }
            return n3;
        }

        @Override
        int getMinWidth() {
            return this.literal.length();
        }

        @Override
        FormatItem<U> update(int n2) {
            return new LiteralItem<U>(n2, this.literal);
        }
    }

    private static class PluralItem<U>
    extends FormatItem<U> {
        private final NumberItem<U> numItem;
        private final FormatItem<U> sepItem;
        private final PluralRules rules;
        private final Map<PluralCategory, String> pluralForms;
        private final int minWidth;

        private PluralItem(U u2, String string, PluralRules pluralRules, Map<PluralCategory, String> map) {
            super(0);
            this.numItem = new NumberItem(0, 1, 18, u2);
            this.sepItem = new LiteralItem(string, true);
            this.rules = pluralRules;
            this.pluralForms = map;
            int n2 = Integer.MAX_VALUE;
            for (String string2 : map.values()) {
                if (string2.length() >= n2) continue;
                n2 = string2.length();
            }
            this.minWidth = n2;
        }

        private PluralItem(int n2, NumberItem<U> numberItem, FormatItem<U> formatItem, PluralRules pluralRules, Map<PluralCategory, String> map, int n3) {
            super(n2);
            this.numItem = numberItem;
            this.sepItem = formatItem;
            this.rules = pluralRules;
            this.pluralForms = map;
            this.minWidth = n3;
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            this.numItem.print(timeSpan, appendable);
            this.sepItem.print(timeSpan, appendable);
            PluralCategory pluralCategory = this.rules.getCategory(this.numItem.getAmount(timeSpan));
            appendable.append(this.pluralForms.get((Object)pluralCategory));
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            int n3 = n2;
            if ((n2 = this.numItem.parse(map, charSequence, n2)) < 0) {
                return n2;
            }
            if ((n2 = this.sepItem.parse(map, charSequence, n2)) < 0) {
                return n2;
            }
            long l2 = map.get(this.numItem.getUnit());
            String string = this.pluralForms.get((Object)this.rules.getCategory(l2));
            int n4 = string.length();
            if (n2 + n4 > charSequence.length() - this.getReserved()) {
                return ~n3;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                if (string.charAt(i2) == charSequence.charAt(n2 + i2)) continue;
                return ~n3;
            }
            return n2 + n4;
        }

        @Override
        int getMinWidth() {
            return this.minWidth;
        }

        @Override
        FormatItem<U> update(int n2) {
            return new PluralItem<U>(n2, this.numItem, this.sepItem, this.rules, this.pluralForms, this.minWidth);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            return this.numItem.isZero(timeSpan);
        }
    }

    private static class OptionalSectionItem<U>
    extends FormatItem<U> {
        private final List<FormatItem<U>> items;

        private OptionalSectionItem(List<FormatItem<U>> list) {
            super(0);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Optional section is empty.");
            }
            if (list.get(0) == OrItem.INSTANCE || list.get(list.size() - 1) == OrItem.INSTANCE) {
                throw new IllegalArgumentException("Optional section must not start or end with an or-operator.");
            }
            this.items = Collections.unmodifiableList(list);
        }

        @Override
        void print(TimeSpan<? super U> timeSpan, Appendable appendable) throws IOException {
            if (!this.isZero(timeSpan)) {
                for (FormatItem<? super U> formatItem : this.items) {
                    if (formatItem == OrItem.INSTANCE) break;
                    formatItem.print(timeSpan, appendable);
                }
            }
        }

        @Override
        int parse(Map<Object, Long> map, CharSequence charSequence, int n2) {
            FormatItem<U> formatItem;
            int n3 = n2;
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            int n4 = this.items.size();
            for (int i2 = 0; i2 < n4 && (formatItem = this.items.get(i2)) != OrItem.INSTANCE; ++i2) {
                int n5 = formatItem.parse(hashMap, charSequence, n3);
                if (n5 < 0) {
                    int n6 = -1;
                    for (int i3 = i2 + 1; i3 < n4; ++i3) {
                        if (this.items.get(i3) != OrItem.INSTANCE) continue;
                        n6 = i3;
                        break;
                    }
                    if (n6 == -1) {
                        return n2;
                    }
                    hashMap.clear();
                    i2 = n6;
                    continue;
                }
                n3 = n5;
            }
            map.putAll(hashMap);
            return n3;
        }

        @Override
        int getMinWidth() {
            return 0;
        }

        @Override
        FormatItem<U> update(int n2) {
            ArrayList<FormatItem<U>> arrayList = new ArrayList<FormatItem<U>>(this.items);
            int n3 = arrayList.size();
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                FormatItem formatItem = (FormatItem)arrayList.get(i2);
                arrayList.set(i2, formatItem.update(n2));
                n2 += formatItem.getMinWidth();
            }
            return new OptionalSectionItem<U>(arrayList);
        }

        @Override
        boolean isZero(TimeSpan<? super U> timeSpan) {
            for (FormatItem<? super U> formatItem : this.items) {
                if (formatItem.isZero(timeSpan)) continue;
                return false;
            }
            return true;
        }
    }
}

