/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.BasicUnit;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.RuleNotFoundException;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;

public final class TimeAxis<U, T extends TimePoint<U, T>>
extends Chronology<T>
implements TimeLine<T> {
    private final Class<U> unitType;
    private final Map<U, UnitRule<T>> unitRules;
    private final Map<U, Double> unitLengths;
    private final Map<U, Set<U>> convertibleUnits;
    private final Map<ChronoElement<?>, U> baseUnits;
    private final T min;
    private final T max;
    private final CalendarSystem<T> calendarSystem;
    private final ChronoElement<T> self;
    private final TimeLine<T> timeline;

    private TimeAxis(Class<T> clazz, Class<U> clazz2, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, Map<U, UnitRule<T>> map2, Map<U, Double> map3, Map<U, Set<U>> map4, List<ChronoExtension> list, Map<ChronoElement<?>, U> map5, T t2, T t3, CalendarSystem<T> calendarSystem, TimeLine<T> timeLine, boolean bl2) {
        super(clazz, chronoMerger, map, list);
        Map<U, UnitRule<T>> map6 = map2;
        if (bl2) {
            map6 = new IdentityHashMap<U, UnitRule<T>>(map2.size());
            map6.putAll(map2);
        }
        this.unitType = clazz2;
        this.unitRules = map6;
        this.unitLengths = Collections.unmodifiableMap(map3);
        this.convertibleUnits = Collections.unmodifiableMap(map4);
        this.baseUnits = Collections.unmodifiableMap(map5);
        this.min = t2;
        this.max = t3;
        this.calendarSystem = calendarSystem;
        this.self = new SelfElement(clazz, (TimePoint)t2, (TimePoint)t3, null);
        if (timeLine == null) {
            ArrayList<U> arrayList = new ArrayList<U>(map2.keySet());
            arrayList.sort(Comparator.comparingDouble(object -> TimeAxis.getLength(map3, object)));
            Object e2 = arrayList.get(0);
            this.timeline = new DefaultTimeLine(e2, t2, t3);
        } else {
            this.timeline = timeLine;
        }
    }

    public Class<U> getUnitType() {
        return this.unitType;
    }

    public Set<U> getRegisteredUnits() {
        return Collections.unmodifiableSet(this.unitRules.keySet());
    }

    public boolean isRegistered(U u2) {
        return this.unitRules.containsKey(u2);
    }

    public boolean isSupported(U u2) {
        if (this.isRegistered(u2)) {
            return true;
        }
        if (u2 instanceof BasicUnit) {
            return ((BasicUnit)BasicUnit.class.cast(u2)).derive(this) != null;
        }
        return false;
    }

    public double getLength(U u2) {
        return TimeAxis.getLength(this.unitLengths, u2);
    }

    public boolean isConvertible(U u2, U u3) {
        Set<U> set = this.convertibleUnits.get(u2);
        return set != null && set.contains(u3);
    }

    public boolean hasBaseUnit(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        boolean bl2 = this.baseUnits.containsKey(chronoElement);
        if (!bl2 && chronoElement instanceof BasicElement) {
            ChronoElement<?> chronoElement2 = ((BasicElement)chronoElement).getParent();
            bl2 = chronoElement2 != null && this.baseUnits.containsKey(chronoElement2);
        }
        return bl2;
    }

    public U getBaseUnit(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        U u2 = this.baseUnits.get(chronoElement);
        if (u2 == null && chronoElement instanceof BasicElement) {
            ChronoElement<?> chronoElement2 = ((BasicElement)chronoElement).getParent();
            u2 = this.baseUnits.get(chronoElement2);
        }
        if (u2 == null) {
            throw new ChronoException("Base unit not found for: " + chronoElement.name());
        }
        return u2;
    }

    public Comparator<? super U> unitComparator() {
        return (object, object2) -> Double.compare(this.getLength(object2), this.getLength(object));
    }

    @Override
    public int compare(T t2, T t3) {
        return ((TimePoint)t2).compareTo(t3);
    }

    @Override
    public T getMinimum() {
        return this.min;
    }

    @Override
    public T getMaximum() {
        return this.max;
    }

    @Override
    public boolean isCalendrical() {
        return this.calendarSystem != null;
    }

    @Override
    public boolean hasCalendarSystem() {
        return this.calendarSystem != null;
    }

    @Override
    public CalendarSystem<T> getCalendarSystem() {
        if (this.calendarSystem == null) {
            return super.getCalendarSystem();
        }
        return this.calendarSystem;
    }

    @Override
    public CalendarSystem<T> getCalendarSystem(String string) {
        if (string.isEmpty()) {
            return this.getCalendarSystem();
        }
        return super.getCalendarSystem(string);
    }

    @Override
    public T createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
        if (chronoEntity.contains(this.self)) {
            return (T)((TimePoint)chronoEntity.get(this.self));
        }
        return (T)((TimePoint)super.createFrom(chronoEntity, attributeQuery, bl2, bl3));
    }

    public ChronoElement<T> element() {
        return this.self;
    }

    @Override
    public T stepForward(T t2) {
        return (T)((TimePoint)this.timeline.stepForward(t2));
    }

    @Override
    public T stepBackwards(T t2) {
        return (T)((TimePoint)this.timeline.stepBackwards(t2));
    }

    UnitRule<T> getRule(U u2) {
        if (u2 == null) {
            throw new NullPointerException("Missing chronological unit.");
        }
        UnitRule<Object> unitRule = this.unitRules.get(u2);
        if (unitRule == null) {
            if (u2 instanceof BasicUnit) {
                unitRule = ((BasicUnit)BasicUnit.class.cast(u2)).derive(this);
            }
            if (unitRule == null) {
                throw new RuleNotFoundException(this, u2);
            }
        }
        return unitRule;
    }

    private static <U> double getLength(Map<U, Double> map, U u2) {
        Double d2 = map.get(u2);
        if (d2 == null) {
            if (u2 instanceof ChronoUnit) {
                return ((ChronoUnit)ChronoUnit.class.cast(u2)).getLength();
            }
            return Double.NaN;
        }
        return d2;
    }

    /* synthetic */ TimeAxis(Class clazz, Class clazz2, ChronoMerger chronoMerger, Map map, Map map2, Map map3, Map map4, List list, Map map5, TimePoint timePoint, TimePoint timePoint2, CalendarSystem calendarSystem, TimeLine timeLine, boolean bl2, 1 var15_15) {
        this(clazz, clazz2, chronoMerger, map, map2, map3, map4, list, map5, timePoint, timePoint2, calendarSystem, timeLine, bl2);
    }

    private static class SelfElement<T extends TimePoint<?, T>>
    extends BasicElement<T>
    implements ElementRule<T, T> {
        private static final long serialVersionUID = 4777240530511579802L;
        private final Class<T> type;
        private final T min;
        private final T max;

        private SelfElement(Class<T> clazz, T t2, T t3) {
            super(clazz.getName() + "-AXIS");
            this.type = clazz;
            this.min = t2;
            this.max = t3;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public T getDefaultMinimum() {
            return this.min;
        }

        @Override
        public T getDefaultMaximum() {
            return this.max;
        }

        @Override
        public boolean isDateElement() {
            return false;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public T getValue(T t2) {
            return t2;
        }

        @Override
        public T getMinimum(T t2) {
            return (T)this.getDefaultMinimum();
        }

        @Override
        public T getMaximum(T t2) {
            return (T)this.getDefaultMaximum();
        }

        @Override
        public boolean isValid(T t2, T t3) {
            return t3 != null;
        }

        @Override
        public T withValue(T t2, T t3, boolean bl2) {
            if (t3 == null) {
                throw new IllegalArgumentException("Missing value.");
            }
            return t3;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected <X extends ChronoEntity<X>> ElementRule<X, T> derive(Chronology<X> chronology) {
            if (chronology.getChronoType().equals(this.type)) {
                return this;
            }
            return null;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        @Override
        protected String getVeto(Chronology<?> chronology) {
            return null;
        }

        /* synthetic */ SelfElement(Class clazz, TimePoint timePoint, TimePoint timePoint2, 1 var4_4) {
            this(clazz, timePoint, timePoint2);
        }
    }

    private static class DefaultTimeLine<U, T extends TimePoint<U, T>>
    implements TimeLine<T> {
        private final U step;
        private final T min;
        private final T max;

        DefaultTimeLine(U u2, T t2, T t3) {
            this.step = u2;
            this.min = t2;
            this.max = t3;
        }

        @Override
        public T stepForward(T t2) {
            if (((TimePoint)t2).compareTo(this.max) >= 0) {
                return null;
            }
            return ((TimePoint)t2).plus(1L, this.step);
        }

        @Override
        public T stepBackwards(T t2) {
            if (((TimePoint)t2).compareTo(this.min) <= 0) {
                return null;
            }
            return ((TimePoint)t2).minus(1L, this.step);
        }

        @Override
        public T getMinimum() {
            return this.min;
        }

        @Override
        public T getMaximum() {
            return this.max;
        }

        @Override
        public int compare(T t2, T t3) {
            return ((TimePoint)t2).compareTo(t3);
        }
    }

    public static final class Builder<U, T extends TimePoint<U, T>>
    extends Chronology.Builder<T> {
        private final Class<U> unitType;
        private final Map<U, UnitRule<T>> unitRules;
        private final Map<U, Double> unitLengths;
        private final Map<U, Set<U>> convertibleUnits;
        private final Map<ChronoElement<?>, U> baseUnits;
        private final T min;
        private final T max;
        private final CalendarSystem<T> calendarSystem;
        private TimeLine<T> timeline;
        private boolean useEnumUnits = true;

        private Builder(Class<U> clazz, Class<T> clazz2, ChronoMerger<T> chronoMerger, T t2, T t3, CalendarSystem<T> calendarSystem, TimeLine<T> timeLine) {
            super(clazz2, chronoMerger);
            if (clazz == null) {
                throw new NullPointerException("Missing unit type.");
            }
            if (t2 == null) {
                throw new NullPointerException("Missing minimum of range.");
            }
            if (t3 == null) {
                throw new NullPointerException("Missing maximum of range.");
            }
            if (Calendrical.class.isAssignableFrom(clazz2) && calendarSystem == null) {
                throw new NullPointerException("Missing calendar system.");
            }
            this.unitType = clazz;
            this.unitRules = new HashMap<U, UnitRule<T>>();
            this.unitLengths = new HashMap<U, Double>();
            this.convertibleUnits = new HashMap<U, Set<U>>();
            this.baseUnits = new HashMap();
            this.min = t2;
            this.max = t3;
            this.calendarSystem = calendarSystem;
            this.timeline = timeLine;
        }

        public static <U, T extends TimePoint<U, T>> Builder<U, T> setUp(Class<U> clazz, Class<T> clazz2, ChronoMerger<T> chronoMerger, T t2, T t3) {
            return new Builder<U, T>(clazz, clazz2, chronoMerger, t2, t3, null, null);
        }

        public static <U, D extends Calendrical<U, D>> Builder<U, D> setUp(Class<U> clazz, Class<D> clazz2, ChronoMerger<D> chronoMerger, CalendarSystem<D> calendarSystem) {
            CalendarSystem<D> calendarSystem2 = calendarSystem;
            Builder<U, Calendrical> builder = new Builder<U, Calendrical>(clazz, clazz2, chronoMerger, (Calendrical)calendarSystem2.transform(calendarSystem2.getMinimumSinceUTC()), (Calendrical)calendarSystem2.transform(calendarSystem2.getMaximumSinceUTC()), calendarSystem2, null);
            for (EpochDays epochDays : EpochDays.values()) {
                builder.appendElement((ChronoElement)epochDays, epochDays.derive(calendarSystem2));
            }
            return builder;
        }

        public <V> Builder<U, T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            super.appendElement(chronoElement, elementRule);
            return this;
        }

        public <V> Builder<U, T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule, U u2) {
            if (u2 == null) {
                throw new NullPointerException("Missing base unit.");
            }
            super.appendElement(chronoElement, elementRule);
            this.baseUnits.put(chronoElement, u2);
            return this;
        }

        public Builder<U, T> appendUnit(U u2, UnitRule<T> unitRule, double d2) {
            Set set = Collections.emptySet();
            return this.appendUnit(u2, unitRule, d2, set);
        }

        public Builder<U, T> appendUnit(U u2, UnitRule<T> unitRule, double d2, Set<? extends U> set) {
            if (u2 == null) {
                throw new NullPointerException("Missing time unit.");
            }
            if (unitRule == null) {
                throw new NullPointerException("Missing unit rule.");
            }
            this.checkUnitDuplicates(u2);
            for (U u3 : set) {
                if (u3 != null) continue;
                throw new NullPointerException("Found convertible unit which is null.");
            }
            if (Double.isNaN(d2)) {
                throw new IllegalArgumentException("Not a number: " + d2);
            }
            if (Double.isInfinite(d2)) {
                throw new IllegalArgumentException("Infinite: " + d2);
            }
            this.useEnumUnits = this.useEnumUnits && u2 instanceof Enum;
            this.unitRules.put(u2, unitRule);
            this.unitLengths.put(u2, d2);
            HashSet<? extends U> hashSet = new HashSet<U>(set);
            hashSet.remove(u2);
            this.convertibleUnits.put(u2, hashSet);
            return this;
        }

        public Builder<U, T> appendExtension(ChronoExtension chronoExtension) {
            super.appendExtension(chronoExtension);
            return this;
        }

        public Builder<U, T> withTimeLine(TimeLine<T> timeLine) {
            if (timeLine == null) {
                throw new NullPointerException("Missing time line.");
            }
            this.timeline = timeLine;
            return this;
        }

        public TimeAxis<U, T> build() {
            if (this.unitRules.isEmpty()) {
                throw new IllegalStateException("No time unit was registered.");
            }
            TimeAxis timeAxis = new TimeAxis(this.chronoType, this.unitType, this.merger, this.ruleMap, this.unitRules, this.unitLengths, this.convertibleUnits, this.extensions, this.baseUnits, (TimePoint)this.min, (TimePoint)this.max, this.calendarSystem, this.timeline, this.useEnumUnits, null);
            Chronology.register(timeAxis);
            return timeAxis;
        }

        private void checkUnitDuplicates(U u2) {
            if (this.time4j) {
                return;
            }
            for (Object object : this.unitRules.keySet()) {
                if (!object.equals(u2)) continue;
                throw new IllegalArgumentException("Unit duplicate found: " + u2.toString());
            }
            if (u2 instanceof Enum) {
                String string = ((Enum)Enum.class.cast(u2)).name();
                for (Object e2 : this.unitRules.keySet()) {
                    if (!(e2 instanceof Enum) || !((Enum)Enum.class.cast(e2)).name().equals(string)) continue;
                    throw new IllegalArgumentException("Unit duplicate found: " + (String)string);
                }
            }
        }
    }
}

