/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.Optional;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public abstract class StartOfDay {
    public static final StartOfDay MIDNIGHT = StartOfDay.fixed(0);
    public static final StartOfDay EVENING = StartOfDay.fixed(-21600);
    public static final StartOfDay MORNING = StartOfDay.fixed(21600);

    protected StartOfDay() {
    }

    public static StartOfDay ofFixedDeviation(int n2) {
        if (n2 == 0) {
            return MIDNIGHT;
        }
        if (n2 == -21600) {
            return EVENING;
        }
        if (n2 > 43200 || n2 <= -43200) {
            throw new IllegalArgumentException("Start of day out of range: " + n2);
        }
        return new FixedStartOfDay(n2);
    }

    public static <T extends UnixTime> StartOfDay definedBy(ChronoFunction<CalendarDate, Optional<T>> chronoFunction) {
        return new FunctionalStartOfDay(chronoFunction);
    }

    public abstract int getDeviation(CalendarDate var1, TZID var2);

    private static StartOfDay fixed(int n2) {
        return new FixedStartOfDay(n2);
    }

    private static class FixedStartOfDay
    extends StartOfDay {
        private final int deviation;

        private FixedStartOfDay(int n2) {
            this.deviation = n2;
        }

        @Override
        public int getDeviation(CalendarDate calendarDate, TZID tZID) {
            return this.deviation;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof FixedStartOfDay) {
                FixedStartOfDay fixedStartOfDay = (FixedStartOfDay)object;
                return this.deviation == fixedStartOfDay.deviation;
            }
            return false;
        }

        public int hashCode() {
            return this.deviation;
        }

        public String toString() {
            return "FixedStartOfDay[" + this.deviation + "]";
        }
    }

    private static class FunctionalStartOfDay<T extends UnixTime>
    extends StartOfDay {
        private final ChronoFunction<CalendarDate, Optional<T>> event;

        private FunctionalStartOfDay(ChronoFunction<CalendarDate, Optional<T>> chronoFunction) {
            if (chronoFunction == null) {
                throw new NullPointerException("Missing event function.");
            }
            this.event = chronoFunction;
        }

        @Override
        public int getDeviation(CalendarDate calendarDate, TZID tZID) {
            Optional<T> optional = this.event.apply(calendarDate);
            if (optional.isPresent()) {
                long l2;
                UnixTime unixTime = (UnixTime)optional.get();
                long l3 = unixTime.getPosixTime() - 63072000L + (long)Timezone.of(tZID).getOffset(unixTime).getIntegralAmount();
                int n2 = MathUtils.safeCast(l3 - (l2 = calendarDate.getDaysSinceEpochUTC() * 86400L));
                return n2 >= 43200 ? n2 - 86400 : n2;
            }
            throw new ChronoException("Cannot determine start of day: No event.");
        }
    }
}

