/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;

public enum EpochDays implements ChronoElement<Long>
{
    UTC(2441317),
    UNIX(2440587),
    MODIFIED_JULIAN_DATE(2400000),
    EXCEL(2415019),
    ANSI(2305812),
    RATA_DIE(1721424),
    JULIAN_DAY_NUMBER(-1),
    LILIAN_DAY_NUMBER(2299159);

    private final int offset;

    private EpochDays(int n3) {
        this.offset = n3 - 2440587 - 730;
    }

    public long transform(long l2, EpochDays epochDays) {
        try {
            return Math.addExact(l2, (long)(epochDays.offset - this.offset));
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(arithmeticException);
        }
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public char getSymbol() {
        return this == MODIFIED_JULIAN_DATE ? (char)'g' : '\u0000';
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
    }

    @Override
    public Long getDefaultMinimum() {
        return -365243219892L - (long)this.offset;
    }

    @Override
    public Long getDefaultMaximum() {
        return 365241779741L - (long)this.offset;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    <D extends ChronoEntity<D>> ElementRule<D, Long> derive(CalendarSystem<D> calendarSystem) {
        return new Rule<D>(this, calendarSystem);
    }

    private static class Rule<D extends ChronoEntity<D>>
    implements ElementRule<D, Long> {
        private static final int UTC_OFFSET = 730;
        private final EpochDays element;
        private final CalendarSystem<D> calsys;

        Rule(EpochDays epochDays, CalendarSystem<D> calendarSystem) {
            this.element = epochDays;
            this.calsys = calendarSystem;
        }

        @Override
        public Long getValue(D d2) {
            long l2 = this.element.transform(this.calsys.transform(d2) + 730L, UNIX);
            return l2;
        }

        @Override
        public boolean isValid(D d2, Long l2) {
            if (l2 == null) {
                return false;
            }
            try {
                long l3 = Math.subtractExact(UNIX.transform(l2, this.element), 730L);
                return l3 <= this.calsys.getMaximumSinceUTC() && l3 >= this.calsys.getMinimumSinceUTC();
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                return false;
            }
        }

        @Override
        public D withValue(D d2, Long l2, boolean bl2) {
            if (l2 == null) {
                throw new IllegalArgumentException("Missing epoch day value.");
            }
            long l3 = Math.subtractExact(UNIX.transform(l2, this.element), 730L);
            return (D)((ChronoEntity)this.calsys.transform(l3));
        }

        @Override
        public Long getMinimum(D d2) {
            long l2 = this.element.transform(this.calsys.getMinimumSinceUTC() + 730L, UNIX);
            return l2;
        }

        @Override
        public Long getMaximum(D d2) {
            long l2 = this.element.transform(this.calsys.getMaximumSinceUTC() + 730L, UNIX);
            return l2;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return null;
        }
    }
}

