/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;

public abstract class Calendrical<U, D extends Calendrical<U, D>>
extends TimePoint<U, D>
implements CalendarDate {
    @Override
    public boolean isBefore(CalendarDate calendarDate) {
        return this.compareByTime(calendarDate) < 0;
    }

    @Override
    public boolean isAfter(CalendarDate calendarDate) {
        return this.compareByTime(calendarDate) > 0;
    }

    @Override
    public boolean isSimultaneous(CalendarDate calendarDate) {
        return this == calendarDate || this.compareByTime(calendarDate) == 0;
    }

    @Override
    public int compareTo(D d2) {
        Class clazz;
        Class clazz2 = this.getChronology().getChronoType();
        if (clazz2 != (clazz = ((TimePoint)d2).getChronology().getChronoType())) {
            throw new ClassCastException("Cannot compare different types of dates, use instance of EpochDays as comparator instead.");
        }
        return this.compareByTime((CalendarDate)d2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Calendrical) {
            Class clazz;
            Calendrical calendrical = (Calendrical)object;
            Class clazz2 = this.getChronology().getChronoType();
            return clazz2 == (clazz = calendrical.getChronology().getChronoType()) && this.getDaysSinceEpochUTC() == calendrical.getDaysSinceEpochUTC();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l2 = this.getDaysSinceEpochUTC();
        return (int)(l2 ^ l2 >>> 32);
    }

    public D plus(CalendarDays calendarDays) {
        long l2 = Math.addExact(this.getDaysSinceEpochUTC(), calendarDays.getAmount());
        try {
            return (D)((Calendrical)((TimeAxis)this.getChronology()).getCalendarSystem().transform(l2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Out of range: " + l2);
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public D minus(CalendarDays calendarDays) {
        return this.plus(CalendarDays.of(Math.negateExact(calendarDays.getAmount())));
    }

    @Override
    public long getDaysSinceEpochUTC() {
        return ((TimeAxis)this.getChronology()).getCalendarSystem().transform((Calendrical)this.getContext());
    }

    protected int compareByTime(CalendarDate calendarDate) {
        long l2;
        long l3 = this.getDaysSinceEpochUTC();
        return l3 < (l2 = calendarDate.getDaysSinceEpochUTC()) ? -1 : (l3 == l2 ? 0 : 1);
    }
}

