/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.List;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;

public abstract class AbstractDuration<U extends ChronoUnit>
implements TimeSpan<U> {
    private static final int MIO = 1000000;

    @Override
    public boolean contains(U u2) {
        for (TimeSpan.Item item : this.getTotalLength()) {
            if (!item.getUnit().equals(u2)) continue;
            return item.getAmount() > 0L;
        }
        return false;
    }

    @Override
    public long getPartialAmount(U u2) {
        for (TimeSpan.Item item : this.getTotalLength()) {
            if (!item.getUnit().equals(u2)) continue;
            return item.getAmount();
        }
        return 0L;
    }

    public abstract AbstractDuration<U> inverse();

    @Override
    public boolean isPositive() {
        return !this.isNegative() && !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        List list = this.getTotalLength();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "PT0S";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        int n2 = this.getTotalLength().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item item = this.getTotalLength().get(i2);
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(item.getAmount());
            stringBuilder.append('{');
            stringBuilder.append(item.getUnit());
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    @Override
    public final <T extends TimePoint<? super U, T>> T addTo(T t2) {
        return this.add(t2, this, false);
    }

    @Override
    public final <T extends TimePoint<? super U, T>> T subtractFrom(T t2) {
        return this.add(t2, this, true);
    }

    private <T extends TimePoint<? super U, T>> T add(T t2, TimeSpan<U> timeSpan, boolean bl2) {
        T t3 = t2;
        Chronology chronology = t2.getChronology();
        List<TimeSpan.Item<U>> list = timeSpan.getTotalLength();
        boolean bl3 = timeSpan.isNegative();
        if (bl2) {
            boolean bl4 = bl3 = !timeSpan.isNegative();
        }
        if (bl3) {
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                int n3;
                TimeSpan.Item<U> item = list.get(n2);
                ChronoUnit chronoUnit = (ChronoUnit)item.getUnit();
                long l2 = item.getAmount();
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    TimeSpan.Item<U> item2 = list.get(n3);
                    ChronoUnit chronoUnit2 = (ChronoUnit)item2.getUnit();
                    long l3 = item2.getAmount();
                    long l4 = AbstractDuration.getFactor(chronology, chronoUnit2, chronoUnit);
                    if (Double.isNaN(l4) || l3 >= Integer.MAX_VALUE || l4 <= 1L || l4 >= 1000000L || !((TimeAxis)chronology).isConvertible(chronoUnit2, chronoUnit)) break;
                    l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l3, l4));
                }
                n2 = n3;
                t3 = t3.plus(MathUtils.safeNegate(l2), (ChronoUnit)chronoUnit);
            }
        } else {
            int n4 = 0;
            int n5 = list.size();
            while (n4 < n5) {
                TimeSpan.Item<U> item;
                ChronoUnit chronoUnit;
                long l5;
                int n6;
                TimeSpan.Item<U> item3 = list.get(n4);
                ChronoUnit chronoUnit3 = (ChronoUnit)item3.getUnit();
                long l6 = item3.getAmount();
                for (n6 = n4 + 1; n6 < n5 && !Double.isNaN(l5 = AbstractDuration.getFactor(chronology, chronoUnit3, chronoUnit = (ChronoUnit)(item = list.get(n6)).getUnit())) && l6 < Integer.MAX_VALUE && l5 > 1L && l5 < 1000000L && ((TimeAxis)chronology).isConvertible(chronoUnit3, chronoUnit); ++n6) {
                    l6 = MathUtils.safeAdd(item.getAmount(), MathUtils.safeMultiply(l6, l5));
                    chronoUnit3 = chronoUnit;
                }
                n4 = n6;
                t3 = t3.plus(l6, (ChronoUnit)chronoUnit3);
            }
        }
        return t3;
    }

    private static <U> long getFactor(TimeAxis<U, ?> timeAxis, U u2, U u3) {
        return Math.round(timeAxis.getLength(u2) / timeAxis.getLength(u3));
    }
}

