/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.scale.TimeScale;

public final class SntpMessage {
    private static final long OFFSET_1900 = 2208988800000000L;
    private static final long OFFSET_2036 = -2085978496000000L;
    private static final int MIO = 1000000;
    private static final double MIO_AS_DOUBLE = 1000000.0;
    private static final byte[] NULL_REF_ID = new byte[]{0, 0, 0, 0};
    private static final double BIT08 = 256.0;
    private static final double BIT16 = 65536.0;
    private final byte leapIndicator;
    private final byte version;
    private final byte mode;
    private final short stratum;
    private final short pollInterval;
    private final byte precision;
    private final double rootDelay;
    private final double rootDispersion;
    private final byte[] refID;
    private final double referenceTimestamp;
    private final double originateTimestamp;
    private final double receiveTimestamp;
    private final double transmitTimestamp;

    SntpMessage(boolean bl2) {
        this.leapIndicator = 0;
        this.version = (byte)(bl2 ? 4 : 3);
        this.mode = (byte)3;
        this.stratum = 0;
        this.pollInterval = 0;
        this.precision = 0;
        this.rootDelay = 0.0;
        this.rootDispersion = 0.0;
        this.refID = NULL_REF_ID;
        this.referenceTimestamp = 0.0;
        this.originateTimestamp = 0.0;
        this.receiveTimestamp = 0.0;
        this.transmitTimestamp = SntpMessage.getLocalTimestamp();
    }

    SntpMessage(byte[] byArray, double d2, byte by2) throws IOException {
        this.leapIndicator = (byte)(byArray[0] >> 6 & 3);
        this.version = (byte)(byArray[0] >> 3 & 7);
        this.mode = (byte)(byArray[0] & 7);
        this.stratum = SntpMessage.toUnsigned(byArray[1]);
        this.pollInterval = SntpMessage.toUnsigned(byArray[2]);
        this.precision = byArray[3];
        this.rootDelay = (double)byArray[4] * 256.0 + (double)SntpMessage.toUnsigned(byArray[5]) + (double)SntpMessage.toUnsigned(byArray[6]) / 256.0 + (double)SntpMessage.toUnsigned(byArray[7]) / 65536.0;
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = byArray[i2 + 8] & 0xFF;
            n2 |= n3 << 24 - i2 * 8;
        }
        this.rootDispersion = (double)n2 / 65536.0;
        byte[] byArray2 = new byte[]{byArray[12], byArray[13], byArray[14], byArray[15]};
        this.refID = byArray2;
        this.referenceTimestamp = SntpMessage.decode(byArray, 16);
        this.originateTimestamp = SntpMessage.decode(byArray, 24);
        this.receiveTimestamp = SntpMessage.decode(byArray, 32);
        this.transmitTimestamp = SntpMessage.decode(byArray, 40);
        if (this.transmitTimestamp == 0.0) {
            throw new IOException("Server hasn't sent any transmit timestamp.");
        }
        if (Math.abs(d2 - this.originateTimestamp) >= 0.001 && this.mode == 4) {
            throw new IOException("Originate timestamp does not match sent timestamp: " + this.originateTimestamp + " (expected = " + d2 + ")");
        }
        if (this.mode != 4 && this.mode != 5) {
            throw new IOException("Unexpected server mode: " + this.mode);
        }
        if (this.leapIndicator < 0 || this.leapIndicator > 3) {
            throw new IOException("Unexpected leap indicator: " + this.leapIndicator);
        }
        if (this.version < 1 || this.version > 4 || this.mode == 4 && this.version != by2) {
            throw new IOException("Unexpected ntp version: " + this.version);
        }
        if (this.stratum < 0 || this.stratum > 15) {
            throw new IOException("Unexpected stratum: " + this.stratum);
        }
    }

    public byte getLeapIndicator() {
        return this.leapIndicator;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getMode() {
        return this.mode;
    }

    public short getStratum() {
        return this.stratum;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public int getPrecision() {
        return this.precision;
    }

    public double getRootDelay() {
        return this.rootDelay;
    }

    public double getRootDispersion() {
        return this.rootDispersion;
    }

    public String getReferenceIdentifier() {
        return this.getRefIDAsString();
    }

    public double getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public double getOriginateTimestamp() {
        return this.originateTimestamp;
    }

    public double getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public double getTransmitTimestamp() {
        return this.transmitTimestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", mode=");
        switch (this.mode) {
            case 3: {
                stringBuilder.append("client");
                break;
            }
            case 4: {
                stringBuilder.append("server");
                break;
            }
            case 5: {
                stringBuilder.append("broadcast");
                break;
            }
            default: {
                stringBuilder.append(this.mode);
            }
        }
        stringBuilder.append(", leap-indicator=");
        stringBuilder.append(this.leapIndicator);
        stringBuilder.append(", stratum=");
        stringBuilder.append(this.stratum);
        stringBuilder.append(", poll-interval=");
        stringBuilder.append(this.pollInterval);
        stringBuilder.append(", precision=");
        stringBuilder.append(this.precision);
        stringBuilder.append(", root-delay=");
        stringBuilder.append(this.rootDelay);
        stringBuilder.append(", root-dispersion=");
        stringBuilder.append(this.rootDispersion);
        stringBuilder.append(", reference-identifier=");
        stringBuilder.append(this.getRefIDAsString());
        stringBuilder.append(", reference-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.referenceTimestamp));
        stringBuilder.append(", originate-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.originateTimestamp));
        stringBuilder.append(", receive-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.receiveTimestamp));
        stringBuilder.append(", transmit-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.transmitTimestamp));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static long convert(double d2) {
        return (long)(d2 * 1000000.0 - 2.2089888E15);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[48];
        byArray[0] = (byte)(this.leapIndicator << 6 | this.version << 3 | this.mode);
        if (this.mode != 3) {
            byArray[1] = (byte)this.stratum;
            byArray[2] = (byte)this.pollInterval;
            byArray[3] = this.precision;
            int n2 = (int)(this.rootDelay * 65536.0);
            byArray[4] = (byte)(n2 >> 24 & 0xFF);
            byArray[5] = (byte)(n2 >> 16 & 0xFF);
            byArray[6] = (byte)(n2 >> 8 & 0xFF);
            byArray[7] = (byte)(n2 & 0xFF);
            long l2 = (long)(this.rootDispersion * 65536.0);
            byArray[8] = (byte)(l2 >> 24 & 0xFFL);
            byArray[9] = (byte)(l2 >> 16 & 0xFFL);
            byArray[10] = (byte)(l2 >> 8 & 0xFFL);
            byArray[11] = (byte)(l2 & 0xFFL);
            for (int i2 = 0; i2 < 4; ++i2) {
                byArray[12 + i2] = this.refID[i2];
            }
            SntpMessage.encode(byArray, 16, this.referenceTimestamp);
            SntpMessage.encode(byArray, 24, this.originateTimestamp);
            SntpMessage.encode(byArray, 32, this.receiveTimestamp);
        }
        SntpMessage.encode(byArray, 40, this.transmitTimestamp);
        return byArray;
    }

    static double getLocalTimestamp() {
        long l2 = SystemClock.MONOTONIC.currentTimeInMicros();
        return (double)(l2 + 2208988800000000L) / 1000000.0;
    }

    private String getRefIDAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.stratum == 0 || this.stratum == 1) {
            char c2;
            for (int i2 = 0; i2 < 4 && (c2 = (char)this.refID[i2]) != '\u0000'; ++i2) {
                stringBuilder.append(c2);
            }
        } else if (this.version == 3) {
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[0]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[1]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[2]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[3]));
        } else {
            if (this.version == 4) {
                int n2 = 0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n3 = this.refID[i3] & 0xFF;
                    n2 |= n3 << 24 - i3 * 8;
                }
                return Integer.toHexString(n2);
            }
            stringBuilder.append('?');
        }
        return stringBuilder.toString();
    }

    private static String toString(double d2) {
        long l2 = SntpMessage.convert(d2);
        Moment moment = Moment.of(l2 / 1000000L, (int)(l2 % 1000000L * 1000L), TimeScale.POSIX);
        return moment.toString();
    }

    private static double decode(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l3 = byArray[i2 + n2] & 0xFF;
            l2 |= l3 << 56 - i2 * 8;
        }
        long l4 = l2 >>> 32 & 0xFFFFFFFFL;
        long l5 = (l2 & 0xFFFFFFFFL) * 1000000L >>> 32;
        long l6 = (l4 & 0x80000000L) == 0L ? -2085978496000000L : 2208988800000000L;
        long l7 = l4 * 1000000L + l5 - l6;
        return (double)(l7 + 2208988800000000L) / 1000000.0;
    }

    private static void encode(byte[] byArray, int n2, double d2) {
        long l2 = SntpMessage.convert(d2);
        boolean bl2 = l2 + -2085978496000000L < 0L;
        long l3 = bl2 ? l2 + 2208988800000000L : l2 + -2085978496000000L;
        long l4 = l3 / 1000000L;
        long l5 = (l3 % 1000000L << 32) / 1000000L;
        if (bl2) {
            l4 |= 0x80000000L;
        }
        long l6 = l4 << 32 | l5;
        for (int i2 = 7; i2 >= 0; --i2) {
            byArray[i2 + n2] = (byte)(l6 & 0xFFL);
            l6 >>>= 8;
        }
        byArray[7 + n2] = (byte)(Math.random() * 256.0);
    }

    private static short toUnsigned(byte by2) {
        short s2 = by2;
        if ((by2 & 0x80) == 128) {
            s2 = (short)(128 + (by2 & 0x7F));
        }
        return s2;
    }
}

